/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.security;

import com.hs.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.hs.lego.cbb.user.service.common.SystemInitializeUserThread;
import com.hs.lego.cbb.user.service.security.ISecurity;
import com.hs.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoExceptionTranslator;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AddressUtil;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class Security
implements ISecurity {
    private static final String USER_LOCK = "USER_LOCK";
    private static final String USER_LOGIN_FAIL = "USER_LOGIN_FAIL";
    private static final int MIN_SESSION_TIMEOUT = 1;
    private static final int DEFALT_SESSION_TIMEOUT = 30;
    private static final int MIN_LOCK_TIME = 1;
    private static final int DEFALT_LOCK_TIME = 3;
    private ICommonDao commonDao;
    private IUserLoginLocalCache cacheService;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private SystemInitializeUserThread systemInitUser;

    @Override
    public void initSysLoginPolicy() {
        UserSecPolicyInfo secInfo;
        UserLoginPolicyInfo info = this.getLoginPolicy();
        if (null == info) {
            UserLoginPolicyInfo defaultLoginPolicy = this.systemInitUser.getDefaultLoginPolicy();
            this.commonDao.save((Object)defaultLoginPolicy);
        }
        if (null == (secInfo = this.getUserSecPolicy())) {
            UserSecPolicyInfo defaultSecPolicy = this.systemInitUser.getDefaultSecPolicy();
            this.commonDao.save((Object)defaultSecPolicy);
        }
    }

    @Override
    public void lockUser(UserInfo userInfo) {
        if (null != userInfo) {
            this.lockUser(userInfo.getId());
        }
    }

    @Override
    public void lockUser(long userId) {
        UserInfo userInfo = null;
        try {
            String hql = "FROM UserInfo where id = " + userId;
            List result = this.commonDao.findByHql(hql);
            if (!result.isEmpty()) {
                userInfo = (UserInfo)result.get(0);
            }
            if (null != userInfo) {
                if (userInfo.isIsLock()) {
                    throw new LegoCheckedException(294L);
                }
            } else {
                throw new LegoCheckedException(201L);
            }
            userInfo.setIsLock(Boolean.TRUE);
            this.commonDao.update((Object)userInfo);
        }
        catch (DataAccessException e) {
            this.log.error((Object)e);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void lockUser(String userName) {
        UserInfo userInfo = null;
        try {
            String hql = "FROM UserInfo where userName =?";
            List result = this.commonDao.findByHql(hql, new Object[]{userName});
            if (!result.isEmpty()) {
                userInfo = (UserInfo)result.get(0);
            }
            if (null == userInfo) {
                throw new LegoCheckedException(201L);
            }
            userInfo.setIsLock(Boolean.TRUE);
            this.commonDao.update((Object)userInfo);
        }
        catch (DataAccessException e) {
            this.log.error((Object)e);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void unLockUser(UserInfo userInfo) {
        if (null != userInfo) {
            this.unLockUser(userInfo.getId());
        }
    }

    @Override
    public void unLockUser(long userId) {
        UserInfo userInfo = null;
        try {
            String hql = "FROM UserInfo where id = " + userId;
            List result = this.commonDao.findByHql(hql);
            if (!result.isEmpty()) {
                userInfo = (UserInfo)result.get(0);
            }
            if (null == userInfo) {
                throw new LegoCheckedException(201L);
            }
            String userName = userInfo.getUserName();
            String userLockKey = USER_LOCK + userName;
            if (!(userInfo.isIsLock() || this.cacheService != null && this.cacheService.containsKey(userLockKey))) {
                throw new LegoCheckedException(295L);
            }
            userInfo.setIsLock(Boolean.FALSE);
            this.commonDao.update((Object)userInfo);
            String loginFailKey = USER_LOGIN_FAIL + userName;
            if (null == this.cacheService) {
                return;
            }
            if (this.cacheService.containsKey(userLockKey)) {
                this.cacheService.remove(userLockKey);
            }
            if (this.cacheService.containsKey(loginFailKey)) {
                this.cacheService.remove(loginFailKey);
            }
        }
        catch (DataAccessException e) {
            this.log.error((Object)e);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public void addUserAcl(Set<UserAclInfo> userAclInfoSet) {
        if (null != userAclInfoSet && !userAclInfoSet.isEmpty()) {
            for (UserAclInfo temp : userAclInfoSet) {
                this.commonDao.save((Object)temp);
            }
        }
    }

    public void delUserAllAcl(long userId) {
        String hql = "delete from UserAclInfo where userId = " + userId;
        this.commonDao.updateByHql(hql);
    }

    public void delUserAllAcl(Long[] userIds) {
        Long[] longArray = userIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long i2 = longArray[i];
            this.delUserAllAcl(i2);
        }
    }

    public void updataUserAcl(Set<UserAclInfo> userAclInfoSet, long userId) {
        this.delUserAllAcl(userId);
        this.commonDao.saveAll(userAclInfoSet);
    }

    public Set<UserAclInfo> getUserAclByUserId(long userId) {
        String hql = "from UserInfo where id =" + userId;
        List list = this.commonDao.findByHql(hql);
        return ((UserInfo)list.get(0)).getUserAcls();
    }

    @Override
    public boolean checkIP(String loginip, Set<UserAclInfo> aclSet) {
        boolean checkLoginIP = false;
        long loginIp = AddressUtil.ipToLong((String)loginip);
        if (null != aclSet && !aclSet.isEmpty()) {
            for (UserAclInfo temp : aclSet) {
                long lStartIp = temp.getStartIp();
                long lEndIp = temp.getEndIp();
                if (loginIp < lStartIp || loginIp > lEndIp) continue;
                checkLoginIP = true;
                break;
            }
        } else {
            throw new LegoCheckedException(265L);
        }
        return checkLoginIP;
    }

    @Override
    public boolean checkIP(String loginip, long userId) {
        boolean checkLoginIP = false;
        Set<UserAclInfo> list = this.getUserAclByUserId(userId);
        long loginIp = AddressUtil.ipToLong((String)loginip);
        if (null != list && !list.isEmpty()) {
            for (UserAclInfo temp : list) {
                long lStartIp = temp.getStartIp();
                long lEndIp = temp.getEndIp();
                if (loginIp < lStartIp || loginIp > lEndIp) continue;
                checkLoginIP = true;
                break;
            }
        } else {
            throw new LegoCheckedException(265L);
        }
        return checkLoginIP;
    }

    @Override
    public UserLoginPolicyInfo getLoginPolicy() {
        UserLoginPolicyInfo temp = null;
        try {
            String hql = "from UserLoginPolicyInfo";
            List result = this.commonDao.findByHql(hql);
            if (!result.isEmpty()) {
                temp = (UserLoginPolicyInfo)result.get(0);
            }
        }
        catch (DataAccessException e) {
            this.log.error((Object)e);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return temp;
    }

    @Override
    public void updateLoginPolicy(UserLoginPolicyInfo policy) {
        if (null != policy) {
            if (policy.getSessionTimeOut() < 1) {
                policy.setSessionTimeOut(30);
            }
            this.commonDao.update((Object)policy);
        }
    }

    @Override
    public UserSecPolicyInfo getUserSecPolicy() {
        UserSecPolicyInfo temp = null;
        try {
            String hql = "from UserSecPolicyInfo";
            List result = this.commonDao.findByHql(hql);
            if (!result.isEmpty()) {
                temp = (UserSecPolicyInfo)result.get(0);
            }
        }
        catch (DataAccessException e) {
            this.log.error((Object)e);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return temp;
    }

    @Override
    public void updateUserSecPolicy(UserSecPolicyInfo policy) {
        this.commonDao.update((Object)policy);
    }

    @Override
    public boolean checkLockIP(String loginip) {
        return false;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }

    public void setCacheService(IUserLoginLocalCache cacheService) {
        this.cacheService = cacheService;
    }

    public void setSystemInitUser(SystemInitializeUserThread systemInitUser) {
        this.systemInitUser = systemInitUser;
    }

    @Override
    public void unLockUserInCache(long userId) {
        UserInfo userInfo = null;
        try {
            String hql = "FROM UserInfo where id = " + userId;
            List result = this.commonDao.findByHql(hql);
            if (!result.isEmpty()) {
                userInfo = (UserInfo)result.get(0);
            }
            if (null == userInfo) {
                throw new LegoCheckedException(201L);
            }
            String userName = userInfo.getUserName();
            String userLockKey = USER_LOCK + userName;
            String loginFailKey = USER_LOGIN_FAIL + userName;
            if (null == this.cacheService) {
                return;
            }
            if (this.cacheService.containsKey(userLockKey)) {
                this.cacheService.remove(userLockKey);
            }
            if (this.cacheService.containsKey(loginFailKey)) {
                this.cacheService.remove(loginFailKey);
            }
        }
        catch (DataAccessException e) {
            this.log.error((Object)e);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }
}

