/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.security;

import com.hs.lego.cbb.user.thirdauth.sdk.IThirdAuthority;
import com.hs.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ThirdAuthorityFactory
implements InitializingBean,
DisposableBean {
    private static final Object LOCK = new Object();
    private static ThirdAuthorityFactory sInstance = null;
    private Map<Integer, IThirdAuthority> serviceMap = new HashMap<Integer, IThirdAuthority>();
    private IThirdAuthority radiusAuthority;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThirdAuthorityFactory getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == sInstance) {
                sInstance = new ThirdAuthorityFactory();
            }
            return sInstance;
        }
    }

    public void afterPropertiesSet() {
        if (null != this.serviceMap) {
            this.serviceMap.clear();
        }
    }

    public void destroy() {
        if (null != this.serviceMap) {
            this.serviceMap.clear();
        }
    }

    public void init() {
        this.onBind(this.radiusAuthority, null);
    }

    public void onBind(IThirdAuthority service, Map<?, ?> properties) {
        this.serviceMap.put(service.getAuthorityType().getValue(), service);
    }

    public void unBind(IThirdAuthority service, Map<?, ?> properties) {
        this.serviceMap.remove(service.getAuthorityType().getValue());
    }

    public IThirdAuthority getThirdAuthorityByType(int type) {
        IThirdAuthority thirdAuthority = null;
        if (null != this.serviceMap) {
            thirdAuthority = this.serviceMap.get(type);
        }
        return thirdAuthority;
    }

    public final Set<Integer> getAuthorityType() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(UserAuthorityType.local.getValue());
        if (null != this.serviceMap) {
            set.addAll(this.serviceMap.keySet());
        }
        return set;
    }

    public IThirdAuthority getRadiusAuthority() {
        return this.radiusAuthority;
    }

    public void setRadiusAuthority(IThirdAuthority radiusAuthority) {
        this.radiusAuthority = radiusAuthority;
    }
}

