/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.user.service.usercache;

import com.hs.lego.cbb.user.service.usercache.IUserLoginLocalCache;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class UserLoginLocalCacheImpl
implements IUserLoginLocalCache<String, Object> {
    private static final int NUM_1000 = 1000;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private ConcurrentHashMap<String, Object> caches;
    private ConcurrentHashMap<String, Long> expiryCache;
    private ConcurrentHashMap<String, Integer> intervalCache;
    private ConcurrentHashMap<String, Integer> saveToCache;
    private ScheduledExecutorService scheduleService;
    private int expiryInterval = 10;
    private String onlineSessionIdList = "onlineSessionIdList";

    public UserLoginLocalCacheImpl() {
        this.init();
    }

    public UserLoginLocalCacheImpl(int expiryInterval) {
        this.expiryInterval = expiryInterval;
        this.init();
    }

    private void init() {
        this.caches = new ConcurrentHashMap();
        this.expiryCache = new ConcurrentHashMap();
        this.intervalCache = new ConcurrentHashMap();
        this.saveToCache = new ConcurrentHashMap();
        this.scheduleService = Executors.newScheduledThreadPool(1);
        this.scheduleService.scheduleAtFixedRate(new CheckOutOfDateSchedule(this.caches, this.expiryCache), 0L, (long)this.expiryInterval * 60L, TimeUnit.SECONDS);
        this.log.info((Object)"User Local Cache is start!");
    }

    @Override
    public boolean clear() {
        if (this.caches != null) {
            this.caches.clear();
        }
        if (this.expiryCache != null) {
            this.expiryCache.clear();
        }
        if (this.intervalCache != null) {
            this.intervalCache.clear();
        }
        this.log.info((Object)"User Local Cache is clear!");
        return true;
    }

    @Override
    public boolean containsKey(String key) {
        this.checkValidate(key);
        return this.caches.containsKey(key);
    }

    @Override
    public boolean containsKey(String key, boolean updateTime) {
        this.clearExpiryKey(key);
        return this.caches.containsKey(key);
    }

    @Override
    public Object get(String key) {
        this.checkValidate(key);
        return this.caches.get(key);
    }

    @Override
    public Object get(String key, boolean updateTime) {
        this.clearExpiryKey(key);
        return this.caches.get(key);
    }

    @Override
    public Set<String> keySet() {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    @Override
    public Set<String> keySet(boolean updateTime) {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        Object result = this.caches.put(key, value);
        this.expiryCache.put(key, -1L);
        return result;
    }

    @Override
    public Object put(String key, Object value, Date expiry) {
        Date now = new Date();
        int ttl = (int)(expiry.getTime() - now.getTime()) / 1000;
        this.saveToCache.put(key, ttl);
        return this.put(key, value, ttl);
    }

    @Override
    public Object put(String key, Object value, int ttl) {
        Object result = this.caches.put(key, value);
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, ttl);
        this.expiryCache.put(key, calendar.getTime().getTime());
        this.intervalCache.put(key, ttl);
        return result;
    }

    @Override
    public Object remove(String key) {
        Object result = this.caches.remove(key);
        this.expiryCache.remove(key);
        this.intervalCache.remove(key);
        this.writeOptLog(key);
        return result;
    }

    @Override
    public int size() {
        this.checkAll();
        return this.expiryCache.size();
    }

    @Override
    public int size(boolean updateTime) {
        this.checkAllWithoutUpdateTime();
        return this.expiryCache.size();
    }

    @Override
    public Collection<Object> values() {
        this.checkAll();
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(this.caches.values());
        return values;
    }

    @Override
    public Collection<Object> values(boolean updateTime) {
        this.checkAllWithoutUpdateTime();
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(this.caches.values());
        return values;
    }

    private void checkValidate(String key) {
        if (null == key) {
            return;
        }
        if (this.expiryCache.get(key) != null && this.expiryCache.get(key) != -1L && new Date(this.expiryCache.get(key)).before(new Date())) {
            this.caches.remove(key);
            this.writeOptLog(key);
            this.writeSessionTimeoutLog(key);
            this.expiryCache.remove(key);
            this.intervalCache.remove(key);
            if (null != this.saveToCache && this.saveToCache.get(key) != null) {
                this.saveToCache.remove(key);
            }
        } else {
            if (null != this.saveToCache && this.saveToCache.get(key) != null) {
                return;
            }
            if (this.intervalCache.get(key) == null) {
                return;
            }
            int ttl = this.intervalCache.get(key);
            Object value = this.caches.get(key);
            this.put(key, value, ttl);
        }
    }

    private void clearExpiryKey(String key) {
        if (key != null && this.expiryCache.get(key) != null && this.expiryCache.get(key) != -1L && new Date(this.expiryCache.get(key)).before(new Date())) {
            this.caches.remove(key);
            this.writeOptLog(key);
            this.writeSessionTimeoutLog(key);
            this.expiryCache.remove(key);
            this.intervalCache.remove(key);
        }
    }

    private void checkAll() {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidate(key);
        }
    }

    private void checkAllWithoutUpdateTime() {
        for (String key : this.expiryCache.keySet()) {
            this.clearExpiryKey(key);
        }
    }

    @Override
    public void destroy() {
        try {
            this.clear();
            if (this.scheduleService != null) {
                this.scheduleService.shutdown();
            }
            this.scheduleService = null;
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
        this.log.info((Object)"Destory user local cache resources.");
    }

    @Override
    public void decreaseCachedDataCount(String key) {
    }

    @Override
    public void increaseCachedDataCount(String key) {
    }

    private void writeOptLog(String userName) {
        if (userName.startsWith("USER_LOCK")) {
            String name = userName.substring("USER_LOCK".length());
            SysOptLog oOptLog = new SysOptLog();
            oOptLog.setDate(new Date());
            oOptLog.setLevel(2);
            oOptLog.setModule("lego.dic.module.user");
            oOptLog.setOperation("lego.lab.log.func.userunlock");
            oOptLog.setResult(1);
            oOptLog.setOperator(name);
            oOptLog.setTerminalIp("127.0.0.1");
            oOptLog.setTarget(name);
            oOptLog.setTargetLocal(Boolean.valueOf(false));
        } else {
            this.log.info((Object)("remove caches " + userName));
        }
    }

    private void writeSessionTimeoutLog(String key) {
        if (null != key && key.startsWith("userId=")) {
            String[] vvs;
            String userId = null;
            String loginIp = null;
            for (String s : vvs = key.split(",")) {
                String[] kv = s.split("=");
                if (kv.length != 2) {
                    return;
                }
                if ("userId".equals(kv[0])) {
                    userId = kv[1];
                    continue;
                }
                if (!"loginIp".equals(kv[0])) continue;
                loginIp = kv[1];
            }
            if (null == userId || null == loginIp) {
                return;
            }
            SysOptLog oOptLog = new SysOptLog();
            oOptLog.setDate(new Date());
            oOptLog.setLevel(1);
            oOptLog.setResult(1);
            oOptLog.setModule("lego.dic.module.user");
            oOptLog.setOperation("lego.lab.com.loginout.auto");
            oOptLog.setOperator("system");
            oOptLog.setTerminalIp(loginIp);
            oOptLog.setTargetLocal(Boolean.valueOf(false));
        }
    }

    class CheckOutOfDateSchedule
    implements Runnable {
        ConcurrentHashMap<String, Object> caches;
        ConcurrentHashMap<String, Long> expiryCache;

        public CheckOutOfDateSchedule(ConcurrentHashMap<String, Object> caches, ConcurrentHashMap<String, Long> expiryCache) {
            this.caches = caches;
            this.expiryCache = expiryCache;
        }

        @Override
        public void run() {
            this.check();
        }

        public void check() {
            try {
                for (String key : this.caches.keySet()) {
                    long date;
                    if (this.expiryCache.get(key) == null || (date = this.expiryCache.get(key).longValue()) <= 0L || !new Date(date).before(new Date())) continue;
                    this.doRemoveCache(this.caches, key);
                    this.doRemoveOnlineUser(this.caches, key);
                }
            }
            catch (Exception ex) {
                UserLoginLocalCacheImpl.this.log.info((Object)("Local Cache Exception!" + ex));
            }
        }

        private void doRemoveCache(ConcurrentHashMap<String, Object> cache, String key) {
            UserLoginLocalCacheImpl.this.saveToCache.remove(key);
            UserLoginLocalCacheImpl.this.intervalCache.remove(key);
            this.expiryCache.remove(key);
            cache.remove(key);
            UserLoginLocalCacheImpl.this.writeOptLog(key);
            UserLoginLocalCacheImpl.this.writeSessionTimeoutLog(key);
        }

        private void doRemoveOnlineUser(ConcurrentHashMap<String, Object> cache, String key) {
            ConcurrentSkipListSet set;
            if (cache.containsKey(UserLoginLocalCacheImpl.this.onlineSessionIdList) && null != (set = (ConcurrentSkipListSet)cache.get(UserLoginLocalCacheImpl.this.onlineSessionIdList))) {
                set.remove(key);
            }
        }
    }
}

