/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.menu.sdk.model.MenuBean;
import com.hs.lego.core.system.menu.sdk.model.MenuItemBean;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class MenuUtil {
    private static final String MAINMENU_NODE_FLAG = "mainMenu";
    private static final String MENU_NODE_DESC_NAME_FLAG = "descname";
    private static final String MENU_NODE_DESC_FLAG = "DESC";
    private static final String MENU_NODE_PARAS_FLAG = "PARAS";
    private static final String MENU_NODE_PARA_FLAG = "PARA";
    private static final String PARA_NAME_FLAG = "name";
    private static final String PARA_VALUE_FLAG = "value";
    private static final String PARA_NAME_SERNUMBER = "serialnumber";
    private static final String PARA_NAME_ORISERNUMBER = "originalSerialNumber";
    private static final String PARA_NAME_OPID = "operationID";
    private static final String PARA_NAME_LICENSFEATRUE = "licensefeatrue";
    private static final String PARA_NAME_LICENSFUNCITEM = "licensefunctionItem";
    private static final String PARA_NAME_LICENSRESITEM = "licenseResourceItem";
    private static final String PARA_NAME_URL = "action";
    private static final String PARA_NAME_TYPE = "type";
    private static final String PARA_NAME_OPID_CONSTANT = "operationIdConstant";
    private static final String PARA_NAME_SHOWPANEL = "isShowInPanel";
    private static final String PARA_NAME_ICONPATH = "icon";
    private static final String PARA_NAME_USEFRAME = "useFrame";
    private static final String PARA_NAME_NOLEFTMENU = "noLeftMenu";
    private static final Object LOCK = new Object();
    private static MenuUtil instanse = null;
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);

    private MenuUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MenuUtil getInstanse() {
        Object object = LOCK;
        synchronized (object) {
            if (instanse == null) {
                instanse = new MenuUtil();
            }
            return instanse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MenuBean> getMenu(InputStream inStream) {
        if (null == inStream) {
            return null;
        }
        TreeSet<MenuBean> menuSet = new TreeSet<MenuBean>();
        InputStream inputStream = null;
        Document document = null;
        try {
            inputStream = inStream;
            SAXReader reader = new SAXReader();
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            document = reader.read(inputStream);
            Element root = document.getRootElement();
            Iterator iterator = root.elementIterator(MENU_NODE_DESC_FLAG);
            while (iterator.hasNext()) {
                Element tableElement = (Element)iterator.next();
                String decName = tableElement.attributeValue(MENU_NODE_DESC_NAME_FLAG);
                if (!decName.equalsIgnoreCase(MAINMENU_NODE_FLAG)) continue;
                this.parseMenu(tableElement, menuSet);
            }
            document.clearContent();
        }
        catch (DocumentException e) {
            log.error((Object)"DocumentException", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"IOException");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioe) {
                log.error((Object)"IOException");
            }
        }
        return menuSet;
    }

    private void parseMenu(Element element, Set<MenuBean> set) {
        MenuBean menuBean = null;
        String menuName = "";
        String serialNumber = "";
        String originalSerialNumber = "";
        String operationId = "";
        String licenseFeatrue = "";
        String licenseFunctionItem = "";
        String licenseResourceItem = "";
        String actionUrl = "";
        String menuType = "";
        String operationIdConstant = "";
        Boolean isShowInPanel = Boolean.FALSE;
        String iconPath = "";
        Boolean useFrame = Boolean.TRUE;
        Boolean noLeftMenu = Boolean.FALSE;
        Iterator parasitrator = element.elementIterator(MENU_NODE_PARAS_FLAG);
        while (parasitrator.hasNext()) {
            Element pamaElement = (Element)parasitrator.next();
            Iterator paraitrator = pamaElement.elementIterator(MENU_NODE_PARA_FLAG);
            while (paraitrator.hasNext()) {
                Element pamasElement = (Element)paraitrator.next();
                String pamaName = pamasElement.attributeValue(PARA_NAME_FLAG);
                String value = pamasElement.attributeValue(PARA_VALUE_FLAG);
                if (pamaName.equals(PARA_NAME_FLAG)) {
                    menuName = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_SERNUMBER)) {
                    serialNumber = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_ORISERNUMBER)) {
                    originalSerialNumber = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_OPID)) {
                    operationId = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_OPID_CONSTANT)) {
                    operationIdConstant = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_LICENSFEATRUE)) {
                    licenseFeatrue = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_LICENSFUNCITEM)) {
                    licenseFunctionItem = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_LICENSRESITEM)) {
                    licenseResourceItem = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_URL)) {
                    actionUrl = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_TYPE)) {
                    menuType = value;
                    continue;
                }
                if (pamaName.equalsIgnoreCase(PARA_NAME_SHOWPANEL)) {
                    isShowInPanel = this.showInPanel(value);
                    continue;
                }
                if (pamaName.equals(PARA_NAME_ICONPATH)) {
                    iconPath = value;
                    continue;
                }
                if (pamaName.equals(PARA_NAME_USEFRAME)) {
                    useFrame = this.checkUseFrame(value);
                    continue;
                }
                if (!pamaName.equals(PARA_NAME_NOLEFTMENU)) continue;
                noLeftMenu = this.checkNoLeftMenu(value);
            }
        }
        if (menuType.equalsIgnoreCase("JMenu")) {
            menuBean = new MenuBean();
            menuBean.setMenuName(menuName);
            menuBean.setSerialNumber(serialNumber);
            menuBean.setOriginalSerialNumber(originalSerialNumber);
            menuBean.setOperationId(operationId);
            menuBean.setOperationIdConstant(operationIdConstant);
            menuBean.setLicenseFeatrue(licenseFeatrue);
            menuBean.setLicenseFunctionItem(licenseFunctionItem);
            menuBean.setLicenseResourceItem(licenseResourceItem);
            menuBean.setActionUrl(actionUrl);
            menuBean.setMenuType(menuType);
            menuBean.setShowInPanel(isShowInPanel.booleanValue());
            menuBean.setIconPath(iconPath);
            menuBean.setUseFrame(useFrame.booleanValue());
            menuBean.setNoLeftMenu(noLeftMenu.booleanValue());
            set.add(menuBean);
        } else if (menuType.equalsIgnoreCase("JMenuItem")) {
            menuBean = new MenuItemBean("");
            menuBean.setMenuName(menuName);
            menuBean.setSerialNumber(serialNumber);
            menuBean.setOriginalSerialNumber(originalSerialNumber);
            menuBean.setOperationId(operationId);
            menuBean.setOperationIdConstant(operationIdConstant);
            menuBean.setLicenseFeatrue(licenseFeatrue);
            menuBean.setLicenseFunctionItem(licenseFunctionItem);
            menuBean.setLicenseResourceItem(licenseResourceItem);
            menuBean.setActionUrl(actionUrl);
            menuBean.setMenuType(menuType);
            menuBean.setShowInPanel(isShowInPanel.booleanValue());
            menuBean.setIconPath(iconPath);
            menuBean.setUseFrame(useFrame.booleanValue());
            menuBean.setNoLeftMenu(noLeftMenu.booleanValue());
            set.add(menuBean);
        }
        if (menuType.equalsIgnoreCase("JMenu") || menuType.equalsIgnoreCase("MenuSet")) {
            Iterator menuItrator = element.elementIterator(MENU_NODE_DESC_FLAG);
            while (menuItrator.hasNext()) {
                Element temp = (Element)menuItrator.next();
                this.parseMenu(temp, set);
            }
        }
    }

    private Boolean checkNoLeftMenu(String value) {
        boolean noLeftMenu = value.equalsIgnoreCase("true") ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        return noLeftMenu;
    }

    private Boolean checkUseFrame(String value) {
        boolean useFrame = value.equalsIgnoreCase("false") ? Boolean.FALSE.booleanValue() : Boolean.TRUE.booleanValue();
        return useFrame;
    }

    private Boolean showInPanel(String value) {
        boolean isShowInPanel = value.equalsIgnoreCase("true") ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        return isShowInPanel;
    }
}

