/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.menu;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.MenuUtil;
import com.hs.lego.core.system.menu.MenuAuthority;
import com.hs.lego.core.system.menu.sdk.model.MenuBean;
import com.hs.lego.core.system.menu.sdk.model.MenuItemBean;
import com.hs.lego.core.system.menu.sdk.service.IMenuManager;
import com.hs.lego.core.system.menu.sdk.service.IProductsMenuFilter;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class MenuManager
implements IMenuManager,
Serializable {
    public static final String MENU_UNICOM_SERIALNUMBER = "6500-100-41";
    private static final long serialVersionUID = -5487999485620553239L;
    private static final String FIRST_INDEX = "1000";
    private static final String TOPO_INDEX = "5000";
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private static Map<String, IProductsMenuFilter> menuFilter = new HashMap<String, IProductsMenuFilter>();
    private static final String UNICOM_CONFIG_PATH = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "unicom" + File.separator + "unicom.xml";
    private static Set<MenuBean> allSysMenu;
    private transient MenuAuthority menuAuthority = null;
    private String sysMenuPath = File.separator + "Tomcat6" + File.separator + "bin" + File.separator + "resources" + File.separator + "menu" + File.separator + "platform" + File.separator + "aticMenuDes.xml";
    private Set<MenuBean> menuBeanSet = new HashSet<MenuBean>();

    @Override
    public void loadDynamicMenus(Set<MenuBean> set) {
        if (null == set) {
            return;
        }
        if (null != allSysMenu) {
            for (MenuBean menuBean : set) {
                if (allSysMenu.contains(menuBean)) {
                    MenuBean temp = this.getMenuBySerialNumber(menuBean.getSerialNumber());
                    if (null == temp) continue;
                    temp.setCounter(temp.getCounter() + 1);
                    continue;
                }
                allSysMenu.add(menuBean);
            }
        } else {
            this.menuBeanSet.addAll(set);
            log.error((Object)"Products load mMenu  fail,allSysMenu is null");
        }
    }

    @Override
    public void removeDynamicMenus(Set<MenuBean> set) {
        if (null == set) {
            return;
        }
        if (null != allSysMenu) {
            for (MenuBean menuBean : set) {
                MenuBean temp = this.getMenuBySerialNumber(menuBean.getSerialNumber());
                if (temp == null) continue;
                if (temp.getCounter() == 1) {
                    allSysMenu.remove(temp);
                    continue;
                }
                temp.setCounter(temp.getCounter() - 1);
            }
        } else {
            log.error((Object)"Products remove system menu fail,allSysMenu is null");
        }
    }

    public void removeAllMenus() {
        if (null != allSysMenu) {
            allSysMenu.clear();
        } else {
            log.error((Object)"Plat remove system menu fail,allSysMenu is null");
        }
    }

    @Override
    public Set<MenuBean> getAllMenu() {
        return allSysMenu;
    }

    @Override
    public Set<MenuBean> getAllSystemMenu(long userId) {
        Set<MenuBean> allMenu = this.getAllMenuTree();
        Set<MenuBean> allFilteredMenu = new TreeSet<MenuBean>();
        if (null != allMenu) {
            allFilteredMenu.addAll(allMenu);
        }
        TreeSet<MenuBean> allMenuTreetemp = null;
        log.info((Object)("menuFilter :" + menuFilter + "allFilteredMenu :" + allFilteredMenu));
        for (IProductsMenuFilter filter : menuFilter.values()) {
            try {
                allFilteredMenu = filter.filterMenus(allFilteredMenu, userId);
            }
            catch (Exception e) {
                log.info((Object)"IProductsMenuFilter filter error");
            }
        }
        if (null != allFilteredMenu) {
            allMenuTreetemp = new TreeSet<MenuBean>();
            for (MenuBean temp : allFilteredMenu) {
                boolean eable = this.menuAuthority.isEnabled(temp, userId);
                if (!eable) continue;
                allMenuTreetemp.add(temp);
            }
        }
        return allMenuTreetemp;
    }

    private Set<MenuBean> filterMenu(Set<MenuBean> allSysMenuTemp) {
        TreeSet<MenuBean> allMenuTreetemp = new TreeSet<MenuBean>();
        if (null == allSysMenuTemp) {
            return allMenuTreetemp;
        }
        for (MenuBean menubean : allSysMenuTemp) {
            if (menubean.getSerialNumber().equals(FIRST_INDEX) || menubean.getSerialNumber().equals(TOPO_INDEX)) {
                allMenuTreetemp.add(menubean);
                continue;
            }
            if (menubean instanceof MenuItemBean) {
                allMenuTreetemp.add(menubean);
                continue;
            }
            if (!this.displayEnble(allSysMenuTemp, menubean)) continue;
            allMenuTreetemp.add(menubean);
        }
        return allMenuTreetemp;
    }

    private boolean displayEnble(Set<MenuBean> allSysMenuTemp, MenuBean menuBean) {
        Set<MenuBean> chirldMenu = this.getAllChildMenu(allSysMenuTemp, menuBean.getSerialNumber());
        if (null == chirldMenu) {
            return false;
        }
        for (MenuBean temp : chirldMenu) {
            if (!(temp instanceof MenuItemBean)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<MenuBean> getAllMenuByUserId(long userId) {
        TreeSet<MenuBean> allMenuTreetemp = null;
        Set<MenuBean> allMenu = this.getAllMenuTree();
        Set<MenuBean> allFilterMenu = new TreeSet<MenuBean>();
        if (null != allMenu) {
            allFilterMenu.addAll(allMenu);
        }
        for (IProductsMenuFilter filter : menuFilter.values()) {
            try {
                allFilterMenu = filter.filterMenus(allFilterMenu, userId);
            }
            catch (Exception e) {
                log.info((Object)"IProductsMenuFilter filter error");
            }
        }
        Set<MenuBean> userAllMenu = null;
        if (null != allFilterMenu) {
            allMenuTreetemp = new TreeSet<MenuBean>();
            for (MenuBean temp : allFilterMenu) {
                boolean eable = this.menuAuthority.isEnabled(temp, userId);
                if (!eable) continue;
                allMenuTreetemp.add(temp);
            }
        }
        userAllMenu = this.filterMenu(allMenuTreetemp);
        return userAllMenu;
    }

    @Override
    public MenuBean getMenuBySerialNumber(String serialNumber) {
        MenuBean menuBean = null;
        if (null != allSysMenu) {
            for (MenuBean temp : allSysMenu) {
                if (!temp.getSerialNumber().equals(serialNumber)) continue;
                menuBean = temp;
                return menuBean;
            }
        }
        return menuBean;
    }

    @Override
    public Set<MenuBean> getAllChildMenu(long userId, String serialNumber) {
        TreeSet<MenuBean> allChildMenu = null;
        Set<MenuBean> allMenu = this.getAllMenuByUserId(userId);
        allChildMenu = new TreeSet<MenuBean>();
        String crrentSerialNumber = "";
        for (MenuBean temp : allMenu) {
            crrentSerialNumber = temp.getSerialNumber();
            if (crrentSerialNumber.indexOf(serialNumber) != 0 || serialNumber.split("-").length >= crrentSerialNumber.split("-").length) continue;
            allChildMenu.add(temp);
        }
        return allChildMenu;
    }

    @Override
    public Set<MenuBean> getAllChildMenu(String serialNumber) {
        TreeSet<MenuBean> allChildMenu = null;
        Set<MenuBean> allMenu = this.getAllMenuTree();
        if (null != allMenu) {
            allChildMenu = new TreeSet<MenuBean>();
            String crrentSerialNumber = "";
            for (MenuBean temp : allMenu) {
                crrentSerialNumber = temp.getSerialNumber();
                if (crrentSerialNumber.indexOf(serialNumber) != 0 || serialNumber.split("-").length >= crrentSerialNumber.split("-").length) continue;
                allChildMenu.add(temp);
            }
        }
        return allChildMenu;
    }

    public Set<MenuBean> getAllChildMenu(Set<MenuBean> allMenuBean, String serialNumber) {
        TreeSet<MenuBean> allChildMenu = null;
        Set<MenuBean> allMenu = allMenuBean;
        if (null != allMenu) {
            allChildMenu = new TreeSet<MenuBean>();
            String crrentSerialNumber = "";
            for (MenuBean temp : allMenu) {
                crrentSerialNumber = temp.getSerialNumber();
                if (crrentSerialNumber.indexOf(serialNumber) != 0 || serialNumber.split("-").length >= crrentSerialNumber.split("-").length) continue;
                allChildMenu.add(temp);
            }
        }
        return allChildMenu;
    }

    private Set<MenuBean> getAllMenuTree() {
        return allSysMenu;
    }

    public void setMenuAuthority(MenuAuthority menuAuthority) {
        this.menuAuthority = menuAuthority;
    }

    public void initSysMenu() {
        if (null != allSysMenu) {
            allSysMenu.clear();
        } else {
            allSysMenu = new TreeSet<MenuBean>();
        }
        String currentPath = AticInstallUtil.getInstance().getAticInstallPath() + this.sysMenuPath;
        Set<MenuBean> set = this.getMenuByAbsolutePath(currentPath);
        if (null != set) {
            allSysMenu.addAll(set);
        }
        this.loadDynamicMenus(this.menuBeanSet);
        this.configuratorUnicomMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configuratorUnicomMenu() {
        String unicomConfigPath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + UNICOM_CONFIG_PATH;
        Properties properties = new Properties();
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(unicomConfigPath);
            properties.loadFromXML(iStream);
            boolean isOpen = Boolean.parseBoolean(properties.getProperty("atic.unicom.isOpen"));
            Iterator<MenuBean> iterator = allSysMenu.iterator();
            while (iterator.hasNext()) {
                MenuBean menuBean = iterator.next();
                if (isOpen || !MENU_UNICOM_SERIALNUMBER.equals(menuBean.getSerialNumber())) continue;
                iterator.remove();
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (InvalidPropertiesFormatException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            if (null != iStream) {
                try {
                    ((InputStream)iStream).close();
                }
                catch (IOException e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MenuBean> getMenuByAbsolutePath(String menuFilePath) {
        if (null == menuFilePath || menuFilePath.trim().equals("")) {
            return null;
        }
        InputStream inputStream = null;
        Set<MenuBean> set = null;
        try {
            File file = new File(menuFilePath);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
                set = MenuUtil.getInstanse().getMenu(inputStream);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"IOException error");
                }
            }
        }
        return set;
    }
}

