/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.discover.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.discover.sdk.model.ProductsCustomizeInfo;
import com.hs.lego.nem.discover.sdk.service.IProductsCustomizeService;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ProductsCustomizeServiceImpl
implements IProductsCustomizeService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private String customizeseFile = "resources" + File.separator + "products" + File.separator + "customizese" + File.separator + "discover.properties";
    private ProductsCustomizeInfo customizeInfo;

    @Override
    public ProductsCustomizeInfo getProductsCustomizeInfo() {
        return this.customizeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        Properties props = new Properties();
        String currentPath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + this.customizeseFile;
        FileInputStream inputStream = null;
        File productsFile = new File(currentPath);
        if (!productsFile.exists()) return;
        try {
            inputStream = new FileInputStream(productsFile);
            props.load(inputStream);
            this.initCustomizeInfo(props);
            return;
        }
        catch (FileNotFoundException fe) {
            LOGGER.error((Object)"file not found");
            return;
        }
        catch (IOException iex) {
            LOGGER.error((Object)"IOException error");
            return;
        }
        finally {
            try {
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException iex) {
                LOGGER.error((Object)"IO Exception error");
            }
            finally {
                props.clear();
            }
        }
    }

    private void initCustomizeInfo(Properties props) {
        this.customizeInfo = new ProductsCustomizeInfo();
        String productsName = "";
        String productsNameKey = "productsname";
        productsName = props.getProperty(productsNameKey);
        this.customizeInfo.setProductsName(productsName);
        String key = "";
        String value = "";
        Map<String, String> customizeParameters = this.customizeInfo.getCustomizeParameters();
        Set<Map.Entry<Object, Object>> keySet = props.entrySet();
        for (Map.Entry<Object, Object> obj : keySet) {
            key = obj.getKey().toString();
            value = props.getProperty(key);
            customizeParameters.put(key, value);
        }
    }

    public String getCustomizeseFile() {
        return this.customizeseFile;
    }

    public void setCustomizeseFile(String customizeseFile) {
        this.customizeseFile = customizeseFile;
    }

    public ProductsCustomizeInfo getCustomizeInfo() {
        return this.customizeInfo;
    }

    public void setCustomizeInfo(ProductsCustomizeInfo customizeInfo) {
        this.customizeInfo = customizeInfo;
    }
}

