/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.filter;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.util.SessionDesListnerSer;
import com.hs.lego.ui.plat.common.util.UiBaseUtil;
import com.hs.lego.ui.plat.user.util.UserUrlAuthUtil;
import com.hs.lego.ui.tag.tools.IAuthHandler;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class SecurityFilter
implements Filter {
    private static final int AMF_TIMEOUT_CODE = 65535;
    private static final List<String> ALLOWED_ASSETS = new ArrayList<String>();
    private static final List<String> ALLOWED_REQUEST;
    private static final List<String> FLUXANALYSIS;
    private static final List<String> ATTACKANALYSIS;
    private static final List<String> DNSANALYSIS;
    private static final List<String> HTTPANSLYSIS;
    private static final Long FLUXANALYSIS_OPTID;
    private static final Long ATTACKANALYSIS_OPTID;
    private static final Long DNSANALYSIS_OPTID;
    private static final Long HTTPANSLYSIS_OPTID;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private List<String> validUris = new ArrayList<String>();
    private List<String> refresh = new ArrayList<String>();
    private Properties config = new Properties();

    public void destroy() {
    }

    private boolean hasTimeout(String uri, User currentUser) {
        boolean bTimeout = false;
        String sessId = currentUser.getSession();
        try {
            boolean checkTimeOut = true;
            for (String refreshUri : this.refresh) {
                if (!uri.contains(refreshUri)) continue;
                checkTimeOut = false;
            }
            IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().getService("userMgr", IUserMgr.class);
            if (userMgr.checkTimeOut(sessId, checkTimeOut).booleanValue()) {
                bTimeout = true;
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("exception Exit system time:" + currentUser.getLoginDate()), (Throwable)ex);
            bTimeout = true;
        }
        return bTimeout;
    }

    private boolean isSpecialUri(String uri) {
        if (uri.endsWith("copyright.html")) {
            return true;
        }
        boolean bSpecial = false;
        if (uri.endsWith(".do") || uri.endsWith(".jsp")) {
            for (String validUri : this.validUris) {
                if (!uri.endsWith(validUri)) continue;
                bSpecial = true;
                break;
            }
        }
        return bSpecial;
    }

    private boolean isAllowedAsset(String uri) {
        boolean bIsAsset = false;
        int len = ALLOWED_ASSETS.size();
        for (int index = 0; index < len; ++index) {
            if (!uri.endsWith(ALLOWED_ASSETS.get(index))) continue;
            bIsAsset = true;
            break;
        }
        return bIsAsset;
    }

    private boolean isAllowedRequest(String uri) {
        boolean bIsAsset = false;
        if (uri.equals("/servlet/DisplayChart")) {
            return true;
        }
        int len = ALLOWED_REQUEST.size();
        for (int index = 0; index < len; ++index) {
            if (!uri.endsWith(ALLOWED_REQUEST.get(index))) continue;
            bIsAsset = true;
            break;
        }
        return bIsAsset;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Boolean mustModifyPwd;
        String passState;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        if (uri.startsWith("/rest/")) {
            chain.doFilter(request, response);
            return;
        }
        if (!uri.equals(URLDecoder.decode(uri, "UTF-8"))) {
            this.log.error((Object)("URI is code : " + uri));
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
            return;
        }
        uri = URLDecoder.decode(uri, "UTF-8");
        if (!(uri = Normalizer.normalize(uri, Normalizer.Form.NFKC)).matches("^[\\w!./-]+$")) {
            this.log.error((Object)"URI exist error Character : ");
            httpRequest.getSession().invalidate();
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
            return;
        }
        if (this.isSpecialUri(uri)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.isAllowedAsset(uri)) {
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (null == session) {
            this.log.info((Object)"Exit system time: HttpSession  is null");
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
            return;
        }
        User currentUser = (User)httpRequest.getSession().getAttribute("currentUser");
        if (null == currentUser) {
            this.log.info((Object)"Exit system time: currentUser is null");
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
            return;
        }
        if (!currentUser.getIpAdr().equals(UiBaseUtil.getInstance().getRemoteAddr(httpRequest)) && !this.isInIpwhiteList(currentUser.getIpAdr())) {
            this.log.info((Object)"Exit system: request ip and user ip is not same and the request ip is not in IPwhitelist");
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
            return;
        }
        if (!uri.endsWith("/core/system/importLogLic.do") && session.getAttribute("LOGIN_NEED_LIC ") != null) {
            this.log.info((Object)"Exit system time: !uri.contains importLogLic and session.getAttribute(MoniConstant.LOGIN_NEED_LIC) != null ");
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
            return;
        }
        if (uri.startsWith("/help/")) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.isAllowedRequest(uri)) {
            this.log.error((Object)("URI suffix is not allowed : " + uri));
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
            return;
        }
        if (uri.endsWith(".do") || uri.endsWith(".jsp")) {
            if (currentUser.getIsAdmin().equals("false")) {
                String actionUrl = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
                String queryStr = httpRequest.getQueryString();
                queryStr = this.checkQueryStr(queryStr, actionUrl, httpRequest);
                Set<String> authOperatorSet = UserUrlAuthUtil.getInstance().getAuthOperator(actionUrl.replace("//", "/"), queryStr);
                if ("/atic/ireport/reportPage.do".equals(actionUrl)) {
                    queryStr = queryStr == null ? "" : queryStr;
                    String reportId = this.getReportId(queryStr, actionUrl, httpRequest);
                    Long currentOptId = 0L;
                    if (FLUXANALYSIS.contains(reportId)) {
                        currentOptId = FLUXANALYSIS_OPTID;
                    } else if (ATTACKANALYSIS.contains(reportId)) {
                        currentOptId = ATTACKANALYSIS_OPTID;
                    } else if (DNSANALYSIS.contains(reportId)) {
                        currentOptId = DNSANALYSIS_OPTID;
                    } else if (HTTPANSLYSIS.contains(reportId)) {
                        currentOptId = HTTPANSLYSIS_OPTID;
                    }
                    IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().getService("userMgr", IUserMgr.class);
                    Set<Long> getOptId = userMgr.getAllOptId(currentUser.getUserID());
                    if (!getOptId.contains(currentOptId)) {
                        this.operationLog(currentUser, actionUrl);
                        httpRequest.getSession().invalidate();
                        httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
                        return;
                    }
                }
                if (!authOperatorSet.isEmpty()) {
                    boolean valid = false;
                    for (String authOperator : authOperatorSet) {
                        IAuthHandler authHandler = (IAuthHandler)httpRequest.getSession().getAttribute("auth_handler");
                        if (!authHandler.isAuthority(authOperator)) continue;
                        valid = true;
                        break;
                    }
                    if (!valid) {
                        this.log.info((Object)("over Purview:" + currentUser.getLoginDate() + "---actionUrl:" + actionUrl + "---queryStr:" + queryStr));
                        this.operationLog(currentUser, actionUrl);
                        httpRequest.getSession().invalidate();
                        httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
                        return;
                    }
                }
            }
            if (this.hasTimeout(uri, currentUser)) {
                this.log.info((Object)("Exit system time:" + currentUser.getLoginDate()));
                SessionDesListnerSer.executeSessionDestroyed((String)session.getId());
                httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
                return;
            }
        }
        if ((passState = (String)httpRequest.getSession().getAttribute("passState")) != null) {
            if (passState.equals("unknow")) {
                this.log.info((Object)"Exit system time: passState is unknow");
                httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
                return;
            }
            if (passState.equals("expired") && uri.contains("index.do")) {
                this.log.info((Object)"Exit system time: passState is expired");
                httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
                return;
            }
        }
        if ((mustModifyPwd = (Boolean)httpRequest.getSession().getAttribute("mustModifyPwd")) != null && mustModifyPwd.booleanValue() && uri.contains("index.do")) {
            this.log.info((Object)"Exit system time: current user must change password first.");
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
            return;
        }
        boolean isContinue = true;
        if (uri.contains("messagebroker/amf")) {
            isContinue = this.processAmfRequest(httpRequest, httpResponse);
        }
        if (isContinue) {
            chain.doFilter(request, response);
        }
    }

    private void operationLog(User currentUser, String actionUrl) {
        SysOptLog optLog = new SysOptLog();
        optLog.setOperation("lego.lab.msg.usr.overpurview.operation");
        optLog.setModule("lego.dic.module.user");
        optLog.setLevel(SysoplogLevel.warning.getValue());
        optLog.setOperator(currentUser.getUserName().trim());
        optLog.setTerminalIp(currentUser.getIpAdr());
        optLog.setResult(0);
        optLog.setDetail("lego.lab.msg.usr.overpurview.detail");
        optLog.setDetailPara(new String[]{actionUrl});
        ISysOptLog sysLogService = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysLogService.writeOptLog(optLog);
    }

    private String getReportId(String queryStr, String url, HttpServletRequest httpRequest) {
        String reportId = "";
        if ("/atic/ireport/reportPage.do".equals(url)) {
            String[] strs = queryStr.split("=|&");
            int length = strs.length;
            for (int i = 0; i < length; ++i) {
                if (!"reportId".equals(strs[i]) || i + 1 >= length) continue;
                reportId = strs[i + 1];
                return reportId;
            }
        } else {
            if ("/atic/ireport/queryReport.do".equals(url) || "/atic/ireport/importTurnBackTaskPage.do".equals(url)) {
                reportId = httpRequest.getParameter("reportId");
            }
            return reportId;
        }
        return reportId;
    }

    private boolean processAmfRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        block4: {
            try {
                String param = httpRequest.getParameter("op");
                if (!"saveView".equals(param) && !"queryView".equals(param)) break block4;
                User currentUser = (User)httpRequest.getSession().getAttribute("currentUser");
                if (null != currentUser) {
                    IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().getService("userMgr", IUserMgr.class);
                    if (userMgr.checkTimeOut(currentUser.getSession(), true).booleanValue()) {
                        this.log.info((Object)("Exit system time in processAmfRequest:" + currentUser.getLoginDate()));
                        httpResponse.sendError(65535);
                        return false;
                    }
                    break block4;
                }
                this.log.info((Object)"currentUser is null in processAmfRequest");
                httpResponse.sendError(65535);
                return false;
            }
            catch (Exception ex) {
                this.log.error((Object)"exception occured in processAmfRequest", (Throwable)ex);
                httpResponse.sendError(65535);
                return false;
            }
        }
        return true;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String refreshStr;
        String validUriStr = filterConfig.getInitParameter("validUris");
        if (validUriStr != null && !validUriStr.isEmpty()) {
            String[] validUriArr = validUriStr.split(",");
            this.validUris = new ArrayList<String>(validUriArr.length);
            for (String validUri : validUriArr) {
                this.validUris.add(validUri.trim());
            }
        }
        if ((refreshStr = filterConfig.getInitParameter("refresh")) != null && !refreshStr.isEmpty()) {
            String[] refreshArr = refreshStr.split(",");
            this.refresh = new ArrayList<String>(refreshArr.length);
            for (String uri : refreshArr) {
                this.refresh.add(uri.trim());
            }
        }
    }

    private String checkQueryStr(String queryStr, String url, HttpServletRequest httpRequest) {
        if ("/atic/ireport/reportPage.do".equals(url)) {
            String[] strs = queryStr.split("=|&");
            int length = strs.length;
            for (int i = 0; i < length; ++i) {
                if (!"reportId".equals(strs[i]) || i + 1 >= length) continue;
                queryStr = strs[i] + "=" + strs[i + 1];
                return queryStr;
            }
        } else {
            queryStr = null;
            if ("/atic/ireport/queryReport.do".equals(url) || "/atic/ireport/importTurnBackTaskPage.do".equals(url)) {
                String reportId = httpRequest.getParameter("reportId");
                queryStr = "reportId=" + reportId;
            }
            return queryStr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInIpwhiteList(String userIP) {
        FileInputStream fin = null;
        String[] ipWhitelist = null;
        try {
            String currentPath = AticInstallUtil.getInstance().getAticInstallPath() + "conf" + File.separator + "IPwhitelist.properties";
            fin = new FileInputStream(currentPath);
            this.config.load(fin);
            String ipWhite = this.config.getProperty("IPwhitelist", "");
            ipWhitelist = ipWhite.split(";");
            for (int i = 0; i < ipWhitelist.length; ++i) {
                if (SecurityFilter.validateIpv4(ipWhitelist[i])) continue;
                this.log.info((Object)"IPwhitelist is empty or has invalide IPs");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            this.log.error((Object)"readDevConfFile exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (NumberFormatException e) {
            this.log.error((Object)"NumberFormatException", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.log.error((Object)"readDevConfFile exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != fin) {
                    fin.close();
                }
            }
            catch (IOException ex) {
                this.log.error((Object)"readDevConfFile close FileInputStream error.", (Throwable)ex);
            }
        }
        int i = 0;
        if (i < ipWhitelist.length) {
            this.log.info((Object)"user IP is in the IPwhitelist");
            return true;
        }
        return false;
    }

    public static boolean validateIpv4(String ip) {
        String ipHeadStr;
        if (SecurityFilter.isNull(ip)) {
            return false;
        }
        String regex1 = "^((22[0-3]|2[0-1]\\d|1\\d{2}|[1-9]\\d|[1-9])\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|[0-9]))?$";
        return ip.matches(regex1) && !StringUtils.equals((CharSequence)(ipHeadStr = ip.split("\\.")[0]), (CharSequence)"127");
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    static {
        ALLOWED_ASSETS.add(".js");
        ALLOWED_ASSETS.add(".css");
        ALLOWED_ASSETS.add(".png");
        ALLOWED_ASSETS.add(".gif");
        ALLOWED_ASSETS.add(".jpg");
        ALLOWED_ASSETS.add(".JPG");
        ALLOWED_ASSETS.add(".ico");
        ALLOWED_ASSETS.add(".swf");
        ALLOWED_REQUEST = new ArrayList<String>();
        ALLOWED_REQUEST.add(".do");
        ALLOWED_REQUEST.add(".geojson");
        ALLOWED_REQUEST.add(".servlet");
        FLUXANALYSIS = Arrays.asList("flowTotalData", "flowCompare", "flowTopN", "appFlow", "fluxDistribute", "connCompare", "slotFlow", "ipLocationTopN", "ipLocationFlow");
        ATTACKANALYSIS = Arrays.asList("attackLogAnalysis", "attackTopN", "attackTopnAnalysis", "attackTypeDistribute", "dropTrend", "attackTypeAnalysis");
        DNSANALYSIS = Arrays.asList("dnsTopN", "dnsReplyTopN", "dnsCache", "requestTrend", "analyzeSuccessRate", "normalAndException");
        HTTPANSLYSIS = Arrays.asList("httpSrcTopN", "httpsSrcTopN", "httpUrlTopN", "httpHostTopN");
        FLUXANALYSIS_OPTID = 2241L;
        ATTACKANALYSIS_OPTID = 2251L;
        DNSANALYSIS_OPTID = 2261L;
        HTTPANSLYSIS_OPTID = 2246L;
    }
}

