/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.interceptor;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 6760749693995054093L;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);

    public String intercept(ActionInvocation invocation) throws Exception {
        String authName;
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String actionName = invocation.getInvocationContext().getName();
        boolean check = actionName.equalsIgnoreCase(authName = (String)request.getSession().getAttribute("authAction"));
        if (check) {
            request.getSession().removeAttribute("authAction");
            return invocation.invoke();
        }
        LOG.warn((Object)"Authorization failed!");
        this.logout(request, response);
        return null;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.getSession().invalidate();
            response.sendRedirect(request.getContextPath() + "/pages/common/exception.jsp?timeout=true");
        }
        catch (IOException e) {
            LOG.info((Object)"Failed to redirect to logout!");
        }
    }
}

