/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.menu.webapp.action;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.util.CheckMenuRightUtil;
import com.hs.lego.core.system.menu.sdk.model.MenuBean;
import com.hs.lego.core.system.menu.sdk.service.IMenuManager;
import com.hs.lego.ui.plat.common.constants.CustomSysConstant;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.model.AuthUser;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.menu.vo.MenuNode;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class MenuAction
extends BaseAction {
    private static final long serialVersionUID = -8018156754030933013L;
    private static final int TWO = 2;
    private IMenuManager menuManager = null;
    private String id = null;
    private List<MenuNode> menuList;
    private List<MenuNode> floatMenuList;
    private String originaSerialNumber = null;
    private String childId = null;
    private String topLink = null;
    private String suffix = null;
    private String status = "false";
    private String rand = null;

    public String getTopMenu() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        Set<MenuBean> menuTree = this.menuManager.getAllSystemMenu(currentUser.getUserID());
        CheckMenuRightUtil checkMenuRightUtil = CheckMenuRightUtil.getInstanse();
        AuthUser au = (AuthUser)this.getSession().getAttribute("auth_handler");
        menuTree = checkMenuRightUtil.getUserAllMenu(menuTree, au.getAuthority());
        TreeSet<MenuBean> frontMenuTree = new TreeSet<MenuBean>();
        for (MenuBean temp : menuTree) {
            if (temp.getSerialNumber().indexOf("-") >= 0) continue;
            String menuNameLocal = this.getText(temp.getMenuName());
            String actionUrl = temp.getActionUrl();
            String tid = temp.getSerialNumber();
            MenuBean tempBean = new MenuBean();
            tempBean.setActionUrl(actionUrl);
            tempBean.setMenuName(menuNameLocal);
            tempBean.setSerialNumber(tid);
            frontMenuTree.add(tempBean);
        }
        this.fetchRequest().setAttribute("menuTree", frontMenuTree);
        return "success";
    }

    public String getFloatMenu() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        this.floatMenuList = new ArrayList<MenuNode>();
        Set<MenuBean> menuTree = this.menuManager.getAllSystemMenu(currentUser.getUserID());
        CheckMenuRightUtil checkMenuRightUtil = CheckMenuRightUtil.getInstanse();
        AuthUser au = (AuthUser)this.getSession().getAttribute("auth_handler");
        menuTree = checkMenuRightUtil.getUserAllMenu(menuTree, au.getAuthority());
        String typeId = this.getOriginaSerialNumber();
        Iterator<MenuBean> iter = menuTree.iterator();
        HashMap<String, MenuNode> parentsMap = new HashMap<String, MenuNode>();
        while (iter.hasNext()) {
            MenuBean temp = iter.next();
            String actionUrl = temp.getActionUrl();
            String serNumber = temp.getSerialNumber();
            String[] current = serNumber.split("-");
            temp.setActionUrl(actionUrl);
            if (!serNumber.startsWith(this.id + "-")) continue;
            MenuNode node = new MenuNode(temp);
            node.setName(this.getText(temp.getMenuName()));
            if (current.length == 2) {
                this.floatMenuList.add(node);
                parentsMap.put(node.getId(), node);
                continue;
            }
            MenuNode parent = (MenuNode)parentsMap.get(this.getParentId(serNumber));
            if (parent == null) continue;
            parent.addChild(node);
            parentsMap.put(node.getId(), node);
        }
        if (typeId != null && !typeId.isEmpty() && !Pattern.matches("^[0-9-]*$", typeId)) {
            throw new LegoSecurityException(206L);
        }
        this.fetchRequest().setAttribute("originaSerialNumber", (Object)typeId);
        this.fetchRequest().setAttribute("menuId", (Object)this.id);
        if ("red".equals(CustomSysConstant.getCustomStyle())) {
            this.fetchRequest().setAttribute("fName", (Object)"-red");
        } else {
            this.fetchRequest().setAttribute("fName", (Object)"");
        }
        if ("classic".equals(CustomSysConstant.getCustomTheme())) {
            this.fetchRequest().setAttribute("customTheme", (Object)"classic");
        } else {
            this.fetchRequest().setAttribute("customTheme", (Object)"default");
        }
        return "success";
    }

    public String getLeftMenu() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        this.menuList = new ArrayList<MenuNode>();
        Set<MenuBean> menuTree = this.menuManager.getAllSystemMenu(currentUser.getUserID());
        CheckMenuRightUtil checkMenuRightUtil = CheckMenuRightUtil.getInstanse();
        AuthUser au = (AuthUser)this.getSession().getAttribute("auth_handler");
        menuTree = checkMenuRightUtil.getUserAllMenu(menuTree, au.getAuthority());
        String typeId = this.getOriginaSerialNumber();
        Iterator<MenuBean> iter = menuTree.iterator();
        HashMap<String, MenuNode> parentsMap = new HashMap<String, MenuNode>();
        MenuBean currentMenu = null;
        String menuSerialNumber = null;
        while (iter.hasNext()) {
            MenuNode parent;
            currentMenu = iter.next();
            currentMenu.setActionUrl(currentMenu.getActionUrl());
            menuSerialNumber = currentMenu.getSerialNumber();
            if (!menuSerialNumber.contains("-")) continue;
            MenuNode node = new MenuNode(currentMenu);
            if (menuSerialNumber.equals(this.id)) {
                this.menuList.add(node);
                parentsMap.put(node.getId(), node);
                continue;
            }
            if (!menuSerialNumber.startsWith(this.id) || (parent = (MenuNode)parentsMap.get(this.getParentId(menuSerialNumber))) == null || node.isNoLeftMenu()) continue;
            parent.addChild(node);
            parentsMap.put(node.getId(), node);
        }
        this.fetchRequest().setAttribute("originaSerialNumber", (Object)typeId);
        this.fetchRequest().setAttribute("menuId", (Object)this.id);
        if ("red".equals(CustomSysConstant.getCustomStyle())) {
            this.fetchRequest().setAttribute("fName", (Object)"-red");
        } else {
            this.fetchRequest().setAttribute("fName", (Object)"");
        }
        if ("classic".equals(CustomSysConstant.getCustomTheme())) {
            this.fetchRequest().setAttribute("customTheme", (Object)"classic");
        } else {
            this.fetchRequest().setAttribute("customTheme", (Object)"default");
        }
        return "success";
    }

    public boolean validatedetailId() {
        HttpServletRequest request = this.fetchRequest();
        String detailId = Normalizer.normalize(request.getParameter("detailId"), Normalizer.Form.NFKC);
        if (!detailId.matches("^[\\d-]+$") || detailId.length() > 32) {
            return false;
        }
        return this.id == null || this.id.matches("^[\\d-]+$");
    }

    public String getFirstPage() {
        return this.getLeftMenu();
    }

    private String getParentId(String id1) {
        String normalizeId1 = Normalizer.normalize(id1, Normalizer.Form.NFKC);
        return normalizeId1.substring(0, normalizeId1.lastIndexOf("-"));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<MenuNode> getMenuList() {
        return this.menuList;
    }

    public List<MenuNode> getFloatMenuList() {
        return this.floatMenuList;
    }

    public void setFloatMenuList(List<MenuNode> floatMenuList) {
        this.floatMenuList = floatMenuList;
    }

    public String getOriginaSerialNumber() {
        return this.originaSerialNumber;
    }

    public void setOriginaSerialNumber(String originaSerialNumber) {
        this.originaSerialNumber = originaSerialNumber;
    }

    public String getChildId() {
        return this.childId;
    }

    public void setChildId(String childId) {
        this.childId = childId;
    }

    public void setMenuManager(IMenuManager menuManager) {
        this.menuManager = menuManager;
    }

    public IMenuManager getMenuManager() {
        return this.menuManager;
    }

    public String getTopLink() {
        return this.topLink;
    }

    public void setTopLink(String topLink) {
        this.topLink = topLink;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRand() {
        return this.rand;
    }

    public void setRand(String rand) {
        this.rand = rand;
    }
}

