/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.user.webapp.action;

import com.hs.lego.cbb.user.thirdauth.sdk.IRadiusAuthService;
import com.hs.lego.cbb.user.thirdauth.sdk.model.LdapServerModel;
import com.hs.lego.cbb.user.thirdauth.sdk.model.RadiusServerModel;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.util.ArrayList;
import java.util.List;

public class AuthServerConfigAction
extends BaseAction {
    private static final Integer DEFAULT_PORT = 1812;
    private static final Integer CONNECTSTATUS = 256;
    private static final long serialVersionUID = 7995065569499093046L;
    private String mainServerIP;
    private String spareServerIP;
    private Integer port = 1812;
    private String shareKey;
    private List<LangPair> authModes;
    private String authModeValue;
    private String returnMessage;
    private LdapServerModel ldapServerInfo;
    private String authMode = null;
    private IRadiusAuthService radiusService;

    public String editAuthServerConf() {
        try {
            RadiusServerModel radMod = this.radiusService.getRadiusServerInfo();
            this.authModes = new ArrayList<LangPair>();
            LangPair lp1 = new LangPair("0", this.getText("lego.lab.radius.authmode.0"));
            LangPair lp2 = new LangPair("1", this.getText("lego.lab.radius.authmode.1"));
            this.authModes.add(lp1);
            this.authModes.add(lp2);
            this.mainServerIP = null;
            this.spareServerIP = null;
            this.shareKey = null;
            if (radMod == null) {
                this.authModeValue = this.getText("lego.lab.radius.authmode.1");
                this.port = DEFAULT_PORT;
            } else {
                this.authModeValue = radMod.getAuthMode();
                this.mainServerIP = radMod.getMainServerIP();
                this.spareServerIP = radMod.getSpareServerIP();
                this.port = radMod.getAuthPort();
                this.shareKey = radMod.getSharedSecret();
            }
        }
        catch (LegoCheckedException ex) {
            this.returnMessage = this.getText("lego.err." + ex.getErrorCode(), new String[]{this.getText("lego.dic.module.radiusAuthApp")});
        }
        catch (Exception ex) {
            this.log.error((Object)"editAuthServerConf ", (Throwable)ex);
        }
        return "success";
    }

    public String editRadiuConf() {
        try {
            RadiusServerModel radMod = this.radiusService.getRadiusServerInfo();
            this.authModes = new ArrayList<LangPair>();
            LangPair lp1 = new LangPair("0", this.getText("lego.lab.radius.authmode.0"));
            LangPair lp2 = new LangPair("1", this.getText("lego.lab.radius.authmode.1"));
            this.authModes.add(lp1);
            this.authModes.add(lp2);
            if (radMod == null) {
                this.authModeValue = this.getText("lego.lab.radius.authmode.1");
                this.port = DEFAULT_PORT;
                return "success";
            }
            this.authModeValue = radMod.getAuthMode();
            this.mainServerIP = radMod.getMainServerIP();
            this.spareServerIP = radMod.getSpareServerIP();
            this.port = radMod.getAuthPort();
            this.shareKey = radMod.getSharedSecret();
        }
        catch (LegoCheckedException ex) {
            this.returnMessage = this.getText("lego.err." + ex.getErrorCode(), new String[]{this.getText("lego.dic.module.radiusAuthApp")});
        }
        catch (Exception ex) {
            this.log.error((Object)"editRadiuConf ", (Throwable)ex);
        }
        return "success";
    }

    public void saveRadiuService(RadiusServerModel radMod) {
        if (null != this.shareKey && this.shareKey.length() > 64) {
            this.fetchRequest().getSession().invalidate();
            return;
        }
        StringBuffer sb = null;
        if (null != this.shareKey && !this.shareKey.trim().equals("")) {
            sb = new StringBuffer(this.shareKey);
        }
        if (null != sb) {
            this.shareKey = DataProtectServiceConst.sdpEncryptLocal(sb);
        }
        if (null == this.shareKey && null != radMod) {
            this.shareKey = radMod.getSharedSecret();
        }
    }

    public void saveRadiuConf() {
        block3: {
            this.getOperateLog().normal("lego.lab.radius.modifyTitle", "lego.dic.module.radiusAuthApp", "lego.lab.radius.title", true, "", null);
            RadiusServerModel radMod = this.radiusService.getRadiusServerInfo();
            this.saveRadiuService(radMod);
            this.radiusService.deleteRadiusServerInfo();
            this.radiusService.createOrUpdate(this.port, this.mainServerIP, this.spareServerIP, this.shareKey, this.authModeValue);
            try {
                this.radiusService.auth("", "");
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == (long)CONNECTSTATUS.intValue()) break block3;
                this.radiusService.deleteRadiusServerInfo();
                if (radMod != null) {
                    this.radiusService.createOrUpdate(radMod.getAuthPort(), radMod.getMainServerIP(), radMod.getSpareServerIP(), radMod.getSharedSecret(), radMod.getAuthMode());
                }
                throw e;
            }
        }
    }

    public boolean validateCommon() {
        if (null == this.authModeValue || !"PAP".equals(this.authModeValue) && !"CHAP".equals(this.authModeValue)) {
            return false;
        }
        if (null == this.radiusService.getRadiusServerInfo() && (null == this.shareKey || "".equals(this.shareKey.trim()))) {
            return false;
        }
        if (null != this.mainServerIP && !IPUtil.isIpv4((String)this.mainServerIP) && !IPUtil.isIpv6((String)this.mainServerIP)) {
            return false;
        }
        return null == this.spareServerIP || this.spareServerIP.equals("") || IPUtil.isIpv4((String)this.spareServerIP) || IPUtil.isIpv6((String)this.spareServerIP);
    }

    public String editLdapConf() {
        return "success";
    }

    public void saveLdapConf() {
    }

    public String getMainServerIP() {
        return this.mainServerIP;
    }

    public void setMainServerIP(String mainServerIP) {
        this.mainServerIP = mainServerIP;
    }

    public String getSpareServerIP() {
        return this.spareServerIP;
    }

    public void setSpareServerIP(String spareServerIP) {
        this.spareServerIP = spareServerIP;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getShareKey() {
        return this.shareKey;
    }

    public void setShareKey(String shareKey) {
        this.shareKey = shareKey;
    }

    public List<LangPair> getAuthModes() {
        return this.authModes;
    }

    public void setAuthModes(List<LangPair> authModes) {
        this.authModes = authModes;
    }

    public String getAuthModeValue() {
        return this.authModeValue;
    }

    public void setAuthModeValue(String authModeValue) {
        this.authModeValue = authModeValue;
    }

    public String getReturnMessage() {
        return this.returnMessage;
    }

    public void setReturnMessage(String returnMessage) {
        this.returnMessage = returnMessage;
    }

    public LdapServerModel getLdapServerInfo() {
        return this.ldapServerInfo;
    }

    public void setLdapServerInfo(LdapServerModel ldapServerInfo) {
        this.ldapServerInfo = ldapServerInfo;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public IRadiusAuthService getRadiusService() {
        return this.radiusService;
    }

    public void setRadiusService(IRadiusAuthService radiusService) {
        this.radiusService = radiusService;
    }
}

