/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.user.webapp.action;

import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.model.RadiusAuthenInfo;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.model.UserSecPolicy;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.util.CheckMenuRightUtil;
import com.hs.lego.core.system.menu.sdk.model.MenuBean;
import com.hs.lego.core.system.menu.sdk.service.IMenuManager;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.CustomSysConstant;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.constants.PageItem;
import com.hs.lego.ui.plat.common.filter.csrf.CsrfGuard;
import com.hs.lego.ui.plat.common.model.AuthUser;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.user.util.LoginMgrUtil;
import com.hs.lego.ui.plat.user.util.VerifyCode;
import com.opensymphony.xwork2.ActionContext;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginAction
extends BaseAction {
    private static final long serialVersionUID = 254570822830040022L;
    private static final int NUM_60 = 60;
    private static final int NUM_24 = 24;
    private static final int NUM_365 = 365;
    private static final int DAY_MS = 86400000;
    private String code;
    private String langLabel;
    private String langValue = "zh_CN";
    private int licState;
    private String licNotice;
    private String lang;
    private int errRegsNum;
    private User user = null;
    private String titleName;
    private String copyRight;
    private String aboutURL;
    private String theStyle;
    private String isLogoutOthers;
    private String id;
    private String imgURL;
    private IMenuManager menuManager;
    private IUserMgr userMgr;
    private transient ISysOptLog sysLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String preLogin() {
        Cookie[] cookies;
        this.getOperateLog().normal("lego.lab.custom.portal.saveLayout", "lego.dic.module.custom", "lego.lab.custom.portal.saveLayout", true, null, null);
        if (this.fetchRequest().getSession().getAttribute("currentUser") != null) {
            User tempUsr = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            Cookie[] sessId = tempUsr.getSession();
            try {
                if (!this.userMgr.checkTimeOut((String)sessId).booleanValue()) {
                    SysOptLog logout = new SysOptLog();
                    logout.setLevel(SysoplogLevel.info.getValue());
                    logout.setResult(1);
                    logout.setModule("lego.dic.module.user");
                    logout.setOperation("lego.lab.com.loginout");
                    logout.setOperator(tempUsr.getUserName());
                    logout.setTerminalIp(this.fetchRequest().getRemoteAddr());
                    logout.setTarget(tempUsr.getUserName());
                    this.sysLogService.writeOptLog(logout);
                    this.userMgr.logout((String)sessId);
                }
            }
            finally {
                this.getSession().invalidate();
            }
        }
        if (null != (cookies = this.fetchRequest().getCookies()) && cookies.length > 0) {
            for (Cookie c : cookies) {
                c.setMaxAge(0);
            }
        }
        if (this.lang == null) {
            this.setTheLang();
        }
        if (this.lang.equals("en")) {
            this.fetchRequest().getSession().setAttribute("WW_TRANS_I18N_LOCALE", (Object)Locale.ENGLISH);
            ActionContext.getContext().setLocale(Locale.ENGLISH);
            this.langLabel = "English";
            this.langValue = "en";
        } else {
            this.fetchRequest().getSession().setAttribute("WW_TRANS_I18N_LOCALE", (Object)Locale.SIMPLIFIED_CHINESE);
            ActionContext.getContext().setLocale(Locale.SIMPLIFIED_CHINESE);
            this.langLabel = this.getText("lego.lab.com.lang.zh");
            this.langValue = "zh_CN";
        }
        this.titleName = this.getText(CustomSysConstant.getCustomResCharacSysname(), this.getText("lego.lab.com.sysname"));
        this.copyRight = this.getText(CustomSysConstant.getCustomResCharacCopyright(), this.getText("lego.lab.com.footViewInfo"));
        this.imgURL = CustomSysConstant.getCustomResImgLogin();
        if ("red".equals(CustomSysConstant.getCustomStyle())) {
            this.fetchRequest().setAttribute("fName", (Object)"-red");
        } else {
            this.fetchRequest().setAttribute("fName", (Object)"");
        }
        String ipAddress = this.fetchRequest().getRemoteAddr();
        if (LoginMgrUtil.getInstance().needVerifyCode(ipAddress, "")) {
            this.fetchRequest().setAttribute("needVerifyCode", (Object)true);
        } else {
            this.fetchRequest().setAttribute("needVerifyCode", (Object)false);
        }
        this.getResponse().addHeader("Set-Cookie", "language=" + this.lang + ";max-age=" + 31536000 + "; Path=/" + this.fetchRequest().getContextPath() + ";Secure; HttpOnly");
        return "success";
    }

    public void login() {
        HttpServletRequest request = this.fetchRequest();
        this.setLocal();
        this.getSession().removeAttribute("LOGIN_NEED_LIC ");
        String randomCode = (String)request.getSession().getAttribute("HWVerifyCode");
        request.getSession().removeAttribute("HWVerifyCode");
        this.getSession().removeAttribute("CFNMAE_S");
        String userName = this.user.getUserName();
        String ipAddress = request.getRemoteAddr();
        boolean logoutOthers = this.isOthersLogOut();
        if (!(logoutOthers || !LoginMgrUtil.getInstance().needVerifyCode(ipAddress, userName) || randomCode != null && randomCode.equalsIgnoreCase(this.code))) {
            this.responseResult("checkCodeError");
            return;
        }
        String reg = "^[\\w-.@]*$";
        if (userName.length() > 64 || !userName.matches(reg)) {
            this.log.info((Object)"illegal username detected");
            LoginMgrUtil.getInstance().loginFail(ipAddress, userName);
            this.responseResult(this.getText("lego.err.256"));
            return;
        }
        this.log.info((Object)("user:" + this.user.getUserName() + " login"));
        this.user.setUserName(userName);
        this.user.setUserPassword(this.user.getUserPassword());
        User currentUser = null;
        this.user.setIpAdr(ipAddress);
        SysOptLog loginLog = new SysOptLog();
        loginLog.setOperation("lego.lab.log.func.login");
        loginLog.setModule("lego.dic.module.user");
        loginLog.setLevel(SysoplogLevel.info.getValue());
        loginLog.setOperator(this.user.getUserName().trim());
        loginLog.setTerminalIp(request.getRemoteAddr());
        if (logoutOthers) {
            this.userMgr.logoutOtherMgr(this.user);
            SysOptLog logoutOthersLog = new SysOptLog();
            logoutOthersLog.setOperation("lego.lab.log.func.logoutOthers");
            logoutOthersLog.setModule("lego.dic.module.user");
            logoutOthersLog.setTarget(this.user.getUserName().trim());
            logoutOthersLog.setLevel(SysoplogLevel.info.getValue());
            logoutOthersLog.setOperator(this.user.getUserName().trim());
            logoutOthersLog.setTerminalIp(request.getRemoteAddr());
            logoutOthersLog.setDetail("lego.lab.log.func.logoutOthers.detail");
            logoutOthersLog.setResult(1);
            this.sysLogService.writeOptLog(logoutOthersLog);
        }
        loginLog.setTarget(this.user.getUserName().trim());
        try {
            this.user.setUserPassword(DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(this.user.getUserPassword())));
            currentUser = this.userMgr.login(this.user);
            UserInfo userInfo = this.userMgr.getUserInfoByName(currentUser.getUserName());
            if (userInfo.getPasswordModel().intValue() != UserAuthorityType.local.getValue()) {
                RadiusAuthenInfo radiusAuthenInfo = this.userMgr.getRadiusAuthenInfo(currentUser);
                String mainIP = radiusAuthenInfo.getRadius().getMainServerIP();
                String spareIp = radiusAuthenInfo.getRadius().getSpareServerIP();
                loginLog.setDetail("Radius Server,mainIP:" + mainIP + ",spareIp:" + spareIp);
            }
            loginLog.setResult(1);
            this.sysLogService.writeOptLog(loginLog);
            LoginMgrUtil.getInstance().loginSuccess(ipAddress, userName);
            this.fetchRequest().setAttribute("needVerifyCode", (Object)false);
        }
        catch (LegoCheckedException ex) {
            if (310L == ex.getErrorCode()) {
                this.responseResult("lego.err." + ex.getErrorCode());
            } else {
                loginLog.setResult(0);
                loginLog.setDetail("lego.err." + ex.getErrorCode());
                this.sysLogService.writeOptLog(loginLog);
                this.responseResult(this.getText("lego.err." + ex.getErrorCode()));
                LoginMgrUtil.getInstance().loginFail(ipAddress, userName);
            }
            return;
        }
        this.getSession().invalidate();
        this.setLocal();
        currentUser.setLoginTime(new Date().getTime());
        currentUser.setIpAdr(request.getRemoteAddr());
        this.getSession().setAttribute("mustModifyPwd", (Object)currentUser.isMustModifyPwd());
        Date date = new Date();
        currentUser.setLoginTime(date.getTime());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        currentUser.setLoginDate(dateFormat.format(date));
        this.getSession().setAttribute("currentUser", (Object)currentUser);
        this.getSession().setAttribute("auth_handler", (Object)new AuthUser(this.userMgr.getUserAllOpNames(currentUser.getUserID())));
        this.getSession().setAttribute("CFNMAE_S", (Object)CsrfGuard.getInstance().getNewValue());
        if (this.licState == 4 || this.licState == 5) {
            if (currentUser.getIsAdmin().equals("true")) {
                this.responseResult("implic");
                return;
            }
            this.responseResult("noadmin");
            return;
        }
        if (currentUser.isMustModifyPwd()) {
            this.responseResult("firstLogin");
            return;
        }
        this.getSession().setAttribute("passState", (Object)"unknow");
        UserSecPolicy usrPolicy = this.userMgr.getUserSecPolicy();
        if (currentUser.getPasswordModel() == 0 && usrPolicy.getUnseal() == 1 && currentUser.getSetTime() > 0L && currentUser.getSetTime() > 0L) {
            Date passChangeDate = new Date(currentUser.getSetTime());
            long betweenDate = (passChangeDate.getTime() - date.getTime()) / 86400000L + (long)usrPolicy.getUsefulLife().intValue();
            if (betweenDate <= 3L && betweenDate > 0L) {
                this.getSession().setAttribute("passState", (Object)"expiring");
                int iDay = (int)betweenDate + 1;
                this.responseResult("passwordExpiring," + iDay);
                return;
            }
            if (betweenDate <= 0L) {
                this.getSession().setAttribute("passState", (Object)"expired");
                this.responseResult("passwordExpired");
                return;
            }
        }
        this.getSession().setAttribute("passState", (Object)"ok");
        if (this.licState == 6) {
            this.responseResult(this.licNotice);
            return;
        }
    }

    private void setLocal() {
        if (this.langValue.equalsIgnoreCase("en")) {
            this.fetchRequest().getSession().setAttribute("WW_TRANS_I18N_LOCALE", (Object)Locale.ENGLISH);
            ActionContext.getContext().setLocale(Locale.ENGLISH);
        } else {
            this.fetchRequest().getSession().setAttribute("WW_TRANS_I18N_LOCALE", (Object)Locale.SIMPLIFIED_CHINESE);
            ActionContext.getContext().setLocale(Locale.SIMPLIFIED_CHINESE);
        }
    }

    private boolean isOthersLogOut() {
        return null != this.isLogoutOthers && "true".equals(this.isLogoutOthers.trim());
    }

    private void setTheLang() {
        if (this.lang == null) {
            Locale defaultLocale = this.fetchRequest().getLocale();
            this.lang = defaultLocale.getLanguage();
        }
    }

    public void checkLic() {
        this.licNotice = "";
        this.licState = 1;
        this.responseResult(this.licNotice);
    }

    public void createImg() {
        try {
            VerifyCode.processRequest((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
        }
        catch (ServletException e) {
            this.log.error((Object)"check code", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            this.log.error((Object)"check code", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void getLangCombo() {
        LangPair langEn = new LangPair(this.getText("lego.lab.com.lang.en"), "en");
        LangPair langZh = new LangPair(this.getText("lego.lab.com.lang.zh"), "zh_CN");
        ArrayList<LangPair> list = new ArrayList<LangPair>();
        list.add(langZh);
        list.add(langEn);
        PageItem item = new PageItem();
        item.setData(list);
        item.setTotal(list.size());
        this.responseResult(item);
    }

    public String index() {
        this.titleName = this.getText(CustomSysConstant.getCustomResCharacSysname(), this.getText("lego.lab.com.sysname"));
        this.copyRight = this.getText(CustomSysConstant.getCustomResCharacCopyright(), this.getText("lego.lab.com.footViewInfo"));
        if ("red".equals(CustomSysConstant.getCustomStyle())) {
            this.fetchRequest().setAttribute("fName", (Object)"-red");
        } else {
            this.fetchRequest().setAttribute("fName", (Object)"");
        }
        String passState = (String)this.fetchRequest().getSession().getAttribute("passState");
        if (passState != null && passState.equalsIgnoreCase("expiring") && (null == this.fetchRequest().getParameter("redirect") || passState.equalsIgnoreCase("expired"))) {
            return "error";
        }
        this.user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        this.imgURL = CustomSysConstant.getCustomResImgIndex();
        this.getUserMenu();
        this.fetchRequest().setAttribute("customTheme", (Object)"default");
        return "standard";
    }

    public String about() {
        this.titleName = this.getText(CustomSysConstant.getCustomResCharacSysname(), this.getText("lego.lab.com.sysname"));
        this.copyRight = this.getText(CustomSysConstant.getCustomResCharacCopyright(), this.getText("lego.lab.com.footViewInfo"));
        this.aboutURL = CustomSysConstant.getCustomUrlAbout() + "?style=" + CustomSysConstant.getCustomStyle();
        this.imgURL = CustomSysConstant.getCustomResImgAbout();
        this.fetchRequest().setAttribute("aboutUrl", (Object)this.aboutURL);
        if ("red".equals(CustomSysConstant.getCustomStyle())) {
            this.fetchRequest().setAttribute("fName", (Object)"-red");
        } else {
            this.fetchRequest().setAttribute("fName", (Object)"");
        }
        return "success";
    }

    public String getUserMenu() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        Set<MenuBean> menuTree = this.menuManager.getAllSystemMenu(currentUser.getUserID());
        CheckMenuRightUtil checkMenuRightUtil = CheckMenuRightUtil.getInstanse();
        AuthUser au = (AuthUser)this.getSession().getAttribute("auth_handler");
        menuTree = checkMenuRightUtil.getUserAllMenu(menuTree, au.getAuthority());
        TreeSet<MenuBean> frontMenuTree = new TreeSet<MenuBean>();
        for (MenuBean temp : menuTree) {
            if (temp.getSerialNumber().indexOf("-") >= 0) continue;
            String menuNameLocal = this.getText(temp.getMenuName());
            String actionUrl = temp.getActionUrl();
            String idNew = temp.getSerialNumber();
            String originalSerialNumber = temp.getOriginalSerialNumber();
            MenuBean tempBean = new MenuBean();
            tempBean.setActionUrl(actionUrl);
            tempBean.setMenuName(menuNameLocal);
            tempBean.setSerialNumber(idNew);
            tempBean.setOriginalSerialNumber(originalSerialNumber);
            frontMenuTree.add(tempBean);
        }
        this.fetchRequest().setAttribute("menuTree", frontMenuTree);
        return "success";
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLangLabel() {
        return this.langLabel;
    }

    public void setLangLabel(String langLabel) {
        this.langLabel = langLabel;
    }

    public String getLangValue() {
        return this.langValue;
    }

    public void setLangValue(String langValue) {
        this.langValue = langValue;
    }

    public int getErrRegsNum() {
        return this.errRegsNum;
    }

    public void setErrRegsNum(int errRegsNum) {
        this.errRegsNum = errRegsNum;
    }

    public int getLicState() {
        return this.licState;
    }

    public void setLicState(int licState) {
        this.licState = licState;
    }

    public String getLicNotice() {
        return this.licNotice;
    }

    public void setLicNotice(String licNotice) {
        this.licNotice = licNotice;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }

    public String getCopyRight() {
        return this.copyRight;
    }

    public void setCopyRight(String copyRight) {
        this.copyRight = copyRight;
    }

    public String getAboutURL() {
        return this.aboutURL;
    }

    public void setAboutURL(String aboutURL) {
        this.aboutURL = aboutURL;
    }

    public String getTheStyle() {
        return this.theStyle;
    }

    public void setTheStyle(String theStyle) {
        this.theStyle = theStyle;
    }

    public String getImgURL() {
        return this.imgURL;
    }

    public void setImgURL(String imgURL) {
        this.imgURL = imgURL;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIsLogoutOthers() {
        return this.isLogoutOthers;
    }

    public void setIsLogoutOthers(String isLogoutOthers) {
        this.isLogoutOthers = isLogoutOthers;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    public void setMenuManager(IMenuManager menuManager) {
        this.menuManager = menuManager;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }
}

