/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.user.webapp.action;

import com.hs.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.hs.lego.cbb.user.sdk.model.Role;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.model.UserAcl;
import com.hs.lego.cbb.user.sdk.model.UserLoginPolicy;
import com.hs.lego.cbb.user.sdk.model.UserSecPolicy;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.hs.lego.cbb.util.ArrayDeepClone;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.comm.SortUnit;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.sdk.util.tree.DataExchange;
import com.hs.lego.core.sdk.util.tree.RootDataElement;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.nem.discover.sdk.service.IProductsCustomizeService;
import com.hs.lego.nem.topo.sdk.model.ITreeElements;
import com.hs.lego.nem.topo.sdk.model.UIElement;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.menu.vo.ResultVO;
import com.hs.lego.ui.plat.user.constants.UserConstant;
import com.hs.lego.ui.plat.user.util.ValidatorUtil;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UsrAction
extends BaseAction {
    private static final long serialVersionUID = -5409548215078346132L;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int SIX = 6;
    private static final int EIGHT = 8;
    private static final int TEN = 10;
    private static final Long TWOL = 2L;
    private static final Long TENL = 10L;
    private static final Long HUNDREDL = 100L;
    private static final long CONERR = 51L;
    private static final long ADMINISTRATOR_MAX_NUMBER = 100L;
    private static final String ASG = "asg";
    private static final String NIP = "nip";
    private static final String KEY_CONTEXT_USER = "key.context.user";
    private static final String KEY_CONTEXT_LOCALIZE = "key.context.localize";
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private String currentUsrSessionId;
    private String currentUsrId;
    private List<User> listAdmin;
    private List<Role> listRole;
    private String selectedIndex;
    private String disabledIndex;
    private User user = null;
    private Role role = null;
    private IUserMgr userMgr;
    private Long id;
    private IProductsCustomizeService pcService;
    private IDeviceTypeMgr deviceTypeMgr;
    private ISysOptLog sysLogService;
    private Long[] box;
    private String[] boxStr;
    private Long[] boxEx;
    private String idList = "";
    private String confirmPassword;
    private String oldPassword;
    private String password;
    private String listRoleSel;
    private List<UserAcl> listAcl;
    private List<LangPair> listPassLen;
    private List<LangPair> listPassComplex;
    private String passLenVal;
    private String passLenLabel;
    private String passComplexVal;
    private String passComplexLabel;
    private boolean aclCtrl;
    private boolean intercurrentLogin;
    private boolean logCtrl;
    private long passErrNum;
    private long passInterTime = 10L;
    private long passLockTime;
    private long sessionTime;
    private String sortField = null;
    private String sortType = "desc";
    private String passwordModleValue;
    private String passwordModleLab;
    private List<LangPair> listpasswordModle;
    private String resIds;
    private String roleidsStr = null;
    private List<ResultVO> resultList;
    private int selectType = 0;
    private String curUsrisAdmin = "false";
    private String projectName = "";
    private List<LangPair> listPassLockType;
    private String passLockType;
    private Boolean passCtrl;
    private int usefulLife;
    private long setTime;
    private String type = null;
    private String usrid = null;
    private String managerFlag = null;
    private String self = null;
    private String byType = null;
    private String admin = null;
    private String roleid = null;
    private String startIp = null;
    private String endIp = null;
    private String userInfo = null;
    private String username = null;
    private String selusr = null;
    private long passType = 0L;

    public boolean validateIP() {
        if (null != this.startIp && !IPUtil.isIpv4((String)this.startIp) && !IPUtil.isIpv6((String)this.startIp)) {
            return false;
        }
        return null == this.endIp || IPUtil.isIpv4((String)this.endIp) || IPUtil.isIpv6((String)this.endIp);
    }

    public String acledit() {
        return "success";
    }

    public String listAll() {
        this.listAdmin = this.userMgr.getAllUserExt();
        if (this.getSelusr() != null) {
            String strUsrs = this.getSelusr();
            String[] selUsrArr = new String[]{};
            this.listRoleSel = ",";
            if (null != strUsrs && !strUsrs.equals("")) {
                selUsrArr = strUsrs.split(";");
            }
            int gridIndex = 0;
            for (User tempUsr : this.listAdmin) {
                for (String role1 : selUsrArr) {
                    if (!role1.equalsIgnoreCase(tempUsr.getUserName() + "")) continue;
                    this.listRoleSel = this.listRoleSel + gridIndex + ",";
                    break;
                }
                ++gridIndex;
            }
        }
        this.total = this.listAdmin.size();
        return "success";
    }

    public boolean validateSelUsers() {
        if (this.getSelusr() != null) {
            String strUsrs = this.getSelusr();
            if ("".equals(strUsrs)) {
                return true;
            }
            if (this.getSelusr().length() > 1000) {
                return false;
            }
            Pattern pattern = Pattern.compile("^[\\w-.@;]*$");
            Matcher matcher = pattern.matcher(strUsrs);
            if (!matcher.find()) {
                return false;
            }
        }
        return true;
    }

    public String list() {
        HttpSession session = this.getSession();
        User currentUser = (User)session.getAttribute("currentUser");
        this.curUsrisAdmin = currentUser.getIsAdmin().equals("true") ? "true" : "false";
        this.setCurrentUsrId(currentUser.getUserID() + "");
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField != null) {
            if (this.sortType.equalsIgnoreCase("desc")) {
                queryMap.put("DESC", this.sortField);
            } else {
                queryMap.put("ASC", this.sortField);
            }
        } else {
            queryMap.put("DESC", "id");
        }
        Paging page = this.userMgr.getAllUser(queryMap, this.start, this.pageSize);
        this.total = page.getCount();
        this.listAdmin = page.getData();
        return "success";
    }

    public String roleUsrList() {
        if (this.getRoleid() != null) {
            Role ruRole = this.userMgr.getRoleInfRelUser(Long.parseLong(this.getRoleid()), true);
            this.listAdmin = new ArrayList<User>();
            Set usrSet = ruRole.getUserSet();
            for (User tempUsr : usrSet) {
                this.listAdmin.add(tempUsr);
            }
        }
        return "success";
    }

    public String onlineList() {
        HttpServletRequest request = this.fetchRequest();
        List usersList = null;
        Paging page = null;
        page = this.sortField == null || this.sortField.equals("") ? this.userMgr.getAllOnlineUser("stayTime", "DESC", this.start, this.pageSize) : this.userMgr.getAllOnlineUser(this.sortField, this.sortType, this.start, this.pageSize);
        usersList = page.getData();
        this.total = page.getCount();
        if (this.start >= this.total) {
            int lastrec = 0;
            lastrec = this.total % this.pageSize;
            this.start = lastrec == 0 ? this.total - this.pageSize : this.total - lastrec;
            page = this.sortField == null || this.sortField.equals("") ? this.userMgr.getAllOnlineUser("stayTime", "DESC", this.start, this.pageSize) : this.userMgr.getAllOnlineUser(this.sortField, this.sortType, this.start, this.pageSize);
            usersList = page.getData();
            this.total = page.getCount();
        }
        if (this.start < 0) {
            this.start = 0;
        }
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        this.currentUsrSessionId = currentUser.getSession();
        int gridIndex = 0;
        this.disabledIndex = "";
        String strDay = this.getText("lego.dic.time.day");
        String strHour = this.getText("lego.dic.time.hour");
        String strMunite = this.getText("lego.dic.time.minute");
        String strSecond = this.getText("lego.dic.time.second");
        for (User userTemp : usersList) {
            if (userTemp.getSession().equals(this.currentUsrSessionId)) {
                this.disabledIndex = gridIndex + "";
            }
            ++gridIndex;
            String strTime = userTemp.getStayTime();
            strTime = strTime.replaceFirst("day", strDay);
            strTime = strTime.replaceFirst("hour", strHour);
            strTime = strTime.replaceFirst("minute", strMunite);
            strTime = strTime.replaceFirst("second", strSecond);
            userTemp.setStayTime(strTime);
        }
        this.listAdmin = usersList;
        return "success";
    }

    public String edit() {
        this.initResultList();
        HttpServletRequest request = this.fetchRequest();
        if (this.getManagerFlag() != null) {
            String adminValue = this.getManagerFlag();
            request.setAttribute("managerFlag", (Object)adminValue);
        }
        if (this.getSelf() != null) {
            String selfValue = this.getSelf();
            request.setAttribute("self", (Object)selfValue);
        }
        this.listpasswordModle = new ArrayList<LangPair>();
        Set<Integer> authTypeSet = this.userMgr.getThirdUserAuthType();
        for (Integer tempI : authTypeSet) {
            LangPair tempLanp = new LangPair(tempI + "", this.getText("lego.lab.usr.passwordmodle." + tempI));
            this.listpasswordModle.add(tempLanp);
        }
        if (this.getType() != null) {
            request.setAttribute("type", (Object)this.getType());
        }
        if (this.getUsrid() != null) {
            this.user = this.userMgr.getUserInfo(Long.parseLong(this.getUsrid()));
            this.passwordModleValue = this.user.getPasswordModel() + "";
            this.setTime = this.user.getSetTime();
            this.passwordModleLab = this.getText("lego.lab.usr.passwordmodle." + this.passwordModleValue);
            this.confirmPassword = this.user.getUserPassword();
            request.setAttribute("isAdd", (Object)"isAdd");
            User loginUser = (User)this.getSession().getAttribute("currentUser");
            if (this.user.getUserID() == loginUser.getUserID()) {
                request.setAttribute("editSelf", (Object)true);
            } else {
                request.setAttribute("editSelf", (Object)false);
            }
        } else {
            int num = this.userMgr.getAllUser().size();
            if ((long)num >= 100L) {
                LegoCheckedException ex = new LegoCheckedException((long)UserConstant.ERR_NUMBER_OVER.intValue());
                String s = this.getText("lego.err." + ex.getErrorCode());
                this.responseResult(s);
                return "error";
            }
            this.user = null;
            this.passwordModleValue = "0";
            this.passwordModleLab = this.getText("lego.lab.usr.passwordmodle.0");
        }
        UserSecPolicy usrPolicy = this.userMgr.getUserSecPolicy();
        if (null != usrPolicy) {
            this.passLenVal = usrPolicy.getPswLenth() + "";
            this.passComplexVal = usrPolicy.getComplex();
        }
        if (this.pcService.getProductsCustomizeInfo().getCustomizeParameters().containsKey("projectname")) {
            this.projectName = this.pcService.getProductsCustomizeInfo().getCustomizeParameters().get("projectname");
        }
        return "success";
    }

    public boolean validateRole() {
        int i;
        if (this.boxEx == null || this.box == null || this.boxStr == null) {
            return false;
        }
        if (this.boxEx.length > 100 || this.box.length > 100 || this.boxStr.length > 100) {
            return false;
        }
        for (i = 0; i < this.box.length; ++i) {
            if (0L == this.boxEx[i] && 1L != this.box[i] && 2L != this.box[i] && 3L != this.box[i]) continue;
            return false;
        }
        for (i = 0; i < this.boxStr.length; ++i) {
            if (this.boxStr[i].matches("^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$") && this.boxStr.length <= 32) continue;
            return false;
        }
        return true;
    }

    public boolean validateRoleId() {
        String[] vvs;
        if (this.idList == null || this.idList.isEmpty()) {
            return false;
        }
        if (this.idList.length() > 1000) {
            return false;
        }
        for (String v : vvs = this.idList.split(",")) {
            if (this.validateNum(v, false)) continue;
            return false;
        }
        if (0L == this.role.getRoleID()) {
            return true;
        }
        return 4L <= this.role.getRoleID();
    }

    public boolean validateUserBox() {
        if (this.box == null || this.box.length > 100) {
            return false;
        }
        for (int i = 0; i < this.box.length; ++i) {
            if (this.box[i] >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateUserBoxStr() {
        if (this.boxStr == null || this.boxStr.length > 100) {
            return false;
        }
        for (int i = 0; i < this.boxStr.length; ++i) {
            if (this.boxStr[i].matches("(^[\\w-.@]*$)") && this.boxStr[i].length() <= 64) continue;
            return false;
        }
        return true;
    }

    public boolean validateLockUsers() {
        if (this.box == null || this.boxStr == null) {
            return false;
        }
        for (int i = 0; i < this.box.length; ++i) {
            if (this.checkUserExist(this.userMgr.getAllUser(), this.boxStr[i], this.box[i])) continue;
            return false;
        }
        return true;
    }

    public boolean validateSavePolicy() {
        if (!(this.checkExist(this.passComplexVal) && this.checkExist(this.passLenVal) && this.checkExist(this.passLockType))) {
            return false;
        }
        if (6 != Integer.parseInt(this.passLenVal) && 8 != Integer.parseInt(this.passLenVal) && 10 != Integer.parseInt(this.passLenVal)) {
            return false;
        }
        if (2 != Integer.parseInt(this.passComplexVal) && 3 != Integer.parseInt(this.passComplexVal) && 4 != Integer.parseInt(this.passComplexVal)) {
            return false;
        }
        if (1L > this.sessionTime || 100L < this.sessionTime) {
            return false;
        }
        if (this.passInterTime < 0L) {
            return false;
        }
        if (!this.checkCheckBox()) {
            return false;
        }
        return this.passType >= 0L;
    }

    private boolean checkExist(String str) {
        if (null == str || "".equals(str.trim())) {
            return false;
        }
        return str.matches("^[\\d]*$") && str.length() <= 32;
    }

    private boolean checkCheckBox() {
        if (null != this.passCtrl && this.passCtrl.booleanValue() && (60 > this.usefulLife || 360 < this.usefulLife)) {
            return false;
        }
        if (this.logCtrl) {
            if (1L > this.passErrNum || 9L < this.passErrNum) {
                return false;
            }
            if (1 != Integer.parseInt(this.passLockType) && 2 != Integer.parseInt(this.passLockType)) {
                return false;
            }
            if (2 == Integer.parseInt(this.passLockType) && (3L > this.passLockTime || 2000L < this.passLockTime)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateBox() {
        if (this.user.getUserID() == 1L) {
            return true;
        }
        if (this.box == null || this.box.length > 100) {
            return false;
        }
        for (int i = 0; i < this.box.length; ++i) {
            if (1L <= this.box[i]) continue;
            return false;
        }
        return true;
    }

    public boolean validateResIds() {
        if (null != this.resIds && !this.resIds.isEmpty()) {
            if (!this.resIds.contains(",")) {
                if (!this.validateNum(this.resIds, true)) {
                    return false;
                }
            } else {
                String[] vvs;
                for (String v : vvs = this.resIds.split(",")) {
                    if (this.validateNum(v, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateNum(String num, boolean canNegative) {
        if (null != num && !num.isEmpty()) {
            Pattern pattern = null;
            pattern = canNegative ? Pattern.compile("^-?(0|[1-9][0-9]*)$") : Pattern.compile("^(0|[1-9][0-9]*)$");
            Matcher matcher = pattern.matcher(num);
            if (!matcher.find()) {
                return false;
            }
        }
        return true;
    }

    public boolean validateBoxStr() {
        HashMap<String, String> ipMap = new HashMap<String, String>();
        if (this.boxStr != null && this.boxStr.length >= 3) {
            String ipBegin = null;
            String ipEnd = null;
            String desc = null;
            if (this.boxStr.length > 100) {
                return false;
            }
            for (int i = 0; i < this.boxStr.length; ++i) {
                ipBegin = this.boxStr[i++];
                ipEnd = this.boxStr[i++];
                desc = this.boxStr[i];
                if (desc.length() > 50) {
                    return false;
                }
                if (!desc.matches("^[\\u4E00-\\u9FA5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\w|=|\\-|!|\\@|$|\\%|\\*|:|;|\\,|\\.|\\+|\\}|\\{|\\[|\\]|\\? ]*$")) {
                    return false;
                }
                if (!this.checkIp(ipBegin) || !this.checkIp(ipEnd) || this.compareIp(ipBegin, ipEnd) || !this.compareNewIp(ipBegin, ipEnd, ipMap)) {
                    return false;
                }
                ipMap.put(ipBegin, ipEnd);
            }
            return true;
        }
        return false;
    }

    private boolean checkIp(String ip) {
        Pattern pattern = Pattern.compile("^(22[0-3]|2[0-1]\\d|1\\d{2}|[1-9]\\d|[1-9])\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[0-9]\\d|[0-9])$");
        Matcher matcher = pattern.matcher(ip);
        return matcher.find();
    }

    private boolean compareNewIp(String ipBegin, String ipEnd, Map<String, String> ipMap) {
        if (null == ipMap || ipMap.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> e : ipMap.entrySet()) {
            if (!this.compareIp(e.getKey(), ipBegin) || !this.compareIp(ipEnd, e.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean compareIp(String aclbegin, String aclend) {
        String[] beginArr = aclbegin.split("\\.");
        String[] endArr = aclend.split("\\.");
        if (Integer.parseInt(endArr[0]) > Integer.parseInt(beginArr[0])) {
            return false;
        }
        if (Integer.parseInt(endArr[0]) < Integer.parseInt(beginArr[0])) {
            return true;
        }
        if (Integer.parseInt(endArr[1]) > Integer.parseInt(beginArr[1])) {
            return false;
        }
        if (Integer.parseInt(endArr[1]) < Integer.parseInt(beginArr[1])) {
            return true;
        }
        if (Integer.parseInt(endArr[2]) > Integer.parseInt(beginArr[2])) {
            return false;
        }
        if (Integer.parseInt(endArr[2]) < Integer.parseInt(beginArr[2])) {
            return true;
        }
        if (Integer.parseInt(endArr[3]) > Integer.parseInt(beginArr[3])) {
            return false;
        }
        if (Integer.parseInt(endArr[3]) < Integer.parseInt(beginArr[3])) {
            return true;
        }
        return Integer.parseInt(endArr[3]) != Integer.parseInt(beginArr[3]);
    }

    public boolean validatePassword() throws UnsupportedEncodingException {
        if (this.user != null) {
            int passwordModle = this.user.getPasswordModel();
            if (passwordModle == UserAuthorityType.radius.getValue()) {
                return true;
            }
            if (this.user.getUserPassword() == null && this.confirmPassword == null) {
                return true;
            }
            if (this.user.getUserPassword() == null || this.user.getUserPassword().isEmpty() || this.confirmPassword == null || this.confirmPassword.isEmpty()) {
                return false;
            }
        }
        if (this.confirmPassword == null || this.confirmPassword.isEmpty()) {
            return false;
        }
        if (this.confirmPassword.length() > 64) {
            return false;
        }
        UserSecPolicy usrPolicy = this.userMgr.getUserSecPolicy();
        if (null == usrPolicy || this.confirmPassword.length() < usrPolicy.getPswLenth()) {
            return false;
        }
        Pattern pattern = Pattern.compile("[^x00-xff]+");
        Matcher matcher = pattern.matcher(this.confirmPassword);
        if (this.confirmPassword.length() != this.confirmPassword.getBytes("utf-8").length && matcher.find()) {
            return false;
        }
        if (this.confirmPassword.contains(" ")) {
            return false;
        }
        pattern = Pattern.compile("[a-zA-Z]+");
        matcher = pattern.matcher(this.confirmPassword);
        boolean enFlag = matcher.find();
        pattern = Pattern.compile("[0-9]+");
        matcher = pattern.matcher(this.confirmPassword);
        boolean numFlag = matcher.find();
        pattern = Pattern.compile("[=|\\-|_|\\!|@|#|\\$|%|/|;|\\*|\\^|\\||:|,|\\.|\\+|}|{]+");
        matcher = pattern.matcher(this.confirmPassword);
        boolean strFlag = matcher.find();
        if (!(!"2".equals(usrPolicy.getComplex()) || enFlag && numFlag)) {
            return false;
        }
        if ("3".equals(usrPolicy.getComplex()) && !strFlag) {
            return false;
        }
        return !"4".equals(usrPolicy.getComplex()) || enFlag && numFlag && strFlag;
    }

    public void addUser() {
        int num;
        User currentOptUser = (User)this.getSession().getAttribute("currentUser");
        if (currentOptUser == null) {
            throw new LegoSecurityException(206L);
        }
        String tartget = this.user.getUserName();
        SysOptLog userlog = new SysOptLog();
        userlog.setTarget(tartget);
        userlog.setModule("lego.dic.module.user");
        userlog.setLevel(SysoplogLevel.normal.getValue());
        userlog.setOperator(currentOptUser.getUserName());
        userlog.setTerminalIp(currentOptUser.getIpAdr());
        if (this.user.getUserID() == 0L) {
            userlog.setOperation("lego.lab.log.func.useradd");
        } else {
            userlog.setOperation("lego.lab.log.func.useredit");
        }
        if (1 == this.user.getPasswordModel()) {
            this.user.setUserPassword("--");
        }
        if (this.equalDefaultPwd(this.userMgr, new StringBuffer(DataProtectServiceConst.sdpEncryptLocal((String)this.user.getUserPassword())))) {
            LegoCheckedException ex = new LegoCheckedException((long)UserConstant.ERR_MODIFYPASSWORD_INITPWD.intValue());
            String s = this.getText("lego.err." + ex.getErrorCode());
            userlog.setResult(0);
            userlog.setDetail("lego.err." + ex.getErrorCode());
            this.sysLogService.writeOptLog(userlog);
            this.responseResult(s);
            return;
        }
        boolean checkPassword = ValidatorUtil.validPasswordValue(this.user.getUserName(), this.user.getUserPassword());
        if (!checkPassword) {
            LegoCheckedException ex = new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SIMPLEVALUE.intValue());
            String s = this.getText("lego.err." + ex.getErrorCode());
            userlog.setResult(0);
            userlog.setDetail("lego.err." + ex.getErrorCode());
            this.sysLogService.writeOptLog(userlog);
            this.responseResult(s);
            return;
        }
        int passwordModle = this.user.getPasswordModel();
        if (passwordModle == UserAuthorityType.local.getValue() && !this.user.getUserPassword().equals(this.confirmPassword)) {
            LegoCheckedException ex = new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
            String s = this.getText("lego.err." + ex.getErrorCode());
            userlog.setResult(0);
            userlog.setDetail("lego.err." + ex.getErrorCode());
            this.sysLogService.writeOptLog(userlog);
            this.responseResult(s);
            return;
        }
        if (this.user.getUserPassword().toLowerCase(Locale.US).contains(this.user.getUserName().toLowerCase(Locale.US)) || this.user.getUserPassword().toLowerCase(Locale.US).contains(this.reverseStr(this.user.getUserName().toLowerCase(Locale.US)))) {
            LegoCheckedException ex = new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SIMPLEVALUE.intValue());
            String s = this.getText("lego.err." + ex.getErrorCode());
            userlog.setResult(0);
            userlog.setDetail("lego.err." + ex.getErrorCode());
            this.sysLogService.writeOptLog(userlog);
            this.responseResult(s);
            return;
        }
        this.user.setIsAdmin("false");
        this.user.setMustModifyPwd(true);
        HashSet<Long> roleSet = new HashSet<Long>();
        if (this.box != null && this.box.length > 0) {
            Long[] s = this.box;
            int n = s.length;
            for (int i = 0; i < n; ++i) {
                long idTemp = s[i];
                roleSet.add(idTemp);
            }
        }
        if (this.boxStr != null && this.boxStr.length >= 3) {
            HashSet<UserAcl> tmpListAcl = new HashSet<UserAcl>();
            for (int i = 0; i < this.boxStr.length; ++i) {
                UserAcl tempUsrAcl = new UserAcl();
                tempUsrAcl.setStrStartIp(this.boxStr[i++]);
                tempUsrAcl.setStrEndIp(this.boxStr[i++]);
                tempUsrAcl.setDes(this.boxStr[i]);
                tmpListAcl.add(tempUsrAcl);
            }
            this.user.setUserAclSet(tmpListAcl);
        }
        this.user.setRolesIdsSet(roleSet);
        if (this.getByType() != null) {
            this.selectType = Integer.parseInt(this.getByType());
        }
        this.user.setSelectType(this.selectType);
        if (null == this.user.getUserName() || this.user.getUserName().trim().equals("")) {
            LegoCheckedException ex = new LegoCheckedException(102L);
            userlog.setResult(0);
            userlog.setDetail("lego.err." + ex.getErrorCode());
            this.sysLogService.writeOptLog(userlog);
            throw new LegoCheckedException(102L);
        }
        if (this.pcService.getProductsCustomizeInfo().getCustomizeParameters().containsKey("projectname")) {
            this.projectName = this.pcService.getProductsCustomizeInfo().getCustomizeParameters().get("projectname");
        }
        if (this.resIds != null && !"-1".equals(this.resIds)) {
            Set<Long> devSet = this.list2Set(this.resIds.split(","));
            if (this.user.getUserID() != 0L) {
                this.mergeMoAuth(devSet);
            }
            this.user.setMoAuthIdsSet(devSet);
        }
        if ((long)(num = this.userMgr.getAllUser().size()) >= 100L) {
            LegoCheckedException ex = new LegoCheckedException((long)UserConstant.ERR_NUMBER_OVER.intValue());
            String s = this.getText("lego.err." + ex.getErrorCode());
            userlog.setResult(0);
            userlog.setDetail("lego.err." + ex.getErrorCode());
            this.sysLogService.writeOptLog(userlog);
            this.responseResult(s);
            return;
        }
        this.dataProtect(passwordModle);
        if (this.user.getUserID() == 0L) {
            LOG.info((Object)("add user:" + this.getSecureString(this.user.getUserName())));
            this.user.setMustModifyPwd(true);
            try {
                this.userMgr.addUserInfo(this.user);
                userlog.setResult(1);
                this.sysLogService.writeOptLog(userlog);
            }
            catch (LegoCheckedException ex) {
                String s = this.getText("lego.err." + ex.getErrorCode());
                userlog.setResult(0);
                userlog.setDetail("lego.err." + ex.getErrorCode());
                this.sysLogService.writeOptLog(userlog);
                this.responseResult(s);
                return;
            }
        } else {
            userlog.setResult(1);
            this.sysLogService.writeOptLog(userlog);
            LOG.info((Object)("modify user:" + this.getSecureString(this.user.getUserName())));
            this.userMgr.updataUser(this.user);
        }
    }

    private void dataProtect(int passwordModle) {
        if (passwordModle == UserAuthorityType.local.getValue() && null != this.user.getUserPassword() && !"".equals(this.user.getUserPassword())) {
            String endPwd = DataProtectServiceConst.sdpProtectPwdLocal((StringBuffer)new StringBuffer(this.user.getUserPassword()));
            this.user.setUserPassword(endPwd);
        }
    }

    public String roleEdit() {
        HttpServletRequest request = this.fetchRequest();
        String selResult = "";
        RootDataElement optRetree = null;
        User currentOptUser = (User)this.getSession().getAttribute("currentUser");
        if (this.getRoleid() != null) {
            this.role = this.userMgr.getRoleInf(Long.parseLong(this.getRoleid()));
            request.setAttribute("isAdd", (Object)"isAdd");
            if (this.getType() != null) {
                request.setAttribute("type", (Object)this.getType());
                optRetree = this.userMgr.getOptTree(this.role.getRoleID());
            } else {
                if ("true".equalsIgnoreCase(this.role.getBuDefault())) {
                    throw new LegoCheckedException((long)UserConstant.ERR_DEL_ADMINISTARTOR_ROLE.intValue());
                }
                optRetree = "true".equalsIgnoreCase(currentOptUser.getIsAdmin()) ? this.userMgr.getOptTree(-1L) : this.userMgr.getOptTreeByUser(currentOptUser.getUserID());
                Set opts = this.role.getOptIdsSet();
                Iterator iterator = opts.iterator();
                while (iterator.hasNext()) {
                    Long op = (Long)iterator.next();
                    selResult = selResult.concat(op + ",");
                }
                request.setAttribute("selResult", (Object)selResult);
            }
        } else {
            this.role = new Role();
            optRetree = "true".equalsIgnoreCase(currentOptUser.getIsAdmin()) ? this.userMgr.getOptTree(-1L) : this.userMgr.getOptTreeByUser(currentOptUser.getUserID());
        }
        optRetree.setDisName(this.getText("lego.lab.usr.operations"));
        for (UIElement child : optRetree.getChildEleUI()) {
            this.filterRole(child);
        }
        this.processDeviceType(optRetree);
        DataExchange exchange = new DataExchange();
        exchange.registerClientStyle("sortId", "string");
        exchange.registerClientStyle("ctrlSel", "string");
        exchange.registerClientStyle("isLeaf", "string");
        String result = exchange.getStringByModel(optRetree);
        Pattern p = Pattern.compile("\\t|\r|\n");
        Matcher m = p.matcher(result);
        String after = m.replaceAll("");
        this.fetchRequest().setAttribute("xmlResult", (Object)after);
        return "success";
    }

    private void filterRole(UIElement optTree) {
        Set childEles = optTree.getChildEleUI();
        if (childEles != null) {
            HashSet<UIElement> temp = new HashSet<UIElement>();
            for (UIElement child : childEles) {
                if (child.getDisName() != null && (child.getDisName().startsWith("lego.sys.operatorMgr.operator") || child.getDisName().startsWith("lego.sys.role"))) {
                    temp.add(child);
                    continue;
                }
                this.filterRole(child);
            }
            for (UIElement child : temp) {
                childEles.remove(child);
            }
        }
    }

    private boolean isStringEmpty(String str) {
        return null == str || str.trim().equals("");
    }

    public void addRole() {
        this.role.setRoleID(0L);
        this.saveRole();
    }

    public void saveRole() {
        String tartget = this.role.getRoleName();
        if (this.role.getRoleID() == 0L) {
            this.getOperateLog().normal("lego.lab.log.func.rolesave", "lego.dic.module.user", tartget);
        } else {
            this.getOperateLog().normal("lego.lab.log.func.roleedit", "lego.dic.module.user", tartget);
        }
        ArrayList<Long> roleList = new ArrayList<Long>();
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.role.setCreateTime(dateFormat.format(date));
        String[] strOpLst = this.idList.split(",");
        if (strOpLst.length == 1 && strOpLst[0].equals("-1")) {
            this.responseResult("operation_null");
            return;
        }
        for (String strOpe : strOpLst) {
            roleList.add(Long.valueOf(strOpe));
        }
        if (this.isStringEmpty(this.role.getRoleName())) {
            throw new LegoUncheckedException(102L);
        }
        User currentOptUser = (User)this.getSession().getAttribute("currentUser");
        Set<Long> set = this.userMgr.getAllOptId("false".equalsIgnoreCase(currentOptUser.getIsAdmin()) ? Long.valueOf(currentOptUser.getUserID()) : null);
        for (Long optid : roleList) {
            if (set.contains(optid)) continue;
            throw new LegoUncheckedException(102L);
        }
        if (this.role.getRoleID() == 0L) {
            this.getOperateLog().normal("lego.lab.log.func.rolesave", "lego.dic.module.user", this.role.getRoleName());
            int num = this.userMgr.getAllRole().size();
            if ((long)num >= 100L) {
                throw new LegoCheckedException(362L);
            }
            LOG.info((Object)("add admin group:" + this.role.getRoleName() + 653110169894912L));
            this.userMgr.addRoleInfo(this.role, roleList);
        } else {
            User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            this.getOperateLog().normal("lego.lab.log.func.roleedit", "lego.dic.module.user", this.role.getRoleName());
            LOG.info((Object)("modify admin group:" + this.role.getRoleName() + 653110169894912L));
            if (!this.checkRoleExist(this.userMgr.getAllRole(), this.role.getRoleName(), this.role.getRoleID())) {
                throw new LegoCheckedException(303L);
            }
            List<User> onlineList = this.userMgr.getAllOnlineUser();
            if (null != onlineList) {
                for (User userNew : onlineList) {
                    if (userNew.getUserID() == currentUser.getUserID()) continue;
                    Set rolesSet = this.userMgr.getUserInfo(userNew.getUserID()).getRolesSet();
                    for (Role roles : rolesSet) {
                        if (roles.getRoleID() != this.role.getRoleID()) continue;
                        this.userMgr.forceLogout(userNew.getSession());
                    }
                }
            }
            this.userMgr.updataRole(this.role, roleList);
        }
    }

    protected Set<Long> list2Set(String[] input) {
        HashSet<Long> output = new HashSet<Long>();
        for (String tempid : input) {
            try {
                long tempLn = Long.parseLong(tempid);
                output.add(tempLn);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return output;
    }

    protected List<Long> set2List(Set<Long> input) {
        ArrayList<Long> output = new ArrayList<Long>();
        for (Long tempid : input) {
            output.add(tempid);
        }
        return output;
    }

    public void saveUser() {
        String tartget = this.user.getUserName();
        if (this.user.getUserID() == 0L) {
            this.getOperateLog().normal("lego.lab.log.func.useradd", "lego.dic.module.user", this.getSecureString(tartget));
        } else {
            this.getOperateLog().normal("lego.lab.log.func.useredit", "lego.dic.module.user", this.getSecureString(tartget));
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (this.user.getUserID() == 1L && currentUser.getUserID() != 1L) {
            throw new LegoCheckedException(299L);
        }
        User rawUser = this.userMgr.getUserInfo(this.user.getUserID());
        if (this.user.getPasswordModel() != rawUser.getPasswordModel()) {
            if (this.user.getUserID() == 1L) {
                throw new LegoCheckedException(206L);
            }
            if (currentUser.getUserID() != 1L) {
                throw new LegoCheckedException(206L);
            }
        }
        String passwordNew = this.user.getUserPassword();
        String confirmPasswordNew = this.getConfirmPassword();
        if (null != passwordNew) {
            if (currentUser.getUserID() == 1L && this.user.getUserID() != 1L) {
                if (this.equalDefaultPwd(this.userMgr, new StringBuffer(DataProtectServiceConst.sdpEncryptLocal((String)passwordNew)))) {
                    throw new LegoCheckedException((long)UserConstant.ERR_MODIFYPASSWORD_INITPWD.intValue());
                }
                if (!passwordNew.equals(confirmPasswordNew)) {
                    throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
                }
                boolean checkPassword = ValidatorUtil.validPasswordValue(this.user.getUserName(), this.user.getUserPassword());
                if (!checkPassword) {
                    throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SIMPLEVALUE.intValue());
                }
                if (passwordNew.toLowerCase(Locale.US).contains(this.user.getUserName().toLowerCase(Locale.US)) || passwordNew.toLowerCase(Locale.US).contains(this.reverseStr(this.user.getUserName().toLowerCase(Locale.US)))) {
                    throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SIMPLEVALUE.intValue());
                }
            } else {
                throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_NOPERMISSION.intValue());
            }
        }
        if (!this.checkUserExist(this.userMgr.getAllUser(), this.user.getUserName(), this.user.getUserID())) {
            throw new LegoCheckedException(303L);
        }
        int passwordModle = this.user.getPasswordModel();
        if (passwordModle == UserAuthorityType.local.getValue() && null != passwordNew && !passwordNew.equals(confirmPasswordNew)) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
        }
        if ("true".equalsIgnoreCase(rawUser.getIsAdmin())) {
            this.user.setIsAdmin("true");
        } else {
            this.user.setIsAdmin("false");
        }
        HashSet<Long> roleSet = new HashSet<Long>();
        if (this.box != null && this.box.length > 0) {
            Long[] longArray = this.box;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long idTemp = longArray[i];
                List<User> onlineUser = this.userMgr.getAllOnlineUser();
                if (null != onlineUser) {
                    for (User users : onlineUser) {
                        if (users.getUserID() != rawUser.getUserID()) continue;
                        this.userMgr.forceLogout(users.getSession());
                        break;
                    }
                }
                roleSet.add(idTemp);
            }
        }
        if (this.boxStr != null && this.boxStr.length >= 3) {
            HashSet<UserAcl> tmpListAcl = new HashSet<UserAcl>();
            for (int i = 0; i < this.boxStr.length; ++i) {
                UserAcl tempUsrAcl = new UserAcl();
                tempUsrAcl.setStrStartIp(this.boxStr[i++]);
                tempUsrAcl.setStrEndIp(this.boxStr[i++]);
                tempUsrAcl.setDes(this.boxStr[i]);
                tmpListAcl.add(tempUsrAcl);
            }
            this.user.setUserAclSet(tmpListAcl);
        }
        this.user.setRolesIdsSet(roleSet);
        if (this.getByType() != null) {
            this.selectType = Integer.parseInt(this.getByType());
        }
        this.user.setSelectType(this.selectType);
        if (null == this.user.getUserName() || this.user.getUserName().trim().equals("")) {
            throw new LegoUncheckedException(102L);
        }
        if (this.pcService.getProductsCustomizeInfo().getCustomizeParameters().containsKey("projectname")) {
            this.projectName = this.pcService.getProductsCustomizeInfo().getCustomizeParameters().get("projectname");
        }
        if (this.resIds != null && !"-1".equals(this.resIds)) {
            Set<Long> devSet = this.list2Set(this.resIds.split(","));
            this.mergeMoAuth(devSet);
            this.user.setMoAuthIdsSet(devSet);
        }
        this.dataProtect(passwordModle);
        if (this.user.getUserID() == 0L) {
            this.getOperateLog().normal("lego.lab.log.func.useradd", "lego.dic.module.user", this.getSecureString(this.user.getUserName()));
            LOG.info((Object)("add user:" + this.getSecureString(this.user.getUserName()) + 653110169894912L));
            this.user.setMustModifyPwd(rawUser.isMustModifyPwd());
        } else {
            this.getOperateLog().normal("lego.lab.log.func.useredit", "lego.dic.module.user", this.getSecureString(this.user.getUserName()));
            LOG.info((Object)("modify user:" + this.getSecureString(this.user.getUserName()) + 653110169894912L));
            this.userMgr.updataUser(this.user);
        }
    }

    private List<Long> getAvailableMoList() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        List<Long> availableMoList = this.userMgr.getUserGrandObjects(currentUser.getUserID());
        return availableMoList;
    }

    private void mergeMoAuth(Set<Long> devSet) {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (currentUser.getIsAdmin().equals("true")) {
            return;
        }
        List<Long> rawMoList = this.userMgr.getUserGrandObjects(this.user.getUserID());
        List<Long> availableMoList = this.userMgr.getUserGrandObjects(currentUser.getUserID());
        for (Long moid : rawMoList) {
            if (availableMoList.contains(moid)) continue;
            devSet.add(moid);
        }
    }

    public void deleteUsers() {
        int i;
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        if (null == currentUser) {
            throw new LegoSecurityException(206L);
        }
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        this.getOperateLog().warning("lego.lab.log.func.userdelete", "lego.dic.module.user");
        StringBuffer sbf = new StringBuffer();
        User tmpUser = null;
        for (i = 0; i < this.box.length; ++i) {
            try {
                tmpUser = this.userMgr.getUserInfo(this.box[i]);
            }
            catch (Exception e) {
                tmpUser = null;
            }
            this.boxStr[i] = tmpUser == null ? "--" : tmpUser.getUserName();
            sbf.append(this.boxStr[i]).append(',');
        }
        LOG.warn((Object)("delete users:" + this.getSecureString(sbf.toString())));
        for (i = 0; i < this.box.length; ++i) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(this.box[i].longValue());
            tempBatch.setTargetName(this.boxStr[i]);
            bathOprLst.add(tempBatch);
        }
        this.batchOperationResult = this.userMgr.batchDeleteUser(bathOprLst, currentUser.getUserID());
        if (this.batchOperationResult != null) {
            this.bathResult(this.batchOperationResult);
        }
    }

    public void lockUsers() {
        int i;
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        if (null == currentUser) {
            throw new LegoSecurityException(206L);
        }
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        this.getOperateLog().warning("lego.lab.log.func.loguserlock", "lego.dic.module.user");
        if (!this.validateLockUsers()) {
            this.getOperateLog().warning("lego.lab.log.func.loguserlock", "lego.dic.module.user", "--");
            LOG.warn((Object)"Attempt to lock non-exist user.");
            throw new LegoCheckedException(2941L);
        }
        StringBuffer sbf = new StringBuffer();
        User tmpUser = null;
        for (i = 0; i < this.box.length; ++i) {
            tmpUser = this.userMgr.getUserInfo(this.box[i]);
            String string = this.boxStr[i] = tmpUser == null ? "" : tmpUser.getUserName();
            if (this.boxStr[i].equals(currentUser.getUserName())) {
                throw new LegoCheckedException(2942L);
            }
            sbf.append(this.boxStr[i]).append(',');
        }
        LOG.warn((Object)("lock users:" + sbf.toString()));
        for (i = 0; i < this.box.length; ++i) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(this.box[i].longValue());
            tempBatch.setTargetName(this.boxStr[i]);
            bathOprLst.add(tempBatch);
        }
        this.batchOperationResult = this.userMgr.lockUser(bathOprLst);
        if (this.batchOperationResult != null) {
            this.bathResult(this.batchOperationResult);
        }
    }

    public void unlockUsers() {
        int i;
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        this.getOperateLog().warning("lego.lab.log.func.userunlock", "lego.dic.module.user");
        StringBuffer sbf = new StringBuffer();
        User tmpUser = null;
        for (i = 0; i < this.box.length; ++i) {
            tmpUser = this.userMgr.getUserInfo(this.box[i]);
            this.boxStr[i] = tmpUser == null ? "" : tmpUser.getUserName();
            sbf.append(this.boxStr[i]).append(',');
        }
        LOG.warn((Object)("unlock users:" + this.getSecureString(sbf.toString())));
        for (i = 0; i < this.box.length; ++i) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(this.box[i].longValue());
            tempBatch.setTargetName(this.boxStr[i]);
            bathOprLst.add(tempBatch);
        }
        this.batchOperationResult = this.userMgr.unLockUser(bathOprLst);
        if (this.batchOperationResult != null) {
            this.bathResult(this.batchOperationResult);
        }
    }

    public void deleteRoles() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        if (null == currentUser) {
            throw new LegoSecurityException(206L);
        }
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        this.getOperateLog().warning("lego.lab.log.func.roledelete", "lego.dic.module.user");
        Role tmpRole = null;
        for (int i = 0; i < this.box.length; ++i) {
            try {
                tmpRole = this.userMgr.getRoleInf(this.box[i]);
            }
            catch (Exception e) {
                tmpRole = null;
            }
            this.boxStr[i] = tmpRole == null ? "--" : tmpRole.getRoleName();
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(this.box[i].longValue());
            tempBatch.setTargetName(this.boxStr[i]);
            bathOprLst.add(tempBatch);
        }
        StringBuffer sbf = new StringBuffer();
        for (String strTemp : this.boxStr) {
            sbf.append(strTemp).append(',');
        }
        LOG.warn((Object)("delete roles:" + sbf.toString() + 653110169894912L));
        this.batchOperationResult = this.userMgr.batchDelRoles(bathOprLst);
        if (this.batchOperationResult != null) {
            this.bathResult(this.batchOperationResult);
        }
    }

    private void initResultList() {
        this.resultList = new ArrayList<ResultVO>();
        ResultVO vo = new ResultVO();
        vo.setLabel(this.getText("lego.dic.module.chooseByDeviceType"));
        vo.setKey(0);
        this.resultList.add(vo);
        vo = new ResultVO();
        vo.setLabel(this.getText("lego.dic.module.chooseByTopoFrame"));
        vo.setKey(1);
        this.resultList.add(vo);
    }

    public List<ResultVO> getResultList() {
        return this.resultList;
    }

    private void produceOne() {
        if (this.pcService.getProductsCustomizeInfo().getCustomizeParameters().containsKey("projectname")) {
            this.projectName = this.pcService.getProductsCustomizeInfo().getCustomizeParameters().get("projectname");
        }
        if (null != this.getType()) {
            this.fetchRequest().setAttribute("type", (Object)this.getType());
        }
    }

    public String produceDeviceTree() {
        this.produceOne();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        this.initResultList();
        if (this.getByType() != null) {
            this.selectType = Integer.parseInt(this.getByType());
        }
        Long userId = null;
        User tempUsr = null;
        if (this.getUsrid() != null) {
            userId = Long.parseLong(this.getUsrid());
            tempUsr = this.userMgr.getUserInfo(userId);
            Set tSet = tempUsr.getMoAuthIdsSet();
            List<Long> availMoList = this.getAvailableMoList();
            StringBuffer tempBuf = new StringBuffer();
            for (Long lid : tSet) {
                if (!currentUser.getIsAdmin().equals("true") && !availMoList.contains(lid)) continue;
                tempBuf.append(lid + ",");
            }
            this.fetchRequest().setAttribute("selResult", (Object)tempBuf.toString());
            this.selectType = tempUsr.getSelectType();
        }
        if (this.selectType == 0) {
            IDeviceTypeMgr obj = this.deviceTypeMgr;
            this.produceDeviceTreeOne(obj, currentUser, userId);
        }
        return "success";
    }

    private void produceDeviceTreeOne(Object obj, User currentUser, Long userId) {
        if (obj == null) {
            String[] parStrArr = new String[]{this.getText("lego.dic.module.ResourceApplication")};
            LegoCheckedException le = new LegoCheckedException(51L, parStrArr);
            LOG.error((Object)"getBundleService error :ResourceApplication/deviceTypeMgr", (Throwable)le);
            throw le;
        }
        IDeviceTypeMgr topoMgr = (IDeviceTypeMgr)obj;
        RootDataElement treeRoot = null;
        treeRoot = currentUser.getIsAdmin().equals("true") ? (!"view".equals(this.getType()) ? topoMgr.getDeviceTypeTree(null, Boolean.valueOf(true)) : topoMgr.getDeviceTypeTree(userId, Boolean.valueOf(true))) : topoMgr.getDeviceTypeTree(userId, Boolean.valueOf(true));
        treeRoot.setDisName(this.getText("lego.lab.res.devlists"));
        this.processDeviceType(treeRoot);
        DataExchange exchange = new DataExchange();
        String result = exchange.getStringByModel(treeRoot);
        Pattern p = Pattern.compile("\\t|\r|\n");
        Matcher m = p.matcher(result);
        String after = m.replaceAll("");
        this.fetchRequest().setAttribute("xmlResult", (Object)after);
    }

    private void processDeviceType(RootDataElement root) {
        Set childEles = root.getChildEleUI();
        for (UIElement child : childEles) {
            this.processDeviceTypeBase((ITreeElements)child);
        }
    }

    private void processDeviceTypeBase(ITreeElements parentEle) {
        Set childEles;
        if (parentEle == null) {
            return;
        }
        UIElement curEle = (UIElement)parentEle;
        Long eleType = curEle.getEleType();
        if (eleType.equals(3L)) {
            try {
                curEle.setDisName(this.getText(curEle.getDisName()));
            }
            catch (Exception e) {
                curEle.setDisName(curEle.getDisName());
            }
        }
        if ((childEles = parentEle.getChildEleUI()) != null) {
            for (UIElement child : childEles) {
                this.processDeviceTypeBase((ITreeElements)child);
            }
        }
    }

    public String usrgroupEdit() {
        return "success";
    }

    public String useRList() {
        SortUnit su = null;
        if (this.sortField != null) {
            su = new SortUnit();
            su.setFieldName(this.sortField);
            su.setSortType(this.sortType);
        }
        Paging page = this.userMgr.getAllRole(this.start, this.pageSize, su);
        this.total = page.getCount();
        this.listRole = page.getData();
        return "success";
    }

    public String editUsrRole() {
        SortUnit su = null;
        this.listRoleSel = ",";
        if (this.getType() != null) {
            this.fetchRequest().setAttribute("type", (Object)this.getType());
        }
        if (this.sortField != null) {
            su = new SortUnit();
            su.setFieldName(this.sortField);
            su.setSortType(this.sortType);
        }
        Paging page = this.userMgr.getAllRole(this.start, this.pageSize, su);
        this.total = page.getCount();
        this.listRole = page.getData();
        String[] selRolArr = null;
        if (this.roleidsStr == null) {
            if (this.getUsrid() != null) {
                User tempUser = this.userMgr.getUserInfo(Long.parseLong(this.getUsrid()));
                Set urSet = tempUser.getRolesSet();
                this.roleidsStr = "";
                for (Role temprole : urSet) {
                    this.roleidsStr = this.roleidsStr + temprole.getRoleID() + ",";
                }
                selRolArr = this.roleidsStr.split(",");
            } else {
                selRolArr = new String[]{};
            }
        } else {
            selRolArr = this.roleidsStr.equals("") ? new String[]{} : this.roleidsStr.split(",");
        }
        int gridIndex = 0;
        for (Role temprole : this.listRole) {
            for (String role1 : selRolArr) {
                if (!role1.equalsIgnoreCase(temprole.getRoleID() + "")) continue;
                this.listRoleSel = this.listRoleSel + gridIndex + ",";
                break;
            }
            ++gridIndex;
        }
        return "success";
    }

    public void modifyPassword() {
        boolean pwdEqual;
        boolean oldPwdCheck;
        HttpServletRequest request = this.fetchRequest();
        User currentUser = null;
        currentUser = (User)request.getSession().getAttribute("currentUser");
        User nowUser = this.userMgr.getUserInfo(currentUser.getUserID());
        this.getOperateLog().normal("lego.lab.log.func.passwordmod", "lego.dic.module.user", this.getSecureString(nowUser.getUserName()));
        if (null == this.oldPassword || "".equals(this.oldPassword.trim())) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_OLDERROR.intValue());
        }
        if (null == this.password || "".equals(this.password.trim()) || null == this.confirmPassword || "".equals(this.confirmPassword.trim())) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMEERROR.intValue());
        }
        if (this.equalDefaultPwd(this.userMgr, new StringBuffer(DataProtectServiceConst.sdpEncryptLocal((String)this.password)))) {
            throw new LegoCheckedException((long)UserConstant.ERR_MODIFYPASSWORD_INITPWD.intValue());
        }
        boolean checkPassword = ValidatorUtil.validPasswordValue(nowUser.getUserName(), this.password);
        if (!checkPassword) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SIMPLEVALUE.intValue());
        }
        if (!this.password.equals(this.confirmPassword)) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
        }
        if (this.password.toLowerCase(Locale.US).contains(currentUser.getUserName().toLowerCase(Locale.US)) || this.password.toLowerCase(Locale.US).contains(this.reverseStr(currentUser.getUserName().toLowerCase(Locale.US)))) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SIMPLEVALUE.intValue());
        }
        if (null != this.getType() && this.getType().equals("first")) {
            LOG.debug((Object)"first login653110169894912");
        }
        if (!(oldPwdCheck = DataProtectServiceConst.sdpVerifyPwdLocal((StringBuffer)new StringBuffer(this.oldPassword), (String)nowUser.getUserPassword()))) {
            this.procPwdNoEquals();
        }
        if (pwdEqual = DataProtectServiceConst.sdpVerifyPwdLocal((StringBuffer)new StringBuffer(this.password), (String)nowUser.getUserPassword())) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMEERROR.intValue());
        }
        this.userMgr.modifyPassword(DataProtectServiceConst.sdpProtectPwdLocal((StringBuffer)new StringBuffer(this.oldPassword)), DataProtectServiceConst.sdpProtectPwdLocal((StringBuffer)new StringBuffer(this.password)), nowUser.getUserID());
        this.getSession().setAttribute("passState", (Object)"ok");
        this.getSession().setAttribute("mustModifyPwd", (Object)false);
        this.getSession().removeAttribute("com.hs.lego.modifyPassword.errorNumber");
    }

    private void procPwdNoEquals() {
        int maxErrorNumber = 5;
        Integer errorNumber = (Integer)this.getSession().getAttribute("com.hs.lego.modifyPassword.errorNumber");
        if (errorNumber == null) {
            this.getSession().setAttribute("com.hs.lego.modifyPassword.errorNumber", (Object)1);
        } else {
            Integer n = errorNumber;
            Integer n2 = errorNumber = Integer.valueOf(errorNumber + 1);
            if (errorNumber >= maxErrorNumber) {
                throw new LegoSecurityException((long)UserConstant.ERR_MODIFYPASSWORD_ERRINPUT.intValue());
            }
            this.getSession().setAttribute("com.hs.lego.modifyPassword.errorNumber", (Object)errorNumber);
            if (errorNumber >= maxErrorNumber - 1) {
                throw new LegoCheckedException((long)UserConstant.ERR_MODIFYPASSWORD_ERRINPUT_PRE.intValue());
            }
        }
        throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_OLDERROR.intValue());
    }

    public void downUsr() {
        if (this.getUserInfo() != null) {
            String tarName = "";
            tarName = this.getUsername() != null ? this.getUsername() : this.getUserInfo();
            LOG.warn((Object)("down user:" + this.getSecureString(tarName)));
            this.getOperateLog().warning("lego.lab.log.func.userdown", "lego.dic.module.user", this.getSecureString(tarName));
            if (!this.checkUserExist(this.userMgr.getAllOnlineUser(), this.getUsername(), this.getUserInfo())) {
                throw new LegoCheckedException(303L);
            }
            this.userMgr.forceLogout(this.getUserInfo());
        }
    }

    private boolean checkUserExist(List<User> userList, String checkUserName, String checkUserSession) {
        if (null == userList) {
            return false;
        }
        for (User u : userList) {
            if (!u.getUserName().equals(checkUserName) || !u.getSession().equals(checkUserSession)) continue;
            return true;
        }
        return false;
    }

    private boolean checkUserExist(List<User> userList, String checkUserName, long id1) {
        if (null == userList) {
            return false;
        }
        for (User u : userList) {
            if (!u.getUserName().equals(checkUserName) || id1 != u.getUserID()) continue;
            return true;
        }
        return false;
    }

    private boolean checkRoleExist(List<Role> userList, String checkUserName, long id1) {
        for (Role r : userList) {
            if (!r.getRoleName().equals(checkUserName) || id1 != r.getRoleID()) continue;
            return true;
        }
        return false;
    }

    public String usrAclList() {
        this.listAcl = new ArrayList<UserAcl>();
        HttpServletRequest request = this.fetchRequest();
        if (this.getType() != null) {
            request.setAttribute("type", (Object)this.getType());
        }
        if (this.getUsrid() != null) {
            request.setAttribute("usrid", (Object)this.getUsrid());
            User queryUsr = this.userMgr.getUserInfo(Long.parseLong(this.getUsrid() + ""));
            Set lstUsrAcl = queryUsr.getUserAclSet();
            if (lstUsrAcl != null) {
                for (UserAcl tempUsrAcl : lstUsrAcl) {
                    this.listAcl.add(tempUsrAcl);
                }
            }
        } else {
            UserAcl defaultAcl = new UserAcl();
            defaultAcl.setStrStartIp("127.0.0.1");
            defaultAcl.setStrEndIp("127.0.0.1");
            this.listAcl.add(defaultAcl);
        }
        return "success";
    }

    public String passPolicy() {
        this.passComplexVal = "";
        this.passLenVal = "";
        this.oldPassword = "";
        this.password = "";
        this.confirmPassword = "";
        this.listPassLen = new ArrayList<LangPair>();
        this.listPassComplex = new ArrayList<LangPair>();
        this.listPassLockType = new ArrayList<LangPair>();
        LangPair len2 = new LangPair("6", this.getText("lego.dic.password.len.six"));
        LangPair len3 = new LangPair("8", this.getText("lego.dic.password.len.eight"));
        LangPair len4 = new LangPair("10", this.getText("lego.dic.password.len.ten"));
        this.listPassLen.add(len2);
        this.listPassLen.add(len3);
        this.listPassLen.add(len4);
        LangPair com2 = new LangPair("2", this.getText("lego.dic.password.complex.letternumberlabel"));
        LangPair com4 = new LangPair("4", this.getText("lego.dic.password.complex.alllabel"));
        this.listPassComplex.add(com2);
        this.listPassComplex.add(com4);
        LangPair lock1 = new LangPair("1", this.getText("lego.lab.securityset.lockforever"));
        LangPair lock2 = new LangPair("2", this.getText("lego.lab.securityset.locktime"));
        this.listPassLockType.add(lock1);
        this.listPassLockType.add(lock2);
        UserSecPolicy usrPolicy = this.userMgr.getUserSecPolicy();
        UserLoginPolicy usrLogPolicy = this.userMgr.getLoginPolicy();
        if (null != usrLogPolicy) {
            this.logCtrl = usrLogPolicy.getUnseal() == 1;
            this.intercurrentLogin = usrLogPolicy.getIntercurrentLogin() == 1;
            this.passErrNum = usrLogPolicy.getLgoinCount();
            this.passInterTime = usrLogPolicy.getLgoinInterval();
            if (usrLogPolicy.getLockTime() == -1) {
                this.passLockType = String.valueOf(1);
                this.passLockTime = 3L;
            } else {
                this.passLockType = String.valueOf(2);
                this.passLockTime = usrLogPolicy.getLockTime();
            }
            this.sessionTime = usrLogPolicy.getSessionTimeOut();
        }
        if (null != usrPolicy) {
            int ilen = usrPolicy.getPswLenth();
            this.passLenVal = usrPolicy.getPswLenth() + "";
            this.passComplexVal = usrPolicy.getComplex();
            this.passCtrl = usrPolicy.getUnseal() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.usefulLife = usrPolicy.getUsefulLife();
            this.passPolyCheck(ilen);
            this.aclCtrl = true;
        }
        return "success";
    }

    private void passPolyCheck(int ilen) {
        this.passLenLabel = ilen == 6 ? this.getText("lego.dic.password.len.six") : (ilen == 8 ? this.getText("lego.dic.password.len.eight") : (ilen == 10 ? this.getText("lego.dic.password.len.ten") : this.getText("lego.dic.password.len.notnull")));
        this.passComplexLabel = this.passComplexVal.equals("2") ? this.getText("lego.dic.password.complex.letternumber") : (this.passComplexVal.equals("3") ? this.getText("lego.dic.password.complex.specharacter") : (this.passComplexVal.equals("4") ? this.getText("lego.dic.password.complex.all") : this.getText("lego.dic.password.complex.absoluteness")));
    }

    public void savePolicy() {
        UserSecPolicy usrPolicy;
        UserLoginPolicy usrLogPolicytemp = this.userMgr.getLoginPolicy();
        if (null != usrLogPolicytemp) {
            usrLogPolicytemp.setSessionTimeOut((int)this.sessionTime);
            if (this.logCtrl) {
                usrLogPolicytemp.setUnseal(1);
                usrLogPolicytemp.setLgoinCount((int)this.passErrNum);
                usrLogPolicytemp.setLgoinInterval((int)this.passInterTime);
                if (this.passLockType.equalsIgnoreCase("1")) {
                    this.passLockTime = -1L;
                }
                usrLogPolicytemp.setLockTime((int)this.passLockTime);
            } else {
                usrLogPolicytemp.setUnseal(0);
            }
            if (this.intercurrentLogin) {
                usrLogPolicytemp.setIntercurrentLogin(1);
            } else {
                usrLogPolicytemp.setIntercurrentLogin(0);
            }
            this.getOperateLog().normal("lego.lab.log.func.polycyedit", "lego.dic.module.user", "lego.lab.securityset.syssecset", true, "", null);
            this.userMgr.updateLoginPolicy(usrLogPolicytemp);
        }
        if (null != (usrPolicy = this.userMgr.getUserSecPolicy())) {
            usrPolicy.setPswLenth(Integer.parseInt(this.passLenVal));
            usrPolicy.setComplex(this.passComplexVal);
            if (this.passCtrl != null && this.passCtrl.booleanValue()) {
                usrPolicy.setUnseal(1);
                usrPolicy.setUsefulLife(this.usefulLife);
            } else {
                usrPolicy.setUnseal(0);
            }
            this.userMgr.updateUserSecPolicy(usrPolicy);
        }
    }

    private String reverseStr(String str) {
        StringBuffer buffer = new StringBuffer();
        for (int i = str.length() - 1; i >= 0; --i) {
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }

    public void exceedMaxAdministrators() {
        int num = this.userMgr.getAllUser().size();
        if ((long)num >= 100L) {
            LegoCheckedException ex = new LegoCheckedException((long)UserConstant.ERR_NUMBER_OVER.intValue());
            String s = this.getText("lego.err." + ex.getErrorCode());
            this.responseResult(s);
        }
    }

    public void exceedMaxAdministratorGroups() {
        int num = this.userMgr.getAllRole().size();
        if ((long)num >= 100L) {
            LegoCheckedException ex = new LegoCheckedException(362L);
            String s = this.getText("lego.err." + ex.getErrorCode());
            this.responseResult(s);
        }
    }

    private boolean equalDefaultPwd(IUserMgr mgr, StringBuffer aPwd) {
        return mgr.verifyDefaultPwd(aPwd);
    }

    public List<User> getListAdmin() {
        return this.listAdmin;
    }

    public void setListAdmin(List<User> listAdmin) {
        this.listAdmin = listAdmin;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public List<Role> getListRole() {
        return this.listRole;
    }

    public void setListRole(List<Role> listRole) {
        this.listRole = listRole;
    }

    public String getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(String selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getIdList() {
        return this.idList;
    }

    public void setIdList(String idList) {
        this.idList = idList;
    }

    public String getListRoleSel() {
        return this.listRoleSel;
    }

    public void setListRoleSel(String listRoleSel) {
        this.listRoleSel = listRoleSel;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCurrentUsrSessionId() {
        return this.currentUsrSessionId;
    }

    public void setCurrentUsrSessionId(String currentUsrSessionId) {
        this.currentUsrSessionId = currentUsrSessionId;
    }

    public List<UserAcl> getListAcl() {
        return this.listAcl;
    }

    public void setListAcl(List<UserAcl> listAcl) {
        this.listAcl = listAcl;
    }

    public String getCurrentUsrId() {
        return this.currentUsrId;
    }

    public void setCurrentUsrId(String currentUsrId) {
        this.currentUsrId = currentUsrId;
    }

    public List<LangPair> getListPassLen() {
        return this.listPassLen;
    }

    public void setListPassLen(List<LangPair> listPassLen) {
        this.listPassLen = listPassLen;
    }

    public List<LangPair> getListPassComplex() {
        return this.listPassComplex;
    }

    public void setListPassComplex(List<LangPair> listPassComplex) {
        this.listPassComplex = listPassComplex;
    }

    public String getPassLenVal() {
        return this.passLenVal;
    }

    public void setPassLenVal(String passLenVal) {
        this.passLenVal = passLenVal;
    }

    public String getPassLenLabel() {
        return this.passLenLabel;
    }

    public void setPassLenLabel(String passLenLabel) {
        this.passLenLabel = passLenLabel;
    }

    public String getPassComplexVal() {
        return this.passComplexVal;
    }

    public void setPassComplexVal(String passComplexVal) {
        this.passComplexVal = passComplexVal;
    }

    public String getPassComplexLabel() {
        return this.passComplexLabel;
    }

    public void setPassComplexLabel(String passComplexLabel) {
        this.passComplexLabel = passComplexLabel;
    }

    public boolean isAclCtrl() {
        return this.aclCtrl;
    }

    public void setAclCtrl(boolean aclCtrl) {
        this.aclCtrl = aclCtrl;
    }

    public long getPassErrNum() {
        return this.passErrNum;
    }

    public void setPassErrNum(long passErrNum) {
        this.passErrNum = passErrNum;
    }

    public long getPassInterTime() {
        return this.passInterTime;
    }

    public void setPassInterTime(long passInterTime) {
        this.passInterTime = passInterTime;
    }

    public long getPassLockTime() {
        return this.passLockTime;
    }

    public void setPassLockTime(long passLockTime) {
        this.passLockTime = passLockTime;
    }

    public long getSessionTime() {
        return this.sessionTime;
    }

    public void setSessionTime(long sessionTime) {
        this.sessionTime = sessionTime;
    }

    public boolean isIntercurrentLogin() {
        return this.intercurrentLogin;
    }

    public void setIntercurrentLogin(boolean intercurrentLogin) {
        this.intercurrentLogin = intercurrentLogin;
    }

    public boolean isLogCtrl() {
        return this.logCtrl;
    }

    public void setLogCtrl(boolean logCtrl) {
        this.logCtrl = logCtrl;
    }

    public String getDisabledIndex() {
        return this.disabledIndex;
    }

    public void setDisabledIndex(String disabledIndex) {
        this.disabledIndex = disabledIndex;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getPasswordModleValue() {
        return this.passwordModleValue;
    }

    public void setPasswordModleValue(String passwordModleValue) {
        this.passwordModleValue = passwordModleValue;
    }

    public String getPasswordModleLab() {
        return this.passwordModleLab;
    }

    public void setPasswordModleLab(String passwordModleLab) {
        this.passwordModleLab = passwordModleLab;
    }

    public List<LangPair> getListpasswordModle() {
        return this.listpasswordModle;
    }

    public void setListpasswordModle(List<LangPair> listpasswordModle) {
        this.listpasswordModle = listpasswordModle;
    }

    public String getResIds() {
        return this.resIds;
    }

    public void setResIds(String resIds) {
        this.resIds = resIds;
    }

    public String getRoleidsStr() {
        return this.roleidsStr;
    }

    public void setRoleidsStr(String roleidsStr) {
        this.roleidsStr = roleidsStr;
    }

    public String getCurUsrisAdmin() {
        return this.curUsrisAdmin;
    }

    public void setCurUsrisAdmin(String curUsrisAdmin) {
        this.curUsrisAdmin = curUsrisAdmin;
    }

    public void setSelectType(int selectType) {
        this.selectType = selectType;
    }

    public List<LangPair> getListPassLockType() {
        return this.listPassLockType;
    }

    public void setListPassLockType(List<LangPair> listPassLockType) {
        this.listPassLockType = listPassLockType;
    }

    public String getPassLockType() {
        return this.passLockType;
    }

    public void setPassLockType(String passLockType) {
        this.passLockType = passLockType;
    }

    public Boolean getPassCtrl() {
        return this.passCtrl;
    }

    public void setPassCtrl(Boolean passCtrl) {
        this.passCtrl = passCtrl;
    }

    public int getUsefulLife() {
        return this.usefulLife;
    }

    public void setUsefulLife(int usefulLife) {
        this.usefulLife = usefulLife;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public long getSetTime() {
        return this.setTime;
    }

    public void setSetTime(long setTime) {
        this.setTime = setTime;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUsrid() {
        return this.usrid;
    }

    public void setUsrid(String usrid) {
        this.usrid = usrid;
    }

    public String getManagerFlag() {
        return this.managerFlag;
    }

    public void setManagerFlag(String managerFlag) {
        this.managerFlag = managerFlag;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getByType() {
        return this.byType;
    }

    public void setByType(String byType) {
        this.byType = byType;
    }

    public String getAdmin() {
        return this.admin;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public String getRoleid() {
        return this.roleid;
    }

    public void setRoleid(String roleid) {
        this.roleid = roleid;
    }

    public String getStartIp() {
        return this.startIp;
    }

    public void setStartIp(String startIp) {
        this.startIp = startIp;
    }

    public String getEndIp() {
        return this.endIp;
    }

    public void setEndIp(String endIp) {
        this.endIp = endIp;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getSelusr() {
        return this.selusr;
    }

    public void setSelusr(String selusr) {
        this.selusr = selusr;
    }

    private String getSecureString(String str) {
        if (str != null) {
            return str.replace("\r", "").replace("\n", "");
        }
        return str;
    }

    public long getPassType() {
        return this.passType;
    }

    public void setPassType(long passType) {
        this.passType = passType;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    public IDeviceTypeMgr getDeviceTypeMgr() {
        return this.deviceTypeMgr;
    }

    public void setDeviceTypeMgr(IDeviceTypeMgr deviceTypeMgr) {
        this.deviceTypeMgr = deviceTypeMgr;
    }

    public IProductsCustomizeService getPcService() {
        return this.pcService;
    }

    public void setPcService(IProductsCustomizeService pcService) {
        this.pcService = pcService;
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public ISysOptLog getSysLogService() {
        return this.sysLogService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }

    public Long[] getBox() {
        return (Long[])ArrayDeepClone.deepClone((Object)this.box);
    }

    public void setBox(Long[] box) {
        this.box = (Long[])ArrayDeepClone.deepClone((Object)box);
    }

    public String[] getBoxStr() {
        return (String[])ArrayDeepClone.deepClone((Object)this.boxStr);
    }

    public void setBoxStr(String[] boxStr) {
        this.boxStr = (String[])ArrayDeepClone.deepClone((Object)boxStr);
    }

    public Long[] getBoxEx() {
        return (Long[])ArrayDeepClone.deepClone((Object)this.boxEx);
    }

    public void setBoxEx(Long[] boxEx) {
        this.boxEx = (Long[])ArrayDeepClone.deepClone((Object)boxEx);
    }

    public int getSelectType() {
        return this.selectType;
    }

    public void setResultList(List<ResultVO> resultList) {
        this.resultList = resultList;
    }
}

