/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.radius;

import com.hs.lego.cbb.user.thirdauth.sdk.IRadiusAuthService;
import com.hs.lego.cbb.user.thirdauth.sdk.model.RadiusServerModel;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.radius.dao.RadiusDao;
import java.util.List;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;
import net.sourceforge.jradiusclient.packets.ChapAccessRequest;
import net.sourceforge.jradiusclient.packets.PapAccessRequest;

public class RadiusAuthServiceImp
implements IRadiusAuthService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    private static final String TIME_OUT = "Receive timed out";
    private static final String RESP_ERROR = "Authenticators do not match, response packet not validated!";
    private RadiusDao<RadiusServerModel, Long> radiusDao = null;

    public RadiusDao<RadiusServerModel, Long> getRadiusDao() {
        return this.radiusDao;
    }

    public void setRadiusDao(RadiusDao<RadiusServerModel, Long> radiusDao) {
        this.radiusDao = radiusDao;
    }

    private RadiusClient getRadiusClient(int authport, String serverIp, String shareSecret) {
        LOGGER.info((Object)"IN getRadiusClient653110178217992");
        RadiusClient client = null;
        try {
            client = new RadiusClient(serverIp, authport, 1813, DataProtectServiceConst.sdpDecryptLocalBuffer((String)shareSecret).toString());
        }
        catch (InvalidParameterException ivpex) {
            LOGGER.error((Object)("@ auth: InvalidParameterException ErrorCode:522: " + ivpex.getMessage()), (Throwable)ivpex);
            this.changeRadiusException(ivpex);
        }
        catch (RadiusException rex) {
            LOGGER.error((Object)("@ auth: RadiusException ErrorCode: 521: " + rex.getMessage()), (Throwable)rex);
            this.changeRadiusException(rex);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"@ auth: LegoCheckedException653110178217992", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error((Object)("@ auth: RadiusException ErrorCode: 520: " + ex.getMessage()), (Throwable)ex);
            throw new LegoCheckedException(521L, (Throwable)ex);
        }
        LOGGER.info((Object)"OUT getRadiusClient653110178217992");
        return client;
    }

    public boolean auth(String userName, String userPass, boolean reConnect) {
        boolean isSucces = false;
        LOGGER.info((Object)"IN auth653110178217992");
        RadiusServerModel serverInfo = this.getRadiusServerInfo();
        if (null == serverInfo) {
            throw new LegoCheckedException(520L, "No radius server information in DB!");
        }
        isSucces = this.auth(userName, userPass, reConnect, serverInfo);
        return isSucces;
    }

    @Override
    public boolean auth(String userName, String userPass, boolean reConnect, RadiusServerModel serverInfo) {
        boolean isSucces = false;
        LOGGER.info((Object)"IN auth653110178217992");
        if (null == serverInfo) {
            return isSucces;
        }
        String userAuthMode = serverInfo.getAuthMode();
        int authPort = serverInfo.getAuthPort();
        String mainServerIP = serverInfo.getMainServerIP();
        String spareServerIP = serverInfo.getSpareServerIP();
        String shareSecret = serverInfo.getSharedSecret();
        RadiusPacket accessResponse = null;
        String serverIP = "";
        serverIP = reConnect ? spareServerIP : mainServerIP;
        RadiusClient client = null;
        if (serverIP != null && !serverIP.equals("")) {
            client = this.getRadiusClient(authPort, serverIP, shareSecret);
        }
        Object accessRequest = null;
        try {
            accessRequest = userAuthMode.equalsIgnoreCase("chap") ? new ChapAccessRequest(userName, DataProtectServiceConst.sdpDecryptLocalBuffer((String)userPass).toString()) : new PapAccessRequest(userName, DataProtectServiceConst.sdpDecryptLocalBuffer((String)userPass).toString());
            if (null != client) {
                accessResponse = client.authenticate((RadiusPacket)accessRequest);
                byte accessResponseResult = 0;
                accessResponseResult = accessResponse.getPacketType();
                if (2 == accessResponseResult || 11 == accessResponseResult) {
                    isSucces = true;
                    return isSucces;
                }
                if (accessResponseResult == 3) {
                    throw new LegoCheckedException(256L, "User " + userName + " NOT authenticated");
                }
                throw new LegoCheckedException(520L, "NOT authenticated,Packet Type is: " + accessResponse.getPacketType());
            }
        }
        catch (InvalidParameterException ivpex) {
            LOGGER.error((Object)("@ auth: InvalidParameterException ErrorCode:520: " + ivpex.getMessage()), (Throwable)ivpex);
            this.changeRadiusException(ivpex);
        }
        catch (RadiusException rex) {
            LOGGER.error((Object)("@ auth: RadiusException ErrorCode: 520: " + rex.getMessage()), (Throwable)rex);
            this.changeRadiusException(rex);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"@ auth: LegoCheckedException", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error((Object)("@ auth: RadiusException ErrorCode: 520: " + ex.getMessage()), (Throwable)ex);
            throw new LegoCheckedException(521L, (Throwable)ex);
        }
        return isSucces;
    }

    @Override
    public boolean auth(String userName, String userPass) {
        boolean isSucces = false;
        LOGGER.info((Object)"IN auth653110178217992");
        try {
            isSucces = this.auth(userName, userPass, false);
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() == 521L) {
                if (!this.auth(userName, userPass, true)) {
                    LOGGER.error((Object)"auth(userName, userPass, true) fault653110178217992");
                    LOGGER.info((Object)("@ auth: RadiusException ErrorCode: 521: " + ex.getMessage()));
                    throw ex;
                }
                isSucces = true;
            }
            LOGGER.info((Object)("@ auth: RadiusException ErrorCode: 522: " + ex.getMessage() + 653110178217992L));
            throw ex;
        }
        catch (Exception e) {
            LOGGER.info((Object)("@ auth: RadiusException ErrorCode: 522: " + e.getMessage() + 653110178217992L));
            throw new LegoCheckedException(522L, (Throwable)e);
        }
        return isSucces;
    }

    @Override
    public boolean deleteRadiusServerInfo() {
        boolean success = false;
        try {
            List<RadiusServerModel> list = this.radiusDao.queryByHql("from RadiusServerModel ");
            if (null != list) {
                this.radiusDao.deleteList(list);
            }
            success = true;
        }
        catch (Exception e) {
            throw new LegoCheckedException(519L, (Throwable)e);
        }
        return success;
    }

    @Override
    public void createOrUpdate(int authport, String mainServerIP, String spareServerIP, String sharedSecret, String authMode) {
        RadiusServerModel info = new RadiusServerModel();
        info.setAuthPort(authport);
        info.setMainServerIP(mainServerIP);
        info.setSpareServerIP(spareServerIP);
        info.setSharedSecret(sharedSecret);
        info.setAuthMode(authMode);
        this.radiusDao.createOrUpdate(info);
    }

    @Override
    public RadiusServerModel getRadiusServerInfo() {
        LOGGER.info((Object)"IN getRadiusServerInfo653110178217992");
        List<RadiusServerModel> list = this.radiusDao.queryByHql("from RadiusServerModel ");
        if (list == null || list.isEmpty()) {
            LOGGER.info((Object)"@getRadiusServerInfo: no data in DB653110178217992");
            return null;
        }
        RadiusServerModel radiusInfo = list.get(0);
        LOGGER.info((Object)"OUT getRadiusServerInfo653110178217992");
        return radiusInfo;
    }

    private void changeRadiusException(InvalidParameterException rex) {
        throw new LegoCheckedException(522L, rex.getMessage());
    }

    private void changeRadiusException(RadiusException rex) {
        String rexMssage = rex.getMessage();
        if (null != rexMssage && !rexMssage.trim().equals("")) {
            if (rexMssage.contains(TIME_OUT)) {
                throw new LegoCheckedException(521L);
            }
            if (rexMssage.contains(RESP_ERROR)) {
                throw new LegoCheckedException(522L);
            }
        }
        throw new LegoCheckedException(521L);
    }

    @Override
    public boolean auth(String userName, String userPass, String authMethod) {
        return false;
    }

    @Override
    public void createOrUpdate(int authport, String serverIp, String shareSecret, String authMode) {
    }
}

