/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.radius.dao;

import com.hs.lego.cbb.user.thirdauth.sdk.model.RadiusServerModel;
import com.hs.lego.core.sdk.comm.Paging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class RadiusDao<T, PK extends Serializable>
extends HibernateDaoSupport {
    protected Class<T> persistentClass;

    public RadiusDao() {
    }

    public RadiusDao(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public List<T> queryPageByHql(final String hql, final int start, final int pageSize) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query q = session.createQuery(hql);
                q.setFirstResult(start);
                q.setMaxResults(pageSize);
                return q.list();
            }
        });
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        String hql = this.initQuery(queryMap, new StringBuffer());
        List<T> list = this.queryPageByHql(hql, start, pageSize);
        Paging page = new Paging();
        page.setData(list);
        page.setCount((int)this.getRowCountByHsql(this.generateRowCountSqlByHsql(hql)));
        return page;
    }

    public void delete(PK id) {
        this.getHibernateTemplate().delete(this.query(id));
    }

    public void delete(T t) {
        this.getHibernateTemplate().delete(t);
    }

    public T query(PK id) {
        return (T)this.getHibernateTemplate().get(this.persistentClass, id);
    }

    public List<RadiusServerModel> queryAll() {
        return this.queryByHql(this.basicHql());
    }

    protected String generateRowCountSqlByHsql(String hsql) {
        String hsqlLowerCase = hsql.toLowerCase(Locale.getDefault());
        int sqlFrom = hsqlLowerCase.indexOf("from ");
        int sqlOrderby = hsqlLowerCase.lastIndexOf("order by");
        int sqlGroupby = hsqlLowerCase.lastIndexOf("group by");
        String rowCountSql = "";
        rowCountSql = sqlOrderby > 0 ? "select count(*) AS rowCount " + hsql.substring(sqlFrom, sqlOrderby) : (sqlGroupby > 0 ? "select count(*) from (select count(*) AS rowCount " + hsql.substring(sqlFrom) + ") as tab" : "select count(*) AS rowCount " + hsql.substring(sqlFrom));
        return rowCountSql;
    }

    public long getRowCountByHsql(String hsql) {
        return (Long)super.getHibernateTemplate().find(hsql, new Object[0]).listIterator().next();
    }

    public List<RadiusServerModel> queryByHql(String hql) {
        return this.getHibernateTemplate().find(hql, new Object[0]);
    }

    protected String initQuery(Map<String, String> queryMap, StringBuffer hql) {
        this.basicHql(hql);
        this.conditionHql(queryMap, hql);
        this.sortHql(queryMap, hql);
        return hql.toString();
    }

    protected void conditionHql(Map<String, String> queryMap, StringBuffer hql) {
        if (!queryMap.isEmpty()) {
            boolean isFirstCondition = true;
            hql.append(" where ");
            for (Map.Entry<String, String> entry : queryMap.entrySet()) {
                if (isFirstCondition) {
                    isFirstCondition = false;
                } else {
                    hql.append(" and ");
                }
                String key = entry.getKey();
                String value = entry.getValue();
                hql.append(key + "= " + value);
            }
        }
    }

    protected String basicHql() {
        StringBuffer hql = new StringBuffer();
        this.basicHql(hql);
        return hql.toString();
    }

    private void basicHql(StringBuffer hql) {
        hql.append("from ").append(this.persistentClass.getSimpleName());
    }

    protected void sortHql(Map<String, String> queryMap, StringBuffer hql) {
        String sortType = queryMap.get("sortType");
        String sortName = queryMap.get("sortName");
        if (null != sortType && null != sortName) {
            hql.append(" order by ").append(sortName).append("  ").append(sortType);
        }
    }

    public T save(T object) {
        return (T)this.getHibernateTemplate().merge(object);
    }

    public void update(T object) {
        this.getHibernateTemplate().update(object);
    }

    public Serializable create(T object) {
        return this.getHibernateTemplate().save(object);
    }

    public void deleteList(Collection<T> list) {
        for (T t : list) {
            this.getHibernateTemplate().delete(t);
        }
    }

    public void createOrUpdate(T object) {
        this.getHibernateTemplate().saveOrUpdate(object);
    }
}

