/*
 * Decompiled with CFR 0.152.
 */
package com.restful.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.restful.model.RestAuthInfo;
import com.restful.model.RestAuthUser;
import com.restful.service.RestAuthService;
import com.restful.util.JSONUtil;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.struts2.ServletActionContext;

@Path(value="ddos/auth")
@Produces(value={"application/json"})
public class RestAuthServiceImpl
implements RestAuthService {
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REST);
    private IUserMgr userMgr;

    @Override
    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public final Response authAdministrator(String json) {
        String username;
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestAuthUser restAuthUser = null;
        HttpServletRequest request = ServletActionContext.getRequest();
        String requestMsg = "authAdministrator. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = "null";
        if (null == request) {
            responseMsg = "restful request is null.";
            responseCode = 400;
            RestUtil.processSysLog(requestMsg, responseCode, responseMsg);
            detailPara[2] = responseCode + "," + responseMsg;
            String[] params = new String[]{terminalIp, "restful", "atic.restful.auth.administrator", "atic.restful.auth.administrator"};
            RestUtil.processOpeLogByTarget(detailPara, responseCode, params, true);
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        detailPara[0] = url = RestAuthUtil.getRequestURL(request, "ddos/auth");
        requestMsg = "authAdministrator. restful request url : " + url + ".";
        terminalIp = request.getRemoteAddr();
        try {
            this.checkJson(json);
            restAuthUser = (RestAuthUser)JSONUtil.getInstance().fromJSON(json, RestAuthUser.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog(requestMsg, responseCode, "convert the format from java to pojo bean failed.", e);
            detailPara[2] = responseCode + "," + responseMsg;
            String[] params = new String[]{terminalIp, "restful", "atic.restful.auth.administrator", "atic.restful.auth.administrator"};
            RestUtil.processOpeLogByTarget(detailPara, responseCode, params, true);
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        detailPara[1] = username = restAuthUser.getUsername().trim();
        String password = restAuthUser.getPassword().trim();
        if (!this.checkParames(username, password)) {
            responseCode = 400;
            RestUtil.processSysLog(requestMsg, responseCode, "illegal parameter.");
            detailPara[2] = responseCode + "," + responseMsg;
            String[] params = new String[]{terminalIp, "restful", "atic.restful.auth.administrator", "atic.restful.auth.administrator"};
            RestUtil.processOpeLogByTarget(detailPara, responseCode, params, true);
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        String clientIp = request.getRemoteAddr();
        User user = null;
        try {
            user = this.userMgr.loginSystem(clientIp, username, DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(password)));
        }
        catch (LegoCheckedException e) {
            responseCode = 400;
            RestUtil.processSysLog(requestMsg, responseCode, "client login failed.", (Exception)((Object)e));
            detailPara[2] = responseCode + "";
            String[] params = new String[]{terminalIp, username, "atic.restful.auth.administrator", username};
            RestUtil.processOpeLogByTarget(detailPara, responseCode, params, true);
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        catch (Exception e) {
            responseCode = 500;
            RestUtil.processSysLog(requestMsg, responseCode, "server login failed.", e);
            detailPara[2] = responseCode + "";
            String[] params = new String[]{terminalIp, username, "atic.restful.auth.administrator", username};
            RestUtil.processOpeLogByTarget(detailPara, responseCode, params, true);
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        if (null == user) {
            responseCode = 400;
            RestUtil.processSysLog(requestMsg, responseCode, "user is null. user's name or password is wrong.");
            detailPara[2] = responseCode + "";
            String[] params = new String[]{terminalIp, username, "atic.restful.auth.administrator", username};
            RestUtil.processOpeLogByTarget(detailPara, responseCode, params, true);
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        StringBuffer csrfToken = new StringBuffer(RestAuthUtil.genRandomString());
        RestAuthInfo restAuthInfo = new RestAuthInfo();
        restAuthInfo.setAuthTime(System.currentTimeMillis());
        restAuthInfo.setClientIp(clientIp);
        restAuthInfo.setToken(csrfToken);
        restAuthInfo.setUsername(username);
        Map<String, RestAuthInfo> restAuthsMap = RestAuthUtil.getRestAuths();
        if (null == restAuthsMap) {
            RestAuthUtil.setRestAuths(new HashMap<String, RestAuthInfo>());
            restAuthsMap = RestAuthUtil.getRestAuths();
        } else if (!restAuthsMap.isEmpty()) {
            Iterator<Map.Entry<String, RestAuthInfo>> iterator = restAuthsMap.entrySet().iterator();
            long tokenLegalTime = this.userMgr.getSessionEffectiveTime();
            this.logger.info((Object)("tokenLegalTime is:" + tokenLegalTime / 60000L + " minutes." + requestMsg));
            ArrayList<String> toDel = new ArrayList<String>();
            while (iterator.hasNext()) {
                Map.Entry<String, RestAuthInfo> entry = iterator.next();
                long authTime = entry.getValue().getAuthTime();
                if (tokenLegalTime >= System.currentTimeMillis() - authTime) continue;
                toDel.add(entry.getKey());
                this.logger.info((Object)("authTime is over tokenLegalTime. " + requestMsg));
            }
            RestAuthUtil.removeTimeoutToken(toDel);
        }
        restAuthsMap.put(clientIp + "_" + username, restAuthInfo);
        responseMsg = "{\"token\": \"" + csrfToken + "\"}";
        responseCode = 200;
        RestUtil.processSysLog(requestMsg, responseCode, "authAdministrator succeed.");
        detailPara[2] = responseCode + "";
        String[] params = new String[]{terminalIp, username, "atic.restful.auth.administrator", username};
        RestUtil.processOpeLogByTarget(detailPara, responseCode, params, true);
        return Response.ok((Object)responseMsg).build();
    }

    @Override
    @PUT
    @Path(value="/password/{username}")
    @PathParam(value="username")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public final Response modifyPassword(@PathParam(value="username") String username, String json) {
        String currUserName;
        Response.ResponseBuilder responseBuilder = Response.ok();
        HttpServletRequest request = ServletActionContext.getRequest();
        String requestMsg = "modifyPassword. restful request is null.";
        String terminalIp = "127.0.0.1";
        String url = "null";
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        if (null != request) {
            detailPara[0] = url = RestAuthUtil.getRequestURL(request, "ddos/auth/password/{username}");
            requestMsg = "modifyPassword. restful request url : " + url + ".";
            terminalIp = request.getRemoteAddr();
        }
        if (AticUtil.isNull((String)(currUserName = RestAuthUtil.isLegalToken(request, "ddos/auth/password/{username}")))) {
            responseMsg = "restful token is null.";
            responseCode = 412;
            RestUtil.processSysLog(requestMsg, responseCode, responseMsg);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog(detailPara, responseCode, terminalIp, "restful", "atic.restful.auth.modify");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        this.logger.info((Object)("is Legal Token, currUserName :" + currUserName + ". " + requestMsg));
        RestAuthUser restAuthUser = null;
        try {
            restAuthUser = (RestAuthUser)JSONUtil.getInstance().fromJSON(json, RestAuthUser.class);
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog(requestMsg, responseCode, "convert the format from java to pojo bean failed.", e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog(detailPara, responseCode, terminalIp, currUserName, "atic.restful.auth.modify");
            Response.ResponseBuilder builder = Response.status((int)responseCode);
            builder.entity((Object)responseMsg);
            return builder.build();
        }
        UserInfo userinfo = null;
        if (!AticUtil.isNull((String)username)) {
            User user = null;
            try {
                if (currUserName.equals("admin")) {
                    user = new User();
                    user.setUserName(username);
                    user.setUserPassword(restAuthUser.getPassword().trim());
                    userinfo = this.userMgr.getUserInfoByName(username);
                    if (userinfo != null) {
                        user.setUserID(userinfo.getId().longValue());
                        if (!RestAuthUtil.validatePassword(restAuthUser.getPassword().trim())) {
                            responseCode = 415;
                            RestUtil.processSysLog(requestMsg, responseCode, "password is not legal");
                            detailPara[2] = responseCode + "";
                            RestUtil.processOpeLog(detailPara, responseCode, terminalIp, username, "atic.restful.auth.modify");
                            responseBuilder = responseBuilder.status(responseCode);
                            return responseBuilder.build();
                        }
                        this.userMgr.modifyPassword(user);
                    }
                    responseCode = 400;
                    RestUtil.processSysLog(requestMsg, responseCode, "user is null. user's name is wrong.");
                    detailPara[2] = responseCode + "";
                    RestUtil.processOpeLog(detailPara, responseCode, terminalIp, username, "atic.restful.auth.modify");
                    responseBuilder = responseBuilder.status(responseCode);
                    return responseBuilder.build();
                }
                if (currUserName.equals(username)) {
                    user = new User();
                    user.setUserName(username);
                    user.setUserPassword(restAuthUser.getPassword().trim());
                    userinfo = this.userMgr.getUserInfoByName(username);
                    if (userinfo != null) {
                        user.setUserID(userinfo.getId().longValue());
                        if (!RestAuthUtil.validatePassword(restAuthUser.getPassword().trim())) {
                            responseCode = 415;
                            RestUtil.processSysLog(requestMsg, responseCode, "password is not legal");
                            detailPara[2] = responseCode + "";
                            RestUtil.processOpeLog(detailPara, responseCode, terminalIp, username, "atic.restful.auth.modify");
                            responseBuilder = responseBuilder.status(responseCode);
                            return responseBuilder.build();
                        }
                        this.userMgr.modifyPassword(user);
                    }
                    responseCode = 400;
                    RestUtil.processSysLog(requestMsg, responseCode, "user is null. user's name is wrong.");
                    detailPara[2] = responseCode + "";
                    RestUtil.processOpeLog(detailPara, responseCode, terminalIp, username, "atic.restful.auth.modify");
                    responseBuilder = responseBuilder.status(responseCode);
                    return responseBuilder.build();
                }
                responseCode = 405;
                RestUtil.processSysLog(requestMsg, responseCode, "Non admin users can not modify other user information");
                detailPara[2] = responseCode + "";
                RestUtil.processOpeLog(detailPara, responseCode, terminalIp, username, "atic.restful.auth.modify");
                responseBuilder = responseBuilder.status(responseCode);
                return responseBuilder.build();
            }
            catch (Exception e) {
                responseMsg = "ATIC inner error occurred while modify password.";
                responseCode = 500;
                RestUtil.processSysLog(requestMsg, responseCode, responseMsg, e);
                detailPara[2] = responseCode + "," + responseMsg;
                RestUtil.processOpeLog(detailPara, responseCode, terminalIp, username, "atic.restful.auth.modify");
                Response.ResponseBuilder builder = Response.status((int)responseCode);
                builder.entity((Object)responseMsg);
                return builder.build();
            }
        } else {
            responseCode = 404;
            RestUtil.processSysLog(requestMsg, responseCode, "user is null.");
            detailPara[2] = responseCode + "";
            RestUtil.processOpeLog(detailPara, responseCode, terminalIp, username, "atic.restful.auth.modify");
            responseBuilder = responseBuilder.status(responseCode);
            return responseBuilder.build();
        }
        responseCode = 200;
        RestUtil.processSysLog(requestMsg, responseCode, "modifyPassword succeed.");
        detailPara[2] = responseCode + "";
        RestUtil.processOpeLog(detailPara, responseCode, terminalIp, username, "atic.restful.auth.modify");
        responseBuilder = responseBuilder.status(responseCode);
        return responseBuilder.build();
    }

    public boolean checkParames(String username, String password) {
        String reg = "^[\\w-.@]*$";
        return username.length() <= 64 && password.length() <= 64 && username.matches(reg) && AticUtil.validateSpecialStr((String)username) && AticUtil.validatePwd((String)password);
    }

    private void checkJson(String json) {
        if (null != json && json.trim().length() > 5000) {
            throw new IllegalArgumentException("the parameters of json is more than 5000.");
        }
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }
}

