/*
 * Decompiled with CFR 0.152.
 */
package com.restful.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.UserSecPolicy;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AESUtil;
import com.restful.model.RestAuthInfo;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class RestAuthUtil {
    private static Map<String, RestAuthInfo> restAuths;
    private static Log logger;

    private RestAuthUtil() {
    }

    public static String getRequestURL(HttpServletRequest request, String url) {
        String path = "/rest/openapi/" + url;
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        return basePath;
    }

    public static String isLegalToken(HttpServletRequest request, String url) {
        if (null == request) {
            logger.error((Object)"isLegalToken: request is null");
            return null;
        }
        String restUrl = "restful request url : " + RestAuthUtil.getRequestURL(request, url) + ". ";
        if (null == request.getHeader("X-Auth-Token")) {
            logger.error((Object)("isLegalToken: request.getHeader(RestConstants.X_AUTH_TOKEN) is null. " + restUrl));
            return null;
        }
        StringBuffer token = new StringBuffer(request.getHeader("X-Auth-Token"));
        String clientIp = request.getRemoteAddr();
        if (null == restAuths || restAuths.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<String, RestAuthInfo>> iterator = restAuths.entrySet().iterator();
        IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().getService("userMgr", IUserMgr.class);
        long tokenLegalTime = userMgr.getSessionEffectiveTime();
        while (iterator.hasNext()) {
            Map.Entry<String, RestAuthInfo> entry = iterator.next();
            long authTime = entry.getValue().getAuthTime();
            if (!entry.getKey().contains(clientIp) || !token.toString().trim().equals(entry.getValue().getToken().toString()) || tokenLegalTime <= System.currentTimeMillis() - authTime) continue;
            entry.getValue().setAuthTime(System.currentTimeMillis());
            return entry.getValue().getUsername();
        }
        return null;
    }

    public static boolean validatePassword(String password) throws UnsupportedEncodingException {
        if (AticUtil.isNull((String)password)) {
            return false;
        }
        if (password.length() > 64) {
            return false;
        }
        IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().getService("userMgr", IUserMgr.class);
        UserSecPolicy usrPolicy = userMgr.getUserSecPolicy();
        if (password.length() < usrPolicy.getPswLenth()) {
            return false;
        }
        Pattern pattern = Pattern.compile("[^x00-xff]+");
        Matcher matcher = pattern.matcher(password);
        if (password.length() != password.getBytes("UTF-8").length && matcher.find()) {
            return false;
        }
        pattern = Pattern.compile("[a-zA-Z]+");
        matcher = pattern.matcher(password);
        boolean enFlag = matcher.find();
        pattern = Pattern.compile("[0-9]+");
        matcher = pattern.matcher(password);
        boolean numFlag = matcher.find();
        pattern = Pattern.compile("[=|\\-|_|`|~|!|@|#|$|%|\\*|\\(|\\^|\\)|\\|||:|;|\\,|\\.|\\\"|\\'|\\+|\\}|\\{|&]+");
        matcher = pattern.matcher(password);
        boolean strFlag = matcher.find();
        if (!(!"2".equals(usrPolicy.getComplex()) || enFlag && numFlag)) {
            return false;
        }
        if ("3".equals(usrPolicy.getComplex()) && !strFlag) {
            return false;
        }
        return !"4".equals(usrPolicy.getComplex()) || enFlag && numFlag && strFlag;
    }

    public static String genRandomString() {
        byte[] bytes = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
        return AESUtil.parseByte2HexStr((byte[])bytes);
    }

    public static Map<String, RestAuthInfo> getRestAuths() {
        return restAuths;
    }

    public static void setRestAuths(Map<String, RestAuthInfo> restAuths) {
        RestAuthUtil.restAuths = restAuths;
    }

    public static synchronized void removeTimeoutToken(List<String> toDel) {
        if (null != restAuths && !restAuths.isEmpty() && !toDel.isEmpty()) {
            for (String toDelToken : toDel) {
                restAuths.remove(toDelToken);
            }
        }
    }

    static {
        logger = LogFactory.getInstance((Module)Module.ATIC_CBB_USER);
    }
}

