/*
 * Decompiled with CFR 0.152.
 */
package com.restful.util;

import com.hs.atic.analysis.util.SysOptLogAnalysisUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;

public final class RestUtil {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REST);
    private static RestUtil instance;
    private static ReentrantLock lock;

    private RestUtil() {
    }

    public static RestUtil getInstance() {
        lock.lock();
        try {
            RestUtil restUtil = instance == null ? (RestUtil)RestUtil.class.newInstance() : instance;
            return restUtil;
        }
        catch (InstantiationException e) {
            RestUtil restUtil = null;
            return restUtil;
        }
        catch (IllegalAccessException e) {
            RestUtil restUtil = null;
            return restUtil;
        }
        finally {
            lock.unlock();
        }
    }

    public static void processSysLog(String requestMsg, int responseCode, String responseMsg, Exception e) {
        String sysDetail = RestUtil.processSysLogMsg(requestMsg, responseCode, responseMsg);
        LOGGER.error((Object)sysDetail, (Throwable)e);
    }

    public static void processSysLog(String requestMsg, int responseCode, String responseMsg) {
        String sysDetail = RestUtil.processSysLogMsg(requestMsg, responseCode, responseMsg);
        if (200 == responseCode || 201 == responseCode) {
            LOGGER.info((Object)sysDetail);
        } else {
            LOGGER.error((Object)sysDetail);
        }
    }

    private static String processSysLogMsg(String requestMsg, int responseCode, String responseMsg) {
        String sysDetail = "";
        if (!AticUtil.isNull((String)requestMsg)) {
            sysDetail = sysDetail + requestMsg + ". ";
        }
        sysDetail = sysDetail + "responseCode: " + responseCode + "; ";
        if (!AticUtil.isNull((String)responseMsg)) {
            sysDetail = sysDetail + "responseMsg: " + responseMsg;
        }
        return sysDetail;
    }

    public static void processOpeLogByTarget(String[] detailPara, int responseCode, String[] params, boolean targetLocal) {
        String terminalIp = params[0];
        String operator = params[1];
        String operation = params[2];
        String target = params[3];
        ISysOptLog sysOptLogMgr = SysOptLogAnalysisUtil.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("lego.dic.module.restful");
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTarget(target);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(targetLocal));
        if (200 == responseCode || 201 == responseCode) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("atic.restful.success");
            sysOptLogLego.setDetailPara(detailPara);
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail("atic.restful.failed");
            sysOptLogLego.setDetailPara(detailPara);
        }
        if (AticUtil.isNull((String)terminalIp)) {
            terminalIp = "127.0.0.1";
        }
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    public static void processOpeLog(String[] detailPara, int responseCode, String terminalIp, String operator, String operation) {
        String[] params = new String[]{terminalIp, operator, operation, ""};
        RestUtil.processOpeLogByTarget(detailPara, responseCode, params, false);
    }

    static {
        lock = new ReentrantLock();
    }
}

