/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.homepage.action;

import com.hs.atic.analysis.util.AnalysisUtil;
import com.hs.atic.analysis.util.DataSourceStub;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.homepage.form.HomePageEntityForm;
import com.hs.atic.homepage.form.HomePagePortalForm;
import com.hs.atic.homepage.vo.HomePageView;
import com.hs.atic.homepage.vo.VSMPlot;
import com.hs.atic.sdk.analysis.form.AttackLogForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.homepage.model.DevTrafficObj;
import com.hs.atic.sdk.homepage.model.FlowTopNForm;
import com.hs.atic.sdk.homepage.model.IfMemoryDataKey;
import com.hs.atic.sdk.homepage.model.SecReportDataKey;
import com.hs.atic.sdk.homepage.model.SecReportTrafficObject;
import com.hs.atic.sdk.homepage.model.ZoneCompareMemoryDataKey;
import com.hs.atic.sdk.homepage.model.ZoneCompareTrafficObj;
import com.hs.atic.sdk.homepage.service.IDevIfTrafficService;
import com.hs.atic.sdk.homepage.service.IHomePageService;
import com.hs.atic.sdk.homepage.service.IZoneCompareTrafficService;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultQueryCondition;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.Interface;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CommonUtil;
import com.huawei.secsyslog.IpTransformer;
import com.opensymphony.xwork2.ActionContext;
import com.security.logserver.module.condition.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class HomepageAction
extends BaseAction {
    private static List<String> color = new ArrayList<String>();
    private static final long serialVersionUID = -524748711607597122L;
    private static final String ANTIDDOS_8000 = "AntiDDoS8000";
    private static final String ANTIDDOS_1600 = "AntiDDoS1600";
    private static final String PARA_ONE = "-1";
    private static final String PARA_TWO = "-2";
    private static final Object LOCK = new Object();
    private static int interval = 10000;
    private static int interval4ZoneCom = 70000;
    private static int faultNum = 10;
    private static int alarmDdosValue = 6;
    private static int alarmOtherValue = -1;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DASHBOARD);
    private static double defaultCpu = 15.0;
    private static double singleCpuOf8000;
    private static double singleCpuOf1600;
    private static Properties config;
    List<AticDevice> firewallList;
    List<AticDevice> antiDDoSDeviceList;
    private Boolean isSnap = false;
    private String image;
    private transient List<VSMPlot> vsmPlotList;
    private String requestType;
    private List<HomePagePortalForm> listHomePagePortal;
    private transient List<HomePageView> homePageList;
    private String currentPassCode;
    private String passcode;
    private int flowType4Interval;
    private int portalNum;
    private Long zoneId;
    private String defDeviceName;
    private String defDeviceId;
    private List<LangPair> ifDeviceList;
    private String defDevName4DevMonitor;
    private String defDevId4DevMonitor;
    private Long devId4DevMonitor;
    private List<LangPair> devList4DevMonitor;
    private List<LangPair> ddosList4SecReport;
    private String devId4SecReport;
    private List<LangPair> topnDeviceList;
    private String allQueryDisplay;
    private Long deviceId;
    private List<LangPair> ifList;
    private int pageMaxNum = 25;
    private int topNValue = 10;
    private int flowTypeValue;
    private int directionValue;
    private int alarmType;
    private Long alarmZoneId;
    private int severity;
    private int ifIndex;
    private String ifName;
    private int flowUnitValue;
    private String zoneDeviceId;
    private String zoneIp;
    private String secReportIp;
    private int topnTypeValue;
    private String topnDeviceId;
    private Long topnZoneId;
    private int statisticTypeValue;
    private int inOrDropValue;
    private int newOrCurConnValue;
    private String statisticalDimensionType;
    private String statisticalDimensionTypeValue = "";
    private int protocolValue;
    private Long[] ids;
    private Integer[] flowTypes;
    private String[] ifNames;
    private String[] deviceIps;
    private Long[] zoneIds;
    private String[] portalIds;
    private Long homePageEntityId;
    private String sortField;
    private String sortType;
    private int refreshButtonState;
    private boolean isSupportOutbound;
    private String isSupportOutboundStr;
    private int statisticType4IpTopn;
    private int topnNum = 10;
    private IHomePageService homePageService;
    private IAticDeviceService aticDeviceService;
    private ILicenseOutboundService licenseOutboundService;
    private IZoneService zoneService;
    private ICollectorService collectorService;
    private ICollectorDeviceService collectorDeviceService;
    private IDevIfTrafficService devIfTrafficService;
    private DataSourceStub dataSourceStub;
    private IDivertTacticsService divertTacticsService;
    private IFilterService filterService;
    private INpFilterService npFilterService;

    public String showHomePage() {
        User currentUser = null;
        try {
            currentUser = (User)this.getSession().getAttribute("currentUser");
            boolean hasAttackReport = false;
            List<HomePageEntityForm> attackReport = this.homePageService.getHomePageEntityByFlowType(6);
            if (null != attackReport && !attackReport.isEmpty()) {
                for (HomePageEntityForm homePageEntityForm : attackReport) {
                    if (homePageEntityForm.getUserId().longValue() != currentUser.getUserID()) continue;
                    hasAttackReport = true;
                    homePageEntityForm.setIsAbnormalConditionMonitoring("true");
                    break;
                }
            }
            if (!hasAttackReport) {
                HomePageEntityForm form = new HomePageEntityForm();
                form.setFlowType(6);
                form.setUserId(currentUser.getUserID());
                form.setIsAbnormalConditionMonitoring("true");
                form.setTopnNum(this.topnNum);
                this.homePageService.saveHomePageEntity(form);
            }
        }
        catch (Exception e) {
            logger.error((Object)"add attack homepage error:", (Throwable)e);
        }
        this.listHomePagePortal = this.homePageService.getAllPortal(this.createQueryMap());
        for (HomePagePortalForm form : this.listHomePagePortal) {
            HomePageEntityForm entityForm = this.homePageService.findById(form.getHomePageEntityId(), this.createQueryMap());
            if (null == entityForm) {
                logger.error((Object)("HomePageEntityForm is null, HomePagePortalForm id = " + form.getHomePageEntityId()));
                continue;
            }
            String parameter = this.getHomePagePara(entityForm, "portal");
            if (entityForm.getFlowType() == 6) {
                form.setIsAbnormalConditionMonitoring("true");
            }
            form.setTitle(parameter);
            int topnType = null == entityForm.getTopnType() ? 0 : entityForm.getTopnType();
            this.statisticType4IpTopn = 1;
            if (null != entityForm.getStatisticType() && entityForm.getStatisticType() > 0) {
                this.statisticType4IpTopn = entityForm.getStatisticType();
            }
            this.topnNum = entityForm.getTopnNum() != null ? entityForm.getTopnNum() : this.topNValue;
            form.setUrl("showHomePageReport.do?homePageEntityId=" + form.getHomePageEntityId() + "&flowType4Interval=" + entityForm.getFlowType() + "&portalNum=" + this.listHomePagePortal.size() + "&topnTypeValue=" + topnType + "&statisticType4IpTopn=" + this.statisticType4IpTopn + "&topnNum=" + this.topnNum + "&refreshButtonState=" + this.refreshButtonState);
        }
        return "success";
    }

    private String getHomePageContent(HomePageEntityForm entityForm) {
        String homePageContent = "";
        if (null == entityForm) {
            return homePageContent;
        }
        if (1 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.interface");
        } else if (2 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.zoneFlowCompare");
        } else if (3 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.alarmDis");
        } else if (4 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.zoneFlowDis");
        } else if (5 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.flowTopn");
        } else if (6 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.attack");
        } else if (7 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.deviceMonitor");
        } else if (8 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.ipFlowSecReport");
        }
        return homePageContent;
    }

    private String getHomePageContent4OperaLog(HomePageEntityForm entityForm) {
        String homePageContent = "";
        if (null == entityForm) {
            return homePageContent;
        }
        if (1 == entityForm.getFlowType()) {
            homePageContent = entityForm.getIfName() + "(" + entityForm.getDeviceIp() + ")";
        } else if (2 == entityForm.getFlowType()) {
            homePageContent = this.processZoneName(entityForm);
        } else if (3 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.alarmDis");
        } else if (7 == entityForm.getFlowType()) {
            homePageContent = this.getText("atic.homepage.common.flowType.deviceMonitor");
        }
        return homePageContent;
    }

    private String getHomePagePara(HomePageEntityForm homePageEntityForm, String type) {
        String parameter = "";
        if (null == homePageEntityForm) {
            return parameter;
        }
        if (1 == homePageEntityForm.getFlowType()) {
            parameter = this.processParameter4InterfaceCompare(homePageEntityForm, parameter);
        } else if (2 == homePageEntityForm.getFlowType()) {
            parameter = this.processParameter4ZoneCompare(homePageEntityForm, parameter, type);
        } else if (3 == homePageEntityForm.getFlowType()) {
            parameter = this.processParameter4AlarmMonitor(homePageEntityForm, parameter, type);
        } else if (4 == homePageEntityForm.getFlowType()) {
            parameter = this.processParameter4ZoneCompare(homePageEntityForm, parameter, type);
        } else if (5 == homePageEntityForm.getFlowType()) {
            parameter = this.processParameter4ZoneCompare(homePageEntityForm, parameter, type);
        } else if (6 == homePageEntityForm.getFlowType()) {
            parameter = this.getText("atic.homepage.common.flowType.attack") + "; ";
        } else if (7 == homePageEntityForm.getFlowType()) {
            parameter = this.processParameter4DeviceMonitor(homePageEntityForm, parameter);
        } else if (8 == homePageEntityForm.getFlowType()) {
            parameter = this.processParameter4SecReport(homePageEntityForm, parameter);
        }
        if (type.equalsIgnoreCase("list") && null != homePageEntityForm.getFlowUnit() && 3 != homePageEntityForm.getFlowType()) {
            String unit = this.getUnitStr(homePageEntityForm.getFlowUnit());
            parameter = parameter + this.getText("atic.analysis.common.unit") + unit + "; ";
        }
        if (2 == homePageEntityForm.getFlowType() && null != homePageEntityForm.getProtocol()) {
            parameter = parameter + this.getText("atic.bis.datastat.flowcompare.label.protocol") + this.getText("atic.public.punctuation.colon") + this.getProtocolStr(homePageEntityForm.getProtocol(), false) + "; ";
        }
        if (AticUtil.isNull((String)(parameter = parameter.trim()))) {
            return "";
        }
        return parameter.substring(0, parameter.length() - 1);
    }

    private String processParameter4AlarmMonitor(HomePageEntityForm homePageEntityForm, String parameter, String type) {
        if (type.equalsIgnoreCase("list")) {
            if (null != homePageEntityForm.getDeviceType()) {
                String alarmTypeStr = this.getAlarmTypeStr(homePageEntityForm.getDeviceType());
                parameter = parameter + this.getText("atic.homepage.common.alarmType") + this.getText("atic.public.punctuation.colon") + " " + alarmTypeStr + "; ";
            }
            if (1 == homePageEntityForm.getDeviceType() && null != homePageEntityForm.getZoneId()) {
                if (homePageEntityForm.getZoneId() > 0L) {
                    String zoneName = this.processZoneName(homePageEntityForm);
                    parameter = parameter + this.getText("atic.analysis.common.zone") + zoneName + "; ";
                } else if (0L == homePageEntityForm.getZoneId()) {
                    parameter = parameter + this.getText("atic.analysis.common.zone") + this.getText("atic.analysis.common.all") + "; ";
                }
            }
            if (null != homePageEntityForm.getFlowUnit()) {
                String severityStr = this.getAlarmSeverity(homePageEntityForm.getFlowUnit());
                parameter = parameter + this.getText("atic.homepage.common.severity") + this.getText("atic.public.punctuation.colon") + severityStr + "; ";
            }
        } else if (null != homePageEntityForm.getDeviceType()) {
            if (1 == homePageEntityForm.getDeviceType()) {
                if (null != homePageEntityForm.getZoneId()) {
                    if (homePageEntityForm.getZoneId() > 0L) {
                        String zoneName = this.processZoneName(homePageEntityForm);
                        parameter = parameter + this.getText("atic.analysis.common.zone") + zoneName + "; ";
                    } else if (0L == homePageEntityForm.getZoneId()) {
                        parameter = parameter + this.getText("atic.analysis.common.zone") + this.getText("atic.analysis.common.all") + "; ";
                    }
                }
            } else {
                String alarmTypeStr = this.getAlarmTypeStr(homePageEntityForm.getDeviceType());
                parameter = parameter + this.getText("atic.homepage.common.alarmType") + this.getText("atic.public.punctuation.colon") + " " + alarmTypeStr + "; ";
            }
        }
        return parameter;
    }

    private String processParameter4InterfaceCompare(HomePageEntityForm homePageEntityForm, String parameter) {
        if (!AticUtil.isNull((String)homePageEntityForm.getDeviceIp())) {
            String deviceIpStr = this.processDeviceIpStr(homePageEntityForm);
            parameter = parameter + this.getText("atic.analysis.common.netdevice") + deviceIpStr + "; ";
        }
        if (!AticUtil.isNull((String)homePageEntityForm.getIfName())) {
            parameter = parameter + this.getText("atic.homepage.common.interface") + this.getText("atic.public.punctuation.colon") + " " + homePageEntityForm.getIfName() + "; ";
        }
        return parameter;
    }

    private String processParameter4ZoneCompare(HomePageEntityForm homePageEntityForm, String parameter, String type) {
        if (null != homePageEntityForm.getTopnType() && homePageEntityForm.getTopnType() > 0) {
            String topnTypeStr = this.getTopnTypeStr(homePageEntityForm.getTopnType());
            parameter = parameter + topnTypeStr + "; ";
        }
        if (!AticUtil.isNull((String)homePageEntityForm.getZoneIp())) {
            parameter = parameter + this.getText("atic.homepage.common.ip") + this.getText("atic.public.punctuation.colon") + IPUtil4Atic.compressIP((String)homePageEntityForm.getZoneIp()) + "; ";
        }
        if (null != homePageEntityForm.getZoneId() && homePageEntityForm.getZoneId() > 0L) {
            String zoneName = this.processZoneName(homePageEntityForm);
            parameter = parameter + this.getText("atic.analysis.common.zone") + zoneName + "; ";
        }
        if (!AticUtil.isNull((String)homePageEntityForm.getDeviceIp())) {
            String deviceIpStr = this.processDeviceIpStr(homePageEntityForm);
            parameter = parameter + this.getText("atic.analysis.common.netdevice") + deviceIpStr + "; ";
        }
        if (!AticUtil.isNull((String)String.valueOf(homePageEntityForm.getInOrDrop()))) {
            parameter = homePageEntityForm.getInOrDrop() == 1 ? parameter + this.getText("atic.homepage.common.in") + "; " : (homePageEntityForm.getInOrDrop() == 2 ? parameter + this.getText("atic.analysis.common.flux.attack") + "; " : parameter + this.getText("atic.homepage.common.out") + "; ");
        }
        if (null != homePageEntityForm.getTopnType() && homePageEntityForm.getTopnType() > 0 && type.equalsIgnoreCase("portal") && (homePageEntityForm.getFlowUnit() == 3 || homePageEntityForm.getFlowUnit() == 4)) {
            parameter = parameter + this.getUnitStr4Top10(homePageEntityForm.getFlowUnit()) + "; ";
        }
        parameter = parameter + this.processDirectionPara(homePageEntityForm);
        parameter = parameter + this.processTopnNum4IpTopN(homePageEntityForm);
        return parameter;
    }

    private String processTopnNum4IpTopN(HomePageEntityForm homePageEntityForm) {
        String parameter = "";
        if (5 == homePageEntityForm.getFlowType() && 2 == homePageEntityForm.getTopnType()) {
            parameter = "Top " + homePageEntityForm.getTopnNum() + "; ";
        }
        return parameter;
    }

    private String processDirectionPara(HomePageEntityForm homePageEntityForm) {
        String parameter = "";
        this.isSupportOutbound = this.licenseOutboundService.isSupportOutbound();
        if (this.isSupportOutbound && null != homePageEntityForm.getDirection() && homePageEntityForm.getDirection() > 0) {
            String directionStr = this.getDirectionStr(homePageEntityForm.getDirection());
            parameter = parameter + this.getText("atic.analysis.common.direction") + directionStr + "; ";
        }
        return parameter;
    }

    private String processParameter4DeviceMonitor(HomePageEntityForm homePageEntityForm, String parameter) {
        if (!AticUtil.isNull((String)homePageEntityForm.getDeviceIp())) {
            String deviceIpStr = this.processDeviceIpStr(homePageEntityForm);
            parameter = parameter + this.getText("atic.analysis.common.netdevice") + deviceIpStr + "; ";
        }
        return parameter;
    }

    private String processParameter4SecReport(HomePageEntityForm homePageEntityForm, String parameter) {
        if (!AticUtil.isNull((String)homePageEntityForm.getZoneIp())) {
            parameter = parameter + this.getText("atic.homepage.common.ip") + this.getText("atic.public.punctuation.colon") + IPUtil4Atic.compressIP((String)homePageEntityForm.getZoneIp()) + "; ";
        }
        if (!AticUtil.isNull((String)homePageEntityForm.getDeviceIp())) {
            String deviceIpStr = this.processDeviceIpStr(homePageEntityForm);
            parameter = parameter + this.getText("atic.analysis.common.netdevice") + deviceIpStr + "; ";
        }
        return parameter;
    }

    private String processZoneName(HomePageEntityForm homePageEntityForm) {
        if (null == homePageEntityForm.getZoneId() || 0L == homePageEntityForm.getZoneId()) {
            return this.getText("atic.analysis.common.all");
        }
        ZoneInfoForm zoneForm = this.zoneService.getById(homePageEntityForm.getZoneId());
        String zoneName = "";
        zoneName = null == zoneForm || "".equals(zoneForm.getZoneDesc()) ? this.getText("atic.analysis.common.unknownZone") + homePageEntityForm.getZoneId() : zoneForm.getZoneDesc();
        return zoneName;
    }

    private String processDeviceIpStr(HomePageEntityForm homePageEntityForm) {
        String deviceIp = homePageEntityForm.getDeviceIp();
        AticDevice secne = this.aticDeviceService.getDeviceByIp(deviceIp);
        if (null == secne) {
            return deviceIp;
        }
        deviceIp = secne.getName();
        if (2 == homePageEntityForm.getFlowType() || 4 == homePageEntityForm.getFlowType() || 5 == homePageEntityForm.getFlowType() || 8 == homePageEntityForm.getFlowType()) {
            if (0 == homePageEntityForm.getDeviceType()) {
                deviceIp = deviceIp + this.getText("atic.analysis.common.clean");
            }
            if (1 == homePageEntityForm.getDeviceType()) {
                deviceIp = deviceIp + this.getText("atic.analysis.common.detect");
            }
        }
        return deviceIp;
    }

    private String processDeviceIpStr4OpraLog(HomePageEntityForm homePageEntityForm) {
        String deviceIp = homePageEntityForm.getDeviceIp();
        if (StringUtils.isNotBlank((CharSequence)deviceIp)) {
            return deviceIp;
        }
        return "--";
    }

    public String listHomePageConfig() {
        this.homePageList = new ArrayList<HomePageView>();
        if (this.getStart() < 0 || this.getPageSize() < 0) {
            logger.error((Object)"pageQuery is error!");
            throw new LegoCheckedException(570505L);
        }
        Paging page = this.homePageService.getAllHomePageEntity(this.createQueryMap(), this.getStart(), this.getPageSize());
        if (null == page) {
            return "success";
        }
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.setTotal(page.getCount());
        List homePage = page.getData();
        if (null == homePage || homePage.isEmpty()) {
            return "success";
        }
        for (HomePageEntityForm homePageEntityForm : homePage) {
            HomePageView temp = new HomePageView();
            String homePageContent = this.getHomePageContent(homePageEntityForm);
            String parameter = this.getHomePagePara(homePageEntityForm, "list");
            temp.setId(homePageEntityForm.getId());
            temp.setFlowType(homePageEntityForm.getFlowType());
            temp.setDeviceIp(homePageEntityForm.getDeviceIp());
            temp.setIfName(homePageEntityForm.getIfName());
            temp.setZoneId(homePageEntityForm.getZoneId());
            temp.setHomePageContent(homePageContent);
            temp.setParameter(parameter);
            this.homePageList.add(temp);
        }
        return "success";
    }

    public void setPageSize(int pageSize) {
        this.getSession().setAttribute("pageSize", (Object)pageSize);
    }

    public int getPageSize() {
        return null == this.fetchRequest().getParameter("pageSize") ? this.pageSize : (Integer)this.getSession().getAttribute("pageSize");
    }

    private Map<String, String> createQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        queryMap.put("isAdmin", String.valueOf(isAdmin));
        queryMap.put("userId", String.valueOf(currentUser.getUserID()));
        return queryMap;
    }

    public void getDeviceList() {
        this.processGetFirewallList();
        this.processInterfaceDeviceJson();
        this.processTopnDeviceJson(true);
    }

    public void getDDoSDeviceList() {
        this.processDDoSDeviceList();
        this.processDDosDeviceJson();
        this.processDDosDeviceJson4SecReport();
    }

    private void processDDosDeviceJson4SecReport() {
        if (null == this.antiDDoSDeviceList) {
            this.antiDDoSDeviceList = new ArrayList<AticDevice>();
        }
        this.ddosList4SecReport = this.processJson4SecReport();
    }

    private List<LangPair> processJson4SecReport() {
        ArrayList<LangPair> json4SecReport = new ArrayList<LangPair>();
        for (int i = 0; i < this.antiDDoSDeviceList.size(); ++i) {
            AticDevice ddosDevice = this.antiDDoSDeviceList.get(i);
            if (null == ddosDevice) continue;
            String moId = String.valueOf(ddosDevice.getMoId());
            String deviceName = ddosDevice.getName();
            int deviceType = ddosDevice.getDdosType();
            if (0 == deviceType) {
                deviceName = deviceName + this.getText("atic.analysis.common.clean");
                moId = moId + "_0";
            } else if (1 == deviceType) {
                deviceName = deviceName + this.getText("atic.analysis.common.detect");
                moId = moId + "_1";
            } else if (2 == deviceType) {
                String deviceNameClean = deviceName + this.getText("atic.analysis.common.clean");
                String moIdClean = moId + "_" + 0;
                json4SecReport.add(new LangPair(moIdClean, deviceNameClean));
                deviceName = deviceName + this.getText("atic.analysis.common.detect");
                moId = moId + "_1";
            }
            json4SecReport.add(new LangPair(moId, deviceName));
        }
        return json4SecReport;
    }

    private void processDDoSDeviceList() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        ArrayList ddosDevicesList = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
        if (null == this.antiDDoSDeviceList) {
            this.antiDDoSDeviceList = new ArrayList<AticDevice>();
        }
        if (null == ddosDevicesList) {
            ddosDevicesList = new ArrayList();
        }
        for (AticDevice temp : ddosDevicesList) {
            if (3 == temp.getDeviceType()) continue;
            this.antiDDoSDeviceList.add(temp);
        }
    }

    private void processDDosDeviceJson() {
        if (null != this.antiDDoSDeviceList && !this.antiDDoSDeviceList.isEmpty()) {
            AticDevice fw = this.antiDDoSDeviceList.get(0);
            if (null != fw) {
                this.defDevId4DevMonitor = String.valueOf(fw.getMoId());
                this.defDevName4DevMonitor = fw.getName();
                this.devId4DevMonitor = fw.getMoId();
            }
            this.devList4DevMonitor = this.processDDListToJson();
        }
    }

    private List<LangPair> processDDListToJson() {
        ArrayList<LangPair> ddosDevListJson = new ArrayList<LangPair>();
        for (int i = 0; i < this.antiDDoSDeviceList.size(); ++i) {
            AticDevice ddosDevice = this.antiDDoSDeviceList.get(i);
            if (null == ddosDevice) continue;
            ddosDevListJson.add(new LangPair(String.valueOf(ddosDevice.getMoId()), ddosDevice.getName()));
        }
        return ddosDevListJson;
    }

    private void processInterfaceDeviceJson() {
        if (null != this.firewallList && !this.firewallList.isEmpty()) {
            AticDevice fw = this.firewallList.get(0);
            if (null != fw) {
                this.defDeviceId = String.valueOf(fw.getMoId());
                this.defDeviceName = fw.getName();
                this.deviceId = fw.getMoId();
            }
            this.ifDeviceList = this.processFirewallListToJson();
        }
    }

    private String processTopnDeviceJson(boolean needNfa) {
        this.topnDeviceList = new ArrayList<LangPair>();
        String returnStringJsonString = "";
        List listDevice = null;
        listDevice = needNfa ? this.dataSourceStub.getDeviceListAndNFA() : this.dataSourceStub.getDeviceList();
        StringBuffer lds = new StringBuffer();
        lds.append('[');
        LangPair deviceItem = null;
        for (Pair device : listDevice) {
            String devId = (String)device.getKey();
            String devName = (String)device.getValue();
            lds.append("['").append(devId).append("','").append(devName).append("'],");
            deviceItem = new LangPair(devId, devName);
            this.topnDeviceList.add(deviceItem);
        }
        lds.deleteCharAt(lds.length() - 1);
        lds.append(']');
        returnStringJsonString = new String(lds);
        return returnStringJsonString;
    }

    private List<LangPair> processFirewallListToJson() {
        ArrayList<LangPair> ifDeviceLists = new ArrayList<LangPair>();
        for (int i = 0; i < this.firewallList.size(); ++i) {
            AticDevice firewall = this.firewallList.get(i);
            if (null == firewall) continue;
            ifDeviceLists.add(new LangPair(String.valueOf(firewall.getMoId()), firewall.getName()));
        }
        return ifDeviceLists;
    }

    private void processGetFirewallList() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        ArrayList devicesList = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
        if (null == this.firewallList) {
            this.firewallList = new ArrayList<AticDevice>();
        }
        if (null == devicesList) {
            devicesList = new ArrayList();
        }
        for (AticDevice temp : devicesList) {
            if (temp.getDeviceType() == 3) continue;
            this.firewallList.add(temp);
        }
        List nfaList = this.aticDeviceService.getNFA2000VDevicePrivilege(currentUser.getUserID());
        if (null != nfaList && !nfaList.isEmpty()) {
            this.firewallList.addAll(nfaList);
        }
    }

    public void getDeviceInterfaceList() {
        this.getInterfaceListJson();
    }

    public void checkHomePageEntityNum() {
        Paging page = this.homePageService.getAllHomePageEntity(this.createQueryMap(), this.getStart(), this.getPageSize());
        if (page.getCount() >= this.pageMaxNum) {
            this.responseResult("false");
        } else {
            this.responseResult("true");
        }
    }

    public String addHomePageEntityInit() {
        this.isSupportOutbound = this.licenseOutboundService.isSupportOutbound();
        this.getSession().setAttribute("isSupportOutbound", (Object)this.isSupportOutbound);
        this.getDeviceList();
        this.getDDoSDeviceList();
        this.getDeviceInterfaceList();
        return "success";
    }

    public void addHomePageEntity() {
        this.isSupportOutbound = this.licenseOutboundService.isSupportOutbound();
        if (!this.isSupportOutbound && this.directionValue != 1) {
            logger.error((Object)"direction is not support outbound");
            throw new LegoCheckedException(570505L);
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        HomePageEntityForm form = new HomePageEntityForm();
        if (this.flowTypeValue == 5 && this.topnTypeValue == 3) {
            form.setStatisticalDimensionType(this.statisticalDimensionTypeValue);
        }
        form.setFlowType(this.flowTypeValue);
        form.setUserId(currentUser.getUserID());
        form.setTopnNum(this.topnNum);
        String deviceIpStr = this.processDeviceIpStr4OpraLog(form);
        String homePageType = this.getHomePageContent4OperaLog(form);
        String unit = "(kbps)";
        String[] detailPara = new String[]{deviceIpStr, "--", unit};
        if (1 == this.flowTypeValue) {
            if (1 != this.directionValue) {
                logger.error((Object)("directionValue is not 1, directionValue=" + this.directionValue));
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", detailPara);
                throw new LegoCheckedException(570505L);
            }
            this.processDataForm4InterfaceCompare(form, this.aticDeviceService);
        } else if (2 == this.flowTypeValue) {
            this.processDataForm4ZoneCompare(form, this.aticDeviceService, this.flowTypeValue);
        } else if (3 == this.flowTypeValue) {
            if (1 != this.directionValue) {
                logger.error((Object)("directionValue is not inbound, directionValue=" + this.directionValue));
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", detailPara);
                throw new LegoCheckedException(570505L);
            }
            this.processDataForm4Alarm(form);
        } else if (4 == this.flowTypeValue) {
            if (3 == this.directionValue) {
                logger.error((Object)("directionValue is not inbound or outbound, directionValue=" + this.directionValue));
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", detailPara);
                throw new LegoCheckedException(570505L);
            }
            this.processDataForm4ZoneCompare(form, this.aticDeviceService, this.flowTypeValue);
        } else if (5 == this.flowTypeValue) {
            if (3 == this.directionValue) {
                logger.error((Object)("directionValue is not inbound or outbound, directionValue=" + this.directionValue));
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", detailPara);
                throw new LegoCheckedException(570505L);
            }
            if (2 == this.directionValue && 3 == this.topnTypeValue) {
                logger.error((Object)"topnTypeValue is locationTopN when directionValue is outbound");
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", detailPara);
                throw new LegoCheckedException(570505L);
            }
            this.processDataForm4ZoneCompare(form, this.aticDeviceService, this.flowTypeValue);
        } else if (7 == this.flowTypeValue) {
            if (1 != this.directionValue) {
                String[] para = new String[]{this.processDeviceIpStr4OpraLog(form)};
                logger.error((Object)("directionValue is not inbound, directionValue=" + this.directionValue));
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", para);
                throw new LegoCheckedException(570505L);
            }
            this.processDataForm4DeviceMonitor(form, this.aticDeviceService, this.flowTypeValue);
        } else if (8 == this.flowTypeValue) {
            if (1 != this.directionValue) {
                String[] para = new String[]{this.processDeviceIpStr4OpraLog(form), form.getZoneIp(), form.getFlowUnit().toString()};
                logger.error((Object)("directionValue is not inbound, directionValue=" + this.directionValue));
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIpFlowSecReport.failed", para);
                throw new LegoCheckedException(570505L);
            }
            if (this.getNum(this.homePageService, 8) >= 1000) {
                logger.error((Object)"the num for ip flow second report is too much");
                throw new LegoCheckedException(571708L);
            }
            this.processDataForm4IPFlowSecReport(form, this.aticDeviceService, this.flowTypeValue);
        } else {
            logger.error((Object)("flowTypeValue is not in 1 to 8, flowTypeValue=" + this.flowTypeValue));
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", detailPara);
            throw new LegoCheckedException(570505L);
        }
        Paging page = this.homePageService.getAllHomePageEntity(this.createQueryMap(), this.getStart(), this.getPageSize());
        Long homePageEntityIdLong = null;
        unit = form.getFlowUnit() != null && this.flowUnitValue == 1 ? "(kbps)" : "(pps)";
        deviceIpStr = this.processDeviceIpStr4OpraLog(form);
        homePageType = this.getHomePageContent4OperaLog(form);
        unit = "(kbps)";
        String[] newdetailPara = new String[]{deviceIpStr, "--", unit};
        if (this.homePageService.isExists(form)) {
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", newdetailPara);
            throw new LegoCheckedException(571702L);
        }
        if (page.getCount() >= this.pageMaxNum) {
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", newdetailPara);
            throw new LegoCheckedException(571704L);
        }
        if (8 == this.flowTypeValue) {
            this.deployCmd(form, this.aticDeviceService);
        }
        if ((homePageEntityIdLong = this.homePageService.saveHomePageEntity(form)) <= 0L) {
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary.failed", newdetailPara);
            throw new LegoCheckedException(571805L);
        }
        this.responseResult("success");
    }

    private int getNum(IHomePageService iHomePageService, int flowType) {
        int num = 0;
        try {
            num = iHomePageService.getNum(flowType);
        }
        catch (Exception e) {
            logger.error((Object)("get num for flowType " + flowType + " failed"));
        }
        return num;
    }

    private void processDataForm4DeviceMonitor(HomePageEntityForm form, IAticDeviceService deviceService, int flowTypeValue2) {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.devId4DevMonitor);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice aticDevice = deviceService.getDeviceByMoid(this.devId4DevMonitor.longValue());
        if (null == aticDevice) {
            throw new LegoCheckedException(201L);
        }
        form.setDeviceIp(deviceService.getDeviceByMoid(this.devId4DevMonitor.longValue()).getIpAddress());
        form.setIfIndex(-1);
        form.setIfName("All");
        form.setFlowUnit(2);
        form.setDirection(this.directionValue);
        String deviceIpStr = this.processDeviceIpStr4OpraLog(form);
        String homePageType = this.getHomePageContent4OperaLog(form);
        String unit = "(pps)";
        String[] detailPara = new String[]{deviceIpStr, unit};
        this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addDeviceMonitor", detailPara);
        if (null == this.devId4DevMonitor || this.devId4DevMonitor < 1L) {
            throw new LegoCheckedException(570505L);
        }
        ArrayList<String> ifNameList = new ArrayList<String>();
        ifNameList.add("All");
        List interfaceList = deviceService.getIfNeedMonitor(this.devId4DevMonitor.longValue());
        if (null != interfaceList) {
            for (Interface item : interfaceList) {
                ifNameList.add(item.getIfDescr());
            }
        }
        if (!ifNameList.contains(this.ifName)) {
            throw new LegoCheckedException(570505L);
        }
    }

    private void processDataForm4IPFlowSecReport(HomePageEntityForm form, IAticDeviceService deviceService, int flowTypeValueInt) {
        Long deviceIdLong;
        String deviceIp = "";
        int deviceType = 0;
        if (this.devId4SecReport.contains("_")) {
            deviceIdLong = Long.parseLong(this.devId4SecReport.split("_")[0]);
            deviceType = Integer.parseInt(this.devId4SecReport.split("_")[1]);
            deviceIp = deviceService.getDeviceByMoid(deviceIdLong.longValue()).getIpAddress();
        } else {
            deviceIdLong = Long.parseLong(this.devId4SecReport);
            AticDevice firewall = deviceService.getDeviceByMoid(deviceIdLong.longValue());
            deviceType = AnalysisUtil.getDeviceDdos(firewall);
            deviceIp = deviceService.getDeviceByMoid(deviceIdLong.longValue()).getIpAddress();
        }
        form.setDeviceIp(deviceIp);
        form.setDeviceType(deviceType);
        form.setZoneIp(this.secReportIp);
        form.setFlowUnit(this.flowUnitValue);
        form.setDirection(this.directionValue);
        String homePageType = this.getHomePageContent4OperaLog(form);
        String deviceIpStr = this.processDeviceIpStr4OpraLog(form);
        String unit = this.getUnitStr(this.flowUnitValue);
        String[] detailPara = new String[]{deviceIpStr, form.getZoneIp(), unit};
        this.checkDevice4Security(deviceIdLong);
        this.checkSelectIp(homePageType, form.getZoneIp(), detailPara);
    }

    private void deployCmd(HomePageEntityForm form, IAticDeviceService deviceService) {
        String[] detailPara = new String[]{this.processDeviceIpStr4OpraLog(form), form.getZoneIp(), form.getFlowUnit().toString()};
        String homePageType = this.getHomePageContent4OperaLog(form);
        String cmd = null;
        String ip = form.getZoneIp();
        if (IPUtil.isIpv4((String)ip)) {
            cmd = "anti-ddos real-time-statistics ip " + ip;
        } else if (IPUtil.isIpv6((String)ip)) {
            cmd = "anti-ddos real-time-statistics ipv6 " + ip;
        }
        AticDevice device = deviceService.getDeviceByIp(form.getDeviceIp());
        int result = 0;
        if (null != cmd) {
            result = this.homePageService.deployCmd(device, cmd);
        }
        if (result == 1) {
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIpFlowSecReport.failed", detailPara);
            logger.error((Object)("failed to deploy command " + cmd + " on device " + device.getName() + ", telnet connection error."));
            throw new LegoCheckedException(660010L);
        }
        if (result == 2) {
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIpFlowSecReport.failed", detailPara);
            logger.error((Object)("failed to deploy command " + cmd + " on device " + device.getName() + ", command deploy error."));
            throw new LegoCheckedException(571806L);
        }
        if (result == 3) {
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIpFlowSecReport.failed", detailPara);
            logger.error((Object)("failed to deploy command " + cmd + " on device " + device.getName() + ", The IP number configured has reached the upper limit."));
            throw new LegoCheckedException(571816L);
        }
        logger.info((Object)("successful to deploy command " + cmd + " on device " + device.getName()));
    }

    private void processDataForm4Alarm(HomePageEntityForm form) {
        form.setDeviceType(this.alarmType);
        if (null == this.alarmZoneId) {
            this.alarmZoneId = 0L;
        }
        ArrayList<Long> moIdList = new ArrayList<Long>();
        if (this.alarmZoneId > 0L) {
            Long moId = 0L;
            ZoneInfoForm zoneInfoForm = this.zoneService.getById(this.zoneId);
            if (null != zoneInfoForm) {
                moId = zoneInfoForm.getMoId();
            }
            moIdList.add(moId);
        }
        BisUtil.checkUserSecurity(moIdList);
        form.setZoneId(this.alarmZoneId);
        form.setFlowUnit(this.severity);
        String homePageType = this.getHomePageContent4OperaLog(form);
        String alarmTypeStr = this.getAlarmTypeStr(this.alarmType);
        String zoneName = this.processZoneName(form);
        String severityStr = this.getAlarmSeverity(this.severity);
        String[] detailPara = new String[]{alarmTypeStr, zoneName, severityStr};
        this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addAlarmSummary", detailPara);
    }

    private String getAlarmSeverity(int severityInt) {
        String returnStr = "";
        switch (severityInt) {
            case 1: {
                returnStr = this.getText("lego.fault.severity.warning");
                break;
            }
            case 2: {
                returnStr = this.getText("lego.fault.severity.minor");
                break;
            }
            case 3: {
                returnStr = this.getText("lego.fault.severity.major");
                break;
            }
            case 4: {
                returnStr = this.getText("lego.fault.severity.critical");
                break;
            }
            default: {
                logger.error((Object)"alarm severity is not in 1 to 4");
                throw new LegoCheckedException(570505L);
            }
        }
        return returnStr;
    }

    private String getAlarmTypeStr(int alarmTypeInt) {
        if (1 == alarmTypeInt) {
            return this.getText("atic.homepage.common.alarmType.ddos");
        }
        if (2 == alarmTypeInt) {
            return this.getText("atic.homepage.common.alarmType.other");
        }
        if (0 == alarmTypeInt) {
            return this.getText("atic.homepage.common.alarmType.all");
        }
        logger.error((Object)"alarmType is not in 0 to 2");
        throw new LegoCheckedException(570505L);
    }

    private void processDataForm4InterfaceCompare(HomePageEntityForm form, IAticDeviceService deviceService) {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.deviceId);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice aticDevice = deviceService.getDeviceByMoid(this.deviceId.longValue());
        if (null == aticDevice) {
            throw new LegoCheckedException(201L);
        }
        form.setDeviceIp(deviceService.getDeviceByMoid(this.deviceId.longValue()).getIpAddress());
        form.setIfIndex(this.ifIndex);
        form.setIfName(this.ifName);
        form.setFlowUnit(this.flowUnitValue);
        String deviceIpStr = this.processDeviceIpStr4OpraLog(form);
        String homePageType = this.getHomePageContent4OperaLog(form);
        String unit = form.getFlowUnit() == 1 ? "(kbps)" : "(pps)";
        String[] detailPara = new String[]{deviceIpStr, form.getIfName(), unit};
        this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIfSummary", detailPara);
        if (null == this.deviceId || this.deviceId < 1L) {
            throw new LegoCheckedException(570505L);
        }
        ArrayList<String> ifNameList = new ArrayList<String>();
        ifNameList.add("All");
        List interfaceList = deviceService.getIfNeedMonitor(this.deviceId.longValue());
        if (null != interfaceList) {
            for (Interface item : interfaceList) {
                ifNameList.add(item.getIfDescr());
            }
        }
        if (!ifNameList.contains(this.ifName)) {
            throw new LegoCheckedException(570505L);
        }
    }

    private void processDataForm4ZoneCompare(HomePageEntityForm form, IAticDeviceService deviceService, int flowTypeValueInt) {
        String deviceIp = "";
        Long zoneDeviceIdLong = 0L;
        int deviceType = 0;
        int statisticType = 0;
        if (5 == flowTypeValueInt) {
            this.zoneDeviceId = this.topnDeviceId;
            this.zoneId = this.topnZoneId;
        }
        if (this.zoneDeviceId.contains("_")) {
            zoneDeviceIdLong = Long.parseLong(this.zoneDeviceId.split("_")[0]);
            deviceType = Integer.parseInt(this.zoneDeviceId.split("_")[1]);
            deviceIp = deviceService.getDeviceByMoid(zoneDeviceIdLong.longValue()).getIpAddress();
        } else if (-2L == Long.parseLong(this.zoneDeviceId)) {
            zoneDeviceIdLong = Long.parseLong(this.zoneDeviceId);
            deviceType = 1;
            deviceIp = String.valueOf(-2);
        } else if (-1L == Long.parseLong(this.zoneDeviceId)) {
            zoneDeviceIdLong = Long.parseLong(this.zoneDeviceId);
            deviceType = 0;
            deviceIp = String.valueOf(-1);
        } else {
            zoneDeviceIdLong = Long.parseLong(this.zoneDeviceId);
            AticDevice firewall = deviceService.getDeviceByMoid(zoneDeviceIdLong.longValue());
            deviceType = AnalysisUtil.getDeviceDdos(firewall);
            deviceIp = deviceService.getDeviceByMoid(zoneDeviceIdLong.longValue()).getIpAddress();
        }
        statisticType = this.statisticTypeValue;
        form.setDeviceIp(deviceIp);
        form.setDeviceType(deviceType);
        form.setStatisticType(statisticType);
        this.checkZoneFlow4Security(zoneDeviceIdLong);
        form.setZoneId(this.zoneId);
        form.setZoneIp(this.zoneIp);
        form.setFlowUnit(this.flowUnitValue);
        form.setDirection(this.directionValue);
        String inOrDrop = "";
        if (4 == flowTypeValueInt || 5 == flowTypeValueInt) {
            form.setInOrDrop(this.inOrDropValue);
            inOrDrop = this.getText("atic.homepage.common.in");
        }
        if (5 == this.flowTypeValue && this.topnTypeValue == 4) {
            form.setFlowUnit(this.newOrCurConnValue);
        }
        String deviceIpStr = this.processDeviceIpStr4OpraLog(form);
        String homePageType = this.getHomePageContent4OperaLog(form);
        String zoneName = this.processZoneName(form);
        String unit = this.getUnitStr(this.flowUnitValue);
        if (4 == flowTypeValueInt) {
            this.checkFlowDistributeZoneIp(inOrDrop, deviceIpStr, homePageType, zoneName, unit);
        } else if (2 == flowTypeValueInt) {
            ZoneInfoForm zoneInfoForm;
            List zoneIpList;
            form.setProtocol(this.protocolValue);
            if (AticUtil.isNull((String)this.zoneIp) && 1 == (zoneIpList = (zoneInfoForm = this.zoneService.getById(this.zoneId)).getZoneIpFormList()).size() && (32 == ((ZoneIpForm)zoneIpList.get(0)).getMask() || 128 == ((ZoneIpForm)zoneIpList.get(0)).getMask())) {
                form.setZoneIp(((ZoneIpForm)zoneIpList.get(0)).getZoneIp());
            }
            this.checkPageZoneZoneIp(deviceIpStr, homePageType, zoneName, unit, this.protocolValue);
        } else if (5 == flowTypeValueInt) {
            AticDevice tempDevice;
            String[] detailPara;
            form.setTopnType(this.topnTypeValue);
            String topnType = this.getTopnTypeStr(this.topnTypeValue);
            if (this.topnTypeValue == 1) {
                detailPara = new String[]{topnType, deviceIpStr, inOrDrop, unit};
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addFlowTopNoZoneSummary", detailPara);
            } else {
                detailPara = new String[]{topnType, deviceIpStr, zoneName, inOrDrop, unit};
                this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addFlowTopSummary", detailPara);
            }
            if (zoneDeviceIdLong > 0L && this.topnTypeValue == 4 && null != (tempDevice = deviceService.getDeviceByMoid(zoneDeviceIdLong.longValue())) && tempDevice.getVersion().toUpperCase(Locale.getDefault()).contains("V100R001C00SPC500")) {
                throw new LegoCheckedException(571705L);
            }
        }
    }

    private void checkZoneFlow4Security(long zoneDeviceIdLong) {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        if (this.zoneId > 0L) {
            Long moId = 0L;
            ZoneInfoForm zoneInfoForm = this.zoneService.getById(this.zoneId);
            if (null != zoneInfoForm) {
                moId = zoneInfoForm.getMoId();
            }
            moIdList.add(moId);
        }
        if (zoneDeviceIdLong > 0L) {
            moIdList.add(zoneDeviceIdLong);
        }
        BisUtil.checkUserSecurity(moIdList);
    }

    private void checkDevice4Security(long zoneDeviceIdLong) {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        if (zoneDeviceIdLong > 0L) {
            moIdList.add(zoneDeviceIdLong);
        }
        BisUtil.checkUserSecurity(moIdList);
    }

    public boolean validateZoneId() {
        if (null == this.zoneId) {
            return true;
        }
        return this.zoneId >= 1L;
    }

    public boolean validateSecReportIp() {
        if (AticUtil.isNullForVpn((String)this.secReportIp)) {
            return true;
        }
        return IPUtil.isIpv4((String)this.secReportIp) || IPUtil.isIpv6((String)this.secReportIp);
    }

    public boolean validateZoneIp() {
        if (AticUtil.isNullForVpn((String)this.zoneIp)) {
            return true;
        }
        return IPUtil.isIpv4((String)this.zoneIp) || IPUtil.isIpv6((String)this.zoneIp);
    }

    public boolean validateZoneDeviceId() {
        return this.validateDeviceId(this.zoneDeviceId);
    }

    public boolean validateTopnDeviceId() {
        return this.validateDeviceId(this.topnDeviceId);
    }

    private boolean validateDeviceId(String zeviceIdStr) {
        if (AticUtil.isNullForVpn((String)zeviceIdStr)) {
            return true;
        }
        return zeviceIdStr.matches("^[-0-9_]+$");
    }

    private String getProtocolStr(Integer protocol, boolean isOpeLog) {
        if (null == protocol) {
            protocol = 0;
        }
        String returnProtocol = "";
        switch (protocol) {
            case 1: {
                returnProtocol = "TCP";
                break;
            }
            case 2: {
                returnProtocol = "UDP";
                break;
            }
            case 3: {
                returnProtocol = "ICMP";
                break;
            }
            case 4: {
                returnProtocol = "OTHER";
                break;
            }
            case 5: {
                returnProtocol = "TCP Fragment";
                break;
            }
            case 6: {
                returnProtocol = "UDP Fragment";
                break;
            }
            case 7: {
                returnProtocol = "SYN";
                break;
            }
            case 8: {
                returnProtocol = "SYN-ACK";
                break;
            }
            case 9: {
                returnProtocol = "ACK";
                break;
            }
            case 10: {
                returnProtocol = "FIN/RST";
                break;
            }
            default: {
                returnProtocol = this.getText("atic.analysis.common.all");
                if (!isOpeLog) break;
                returnProtocol = "atic.analysis.common.all";
            }
        }
        return returnProtocol;
    }

    private void checkPageZoneZoneIp(String deviceIpStr, String homePageType, String zoneName, String unit, int protocol) {
        String protocolStr = this.getProtocolStr(protocol, true);
        if (AticUtil.isNull((String)this.zoneIp)) {
            String[] detailPara = new String[]{zoneName, deviceIpStr, unit, protocolStr};
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addZoneNoIpSummary", detailPara);
        } else {
            String[] detailPara = new String[]{zoneName, deviceIpStr, IPUtil4Atic.compressIP((String)this.zoneIp), unit, protocolStr};
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addZoneSummary", detailPara);
            if (!IPUtil.isIpv4((String)this.zoneIp) && !IPUtil.isIpv6((String)this.zoneIp)) {
                throw new LegoCheckedException(570505L);
            }
        }
    }

    private void checkFlowDistributeZoneIp(String inOrDrop, String deviceIpStr, String homePageType, String zoneName, String unit) {
        if (AticUtil.isNull((String)this.zoneIp)) {
            String[] detailPara = new String[]{zoneName, deviceIpStr, inOrDrop, unit};
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addZoneDisNoIpSummary", detailPara);
        } else {
            String[] detailPara = new String[]{zoneName, deviceIpStr, IPUtil4Atic.compressIP((String)this.zoneIp), inOrDrop, unit};
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addZoneDisSummary", detailPara);
            if (!IPUtil.isIpv4((String)this.zoneIp) && !IPUtil.isIpv6((String)this.zoneIp)) {
                throw new LegoCheckedException(570505L);
            }
        }
    }

    private void checkSelectIp(String homePageType, String ip, String[] detailPara) {
        if (AticUtil.isNull((String)ip)) {
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIpFlowSecReport.failed", detailPara);
            throw new LegoCheckedException(571706L);
        }
        if (!IPUtil.isIpv4((String)ip) && !IPUtil.isIpv6((String)ip)) {
            this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIpFlowSecReport.failed", detailPara);
            throw new LegoCheckedException(571707L);
        }
        this.getOperateLog().normal("atic.homepage.common.add.title", "lego.dic.module.custom", homePageType, false, "atic.homepage.common.addIpFlowSecReport", detailPara);
    }

    private String getUnitStr(int unit) {
        if (5 == this.flowTypeValue && this.topnTypeValue == 4) {
            unit = this.newOrCurConnValue;
        }
        String unitStr = "";
        if (unit == 1) {
            unitStr = "(kbps)";
        } else if (unit == 2) {
            unitStr = "(pps)";
        } else if (unit == 3) {
            unitStr = this.getText("atic.homepage.common.currConn");
        } else if (unit == 4) {
            unitStr = this.getText("atic.homepage.common.newConn");
        }
        return unitStr;
    }

    private String getUnitStr4Top10OnlyKbpsAndPps(int unit) {
        String unitStr = "";
        if (unit == 1) {
            unitStr = "Kbps";
        } else if (unit == 2) {
            unitStr = "pps";
        }
        return unitStr;
    }

    private String getUnitStr4Top10(int unit) {
        String unitStr = "";
        if (unit == 1) {
            unitStr = "kbps";
        } else if (unit == 2) {
            unitStr = "pps";
        } else if (unit == 3) {
            unitStr = this.getText("atic.homepage.common.currConn");
        } else if (unit == 4) {
            unitStr = this.getText("atic.homepage.common.newConn");
        }
        return unitStr;
    }

    private String getTopnTypeStr(int topnType) {
        String topnTypeStr = "";
        if (topnType == 1) {
            topnTypeStr = this.getText("atic.homepage.common.zoneTopn");
        } else if (topnType == 2) {
            topnTypeStr = this.getText("atic.homepage.common.ipTopn");
        } else if (topnType == 3) {
            topnTypeStr = this.getText("atic.homepage.common.locationTopn");
        } else if (topnType == 4) {
            topnTypeStr = this.getText("atic.homepage.common.connectionTopn");
        } else {
            logger.error((Object)"topnTypeValue is not in 1 to 4");
            throw new LegoCheckedException(570505L);
        }
        return topnTypeStr;
    }

    private String getDirectionStr(int direction) {
        String directionStr = "";
        if (1 == direction) {
            directionStr = this.getText("atic.homepage.common.directionType.inbound");
        } else if (2 == direction) {
            directionStr = this.getText("atic.homepage.common.directionType.outbound");
        } else if (3 == direction) {
            directionStr = this.getText("atic.homepage.common.directionType.inboundAndOutbound");
        } else {
            logger.error((Object)"directionValue is not in 1 to 3");
            throw new LegoCheckedException(570505L);
        }
        return directionStr;
    }

    public void getDeviceInterfaceList4Ajax() {
        this.responseResult(this.getInterfaceListJson());
    }

    public void getDeviceList4AjaxTopnType() {
        boolean needNfa = true;
        if (this.topnTypeValue < 1 || this.topnTypeValue > 4) {
            logger.error((Object)"topnTypeValue is not in 1 to 3");
            throw new LegoCheckedException(570505L);
        }
        if (this.topnTypeValue == 3 || this.topnTypeValue == 4) {
            needNfa = false;
        }
        this.responseResult(this.processTopnDeviceJson(needNfa));
    }

    public void checkZoneHasOneIp() {
        ZoneInfoForm zoneInfoForm = this.zoneService.getById(this.zoneId);
        List zoneIpList = zoneInfoForm.getZoneIpFormList();
        if (1 == zoneIpList.size() && (32 == ((ZoneIpForm)zoneIpList.get(0)).getMask() || 128 == ((ZoneIpForm)zoneIpList.get(0)).getMask())) {
            this.responseResult("true");
        }
    }

    public void getFireWall4AjaxZoneFlowCompare() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        ArrayList<Long> moIdList = new ArrayList<Long>();
        Long moId = 0L;
        ZoneInfoForm zoneInfoForm = this.zoneService.getById(this.zoneId);
        if (null != zoneInfoForm) {
            moId = zoneInfoForm.getMoId();
        }
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        if (null != this.zoneId) {
            IZoneDeviceDeployStatusService zoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
            List lstDevId = zoneDeviceDeployStatusService.getDevByZone4Secutity(this.zoneId, isAdmin, Long.valueOf(currentUser.getUserID()));
            ArrayList<AticDevice> fwList = new ArrayList<AticDevice>();
            for (Long devId : lstDevId) {
                AticDevice firewall = this.aticDeviceService.getDeviceByMoid(devId.longValue());
                if (null == firewall) continue;
                fwList.add(firewall);
            }
            this.firewallList = fwList;
        }
        StringBuffer lds = new StringBuffer();
        lds.append('[');
        if (null == this.firewallList || this.firewallList.isEmpty()) {
            lds.deleteCharAt(lds.length() - 1);
            lds.append(']');
        } else {
            for (int i = 0; i < this.firewallList.size(); ++i) {
                this.processIdsStr4SingleFireWall(lds, this.firewallList.get(i));
            }
            lds.deleteCharAt(lds.length() - 1);
            lds.append(']');
        }
        this.responseResult(lds.toString());
    }

    private void processIdsStr4SingleFireWall(StringBuffer lds, AticDevice firewall) {
        if (null == firewall) {
            return;
        }
        String fireName = firewall.getName();
        String moId = String.valueOf(firewall.getMoId());
        int deviceType = AnalysisUtil.getDeviceDdos(firewall);
        if (0 == deviceType) {
            fireName = fireName + this.getText("atic.analysis.common.clean");
            moId = moId + "_0";
        } else if (1 == deviceType) {
            fireName = fireName + this.getText("atic.analysis.common.detect");
            moId = moId + "_1";
        } else if (2 == deviceType) {
            String fireNameClean = fireName + this.getText("atic.analysis.common.clean");
            String moIdClean = moId + "_" + 0;
            lds.append("['").append(moIdClean).append("','").append(fireNameClean).append("'],");
            fireName = fireName + this.getText("atic.analysis.common.detect");
            moId = moId + "_1";
        }
        lds.append("['").append(moId).append("','").append(fireName).append("'],");
    }

    private String getInterfaceListJson() {
        this.ifList = new ArrayList<LangPair>();
        if (null == this.deviceId || this.deviceId < 1L) {
            return "";
        }
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.deviceId);
        BisUtil.checkUserSecurity(moIdList);
        List interfaceList = this.aticDeviceService.getIfNeedMonitor(this.deviceId.longValue());
        StringBuffer lds = new StringBuffer();
        lds.append('[');
        lds.append("['-1','All'],");
        LangPair allIf = new LangPair(PARA_ONE, "All");
        this.ifList.add(allIf);
        if (null == interfaceList || interfaceList.isEmpty()) {
            lds.deleteCharAt(lds.length() - 1);
            lds.append(']');
        } else {
            LangPair ifItem = null;
            for (int i = 0; i < interfaceList.size(); ++i) {
                Interface interfaceItem = (Interface)interfaceList.get(i);
                if (null == interfaceItem) continue;
                if (i == interfaceList.size() - 1) {
                    lds.append("['").append(interfaceItem.getIfIndex()).append("','").append(interfaceItem.getIfDescr()).append("']]");
                } else {
                    lds.append("['").append(interfaceItem.getIfIndex()).append("','").append(interfaceItem.getIfDescr()).append("'],");
                }
                ifItem = new LangPair(String.valueOf(interfaceItem.getIfIndex()), interfaceItem.getIfDescr());
                this.ifList.add(ifItem);
            }
        }
        return lds.toString();
    }

    private void checkHomePageSecurity(List<Long> homePageIds) {
        Paging page = this.homePageService.getAllHomePageEntity(this.createQueryMap(), 0, Integer.MAX_VALUE);
        List homePage = page.getData();
        if (null != homePage && !homePage.isEmpty()) {
            ArrayList<Long> allHomePageIds = new ArrayList<Long>();
            for (HomePageEntityForm temp : homePage) {
                if (6 == temp.getFlowType()) continue;
                allHomePageIds.add(temp.getId());
            }
            for (Long tempId : homePageIds) {
                if (allHomePageIds.contains(tempId)) continue;
                logger.info((Object)"yue quan operation");
                throw new LegoCheckedException(630114L);
            }
        } else {
            logger.info((Object)"taskList is null ");
        }
    }

    public void deleteHomePageEntity() {
        this.getOperateLog().warning("atic.homepage.common.delete.title", "lego.dic.module.custom");
        this.checkHomePageSecurity(Arrays.asList(this.ids));
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        for (int i = 0; i < this.ids.length; ++i) {
            if (6 == this.flowTypes[i]) continue;
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.ids[i].longValue());
            HomePageEntityForm entityForm = new HomePageEntityForm();
            entityForm.setFlowType(this.flowTypes[i]);
            entityForm.setDeviceIp(this.deviceIps[i]);
            entityForm.setIfName(this.ifNames[i]);
            entityForm.setZoneId(this.zoneIds[i]);
            String typyStr = this.getHomePageContent4OperaLog(entityForm);
            bo.setTargetName(typyStr);
            batchOpList.add(bo);
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        this.batchOperationResult = this.homePageService.batchDelHomePageEntity(batchOpList, currentUser.getUserID());
        this.bathResult(this.batchOperationResult);
    }

    public boolean validateIfNames() {
        if (null == this.ifNames) {
            return false;
        }
        String regex = "^[\\w|0-9|=|\\-|/|!|@|#|$|*|^|:|,|.|+|}|{]*$";
        for (String checkIfName : this.ifNames) {
            if (StringUtils.isBlank((CharSequence)checkIfName) || checkIfName.matches(regex)) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeleteHomePageZoneIds() {
        if (null == this.zoneIds || this.zoneIds.length == 0) {
            return true;
        }
        for (Long checkId : this.zoneIds) {
            if (null == checkId || checkId >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateIds() {
        if (null == this.ids) {
            return false;
        }
        Long[] longArray = this.ids;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long testId = longArray[i];
            if (testId >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeviceIps() {
        if (null == this.deviceIps) {
            return false;
        }
        for (String testIp : this.deviceIps) {
            if (!StringUtils.isNotEmpty((CharSequence)testIp) || PARA_ONE.equals(testIp) || PARA_TWO.equals(testIp) || IPUtil.isIpv4((String)testIp)) continue;
            return false;
        }
        return true;
    }

    public boolean validateFlowTypes() {
        if (null == this.flowTypes) {
            return false;
        }
        for (Integer flowType : this.flowTypes) {
            if (flowType >= 1 && flowType <= 8) continue;
            logger.error((Object)("flowType is not in 1 to 8, flowType=" + flowType));
            return false;
        }
        return true;
    }

    public void saveHomePagePortal() {
        if (this.portalIds != null && this.portalIds.length > 0) {
            this.getOperateLog().normal("atic.homepage.common.saveLayOut", "lego.dic.module.custom", "lego.ver.custom.homepageLayout", true, "lego.ver.custom.saveLayout", null);
            ArrayList<HomePagePortalForm> portals = new ArrayList<HomePagePortalForm>();
            int flag = 0;
            int j = this.portalIds.length;
            for (int i = 0; i < j; ++i) {
                HomePagePortalForm homePagePortalForm = new HomePagePortalForm();
                flag = 0;
                String[] idArray = this.portalIds[i].split("-");
                homePagePortalForm.setId(Long.valueOf(idArray[flag++]));
                homePagePortalForm.setX(Integer.valueOf(idArray[flag++]));
                homePagePortalForm.setY(Integer.valueOf(idArray[flag++]));
                homePagePortalForm.setCollapsed(Boolean.valueOf(idArray[flag]));
                portals.add(homePagePortalForm);
            }
            this.homePageService.updataPortal(portals);
            this.responseResult("success");
        }
    }

    public boolean validatePortalIds() {
        if (this.portalIds == null || this.portalIds.length == 0) {
            return false;
        }
        for (String thePortalId : this.portalIds) {
            String[] idArray = thePortalId.split("-");
            if (idArray.length != 4) {
                return false;
            }
            try {
                long portalFormId = Long.parseLong(idArray[0]);
                if (portalFormId < 0L) {
                    return false;
                }
                long portalFormX = Integer.parseInt(idArray[1]);
                if (portalFormX < 0L) {
                    return false;
                }
                long portalFormY = Integer.parseInt(idArray[2]);
                if (portalFormY >= 0L) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public String showHomePageReport() {
        ActionContext ctx = ActionContext.getContext();
        if (null != ctx) {
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            this.currentPassCode = request.getSession().getId();
        }
        this.isSupportOutboundStr = this.licenseOutboundService.isSupportOutbound() + "";
        return "success";
    }

    public void getHomePageReportData() {
        try {
            if (null != this.licenseOutboundService) {
                this.isSupportOutbound = this.licenseOutboundService.isSupportOutbound();
            }
            String flowData = "";
            HomePageEntityForm homePageEntity = this.homePageService.findById(this.homePageEntityId, this.createQueryMap());
            if (null != homePageEntity && (this.isSupportOutbound || homePageEntity.getDirection() == 1)) {
                flowData = this.processHomePageData(homePageEntity);
            }
            ServletActionContext.getResponse().getWriter().write(flowData);
        }
        catch (Exception e) {
            logger.error((Object)("unknow exception" + e));
        }
    }

    private String processHomePageData(HomePageEntityForm homePageEntity) {
        String flowData = "";
        if (1 == homePageEntity.getFlowType()) {
            flowData = this.getReportFlowJson4Interface(homePageEntity);
        } else if (2 == homePageEntity.getFlowType()) {
            flowData = this.getReportFlowJson4ZoneCompare(homePageEntity);
        } else if (3 == homePageEntity.getFlowType()) {
            flowData = this.getReportFlowJson4Alam(homePageEntity);
        } else if (4 == homePageEntity.getFlowType()) {
            flowData = this.getReportFlowJson4ZoneDis(homePageEntity);
        } else if (5 == homePageEntity.getFlowType()) {
            flowData = this.getReportFlowJson4FlowTop(homePageEntity);
        } else if (6 == homePageEntity.getFlowType()) {
            flowData = this.getReportFlowJson4Attack();
        } else if (7 == homePageEntity.getFlowType()) {
            flowData = this.getReportFlowJson4Device(homePageEntity);
        } else if (8 == homePageEntity.getFlowType()) {
            flowData = this.getReportFlowJson4IpFlowSecReport(homePageEntity);
        }
        return flowData;
    }

    private List<Long> getZoneIdList(long userId, boolean isAdmin) {
        List tempDetectZone;
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        List tempCleanZone = this.zoneService.getDeployZoneInfoByDeviceType(Long.valueOf(userId), Boolean.valueOf(isAdmin), 0);
        if (null != tempCleanZone && !tempCleanZone.isEmpty()) {
            for (ZoneInfoForm zoneInfoForm : tempCleanZone) {
                zoneIdList.add(zoneInfoForm.getZoneId());
            }
        }
        if (null != (tempDetectZone = this.zoneService.getDeployZoneInfoByDeviceType(Long.valueOf(userId), Boolean.valueOf(isAdmin), 1)) && !tempDetectZone.isEmpty()) {
            for (ZoneInfoForm zoneInfoForm : tempDetectZone) {
                if (zoneIdList.contains(zoneInfoForm.getZoneId())) continue;
                zoneIdList.add(zoneInfoForm.getZoneId());
            }
        }
        return zoneIdList;
    }

    private String getReportFlowJson4Attack() {
        String flowData = "";
        try {
            ArrayList<String> deviceIpList = new ArrayList<String>();
            List<Object> zoneIdList = new ArrayList();
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
            List antiDDosDevicesList = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
            List nfaDevicesList = this.aticDeviceService.getClusterAndNfa(currentUser.getUserID());
            ArrayList<Object> devicesList = new ArrayList<Object>();
            if (null != antiDDosDevicesList && !antiDDosDevicesList.isEmpty()) {
                for (Object device : antiDDosDevicesList) {
                    devicesList.add(device);
                }
            }
            if (null != nfaDevicesList && !nfaDevicesList.isEmpty()) {
                for (Object device : nfaDevicesList) {
                    devicesList.add(device);
                }
            }
            if (devicesList.isEmpty()) {
                return "";
            }
            if (!isAdmin.booleanValue()) {
                for (Object device : devicesList) {
                    deviceIpList.add(device.getIpAddress());
                }
                zoneIdList = this.getZoneIdList(currentUser.getUserID(), isAdmin);
                if (zoneIdList.isEmpty()) {
                    return "";
                }
            }
            ArrayList<String> collectorIps = new ArrayList<String>();
            for (AticDevice aticDevice : devicesList) {
                Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(aticDevice.getMoId()));
                if (null == collectorId || null == this.collectorService.getCollectorInfo(collectorId.longValue())) {
                    logger.warn((Object)("no collector found, device is : " + aticDevice.getName()));
                    continue;
                }
                String colletorIp = this.collectorService.getCollectorInfo(collectorId.longValue()).getIpAddress();
                if (2 == this.collectorService.getCollectorInfo(collectorId.longValue()).getStatus()) {
                    logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + colletorIp));
                    continue;
                }
                if (collectorIps.contains(colletorIp)) continue;
                collectorIps.add(colletorIp);
            }
            IDataStatService dataStatService = (IDataStatService)ServiceContext.getInstance().getService("dataStatService", IDataStatService.class);
            Object var11_13 = null;
            for (String collectorIp : collectorIps) {
                List<AttackLogForm> attackLogFormList = dataStatService.getCur10AttackIpLog(deviceIpList, zoneIdList, collectorIp);
                for (AttackLogForm form : attackLogFormList) {
                    long durationCompare = 0L;
                    if (null != form.getDuration() && !"".equals(form.getDuration())) {
                        durationCompare = Long.parseLong(form.getDuration());
                    }
                    form.setDurationCompare(Long.valueOf(durationCompare));
                }
                if (!this.sortField.isEmpty() && !this.sortType.isEmpty()) {
                    attackLogFormList = this.sortAttackLogList(attackLogFormList);
                }
                for (AttackLogForm form : attackLogFormList) {
                    String zoneName = "";
                    ZoneInfoForm zoneForm = this.zoneService.getById(form.getZoneId());
                    if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                        logger.info((Object)("the zone not exist,zoneId = " + form.getZoneId()));
                        zoneName = this.getText("atic.analysis.common.unknownZone") + form.getZoneId();
                    } else {
                        zoneName = zoneForm.getZoneDesc();
                    }
                    String direction = "-";
                    if (1 == form.getDirection()) {
                        direction = this.getText("atic.homepage.common.directionType.inbound");
                    } else if (2 == form.getDirection()) {
                        direction = this.getText("atic.homepage.common.directionType.outbound");
                    }
                    AticDevice aticDevice = this.aticDeviceService.getDeviceByIp(form.getDeviceIp());
                    String secName = "";
                    String deviceIdStr = "";
                    if (null == aticDevice) continue;
                    deviceIdStr = aticDevice.getMoId() + "_" + (form.getDeviceType() == 2 ? 1 : form.getDeviceType());
                    secName = aticDevice.getName();
                    if (0 == form.getDeviceType()) {
                        secName = secName + this.getText("atic.analysis.common.clean");
                    }
                    if (1 == form.getDeviceType()) {
                        secName = secName + this.getText("atic.analysis.common.detect");
                    }
                    String switchOption = this.getSwitchOptionValue(form.getDeviceType(), aticDevice);
                    String reportUrl = "/atic/ireport/dataDrillWithNoSession.do?reportId=attackLogDetailAnalysis4AttackEvent&direction_combobox=" + form.getDirection() + "&switchOption=" + switchOption + "&netDevice_combobox=" + deviceIdStr + "&zone_ip=" + form.getZoneIp() + "&zone_combobox=" + form.getZoneId() + "&startTime=" + form.getAbnormalTime() + "&endTime=" + System.currentTimeMillis() / 1000L + "&dataDrillTitle=&IREPORT_WOS_CODE=";
                    String statusKey = this.getText(AnalysisUtil.getLogAttackStatus().get(form.getStatus()));
                    String divertStatus = this.getDivertStatus(aticDevice.getMoId(), form);
                    String divertUrl = "/atic/business/listDivertTactics.do?dashBoardZoneId=" + form.getZoneId() + "&dashBoardDeviceId=" + aticDevice.getMoId() + "&dashBoardDivertIp=" + form.getZoneIp() + "&showDivertType=";
                    if (1 == form.getDeviceType()) {
                        divertStatus = "--";
                        divertUrl = "--";
                    }
                    String pcapstatus = this.getPcapStatus(form.getZoneId());
                    String pcapUrl = "/atic/business/listPacketTask.do?dashBoardZoneId=" + form.getZoneId() + "&dashBoardDeviceId=" + aticDevice.getMoId();
                    if (5 == aticDevice.getDeviceType() || 7 == aticDevice.getDeviceType()) {
                        pcapstatus = "--";
                        pcapUrl = "--";
                    }
                    logger.info((Object)"start attack flow flowData ");
                    String dropFlowPps = "--";
                    String dropFlowKbps = "--";
                    if (1 != form.getDeviceType()) {
                        dropFlowPps = this.getAttackTableInFlowShowValue4Pps(this.longFromLong(form.getIpAttackPeakPps()));
                        dropFlowKbps = this.getAttackTableInFlowShowValue(this.longFromLong(form.getIpAttackPeakKbps()));
                    }
                    flowData = flowData + IPUtil4Atic.compressIP((String)form.getZoneIp()) + "#" + zoneName + "#" + secName + "#" + statusKey + "#" + this.getAttackTableInFlowShowValue(this.longFromLong(form.getIpInPeakKbps())) + "#" + this.getAttackTableInFlowShowValue4Pps(this.longFromLong(form.getIpInPeakPps())) + "#" + divertStatus + "#" + pcapstatus + "#" + reportUrl + "#" + divertUrl + "#" + pcapUrl + "#" + direction + "#" + dropFlowKbps + "#" + dropFlowPps + "#" + this.longFromLong(form.getTcpNewConnNum()) + "#" + this.longFromLong(form.getTcpCurConnNum()) + "#" + this.queryAttackTypes(form.getAttackType()) + "#" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(form.getAttackTime() * 1000L)) + "#" + this.queryDuration(form.getDurationCompare()) + "##";
                    logger.info((Object)("attack flow flowData:" + flowData));
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"unknow excepton", (Throwable)e);
        }
        return flowData;
    }

    private String queryDuration(Long duration) {
        String druations = (duration / 3600L > 0L ? duration / 3600L + "h " : "") + (duration % 3600L / 60L > 0L ? duration % 3600L / 60L + "m " : "") + (duration % 3600L % 60L > 0L ? duration % 3600L % 60L + "s " : "");
        return druations;
    }

    private List<AttackLogForm> sortAttackLogList(List<AttackLogForm> attackLogFormList) {
        BeanComparator comparator = new BeanComparator(this.sortField);
        if (this.sortType.equals("DESC") || this.sortType.equals("desc")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(attackLogFormList, comparator);
        return attackLogFormList;
    }

    private String queryAttackTypes(String attackTypes) {
        StringBuilder sb = new StringBuilder();
        if (attackTypes.isEmpty()) {
            return "";
        }
        String[] str = attackTypes.split(",");
        for (int i = 0; i < str.length; ++i) {
            int attackTypeValue = Integer.parseInt(str[i]);
            long filterId = 0L;
            String attackType = "";
            if (attackTypeValue > 2000 && attackTypeValue < 80000) {
                filterId = attackTypeValue - 2000;
                FilterForm filterTemp = this.filterService.queryFilterName(Long.valueOf(filterId));
                attackType = null != filterTemp && !AticUtil.isNull((String)filterTemp.getFilterName()) ? filterTemp.getFilterName() : "Unknown Filter " + filterId;
            } else if (attackTypeValue >= 80000) {
                if (this.npFilterService != null) {
                    filterId = attackTypeValue - 80000;
                    NPFilterForm npfilterTemp = this.npFilterService.queryNPFilterFormByfilterId(filterId);
                    attackType = null != npfilterTemp && !AticUtil.isNull((String)npfilterTemp.getFilterName()) ? npfilterTemp.getFilterName() : this.getText("com.hs.atic.alart.attack.attackType.80000");
                    logger.info((Object)("npfilterTemp attackTypeValue : " + attackTypeValue + ";attackType: " + attackType));
                } else {
                    logger.error((Object)"npFilterService service is null!");
                    attackType = this.getText("com.hs.atic.alart.attack.attackType.80000");
                }
            } else {
                attackType = this.getText("com.hs.atic.alart.attack.attackType." + attackTypeValue);
            }
            sb.append(attackType).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private long longFromLong(Long attackFlow) {
        if (attackFlow == null) {
            return 0L;
        }
        return attackFlow;
    }

    private String getSwitchOptionValue(int deviceType, AticDevice secNE) {
        String switchOption = "clean_less1day_pps";
        switchOption = 1 == deviceType ? "detect_less1day_pps" : "clean_less1day_pps";
        ArrayList<AticDevice> devList = new ArrayList<AticDevice>();
        devList.add(secNE);
        if (CommonUtil.includesV1R1(devList)) {
            switchOption = 1 == deviceType ? "detect_less2day_pps" : "clean_less2day_pps";
        }
        return switchOption;
    }

    private String getAttackTableInFlowShowValue(long kbps) {
        long changeValue = this.getChangeValue(kbps, 1);
        String unit = this.getUnit4Kbps(kbps);
        if (AticUtil.isNull((String)unit)) {
            unit = "kbps";
        }
        String returnKbps = kbps / changeValue + unit;
        return returnKbps;
    }

    private String getAttackTableInFlowShowValue4Pps(long pps) {
        long changeValue = this.getChangeValue(pps, 2);
        String unit = this.getAttackUnit4Pps(pps);
        if (AticUtil.isNull((String)unit)) {
            unit = "pps";
        }
        String returnKbps = pps / changeValue + unit;
        return returnKbps;
    }

    private String getPcapStatus(long zoneID) {
        String pcapStatusStr = this.getText("atic.homepage.common.attack.table.noPcapTask");
        IPacketTaskService packetTaskService = (IPacketTaskService)ServiceContext.getInstance().getService("packetTaskService", IPacketTaskService.class);
        int pcapStatus = packetTaskService.getZoneCaputreStauts(zoneID);
        if (1 == pcapStatus) {
            pcapStatusStr = this.getText("atic.bis.packet.task.state.start");
        } else if (0 == pcapStatus) {
            pcapStatusStr = this.getText("atic.bis.packet.task.state.stop");
        }
        return pcapStatusStr;
    }

    private String getDivertStatus(Long deviceID, AttackLogForm form) {
        String divertStatus = this.getText("atic.homepage.common.attack.table.noDivert");
        if (1 == form.getDeviceType()) {
            return "-";
        }
        DivertTacticsForm divertForm = this.divertTacticsService.getDivertTacticsByZoneIp(deviceID, form.getZoneId(), form.getZoneIp());
        if (null != divertForm) {
            if (1 == divertForm.getDivertStatus()) {
                divertStatus = this.getText("atic.bis.divert.tactics.divert.status.start");
            } else if (0 == divertForm.getDivertStatus()) {
                divertStatus = this.getText("atic.bis.divert.tactics.divert.status.stop");
            }
        }
        return divertStatus;
    }

    private String getReportFlowJson4FlowTop(HomePageEntityForm homePageEntity) {
        List<Object> flowTopNList = new ArrayList();
        IDataStatService dataStatService = (IDataStatService)ServiceContext.getInstance().getService("dataStatService", IDataStatService.class);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        List<Object> zoneIdList = new ArrayList();
        if (!isAdmin.booleanValue()) {
            zoneIdList = this.getZoneIdList(currentUser.getUserID(), isAdmin);
        }
        if (homePageEntity.getDeviceIp().equals(PARA_ONE) || homePageEntity.getDeviceIp().equals(PARA_TWO)) {
            List<Object> devicesList = new ArrayList();
            if (homePageEntity.getDeviceIp().equals(PARA_ONE)) {
                devicesList.addAll(this.aticDeviceService.getCleanDevice(currentUser.getUserID()));
            } else {
                devicesList = AnalysisUtil.getAllDetectList4Cluster(this.aticDeviceService, currentUser.getUserID());
            }
            for (AticDevice aticDevice : devicesList) {
                homePageEntity.setDeviceIp(aticDevice.getIpAddress());
                List tempList = dataStatService.queryDashboardTopNData(this.processFlowTopNObj(homePageEntity), isAdmin.booleanValue(), zoneIdList);
                if (null == tempList || tempList.isEmpty()) continue;
                flowTopNList.addAll(tempList);
            }
            flowTopNList = this.checkProvince(flowTopNList, homePageEntity);
            this.processAddSameData(homePageEntity.getTopnType(), flowTopNList);
        } else {
            flowTopNList = dataStatService.queryDashboardTopNData(this.processFlowTopNObj(homePageEntity), isAdmin.booleanValue(), zoneIdList);
            flowTopNList = this.checkProvince(flowTopNList, homePageEntity);
        }
        if (flowTopNList.isEmpty()) {
            return "{data: [], ticks: []}@@" + this.getUnitStr4Top10(homePageEntity.getFlowUnit());
        }
        this.sortTopnDataList(flowTopNList);
        int tonpNTemp = this.topNValue;
        if (2 == homePageEntity.getTopnType()) {
            tonpNTemp = homePageEntity.getTopnNum();
        }
        if (4 == homePageEntity.getTopnType()) {
            tonpNTemp = 5;
        }
        int count = tonpNTemp < flowTopNList.size() ? tonpNTemp : flowTopNList.size();
        flowTopNList = flowTopNList.subList(0, count);
        long l = 0L;
        String unit4BigValue = "";
        long changeValue = 1L;
        if (!flowTopNList.isEmpty()) {
            l = this.getTopNValue((FlowTopNForm)flowTopNList.get(0));
            unit4BigValue = this.getUnit4BigValue(l, homePageEntity.getFlowUnit());
            changeValue = this.getChangeValue(l, homePageEntity.getFlowUnit());
        }
        String unit = this.getUnit4ReportShow(unit4BigValue, homePageEntity.getFlowUnit());
        StringBuffer buf = new StringBuffer();
        String json = "";
        for (int i = 0; i < flowTopNList.size(); ++i) {
            FlowTopNForm flowTopNObj = (FlowTopNForm)flowTopNList.get(i);
            long o1Flow = this.getTopNValue(flowTopNObj);
            String tickStr = this.getTopNTick(flowTopNObj);
            tickStr = tickStr != null ? tickStr.substring(tickStr.lastIndexOf("/") + 1) : null;
            double doubleValue = this.getDoubleValue(o1Flow, changeValue);
            if (tonpNTemp <= this.topNValue) {
                buf.append("{label: '");
                buf.append(tickStr);
                buf.append("', color: 'rgb(");
                buf.append(color.get(i));
                buf.append(")', data: [");
                buf.append('[');
                buf.append(i);
                buf.append(',');
                buf.append(doubleValue);
                buf.append(']');
                buf.append("], ticks: [");
                buf.append('[');
                buf.append(i);
                buf.append(",'");
                buf.append(tickStr);
                buf.append("']");
                buf.append("]}#");
                continue;
            }
            buf.append(i + 1 + "#" + tickStr + "#" + doubleValue + unit + "##");
        }
        if (tonpNTemp <= this.topNValue) {
            json = buf.toString();
            if (!flowTopNList.isEmpty() && flowTopNList.size() < this.topNValue) {
                json = json + "{label: '', color: '', data: [[9,0]], ticks: [[9,'']]}#";
            }
            json = json.substring(0, json.length() - 1);
            json = json + "@@" + unit;
        } else {
            json = buf.toString();
        }
        return json;
    }

    private List<FlowTopNForm> checkProvince(List<FlowTopNForm> flowTopNList, HomePageEntityForm homePageEntity) {
        ArrayList<FlowTopNForm> temp = new ArrayList<FlowTopNForm>();
        if (null == flowTopNList) {
            return temp;
        }
        if (homePageEntity.getFlowType() != 5 || null == homePageEntity.getTopnType() || homePageEntity.getTopnType() != 3) {
            return flowTopNList;
        }
        for (FlowTopNForm flowTopNForm : flowTopNList) {
            if (null == flowTopNForm) continue;
            if (flowTopNForm.getLocationId() > 512L && homePageEntity.getStatisticalDimensionType().equalsIgnoreCase("1")) {
                temp.add(flowTopNForm);
                continue;
            }
            if (flowTopNForm.getLocationId() <= 512L && homePageEntity.getStatisticalDimensionType().equalsIgnoreCase("0")) {
                temp.add(flowTopNForm);
                continue;
            }
            if (null != homePageEntity.getStatisticalDimensionType() && !"".equals(homePageEntity.getStatisticalDimensionType())) continue;
            temp.add(flowTopNForm);
        }
        return temp;
    }

    private double getDoubleValue(long flow, long changeValue) {
        double divideDoubleValue = (double)flow / (double)changeValue;
        BigDecimal b = new BigDecimal(divideDoubleValue);
        double doubleValue = b.setScale(2, 4).doubleValue();
        return doubleValue;
    }

    private String getUnit4ReportShow(String unit4BigValue, int flowUnit) {
        String unit = "";
        unit = AticUtil.isNull((String)unit4BigValue) ? this.getUnitStr4Top10OnlyKbpsAndPps(flowUnit) : (flowUnit == 1 ? unit4BigValue : (flowUnit == 2 ? unit4BigValue + this.getUnitStr4Top10(flowUnit) : unit4BigValue));
        return unit;
    }

    private String getUnit4BigValue(long lessFlowValue, int flowUnit) {
        String unit4BigValue = "";
        unit4BigValue = flowUnit == 1 ? this.getUnit4Kbps(lessFlowValue) : this.getUnit4Pps(lessFlowValue);
        return unit4BigValue;
    }

    private String getUnit4Kbps(long lessFlowValue) {
        String unit4BigValue = "";
        unit4BigValue = lessFlowValue < 10000L ? "" : (lessFlowValue < 10000000L ? "Mbps" : (lessFlowValue < 10000000000L ? "Gbps" : "Tbps"));
        return unit4BigValue;
    }

    private String getUnit4Pps(long lessFlowValue) {
        String unit4BigValue = "";
        unit4BigValue = lessFlowValue < 10000L ? "" : (lessFlowValue < 10000000L ? "K" : (lessFlowValue < 10000000000L ? "M" : "G"));
        return unit4BigValue;
    }

    private String getAttackUnit4Pps(long lessFlowValue) {
        String unit4BigValue = "";
        unit4BigValue = lessFlowValue < 10000L ? "" : (lessFlowValue < 10000000L ? "kpps" : (lessFlowValue < 10000000000L ? "Mpps" : "Gpps"));
        return unit4BigValue;
    }

    private long getChangeValue(long lessFlowValue, int flowUnit) {
        long changeValue = 1L;
        long unitNum = 1000L;
        if (flowUnit == 1) {
            unitNum = 1000L;
        }
        if (lessFlowValue < unitNum * 10L) {
            changeValue = 1L;
        } else if (unitNum * 10L <= lessFlowValue && lessFlowValue < unitNum * unitNum * 10L) {
            changeValue = unitNum;
        } else if (unitNum * unitNum * 10L <= lessFlowValue && lessFlowValue < unitNum * unitNum * unitNum * 10L) {
            changeValue = unitNum * unitNum;
        } else if (lessFlowValue >= unitNum * unitNum * unitNum * 10L) {
            changeValue = unitNum * unitNum * unitNum;
        }
        return changeValue;
    }

    private String getTopNTick(FlowTopNForm flowTopNObj) {
        String tickStr = "";
        int topnType = flowTopNObj.getTopnType();
        if (topnType == 1) {
            ZoneInfoForm zoneForm = this.zoneService.getById(Long.valueOf(flowTopNObj.getZoneId()));
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                logger.info((Object)("the zone not exist,zoneId = " + flowTopNObj.getZoneId()));
                tickStr = this.getText("atic.analysis.common.unknownZone") + flowTopNObj.getZoneId();
            } else {
                tickStr = zoneForm.getZoneDesc();
            }
        } else if (topnType == 2 || topnType == 4) {
            if (!AticUtil.isNull((String)flowTopNObj.getZoneIp())) {
                tickStr = IPUtil4Atic.compressIP((String)flowTopNObj.getZoneIp());
            }
        } else if (topnType == 3) {
            tickStr = AnalysisUtil.getIpLocationName(Integer.parseInt(String.valueOf(flowTopNObj.getLocationId())));
        }
        return tickStr;
    }

    private long getTopNValue(FlowTopNForm o1) {
        long o1Flow = 0L;
        if (o1.getInOrDrop() == 1) {
            if (o1.getAvgOrPeak() == 1) {
                if (o1.getUnit() == 1) {
                    o1Flow = o1.getInKbps();
                } else if (o1.getUnit() == 2) {
                    o1Flow = o1.getInPps();
                } else if (o1.getUnit() == 3) {
                    o1Flow = o1.getCurrConn();
                } else if (o1.getUnit() == 4) {
                    o1Flow = o1.getNewConn();
                }
            } else if (o1.getUnit() == 1) {
                o1Flow = o1.getMaxInKbps();
            } else if (o1.getUnit() == 2) {
                o1Flow = o1.getMaxInPps();
            } else if (o1.getUnit() == 3) {
                o1Flow = o1.getMaxCurrConn();
            } else if (o1.getUnit() == 4) {
                o1Flow = o1.getMaxNewConn();
            }
        } else if (o1.getInOrDrop() == 3) {
            if (o1.getUnit() == 1) {
                o1Flow = o1.getMaxForwardKbps();
            } else if (o1.getUnit() == 2) {
                o1Flow = o1.getMaxForwardPps();
            }
        } else if (o1.getAvgOrPeak() == 1) {
            if (o1.getUnit() == 1) {
                o1Flow = o1.getDropKbps();
            } else if (o1.getUnit() == 2) {
                o1Flow = o1.getDropPps();
            } else if (o1.getUnit() == 3) {
                o1Flow = o1.getCurrConn();
            } else if (o1.getUnit() == 4) {
                o1Flow = o1.getNewConn();
            }
        } else if (o1.getUnit() == 1) {
            o1Flow = o1.getMaxDropKbps();
        } else if (o1.getUnit() == 2) {
            o1Flow = o1.getMaxDropPps();
        } else if (o1.getUnit() == 3) {
            o1Flow = o1.getMaxCurrConn();
        } else if (o1.getUnit() == 4) {
            o1Flow = o1.getMaxNewConn();
        }
        return o1Flow;
    }

    private void processAddSameData(Integer topnType, List<FlowTopNForm> flowTopNList) {
        block5: {
            block4: {
                if (topnType != 1) break block4;
                for (int i = 0; i < flowTopNList.size(); ++i) {
                    for (int j = flowTopNList.size() - 1; j > i; --j) {
                        if (flowTopNList.get(i).getZoneId() != flowTopNList.get(j).getZoneId()) continue;
                        flowTopNList.get(i).setInKbps(flowTopNList.get(i).getInKbps() + flowTopNList.get(j).getInKbps());
                        flowTopNList.get(i).setMaxInKbps(flowTopNList.get(i).getMaxInKbps() + flowTopNList.get(j).getMaxInKbps());
                        flowTopNList.get(i).setDropKbps(flowTopNList.get(i).getDropKbps() + flowTopNList.get(j).getDropKbps());
                        flowTopNList.get(i).setMaxDropKbps(flowTopNList.get(i).getMaxDropKbps() + flowTopNList.get(j).getMaxDropKbps());
                        flowTopNList.get(i).setInPps(flowTopNList.get(i).getInPps() + flowTopNList.get(j).getInPps());
                        flowTopNList.get(i).setMaxInPps(flowTopNList.get(i).getMaxInPps() + flowTopNList.get(j).getMaxInPps());
                        flowTopNList.get(i).setDropPps(flowTopNList.get(i).getDropPps() + flowTopNList.get(j).getDropPps());
                        flowTopNList.get(i).setMaxDropPps(flowTopNList.get(i).getMaxDropPps() + flowTopNList.get(j).getMaxDropPps());
                        flowTopNList.get(i).setCurrConn(flowTopNList.get(i).getCurrConn() + flowTopNList.get(j).getCurrConn());
                        flowTopNList.get(i).setMaxCurrConn(flowTopNList.get(i).getMaxCurrConn() + flowTopNList.get(j).getMaxCurrConn());
                        flowTopNList.get(i).setNewConn(flowTopNList.get(i).getNewConn() + flowTopNList.get(j).getNewConn());
                        flowTopNList.get(i).setMaxNewConn(flowTopNList.get(i).getMaxNewConn() + flowTopNList.get(j).getMaxNewConn());
                        flowTopNList.remove(j);
                    }
                }
                break block5;
            }
            if (topnType != 3) break block5;
            for (int i = 0; i < flowTopNList.size(); ++i) {
                for (int j = flowTopNList.size() - 1; j > i; --j) {
                    if (flowTopNList.get(i).getLocationId() != flowTopNList.get(j).getLocationId()) continue;
                    flowTopNList.get(i).setInKbps(flowTopNList.get(i).getInKbps() + flowTopNList.get(j).getInKbps());
                    flowTopNList.get(i).setMaxInKbps(flowTopNList.get(i).getMaxInKbps() + flowTopNList.get(j).getMaxInKbps());
                    flowTopNList.get(i).setDropKbps(flowTopNList.get(i).getDropKbps() + flowTopNList.get(j).getDropKbps());
                    flowTopNList.get(i).setMaxDropKbps(flowTopNList.get(i).getMaxDropKbps() + flowTopNList.get(j).getMaxDropKbps());
                    flowTopNList.get(i).setInPps(flowTopNList.get(i).getInPps() + flowTopNList.get(j).getInPps());
                    flowTopNList.get(i).setMaxInPps(flowTopNList.get(i).getMaxInPps() + flowTopNList.get(j).getMaxInPps());
                    flowTopNList.get(i).setDropPps(flowTopNList.get(i).getDropPps() + flowTopNList.get(j).getDropPps());
                    flowTopNList.get(i).setMaxDropPps(flowTopNList.get(i).getMaxDropPps() + flowTopNList.get(j).getMaxDropPps());
                    flowTopNList.get(i).setCurrConn(flowTopNList.get(i).getCurrConn() + flowTopNList.get(j).getCurrConn());
                    flowTopNList.get(i).setMaxCurrConn(flowTopNList.get(i).getMaxCurrConn() + flowTopNList.get(j).getMaxCurrConn());
                    flowTopNList.get(i).setNewConn(flowTopNList.get(i).getNewConn() + flowTopNList.get(j).getNewConn());
                    flowTopNList.get(i).setMaxNewConn(flowTopNList.get(i).getMaxNewConn() + flowTopNList.get(j).getMaxNewConn());
                    flowTopNList.remove(j);
                }
            }
        }
    }

    private void sortTopnDataList(List<FlowTopNForm> flowTopNList) {
        Collections.sort(flowTopNList, new InnerClass());
    }

    private FlowTopNForm processFlowTopNObj(HomePageEntityForm homePageEntity) {
        FlowTopNForm flowTopNObj = new FlowTopNForm();
        try {
            CollectorInfo collectorInfo;
            AticDevice firewall = this.aticDeviceService.getDeviceByIp(homePageEntity.getDeviceIp());
            Long collId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
            long collectorId = 0L;
            if (null != collId) {
                collectorId = collId;
            }
            if (null == (collectorInfo = this.collectorService.getCollectorInfo(collectorId))) {
                logger.error((Object)("processFlowTopNObj(), collectorInfo is null, collectorId = " + collectorId));
                return flowTopNObj;
            }
            flowTopNObj.setCollectorIp(collectorInfo.getIpAddress());
            flowTopNObj.setTopnType(homePageEntity.getTopnType().intValue());
            flowTopNObj.setDeviceIp(homePageEntity.getDeviceIp());
            flowTopNObj.setDevType(homePageEntity.getDeviceType().intValue());
            flowTopNObj.setZoneId(homePageEntity.getZoneId().longValue());
            flowTopNObj.setInOrDrop(homePageEntity.getInOrDrop().intValue());
            flowTopNObj.setDirection(homePageEntity.getDirection().intValue());
            if (null != homePageEntity.getStatisticType()) {
                flowTopNObj.setAvgOrPeak(homePageEntity.getStatisticType().intValue());
            } else {
                flowTopNObj.setAvgOrPeak(1);
            }
            flowTopNObj.setUnit(homePageEntity.getFlowUnit().intValue());
        }
        catch (Exception e) {
            logger.error((Object)"unknow excepton", (Throwable)e);
        }
        return flowTopNObj;
    }

    private String getReportFlowJson4ZoneDis(HomePageEntityForm homePageEntity) {
        String unit;
        String json = "";
        String tcpInData = "";
        String tcpDropData = "";
        String tcpForwardData = "";
        String udpInData = "";
        String udpDropData = "";
        String udpForwardData = "";
        String icmpInData = "";
        String icmpDropData = "";
        String icmpForwardData = "";
        String otherInData = "";
        String otherDropData = "";
        String otherForwardData = "";
        ZoneCompareMemoryDataKey zoneCompareMemoryDataKey = new ZoneCompareMemoryDataKey();
        zoneCompareMemoryDataKey.setDeviceIp(homePageEntity.getDeviceIp());
        zoneCompareMemoryDataKey.setDeviceType(homePageEntity.getDeviceType());
        zoneCompareMemoryDataKey.setZoneId(homePageEntity.getZoneId());
        zoneCompareMemoryDataKey.setMax(false);
        zoneCompareMemoryDataKey.setDirection(homePageEntity.getDirection());
        if (null != homePageEntity.getStatisticType() && homePageEntity.getStatisticType() == 2) {
            zoneCompareMemoryDataKey.setMax(true);
        }
        if (!AticUtil.isNull((String)homePageEntity.getZoneIp())) {
            zoneCompareMemoryDataKey.setZoneIp(homePageEntity.getZoneIp());
        }
        List<ZoneCompareTrafficObj> reportData = this.sortListByField(this.getZoneCompareData(zoneCompareMemoryDataKey), "logTime", "ASC");
        int flowUnit = homePageEntity.getFlowUnit();
        int deviceType = homePageEntity.getDeviceType();
        for (int i = 0; i < reportData.size(); ++i) {
            ZoneCompareTrafficObj tempObj = reportData.get(i);
            tcpInData = tcpInData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getTcpInFlowKbps() : tempObj.getTcpInFlowPps()) + "]";
            udpInData = udpInData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getUdpInFlowKbps() : tempObj.getUdpInFlowPps()) + "]";
            icmpInData = icmpInData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getIcmpInFlowKbps() : tempObj.getIcmpInFlowPps()) + "]";
            otherInData = otherInData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getOtherInFlowKbps() : tempObj.getOtherInFlowPps()) + "]";
            if (i < reportData.size() - 1) {
                tcpInData = tcpInData + ",";
                udpInData = udpInData + ",";
                icmpInData = icmpInData + ",";
                otherInData = otherInData + ",";
            }
            tcpDropData = tcpDropData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getTcpOutFlowKbps() : tempObj.getTcpOutFlowPps()) + "]";
            udpDropData = udpDropData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getUdpOutFlowKbps() : tempObj.getUdpOutFlowPps()) + "]";
            icmpDropData = icmpDropData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getIcmpOutFlowKbps() : tempObj.getIcmpOutFlowPps()) + "]";
            otherDropData = otherDropData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getOtherOutFlowKbps() : tempObj.getOtherOutFlowPps()) + "]";
            if (i < reportData.size() - 1) {
                tcpDropData = tcpDropData + ",";
                udpDropData = udpDropData + ",";
                icmpDropData = icmpDropData + ",";
                otherDropData = otherDropData + ",";
            }
            tcpForwardData = tcpForwardData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getTcpForwardFlowKbps() : tempObj.getTcpForwardFlowPps()) + "]";
            udpForwardData = udpForwardData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getUdpForwardFlowKbps() : tempObj.getUdpForwardFlowPps()) + "]";
            icmpForwardData = icmpForwardData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getIcmpForwardFlowKbps() : tempObj.getIcmpForwardFlowPps()) + "]";
            otherForwardData = otherForwardData + "[" + tempObj.getLogTime() * 1000L + "," + (flowUnit == 1 ? tempObj.getOtherForwardFlowKbps() : tempObj.getOtherForwardFlowPps()) + "]";
            if (i >= reportData.size() - 1) continue;
            tcpForwardData = tcpForwardData + ",";
            udpForwardData = udpForwardData + ",";
            icmpForwardData = icmpForwardData + ",";
            otherForwardData = otherForwardData + ",";
        }
        String string = unit = flowUnit == 1 ? "(kbps)" : "(pps)";
        if (1 == deviceType) {
            json = "{label: 'TCP" + unit + "', color: 'rgb(77,130,249)', data: [" + tcpInData + "]}#";
            json = json + "{label: 'UDP" + unit + "', color: 'rgb(94,237,79)', data: [" + udpInData + "]}#";
            json = json + "{label: 'ICMP" + unit + "', color: 'rgb(236,116,97)', data: [" + icmpInData + "]}#";
            json = json + "{label: 'OTHER" + unit + "', color: 'rgb(204,153,255)', data: [" + otherInData + "]}#";
        }
        if (0 == deviceType) {
            if (homePageEntity.getInOrDrop() == 1) {
                json = "{label: 'TCP" + unit + "', color: 'rgb(77,130,249)', data: [" + tcpInData + "]}#";
                json = json + "{label: 'UDP" + unit + "', color: 'rgb(94,237,79)', data: [" + udpInData + "]}#";
                json = json + "{label: 'ICMP" + unit + "', color: 'rgb(236,116,97)', data: [" + icmpInData + "]}#";
                json = json + "{label: 'OTHER" + unit + "', color: 'rgb(204,153,255)', data: [" + otherInData + "]}#";
            } else if (homePageEntity.getInOrDrop() == 2) {
                json = json + "{label: 'TCP" + unit + "', color: 'rgb(77,130,249)', data: [" + tcpDropData + "]}#";
                json = json + "{label: 'UDP" + unit + "', color: 'rgb(94,237,79)', data: [" + udpDropData + "]}#";
                json = json + "{label: 'ICMP" + unit + "', color: 'rgb(236,116,97)', data: [" + icmpDropData + "]}#";
                json = json + "{label: 'OTHER" + unit + "', color: 'rgb(204,153,255)', data: [" + otherDropData + "]}#";
            } else {
                json = json + "{label: 'TCP" + unit + "', color: 'rgb(77,130,249)', data: [" + tcpForwardData + "]}#";
                json = json + "{label: 'UDP" + unit + "', color: 'rgb(94,237,79)', data: [" + udpForwardData + "]}#";
                json = json + "{label: 'ICMP" + unit + "', color: 'rgb(236,116,97)', data: [" + icmpForwardData + "]}#";
                json = json + "{label: 'OTHER" + unit + "', color: 'rgb(204,153,255)', data: [" + otherForwardData + "]}#";
            }
        }
        return json;
    }

    private List<Fault> sortAlarmListByseverity(List<Fault> alertList) {
        BeanComparator comparator = new BeanComparator("severity");
        comparator = new ReverseComparator((Comparator)comparator);
        Collections.sort(alertList, comparator);
        return alertList;
    }

    private String getReportFlowJson4Alam(HomePageEntityForm homePageEntity) {
        String flowData = "";
        if (null != homePageEntity) {
            try {
                FaultService service = (FaultService)ServiceContext.getInstance().getService("faultService", FaultService.class);
                Paging page = service.listFault(this.createCondition(homePageEntity));
                this.total = page.getCount();
                List<Fault> faultList = this.sortAlarmListByseverity(page.getData());
                for (Fault fault : faultList) {
                    String[] briefParams = fault.getBriefParams();
                    for (int i = 0; i < briefParams.length; ++i) {
                        if (!briefParams[i].contains(".")) continue;
                        if (briefParams[i].contains(",")) {
                            String[] attacktypes = briefParams[i].split(",");
                            for (int j = 0; j < attacktypes.length; ++j) {
                                briefParams[i] = 0 == j ? this.getText(attacktypes[j]).trim() : briefParams[i] + "," + this.getText(attacktypes[j]).trim();
                            }
                            continue;
                        }
                        briefParams[i] = this.getText(briefParams[i]).trim();
                    }
                    String brief = this.getText(fault.getFaultDefineId() + ".alarm.name") + "; " + this.getText(fault.getFaultDefineId() + ".alarm.brief", briefParams);
                    flowData = flowData + fault.getSeverity() + "#" + this.getAlarmSeverity(fault.getSeverity().byteValue()) + "#" + new SimpleDateFormat("MM-dd HH:mm:ss").format(fault.getModTime()) + "#" + brief + "##";
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"unknow excepton", (Throwable)e);
            }
        }
        return flowData;
    }

    private FaultQueryCondition createCondition(HomePageEntityForm homePageEntity) {
        int severityInt = homePageEntity.getFlowUnit();
        int sourceType = homePageEntity.getDeviceType();
        FaultQueryCondition queryCond = new FaultQueryCondition();
        switch (severityInt) {
            case 2: {
                queryCond.setSeverity(new Byte[]{Byte.parseByte(String.valueOf(2)), Byte.parseByte(String.valueOf(3)), Byte.parseByte(String.valueOf(4))});
                break;
            }
            case 3: {
                queryCond.setSeverity(new Byte[]{Byte.parseByte(String.valueOf(3)), Byte.parseByte(String.valueOf(4))});
                break;
            }
            case 4: {
                queryCond.setSeverity(new Byte[]{Byte.parseByte(String.valueOf(4))});
                break;
            }
            default: {
                queryCond.setSeverity(new Byte[]{Byte.parseByte(String.valueOf(1)), Byte.parseByte(String.valueOf(2)), Byte.parseByte(String.valueOf(3)), Byte.parseByte(String.valueOf(4))});
            }
        }
        queryCond.setStart(Integer.valueOf(0));
        queryCond.setPageSize(Integer.valueOf(faultNum));
        queryCond.setSortField("modTime");
        queryCond.setSortType("desc");
        if (1 == sourceType) {
            queryCond.setSourceType(Byte.valueOf(Byte.parseByte(String.valueOf(alarmDdosValue))));
        } else if (2 == sourceType) {
            queryCond.setSourceType(Byte.valueOf(Byte.parseByte(String.valueOf(alarmOtherValue))));
        }
        if (1 == sourceType && homePageEntity.getZoneId() > 0L) {
            ZoneInfoForm zone = this.zoneService.getById(homePageEntity.getZoneId());
            if (null != zone) {
                queryCond.setZoneId(zone.getMoId().longValue());
            } else {
                queryCond.setZoneId(-1L);
            }
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        queryCond.setUserID(currentUser.getUserID());
        queryCond.setClearStatus(Fault.FaultClearStatus.UNCLEARED.getValue());
        return queryCond;
    }

    public List<DevTrafficObj> sortListByField4If(List<DevTrafficObj> beSortedList, String sortFields, String sortTypes) {
        BeanComparator comparator = new BeanComparator(sortFields);
        if (sortTypes.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<ZoneCompareTrafficObj> sortListByField(List<ZoneCompareTrafficObj> beSortedList, String sortFields, String sortTypes) {
        if (null == beSortedList) {
            return new ArrayList<ZoneCompareTrafficObj>();
        }
        BeanComparator comparator = new BeanComparator(sortFields);
        if (sortTypes.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<SecReportTrafficObject> sortListByField2(List<SecReportTrafficObject> beSortedList, String sortFields, String sortTypes) {
        if (null == beSortedList) {
            return new ArrayList<SecReportTrafficObject>();
        }
        BeanComparator comparator = new BeanComparator(sortFields);
        if (sortTypes.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    private List<ZoneCompareTrafficObj> getZoneCompareData(ZoneCompareMemoryDataKey zoneCompareMemoryDataKey) {
        IZoneCompareTrafficService zoneCompareTrafficService = (IZoneCompareTrafficService)ServiceContext.getInstance().getService("zoneCompareTrafficServiceImpl", IZoneCompareTrafficService.class);
        List<ZoneCompareTrafficObj> zoneCompareFlow = null;
        if (zoneCompareMemoryDataKey.getDeviceIp().equals(PARA_ONE) || zoneCompareMemoryDataKey.getDeviceIp().equals(PARA_TWO)) {
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            ArrayList<AticDevice> devicesList = new ArrayList();
            if (zoneCompareMemoryDataKey.getDeviceIp().equals(PARA_ONE)) {
                devicesList.addAll(this.aticDeviceService.getCleanDevice(currentUser.getUserID()));
            } else {
                devicesList = AnalysisUtil.getAllDetectList4Cluster(this.aticDeviceService, currentUser.getUserID());
            }
            zoneCompareFlow = this.processFinalZoneCompareData(devicesList, zoneCompareMemoryDataKey, zoneCompareTrafficService);
        } else {
            zoneCompareFlow = zoneCompareTrafficService.getZoneCompareTrafficData(zoneCompareMemoryDataKey);
        }
        return zoneCompareFlow;
    }

    private List<ZoneCompareTrafficObj> processFinalZoneCompareData(List<AticDevice> devicesList, ZoneCompareMemoryDataKey zoneCompareMemoryDataKey, IZoneCompareTrafficService zoneCompareTrafficService) {
        ArrayList<ZoneCompareTrafficObj> zoneCompareFlow = new ArrayList<ZoneCompareTrafficObj>();
        for (AticDevice firewall : devicesList) {
            zoneCompareMemoryDataKey.setDeviceIp(firewall.getIpAddress());
            List<ZoneCompareTrafficObj> tempList = zoneCompareTrafficService.getZoneCompareTrafficData(zoneCompareMemoryDataKey);
            if (null == tempList || tempList.isEmpty()) continue;
            zoneCompareFlow.addAll(tempList);
        }
        for (int i = 0; i < zoneCompareFlow.size(); ++i) {
            for (int j = zoneCompareFlow.size() - 1; j > i; --j) {
                if (((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getLogTime() != ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getLogTime()) continue;
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setInKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getInKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getInKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setInPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getInPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getInPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setOutKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getOutKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getOutKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setOutPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getOutPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getOutPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setTcpInFlowKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getTcpInFlowKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getTcpInFlowKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setTcpInFlowPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getTcpInFlowPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getTcpInFlowPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setTcpOutFlowKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getTcpOutFlowKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getTcpOutFlowKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setTcpOutFlowPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getTcpOutFlowPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getTcpOutFlowPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setUdpInFlowKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getUdpInFlowKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getUdpInFlowKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setUdpInFlowPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getUdpInFlowPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getUdpInFlowPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setUdpOutFlowKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getUdpOutFlowKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getUdpOutFlowKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setUdpOutFlowPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getUdpOutFlowPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getUdpOutFlowPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setIcmpInFlowKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getIcmpInFlowKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getIcmpInFlowKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setIcmpInFlowPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getIcmpInFlowPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getIcmpInFlowPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setIcmpOutFlowKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getIcmpOutFlowKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getIcmpOutFlowKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setIcmpOutFlowPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getIcmpOutFlowPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getIcmpOutFlowPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setOtherInFlowKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getOtherInFlowKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getOtherInFlowKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setOtherInFlowPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getOtherInFlowPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getOtherInFlowPps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setOtherOutFlowKbps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getOtherOutFlowKbps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getOtherOutFlowKbps());
                ((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).setOtherOutFlowPps(((ZoneCompareTrafficObj)zoneCompareFlow.get(i)).getOtherOutFlowPps() + ((ZoneCompareTrafficObj)zoneCompareFlow.get(j)).getOtherOutFlowPps());
                zoneCompareFlow.remove(j);
            }
        }
        return zoneCompareFlow;
    }

    private String[] getReportData4ZoneCompare(HomePageEntityForm homePageEntity) {
        String[] returnData = new String[3];
        ZoneCompareMemoryDataKey zoneCompareMemoryDataKey = new ZoneCompareMemoryDataKey();
        zoneCompareMemoryDataKey.setDeviceIp(homePageEntity.getDeviceIp());
        zoneCompareMemoryDataKey.setDeviceType(homePageEntity.getDeviceType());
        zoneCompareMemoryDataKey.setZoneId(homePageEntity.getZoneId());
        zoneCompareMemoryDataKey.setDirection(homePageEntity.getDirection());
        zoneCompareMemoryDataKey.setMax(false);
        if (null != homePageEntity.getStatisticType() && homePageEntity.getStatisticType() == 2) {
            zoneCompareMemoryDataKey.setMax(true);
        }
        if (!AticUtil.isNull((String)homePageEntity.getZoneIp())) {
            zoneCompareMemoryDataKey.setZoneIp(homePageEntity.getZoneIp());
        }
        List<ZoneCompareTrafficObj> reportData = this.sortListByField(this.getZoneCompareData(zoneCompareMemoryDataKey), "logTime", "ASC");
        int flowUnit = homePageEntity.getFlowUnit();
        String inData = "";
        String attackData = "";
        String forwardData = "";
        block12: for (int i = 0; i < reportData.size(); ++i) {
            int protocol = homePageEntity.getProtocol();
            switch (protocol) {
                case 1: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getTcpInFlowKbps() : reportData.get(i).getTcpInFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getTcpOutFlowKbps() : reportData.get(i).getTcpOutFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getTcpForwardFlowKbps() : reportData.get(i).getTcpForwardFlowPps()) + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 2: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getUdpInFlowKbps() : reportData.get(i).getUdpInFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getUdpOutFlowKbps() : reportData.get(i).getUdpOutFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getUdpForwardFlowKbps() : reportData.get(i).getUdpForwardFlowPps()) + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 3: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getIcmpInFlowKbps() : reportData.get(i).getIcmpInFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getIcmpOutFlowKbps() : reportData.get(i).getIcmpOutFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getIcmpForwardFlowKbps() : reportData.get(i).getIcmpForwardFlowPps()) + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 4: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getOtherInFlowKbps() : reportData.get(i).getOtherInFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getOtherOutFlowKbps() : reportData.get(i).getOtherOutFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getOtherForwardFlowKbps() : reportData.get(i).getOtherForwardFlowPps()) + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 5: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getTcpFragInFlowKbps() : reportData.get(i).getTcpFragInFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getTcpFragOutFlowKbps() : reportData.get(i).getTcpFragOutFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getTcpFragForwardFlowKbps() : reportData.get(i).getTcpFragForwardFlowPps()) + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 6: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getUdpFragInFlowKbps() : reportData.get(i).getUdpFragInFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getUdpFragOutFlowKbps() : reportData.get(i).getUdpFragOutFlowPps()) + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getUdpFragForwardFlowKbps() : reportData.get(i).getUdpFragForwardFlowPps()) + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 7: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getSynInFlowPps() + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getSynInFlowPps() + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getSynForwardFlowPps() + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 8: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getSynAckInFlowPps() + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getSynAckOutFlowPps() + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getSynAckForwardFlowPps() + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 9: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getAckInFlowPps() + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getAckOutFlowPps() + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getAckForwardFlowPps() + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                case 10: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getFinRstInFlowPps() + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getFinRstOutFlowPps() + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + reportData.get(i).getFinRstForwardFlowPps() + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                    continue block12;
                }
                default: {
                    inData = inData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getInKbps() : reportData.get(i).getInPps()) + "]";
                    if (i < reportData.size() - 1) {
                        inData = inData + ",";
                    }
                    attackData = attackData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getOutKbps() : reportData.get(i).getOutPps()) + "]";
                    if (i < reportData.size() - 1) {
                        attackData = attackData + ",";
                    }
                    forwardData = forwardData + "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getForwardKbps() : reportData.get(i).getForwardPps()) + "]";
                    if (i >= reportData.size() - 1) continue block12;
                    forwardData = forwardData + ",";
                }
            }
        }
        returnData[0] = inData;
        returnData[1] = attackData;
        returnData[2] = forwardData;
        return returnData;
    }

    private String[] getReportData4SecReport(HomePageEntityForm homePageEntity) {
        String[] returnData = new String[2];
        SecReportDataKey secReportDataKey = new SecReportDataKey();
        secReportDataKey.setDeviceIp(homePageEntity.getDeviceIp());
        secReportDataKey.setDeviceType(homePageEntity.getDeviceType());
        secReportDataKey.setDirection(homePageEntity.getDirection());
        if (!AticUtil.isNull((String)homePageEntity.getZoneIp())) {
            secReportDataKey.setZoneIp(IpTransformer.formatIpAddress((String)homePageEntity.getZoneIp()));
        }
        List<SecReportTrafficObject> data = this.homePageService.getSecReportData(secReportDataKey);
        List<SecReportTrafficObject> reportData = this.sortListByField2(data, "logTime", "ASC");
        int flowUnit = homePageEntity.getFlowUnit();
        StringBuffer inDataBuffer = new StringBuffer();
        StringBuffer outDataBuffer = new StringBuffer();
        String inData = "";
        String outData = "";
        for (int i = 0; i < reportData.size(); ++i) {
            inData = "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getInKbps() : reportData.get(i).getInPps()) + "]";
            if (i < reportData.size() - 1) {
                inData = inData + ",";
            }
            inDataBuffer.append(inData);
            outData = "[" + reportData.get(i).getLogTime() * 1000L + "," + (flowUnit == 1 ? reportData.get(i).getOutKbps() : reportData.get(i).getOutPps()) + "]";
            if (i < reportData.size() - 1) {
                outData = outData + ",";
            }
            outDataBuffer.append(outData);
        }
        returnData[0] = inDataBuffer.toString();
        returnData[1] = outDataBuffer.toString();
        return returnData;
    }

    private String getReportFlowJson4ZoneCompare(HomePageEntityForm homePageEntity) {
        String unit;
        if (3 == homePageEntity.getDirection()) {
            String unit2;
            homePageEntity.setDirection(1);
            String[] inboundReportData = this.getReportData4ZoneCompare(homePageEntity);
            homePageEntity.setDirection(2);
            String[] outboundReportData = this.getReportData4ZoneCompare(homePageEntity);
            int flowUnit = homePageEntity.getFlowUnit();
            int deviceType = homePageEntity.getDeviceType();
            String json = "";
            String inboundInData = inboundReportData[0];
            String inboundAttackData = inboundReportData[1];
            String inboundForwardData = inboundReportData[2];
            String outboundInData = outboundReportData[0];
            String outboundAttackData = outboundReportData[1];
            String outboundForwardData = outboundReportData[2];
            String string = unit2 = flowUnit == 1 ? "(kbps)" : "(pps)";
            if (1 == deviceType) {
                String inboundDetectFluxStr = this.getText("atic.homepage.common.directionType.inbound") + " " + this.getText("atic.homepage.common.in") + " " + unit2;
                String outboundDetectFluxStr = this.getText("atic.homepage.common.directionType.outbound") + " " + this.getText("atic.homepage.common.in") + " " + unit2;
                json = "{label: '" + inboundDetectFluxStr + "', color: 'rgb(77,130,249)', data: [" + inboundInData + "]}#";
                json = json + "{label: '" + outboundDetectFluxStr + "', color: 'rgb(255,0,255)', data: [" + outboundInData + "]}";
            }
            if (0 == deviceType) {
                String inboundInFluxStr = this.getText("atic.homepage.common.directionType.inbound") + " " + this.getText("atic.homepage.common.in") + " " + unit2;
                String inboundAttackFluxStr = this.getText("atic.homepage.common.directionType.inbound") + " " + this.getText("atic.homepage.common.attack") + " " + unit2;
                String inboundForwardFluxStr = this.getText("atic.homepage.common.directionType.inbound") + " " + this.getText("atic.homepage.common.out") + " " + unit2;
                String outboundInFluxStr = this.getText("atic.homepage.common.directionType.outbound") + " " + this.getText("atic.homepage.common.in") + " " + unit2;
                String outboundAttackFluxStr = this.getText("atic.homepage.common.directionType.outbound") + " " + this.getText("atic.homepage.common.attack") + " " + unit2;
                String outboundForwardFluxStr = this.getText("atic.homepage.common.directionType.outbound") + " " + this.getText("atic.homepage.common.out") + " " + unit2;
                json = "{label: '" + inboundInFluxStr + "', color: 'rgb(77,130,249)', data: [" + inboundInData + "]}#";
                json = json + "{label: '" + inboundAttackFluxStr + "', color: 'rgb(209,78,57)', data: [" + inboundAttackData + "]}#";
                json = json + "{label: '" + inboundForwardFluxStr + "', color: 'rgb(94,237,79)', data: [" + inboundForwardData + "]}#";
                json = json + "{label: '" + outboundInFluxStr + "', color: 'rgb(0,255,255)', data: [" + outboundInData + "]}#";
                json = json + "{label: '" + outboundAttackFluxStr + "', color: 'rgb(255,0,255)', data: [" + outboundAttackData + "]}#";
                json = json + "{label: '" + outboundForwardFluxStr + "', color: 'rgb(255,255,0)', data: [" + outboundForwardData + "]}";
            }
            return json;
        }
        String[] reportData = this.getReportData4ZoneCompare(homePageEntity);
        int flowUnit = homePageEntity.getFlowUnit();
        int deviceType = homePageEntity.getDeviceType();
        String json = "";
        String inData = reportData[0];
        String attackData = reportData[1];
        String forwardData = reportData[2];
        String string = unit = flowUnit == 1 ? "(kbps)" : "(pps)";
        if (1 == deviceType) {
            String detectFluxStr = this.getText("atic.homepage.common.in") + " " + unit;
            json = "{label: '" + detectFluxStr + "', color: 'rgb(77,130,249)', data: [" + inData + "]}#";
        }
        if (0 == deviceType) {
            String inFluxStr = this.getText("atic.homepage.common.in") + " " + unit;
            String attackFluxStr = this.getText("atic.homepage.common.attack") + " " + unit;
            String forwardFluxStr = this.getText("atic.homepage.common.out") + " " + unit;
            json = "{label: '" + inFluxStr + "', color: 'rgb(77,130,249)', data: [" + inData + "]}#";
            json = json + "{label: '" + attackFluxStr + "', color: 'rgb(209,78,57)', data: [" + attackData + "]}#";
            json = json + "{label: '" + forwardFluxStr + "', color: 'rgb(94,237,79)', data: [" + forwardData + "]}";
        }
        return json;
    }

    private String getReportFlowJson4Interface(HomePageEntityForm homePageEntity) {
        IfMemoryDataKey ifMemoryDataKey = new IfMemoryDataKey();
        ifMemoryDataKey.setDeviceIp(homePageEntity.getDeviceIp());
        ifMemoryDataKey.setIfIndex(homePageEntity.getIfIndex());
        List<DevTrafficObj> reportData = this.sortListByField4If(this.devIfTrafficService.getDevIfTrafficData(ifMemoryDataKey), "monitorTime", "ASC");
        int flowUnit = homePageEntity.getFlowUnit();
        String json = "";
        String inData = "";
        String outData = "";
        StringBuffer buf = new StringBuffer();
        StringBuffer buf1 = new StringBuffer();
        for (int i = 0; i < reportData.size(); ++i) {
            buf1.append('[');
            buf1.append(reportData.get(i).getMonitorTime());
            buf1.append(',');
            buf1.append(flowUnit == 1 ? reportData.get(i).getInKbps() : reportData.get(i).getInPps());
            buf1.append(']');
            if (i < reportData.size() - 1) {
                buf1.append(',');
            }
            buf.append('[');
            buf.append(reportData.get(i).getMonitorTime());
            buf.append(',');
            buf.append(flowUnit == 1 ? reportData.get(i).getOutKbps() : reportData.get(i).getOutPps());
            buf.append(']');
            if (i >= reportData.size() - 1) continue;
            buf.append(',');
        }
        inData = buf1.toString();
        outData = buf.toString();
        String unit = flowUnit == 1 ? "(kbps)" : "(pps)";
        String inFluxStr = this.getText("atic.homepage.common.in") + " " + unit;
        String outFluxStr = this.getText("atic.homepage.common.out") + " " + unit;
        json = "{label: '" + outFluxStr + "', color: 'rgb(94,237,79)', data: [" + outData + "]}#";
        json = json + "{label: '" + inFluxStr + "', color: 'rgb(77,130,249)', data: [" + inData + "]}";
        return json;
    }

    private String getReportFlowJson4Device(HomePageEntityForm homePageEntity) {
        IfMemoryDataKey ifMemoryDataKey = new IfMemoryDataKey();
        ifMemoryDataKey.setDeviceIp(homePageEntity.getDeviceIp());
        ifMemoryDataKey.setIfIndex(-1);
        this.readDevConfFile();
        AticDevice device = this.aticDeviceService.getDeviceByIp(homePageEntity.getDeviceIp());
        String deviceModel = device.getDeviceModel();
        int deviceCpu = device.getCpuNumber();
        double performance = deviceModel.startsWith("AntiDDoS8") ? (double)deviceCpu * singleCpuOf8000 * 1000.0 * 1000.0 : singleCpuOf1600 * 1000.0 * 1000.0;
        performance = (int)performance;
        List<DevTrafficObj> reportData = this.sortListByField4If(this.devIfTrafficService.getDevIfTrafficData(ifMemoryDataKey), "monitorTime", "ASC");
        String json = "";
        String inData = "";
        String outData = "";
        StringBuffer buf = new StringBuffer();
        StringBuffer buf1 = new StringBuffer();
        for (int i = 0; i < reportData.size(); ++i) {
            buf1.append('[');
            buf1.append(reportData.get(i).getMonitorTime());
            buf1.append(',');
            buf1.append(reportData.get(i).getInPps());
            buf1.append(']');
            if (i < reportData.size() - 1) {
                buf1.append(',');
            }
            buf.append('[');
            buf.append(reportData.get(i).getMonitorTime());
            buf.append(',');
            buf.append(performance);
            buf.append(']');
            if (i >= reportData.size() - 1) continue;
            buf.append(',');
        }
        inData = buf1.toString();
        outData = buf.toString();
        String unit = "(pps)";
        String inFluxStr = this.getText("atic.homepage.common.in") + " " + unit;
        String outFluxStr = this.getText("atic.homepage.common.deviceperf") + " " + unit;
        json = "{label: '" + inFluxStr + "', color: 'rgb(77,130,249)', data: [" + inData + "]}#";
        json = json + "{label: '" + outFluxStr + "', color: 'rgb(94,237,79)', data: [" + outData + "]}";
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDevConfFile() {
        Object object = LOCK;
        synchronized (object) {
            FileInputStream fin = null;
            try {
                String currentPath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "LegoRuntime" + File.separator + "devconfig" + File.separator + "devConf.properties";
                logger.info((Object)"readDevConfFile OK");
                fin = new FileInputStream(currentPath);
                config.load(fin);
                HomepageAction.setSingleCpuOf8000(defaultCpu);
                HomepageAction.setSingleCpuOf1600(defaultCpu);
                HomepageAction.setSingleCpuOf8000(Double.parseDouble(config.getProperty(ANTIDDOS_8000, String.valueOf(defaultCpu))));
                HomepageAction.setSingleCpuOf1600(Double.parseDouble(config.getProperty(ANTIDDOS_1600, String.valueOf(defaultCpu))));
                logger.info((Object)("read conf file finished, the singleCpuOf8000 is " + singleCpuOf8000 + " and the singleCpuOf1600 is " + singleCpuOf1600));
            }
            catch (IOException e) {
                logger.error((Object)"readDevConfFile exception.");
            }
            catch (NumberFormatException e) {
                logger.error((Object)"NumberFormatException", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"readDevConfFile exception.", (Throwable)e);
            }
            finally {
                try {
                    if (null != fin) {
                        fin.close();
                    }
                }
                catch (IOException ex) {
                    logger.error((Object)"readDevConfFile close FileInputStream error.");
                }
            }
        }
    }

    private String getReportFlowJson4IpFlowSecReport(HomePageEntityForm homePageEntity) {
        String unit;
        String[] reportData = this.getReportData4SecReport(homePageEntity);
        int flowUnit = homePageEntity.getFlowUnit();
        int deviceType = homePageEntity.getDeviceType();
        String json = "";
        String inData = reportData[0];
        String outData = reportData[1];
        String string = unit = flowUnit == 1 ? "(kbps)" : "(pps)";
        if (1 == deviceType) {
            String detectFluxStr = this.getText("atic.homepage.common.in") + " " + unit;
            json = "{label: '" + detectFluxStr + "', color: 'rgb(77,130,249)', data: [" + inData + "]}#";
        } else if (0 == deviceType) {
            String inFluxStr = this.getText("atic.homepage.common.in") + " " + unit;
            String outFluxStr = this.getText("atic.homepage.common.out") + " " + unit;
            json = "{label: '" + outFluxStr + "', color: 'rgb(94,237,79)', data: [" + outData + "]}#";
            json = json + "{label: '" + inFluxStr + "', color: 'rgb(77,130,249)', data: [" + inData + "]}";
        }
        return json;
    }

    public static int getInterval() {
        return interval;
    }

    public static int getInterval4ZoneCom() {
        return interval4ZoneCom;
    }

    public static void setInterval4ZoneCom(int interval4ZoneCom) {
        HomepageAction.interval4ZoneCom = interval4ZoneCom;
    }

    public static void setInterval(int interval) {
        HomepageAction.interval = interval;
    }

    public Long getHomePageEntityId() {
        return this.homePageEntityId;
    }

    public void setHomePageEntityId(Long homePageEntityId) {
        this.homePageEntityId = homePageEntityId;
    }

    public String[] getPortalIds() {
        if (null != this.portalIds) {
            return (String[])this.portalIds.clone();
        }
        return new String[0];
    }

    public void setPortalIds(String[] portalIds) {
        this.portalIds = null != portalIds ? (String[])portalIds.clone() : null;
    }

    public Long[] getIds() {
        if (null != this.ids) {
            return (Long[])this.ids.clone();
        }
        return new Long[0];
    }

    public void setIds(Long[] ids) {
        this.ids = null != ids ? (Long[])ids.clone() : null;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public List<VSMPlot> getVsmPlotList() {
        return this.vsmPlotList;
    }

    public void setVsmPlotList(List<VSMPlot> vsmPlotList) {
        this.vsmPlotList = vsmPlotList;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public Boolean getIsSnap() {
        return this.isSnap;
    }

    public void setIsSnap(Boolean isSnap) {
        this.isSnap = isSnap;
    }

    public List<HomePagePortalForm> getListHomePagePortal() {
        return this.listHomePagePortal;
    }

    public void setListHomePagePortal(List<HomePagePortalForm> listHomePagePortal) {
        this.listHomePagePortal = listHomePagePortal;
    }

    public List<HomePageView> getHomePageList() {
        return this.homePageList;
    }

    public void setHomePageList(List<HomePageView> homePageList) {
        this.homePageList = homePageList;
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public void setFirewallList(List<AticDevice> firewallList) {
        this.firewallList = firewallList;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public String getDefDeviceName() {
        return this.defDeviceName;
    }

    public void setDefDeviceName(String defDeviceName) {
        this.defDeviceName = defDeviceName;
    }

    public String getDefDeviceId() {
        return this.defDeviceId;
    }

    public void setDefDeviceId(String defDeviceId) {
        this.defDeviceId = defDeviceId;
    }

    public List<LangPair> getIfDeviceList() {
        return this.ifDeviceList;
    }

    public void setIfDeviceList(List<LangPair> ifDeviceList) {
        this.ifDeviceList = ifDeviceList;
    }

    public String getAllQueryDisplay() {
        return this.allQueryDisplay;
    }

    public void setAllQueryDisplay(String allQueryDisplay) {
        this.allQueryDisplay = allQueryDisplay;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public List<LangPair> getIfList() {
        return this.ifList;
    }

    public void setIfList(List<LangPair> ifList) {
        this.ifList = ifList;
    }

    public int getFlowTypeValue() {
        return this.flowTypeValue;
    }

    public void setFlowTypeValue(int flowTypeValue) {
        this.flowTypeValue = flowTypeValue;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public void setIfIndex(int ifIndex) {
        this.ifIndex = ifIndex;
    }

    public int getFlowUnitValue() {
        return this.flowUnitValue;
    }

    public void setFlowUnitValue(int flowUnitValue) {
        this.flowUnitValue = flowUnitValue;
    }

    public String getIfName() {
        return this.ifName;
    }

    public void setIfName(String ifName) {
        this.ifName = ifName;
    }

    public String getZoneDeviceId() {
        return this.zoneDeviceId;
    }

    public void setZoneDeviceId(String zoneDeviceId) {
        this.zoneDeviceId = zoneDeviceId;
    }

    public String getSecReportIp() {
        return this.secReportIp;
    }

    public void setSecReportIp(String secReportIp) {
        this.secReportIp = secReportIp;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public int getFlowType4Interval() {
        return this.flowType4Interval;
    }

    public void setFlowType4Interval(int flowType4Interval) {
        this.flowType4Interval = flowType4Interval;
    }

    public String[] getIfNames() {
        if (null != this.ifNames) {
            return (String[])this.ifNames.clone();
        }
        return new String[0];
    }

    public void setIfNames(String[] ifNames) {
        this.ifNames = null != ifNames ? (String[])ifNames.clone() : null;
    }

    public String[] getDeviceIps() {
        if (null != this.deviceIps) {
            return (String[])this.deviceIps.clone();
        }
        return new String[0];
    }

    public void setDeviceIps(String[] deviceIps) {
        this.deviceIps = null != deviceIps ? (String[])deviceIps.clone() : null;
    }

    public Long[] getZoneIds() {
        if (null != this.zoneIds) {
            return (Long[])this.zoneIds.clone();
        }
        return new Long[0];
    }

    public void setZoneIds(Long[] zoneIds) {
        this.zoneIds = null != zoneIds ? (Long[])zoneIds.clone() : null;
    }

    public Integer[] getFlowTypes() {
        if (null != this.flowTypes) {
            return (Integer[])this.flowTypes.clone();
        }
        return new Integer[0];
    }

    public void setFlowTypes(Integer[] flowTypes) {
        this.flowTypes = null != flowTypes ? (Integer[])flowTypes.clone() : null;
    }

    public int getPortalNum() {
        return this.portalNum;
    }

    public void setPortalNum(int portalNum) {
        this.portalNum = portalNum;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public String getCurrentPassCode() {
        return this.currentPassCode;
    }

    public void setCurrentPassCode(String currentPassCode) {
        this.currentPassCode = currentPassCode;
    }

    public int getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmType(int alarmType) {
        this.alarmType = alarmType;
    }

    public Long getAlarmZoneId() {
        return this.alarmZoneId;
    }

    public void setAlarmZoneId(Long alarmZoneId) {
        this.alarmZoneId = alarmZoneId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public int getTopnTypeValue() {
        return this.topnTypeValue;
    }

    public void setTopnTypeValue(int topnTypeValue) {
        this.topnTypeValue = topnTypeValue;
    }

    public String getTopnDeviceId() {
        return this.topnDeviceId;
    }

    public void setTopnDeviceId(String topnDeviceId) {
        this.topnDeviceId = topnDeviceId;
    }

    public Long getTopnZoneId() {
        return this.topnZoneId;
    }

    public void setTopnZoneId(Long topnZoneId) {
        this.topnZoneId = topnZoneId;
    }

    public int getInOrDropValue() {
        return this.inOrDropValue;
    }

    public void setInOrDropValue(int inOrDropValue) {
        this.inOrDropValue = inOrDropValue;
    }

    public List<LangPair> getTopnDeviceList() {
        return this.topnDeviceList;
    }

    public void setTopnDeviceList(List<LangPair> topnDeviceList) {
        this.topnDeviceList = topnDeviceList;
    }

    public int getRefreshButtonState() {
        return this.refreshButtonState;
    }

    public void setRefreshButtonState(int refreshButtonState) {
        this.refreshButtonState = refreshButtonState;
    }

    public int getStatisticTypeValue() {
        return this.statisticTypeValue;
    }

    public void setStatisticTypeValue(int statisticTypeValue) {
        this.statisticTypeValue = statisticTypeValue;
    }

    public static double getSingleCpuOf8000() {
        return singleCpuOf8000;
    }

    public static void setSingleCpuOf8000(double singleCpuOf8000) {
        HomepageAction.singleCpuOf8000 = singleCpuOf8000;
    }

    public static double getSingleCpuOf1600() {
        return singleCpuOf1600;
    }

    public static void setSingleCpuOf1600(double singleCpuOf1600) {
        HomepageAction.singleCpuOf1600 = singleCpuOf1600;
    }

    public List<AticDevice> getAntiDDoSDeviceList() {
        return this.antiDDoSDeviceList;
    }

    public void setAntiDDoSDeviceList(List<AticDevice> antiDDoSDeviceList) {
        this.antiDDoSDeviceList = antiDDoSDeviceList;
    }

    public String getDefDevName4DevMonitor() {
        return this.defDevName4DevMonitor;
    }

    public void setDefDevName4DevMonitor(String defDevName4DevMonitor) {
        this.defDevName4DevMonitor = defDevName4DevMonitor;
    }

    public String getDefDevId4DevMonitor() {
        return this.defDevId4DevMonitor;
    }

    public void setDefDevId4DevMonitor(String defDevId4DevMonitor) {
        this.defDevId4DevMonitor = defDevId4DevMonitor;
    }

    public Long getDevId4DevMonitor() {
        return this.devId4DevMonitor;
    }

    public void setDevId4DevMonitor(Long devId4DevMonitor) {
        this.devId4DevMonitor = devId4DevMonitor;
    }

    public List<LangPair> getDevList4DevMonitor() {
        return this.devList4DevMonitor;
    }

    public void setDevList4DevMonitor(List<LangPair> devList4DevMonitor) {
        this.devList4DevMonitor = devList4DevMonitor;
    }

    public List<LangPair> getDDoSList4SecReport() {
        return this.ddosList4SecReport;
    }

    public void setDDoSList4SecReport(List<LangPair> dDoSList4SecReport) {
        this.ddosList4SecReport = dDoSList4SecReport;
    }

    public String getDevId4SecReport() {
        return this.devId4SecReport;
    }

    public void setDevId4SecReport(String devId4SecReport) {
        this.devId4SecReport = devId4SecReport;
    }

    public int getDirectionValue() {
        return this.directionValue;
    }

    public void setDirectionValue(int directionValue) {
        this.directionValue = directionValue;
    }

    public String getIsSupportOutboundStr() {
        return this.isSupportOutboundStr;
    }

    public void setIsSupportOutboundStr(String isSupportOutboundStr) {
        this.isSupportOutboundStr = isSupportOutboundStr;
    }

    public int getStatisticType4IpTopn() {
        return this.statisticType4IpTopn;
    }

    public void setStatisticType4IpTopn(int statisticType4IpTopn) {
        this.statisticType4IpTopn = statisticType4IpTopn;
    }

    public int getTopnNum() {
        return this.topnNum;
    }

    public void setTopnNum(int topnNum) {
        this.topnNum = topnNum;
    }

    public IHomePageService getHomePageService() {
        return this.homePageService;
    }

    public void setHomePageService(IHomePageService homePageService) {
        this.homePageService = homePageService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ILicenseOutboundService getLicenseOutboundService() {
        return this.licenseOutboundService;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public IDevIfTrafficService getDevIfTrafficService() {
        return this.devIfTrafficService;
    }

    public void setDevIfTrafficService(IDevIfTrafficService devIfTrafficService) {
        this.devIfTrafficService = devIfTrafficService;
    }

    public DataSourceStub getDataSourceStub() {
        return this.dataSourceStub;
    }

    public void setDataSourceStub(DataSourceStub dataSourceStub) {
        this.dataSourceStub = dataSourceStub;
    }

    public IDivertTacticsService getDivertTacticsService() {
        return this.divertTacticsService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public String getStatisticalDimensionTypeValue() {
        return this.statisticalDimensionTypeValue;
    }

    public void setStatisticalDimensionTypeValue(String statisticalDimensionTypeValue) {
        this.statisticalDimensionTypeValue = statisticalDimensionTypeValue;
    }

    public String getStatisticalDimensionType() {
        return this.statisticalDimensionType;
    }

    public void setStatisticalDimensionType(String statisticalDimensionType) {
        this.statisticalDimensionType = statisticalDimensionType;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public int getNewOrCurConnValue() {
        return this.newOrCurConnValue;
    }

    public void setNewOrCurConnValue(int newOrCurConnValue) {
        this.newOrCurConnValue = newOrCurConnValue;
    }

    public int getProtocolValue() {
        return this.protocolValue;
    }

    public void setProtocolValue(int protocolValue) {
        this.protocolValue = protocolValue;
    }

    public INpFilterService getNpFilterService() {
        return this.npFilterService;
    }

    public void setNpFilterService(INpFilterService npFilterService) {
        this.npFilterService = npFilterService;
    }

    static {
        config = new Properties();
        color.add("0,102,204");
        color.add("204,153,255");
        color.add("85,176,219");
        color.add("51,153,102");
        color.add("228,200,87");
        color.add("236,162,55");
        color.add("236,116,97");
        color.add("204,204,255");
        color.add("153,204,0");
        color.add("0,204,255");
    }

    private static class InnerClass<T>
    implements Comparator<FlowTopNForm>,
    Serializable {
        private static final long serialVersionUID = -1831473458738307038L;

        private InnerClass() {
        }

        @Override
        public int compare(FlowTopNForm o1, FlowTopNForm o2) {
            long o1Flow = 0L;
            long o2Flow = 0L;
            if (o1.getInOrDrop() == 1) {
                if (o1.getAvgOrPeak() == 1) {
                    if (o1.getUnit() == 1) {
                        o1Flow = o1.getInKbps();
                        o2Flow = o2.getInKbps();
                    } else if (o1.getUnit() == 2) {
                        o1Flow = o1.getInPps();
                        o2Flow = o2.getInPps();
                    } else if (o1.getUnit() == 3) {
                        o1Flow = o1.getCurrConn();
                        o2Flow = o2.getCurrConn();
                    } else if (o1.getUnit() == 4) {
                        o1Flow = o1.getNewConn();
                        o2Flow = o2.getNewConn();
                    }
                } else if (o1.getUnit() == 1) {
                    o1Flow = o1.getMaxInKbps();
                    o2Flow = o2.getMaxInKbps();
                } else if (o1.getUnit() == 2) {
                    o1Flow = o1.getMaxInPps();
                    o2Flow = o2.getMaxInPps();
                } else if (o1.getUnit() == 3) {
                    o1Flow = o1.getMaxCurrConn();
                    o2Flow = o2.getMaxCurrConn();
                } else if (o1.getUnit() == 4) {
                    o1Flow = o1.getMaxNewConn();
                    o2Flow = o2.getMaxNewConn();
                }
            } else if (o1.getInOrDrop() == 3) {
                if (o1.getUnit() == 1) {
                    o1Flow = o1.getMaxForwardKbps();
                    o2Flow = o2.getMaxForwardKbps();
                } else if (o1.getUnit() == 2) {
                    o1Flow = o1.getMaxForwardPps();
                    o2Flow = o2.getMaxForwardPps();
                } else if (o1.getUnit() == 3) {
                    o1Flow = o1.getMaxCurrConn();
                    o2Flow = o2.getMaxCurrConn();
                } else if (o1.getUnit() == 4) {
                    o1Flow = o1.getMaxNewConn();
                    o2Flow = o2.getMaxNewConn();
                }
            } else if (o1.getAvgOrPeak() == 1) {
                if (o1.getUnit() == 1) {
                    o1Flow = o1.getDropKbps();
                    o2Flow = o2.getDropKbps();
                } else if (o1.getUnit() == 2) {
                    o1Flow = o1.getDropPps();
                    o2Flow = o2.getDropPps();
                } else if (o1.getUnit() == 3) {
                    o1Flow = o1.getCurrConn();
                    o2Flow = o2.getCurrConn();
                } else if (o1.getUnit() == 4) {
                    o1Flow = o1.getNewConn();
                    o2Flow = o2.getNewConn();
                }
            } else if (o1.getUnit() == 1) {
                o1Flow = o1.getMaxDropKbps();
                o2Flow = o2.getMaxDropKbps();
            } else if (o1.getUnit() == 2) {
                o1Flow = o1.getMaxDropPps();
                o2Flow = o2.getMaxDropPps();
            } else if (o1.getUnit() == 3) {
                o1Flow = o1.getMaxCurrConn();
                o2Flow = o2.getMaxCurrConn();
            } else if (o1.getUnit() == 4) {
                o1Flow = o1.getMaxNewConn();
                o2Flow = o2.getMaxNewConn();
            }
            return o1Flow > o2Flow ? -1 : (o1Flow == o2Flow ? 0 : 1);
        }
    }
}

