/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.homepage.service;

import com.hs.atic.homepage.dao.HomePageDao;
import com.hs.atic.homepage.dao.HomePagePortalDao;
import com.hs.atic.homepage.form.HomePageEntityForm;
import com.hs.atic.homepage.form.HomePagePortalForm;
import com.hs.atic.homepage.model.HomePageEntity;
import com.hs.atic.homepage.model.HomePagePortal;
import com.hs.atic.homepage.util.TrafficData4IpFlowSecReport;
import com.hs.atic.sdk.homepage.model.SecReportDataKey;
import com.hs.atic.sdk.homepage.model.SecReportTrafficObject;
import com.hs.atic.sdk.homepage.service.IHomePageService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HomePageServiceImpl
implements IHomePageService {
    private static final int COMMAND_DEPLOY_SUCCESS = 0;
    private static final int DEVICE_CONNECT_FAILED = 1;
    private static final int COMMAND_DEPLOY_FAILED = 2;
    private static final int REACH_UPPER_LIMIT = 3;
    private HomePageDao homePageDao;
    private HomePagePortalDao homePagePortalDao;
    private IZoneService zoneService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DASHBOARD);

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public BatchOperationResult batchDelHomePageEntity(List<BatchOperation> boList, Long useId) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == boList) {
            return result;
        }
        if (!boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                try {
                    String[] detailPara;
                    String inOrDrop;
                    String[] detailPara2;
                    String deviceIpStr;
                    String[] detailPara3;
                    if (null == this.findById(bo.getTargetId())) {
                        this.logger.error((Object)("delete homePage : " + this.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                        ++fail;
                        bo.setErrorCode(571703L);
                        continue;
                    }
                    HomePageEntityForm form = this.findById(bo.getTargetId());
                    if (6 == form.getFlowType()) continue;
                    this.delById(bo.getTargetId(), useId);
                    String unit = this.getUnitStr(form.getFlowUnit());
                    if (1 == form.getFlowType()) {
                        detailPara3 = new String[]{form.getDeviceIp(), form.getIfName(), unit};
                        bo.setOptDetail("atic.homepage.common.delIfSummary");
                        bo.setDetailParam(detailPara3);
                    } else if (2 == form.getFlowType()) {
                        deviceIpStr = this.processDeviceIpStr4OpraLog(form);
                        String protocol = this.getProtocolStr(form.getProtocol());
                        if (AticUtil.isNull((String)form.getZoneIp())) {
                            detailPara2 = new String[]{this.processZoneName(form.getZoneId()), deviceIpStr, unit, protocol};
                            bo.setOptDetail("atic.homepage.common.delZoneNoIpSummary");
                            bo.setDetailParam(detailPara2);
                        } else {
                            detailPara2 = new String[]{this.processZoneName(form.getZoneId()), deviceIpStr, form.getZoneIp(), unit, protocol};
                            bo.setOptDetail("atic.homepage.common.delZoneSummary");
                            bo.setDetailParam(detailPara2);
                        }
                    } else if (4 == form.getFlowType()) {
                        deviceIpStr = this.processDeviceIpStr4OpraLog(form);
                        inOrDrop = "atic.homepage.common.in";
                        if (AticUtil.isNull((String)form.getZoneIp())) {
                            detailPara2 = new String[]{this.processZoneName(form.getZoneId()), deviceIpStr, inOrDrop, unit};
                            bo.setOptDetail("atic.homepage.common.delZoneDisNoIpSummary");
                            bo.setDetailParam(detailPara2);
                        } else {
                            detailPara2 = new String[]{this.processZoneName(form.getZoneId()), deviceIpStr, form.getZoneIp(), inOrDrop, unit};
                            bo.setOptDetail("atic.homepage.common.delZoneDisSummary");
                            bo.setDetailParam(detailPara2);
                        }
                    } else if (5 == form.getFlowType()) {
                        deviceIpStr = this.processDeviceIpStr4OpraLog(form);
                        inOrDrop = "atic.homepage.common.in";
                        String topnType = this.getTopnTypeStr(form.getTopnType());
                        if (form.getTopnType() == 1) {
                            detailPara = new String[]{topnType, deviceIpStr, inOrDrop, unit};
                            bo.setOptDetail("atic.homepage.common.delFlowTopNoZoneSummary");
                            bo.setDetailParam(detailPara);
                        } else {
                            detailPara = new String[]{topnType, deviceIpStr, this.processZoneName(form.getZoneId()), inOrDrop, unit};
                            bo.setOptDetail("atic.homepage.common.delFlowTopSummary");
                            bo.setDetailParam(detailPara);
                        }
                    } else if (3 == form.getFlowType()) {
                        String alarmTypeStr = this.getAlarmTypeStr(form.getDeviceType());
                        String zoneName = this.processZoneName(form.getZoneId());
                        String severityStr = this.getAlarmSeverity(form.getFlowUnit());
                        detailPara = new String[]{alarmTypeStr, zoneName, severityStr};
                        bo.setOptDetail("atic.homepage.common.delAlarmSummary");
                        bo.setDetailParam(detailPara);
                    } else if (7 == form.getFlowType()) {
                        detailPara3 = new String[]{form.getDeviceIp(), unit};
                        bo.setOptDetail("atic.homepage.common.delDeviceMonitor");
                        bo.setDetailParam(detailPara3);
                    } else if (8 == form.getFlowType()) {
                        deviceIpStr = this.processDeviceIpStr4OpraLog(form);
                        if (!AticUtil.isNull((String)form.getZoneIp())) {
                            String[] detailPara4 = new String[]{deviceIpStr, form.getZoneIp(), unit};
                            bo.setOptDetail("atic.homepage.common.delIpFlowSecReport");
                            bo.setDetailParam(detailPara4);
                            if (!this.isExistsSecReport(form)) {
                                this.undoDeploy(form);
                            }
                        }
                    }
                    this.logger.info((Object)("delete homePage : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (RuntimeException e) {
                    ++fail;
                    bo.setErrorCode(570507L);
                    this.logger.error((Object)("delete homePage : " + this.getcleanedMessage(bo.getTargetName()) + " failed"), (Throwable)e);
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("batch delete homePage result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    private String getProtocolStr(Integer protocolValue) {
        if (null == protocolValue) {
            return "atic.analysis.common.all";
        }
        String returnProtocol = "";
        switch (protocolValue) {
            case 1: {
                returnProtocol = "TCP";
                break;
            }
            case 2: {
                returnProtocol = "UDP";
                break;
            }
            case 3: {
                returnProtocol = "ICMP";
                break;
            }
            case 4: {
                returnProtocol = "OTHER";
                break;
            }
            case 5: {
                returnProtocol = "TCP Fragment";
                break;
            }
            case 6: {
                returnProtocol = "UDP Fragment";
                break;
            }
            case 7: {
                returnProtocol = "SYN";
                break;
            }
            case 8: {
                returnProtocol = "SYN-ACK";
                break;
            }
            case 9: {
                returnProtocol = "ACK";
                break;
            }
            case 10: {
                returnProtocol = "FIN/RST";
                break;
            }
            default: {
                returnProtocol = "atic.analysis.common.all";
            }
        }
        return returnProtocol;
    }

    private void undoDeploy(HomePageEntityForm form) {
        String cmd = null;
        String ip = form.getZoneIp();
        if (IPUtil.isIpv4((String)ip)) {
            cmd = "undo anti-ddos real-time-statistics ip " + ip;
        } else if (IPUtil.isIpv6((String)ip)) {
            cmd = "undo anti-ddos real-time-statistics ipv6 " + ip;
        } else {
            throw new LegoCheckedException(571707L);
        }
        ServiceContext context = ServiceContext.getInstance();
        IAticDeviceService aticDeviceService = (IAticDeviceService)context.getService("aticDeviceService", IAticDeviceService.class);
        AticDevice device = aticDeviceService.getDeviceByIp(form.getDeviceIp());
        int result = this.deployCmd(device, cmd);
        if (result == 1) {
            this.logger.error((Object)("failed to undo deploy command " + cmd + " on device " + device.getName() + ", telnet connection error."));
            throw new LegoCheckedException(660010L);
        }
        if (result == 2) {
            this.logger.error((Object)("failed to undo deploy command " + cmd + " on device " + device.getName() + ", command deploy error."));
            throw new LegoCheckedException(571806L);
        }
        this.logger.info((Object)("successful to undo deploy command " + cmd + " on device " + device.getName()));
    }

    private String getTopnTypeStr(int topnType) {
        String topnTypeStr = "";
        if (topnType == 1) {
            topnTypeStr = "atic.homepage.common.zoneTopn";
        } else if (topnType == 2) {
            topnTypeStr = "atic.homepage.common.ipTopn";
        } else if (topnType == 3) {
            topnTypeStr = "atic.homepage.common.locationTopn";
        } else if (topnType == 4) {
            topnTypeStr = "atic.homepage.common.connectionTopn";
        }
        return topnTypeStr;
    }

    private String getUnitStr(int unit) {
        String unitStr = "";
        if (unit == 1) {
            unitStr = "(kbps)";
        } else if (unit == 2) {
            unitStr = "(pps)";
        } else if (unit == 3) {
            unitStr = "atic.homepage.common.currConn";
        } else if (unit == 4) {
            unitStr = "atic.homepage.common.newConn";
        }
        return unitStr;
    }

    private String getAlarmTypeStr(int alarmType) {
        if (1 == alarmType) {
            return "atic.homepage.common.alarmType.ddos";
        }
        if (2 == alarmType) {
            return "atic.homepage.common.alarmType.other";
        }
        return "atic.homepage.common.alarmType.all";
    }

    private String getAlarmSeverity(int severity) {
        String returnStr = "";
        switch (severity) {
            case 1: {
                returnStr = "lego.fault.severity.warning";
                break;
            }
            case 2: {
                returnStr = "lego.fault.severity.minor";
                break;
            }
            case 3: {
                returnStr = "lego.fault.severity.major";
                break;
            }
            case 4: {
                returnStr = "lego.fault.severity.critical";
                break;
            }
            default: {
                returnStr = "lego.fault.severity.warning";
            }
        }
        return returnStr;
    }

    private String processDeviceIpStr4OpraLog(HomePageEntityForm homePageEntityForm) {
        String deviceIp = homePageEntityForm.getDeviceIp();
        return deviceIp;
    }

    private String processZoneName(Long zoneId) {
        if (0L == zoneId) {
            return "atic.analysis.common.all";
        }
        ZoneInfoForm zoneForm = this.zoneService.getById(zoneId);
        String zoneName = "";
        zoneName = null == zoneForm || "".equals(zoneForm.getZoneDesc()) ? "atic.analysis.common.unknownZone" : zoneForm.getZoneDesc();
        return zoneName;
    }

    private void setXYValue(List<HomePagePortal> orderList, int max1, int max2, int max3, HomePagePortal portal) {
        if (orderList.size() < 4) {
            if (max1 <= max2) {
                portal.setX(1);
                portal.setY(max1 + 1);
            } else {
                portal.setX(2);
                portal.setY(max2 + 1);
            }
        } else if (max1 <= max2 && max1 <= max3) {
            portal.setX(1);
            portal.setY(max1 + 1);
        } else if (max2 <= max1 && max2 <= max3) {
            portal.setX(2);
            portal.setY(max2 + 1);
        } else if (max3 <= max1 && max3 <= max2) {
            portal.setX(3);
            portal.setY(max3 + 1);
        }
    }

    @Override
    public void delById(Long id, Long useId) {
        try {
            this.homePageDao.remove(id);
            HomePagePortal portal = this.homePagePortalDao.getPortalByEntityId(id);
            if (portal == null) {
                this.logger.error((Object)"delById : portal is null");
                return;
            }
            List<HomePagePortal> list = this.homePagePortalDao.queryByUserId(useId);
            for (HomePagePortal item : list) {
                if (!portal.getX().equals(item.getX()) || portal.getY() >= item.getY()) continue;
                item.setY(item.getY() - 1);
                this.homePagePortalDao.update(item);
            }
            this.homePagePortalDao.deleteByEntityId(id);
            boolean needReLayOut = false;
            List<HomePagePortal> afterDelList = this.homePagePortalDao.queryByUserId(useId);
            if (!afterDelList.isEmpty() && afterDelList.size() <= 4) {
                for (HomePagePortal homePagePortal : afterDelList) {
                    if (homePagePortal.getX() <= 2 && homePagePortal.getY() <= 2) continue;
                    needReLayOut = true;
                    break;
                }
            }
            if (needReLayOut) {
                int portalIndex = 0;
                for (int i = 1; i < 3; ++i) {
                    for (int j = 1; j < 3; ++j) {
                        if (portalIndex >= afterDelList.size()) continue;
                        HomePagePortal temp = afterDelList.get(portalIndex);
                        temp.setX(i);
                        temp.setY(j);
                        this.homePagePortalDao.update(temp);
                        ++portalIndex;
                    }
                }
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("unknow exception:" + e));
        }
    }

    @Override
    public void delById(List<Long> ids) {
        try {
            for (Long id : ids) {
                this.homePageDao.remove(id);
                this.homePagePortalDao.deleteByEntityId(id);
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("unknow exception:" + e));
        }
    }

    private HomePageEntityForm findById(Long id) {
        HomePageEntity homePageEntity = this.homePageDao.get(id);
        HomePageEntityForm homePageEntityForm = (HomePageEntityForm)AticUtil.copyProperties((Object)homePageEntity, (Object)new HomePageEntityForm());
        return homePageEntityForm;
    }

    @Override
    public HomePageEntityForm findById(Long id, Map<String, String> queryMap) {
        HomePageEntityForm homePageEntityForm = null;
        HomePageEntity homePageEntity = this.homePageDao.get(id);
        if (null == homePageEntity) {
            this.logger.error((Object)("homePageEntity is null, homePageEntityId=" + id));
            return homePageEntityForm;
        }
        Long userId = homePageEntity.getUserId();
        String currencUserId = queryMap.get("userId");
        if (currencUserId != null && currencUserId.equals(String.valueOf(userId))) {
            homePageEntityForm = (HomePageEntityForm)AticUtil.copyProperties((Object)homePageEntity, (Object)new HomePageEntityForm());
        }
        return homePageEntityForm;
    }

    @Override
    public boolean isExists(HomePageEntityForm homePageEntity) {
        return this.homePageDao.isExists(homePageEntity);
    }

    public boolean isExistsSecReport(HomePageEntityForm homePageEntity) {
        List<HomePageEntity> list = this.homePageDao.queryExistingSecReport(homePageEntity);
        return list.size() > 0;
    }

    @Override
    public Paging getAllHomePageEntity(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.homePageDao.queryByPage(queryMap, start, pageSize);
        List entityList = page.getData();
        ArrayList<HomePageEntityForm> formList = new ArrayList<HomePageEntityForm>();
        for (HomePageEntity homePageEntity : entityList) {
            HomePageEntityForm form = new HomePageEntityForm();
            AticUtil.copyProperties((Object)homePageEntity, (Object)form);
            formList.add(form);
        }
        page.setData(formList);
        page.setCount(page.getCount());
        this.logger.info((Object)("query homepage list, size = " + formList.size()));
        return page;
    }

    @Override
    public Long saveHomePageEntity(HomePageEntityForm homePageEntityForm) {
        HomePageEntity homePageEntity = (HomePageEntity)AticUtil.copyProperties((Object)homePageEntityForm, (Object)new HomePageEntity());
        this.homePageDao.saveOrUpdate(homePageEntity);
        Long id = homePageEntity.getId();
        this.logger.info((Object)("save HomePageEntity, id is : " + id));
        this.saveHomePagePortal(homePageEntityForm.getUserId(), id);
        return id;
    }

    private void saveHomePagePortal(Long userId, Long homePageEntityId) {
        HomePagePortal homePagePortal = new HomePagePortal();
        homePagePortal.setHomePageEntityId(homePageEntityId);
        homePagePortal.setUserId(userId);
        this.addPortal(homePagePortal);
    }

    private Long addPortal(HomePagePortal portal) {
        List<HomePagePortal> list = this.homePagePortalDao.queryByUserId(portal.getUserId());
        int max1 = 0;
        int max2 = 0;
        int max3 = 0;
        for (HomePagePortal p : list) {
            if (p.getHomePageEntityId().equals(portal.getHomePageEntityId())) {
                return 0L;
            }
            if (list.size() < 4) {
                if (p.getX() == 1) {
                    max1 = p.getY();
                    continue;
                }
                max2 = p.getY();
                continue;
            }
            if (p.getX() == 1) {
                max1 = p.getY();
                continue;
            }
            if (p.getX() == 2) {
                max2 = p.getY();
                continue;
            }
            max3 = p.getY();
        }
        this.setXYValue(list, max1, max2, max3, portal);
        portal.setCollapsed(false);
        this.homePagePortalDao.saveOrUpdate(portal);
        return portal.getId();
    }

    @Override
    public List<HomePagePortalForm> getAllPortal(Map<String, String> queryMap) {
        Long userId = -1L;
        try {
            userId = Long.valueOf(queryMap.get("userId"));
        }
        catch (Exception e) {
            this.logger.error((Object)"Long.valueOf(queryMap.get(userId)) error", (Throwable)e);
        }
        List<HomePagePortal> returnList = this.homePagePortalDao.queryByUserId(userId);
        ArrayList<HomePagePortalForm> formList = new ArrayList<HomePagePortalForm>();
        for (HomePagePortal homePagePortal : returnList) {
            HomePagePortalForm form = new HomePagePortalForm();
            AticUtil.copyProperties((Object)homePagePortal, (Object)form);
            form.setCollapsed(false);
            formList.add(form);
        }
        this.logger.info((Object)("home portal list, size = " + returnList.size()));
        return formList;
    }

    public HomePageDao getHomePageDao() {
        return this.homePageDao;
    }

    public void setHomePageDao(HomePageDao homePageDao) {
        this.homePageDao = homePageDao;
    }

    public HomePagePortalDao getHomePagePortalDao() {
        return this.homePagePortalDao;
    }

    public void setHomePagePortalDao(HomePagePortalDao homePagePortalDao) {
        this.homePagePortalDao = homePagePortalDao;
    }

    @Override
    public void updataPortal(List<HomePagePortalForm> homePagePortalForm) {
        if (null == homePagePortalForm) {
            return;
        }
        for (HomePagePortalForm form : homePagePortalForm) {
            HomePagePortal p = this.homePagePortalDao.get(form.getId());
            if (p == null) continue;
            p.setX(form.getX());
            p.setY(form.getY());
            p.setCollapsed(form.getCollapsed());
            this.homePagePortalDao.update(p);
        }
    }

    @Override
    public List<HomePageEntityForm> getHomePageEntityByFlowType(int flowType) {
        List<HomePageEntity> returnList = this.homePageDao.queryByFlowType(flowType);
        ArrayList<HomePageEntityForm> formList = new ArrayList<HomePageEntityForm>();
        for (HomePageEntity homePagePortal : returnList) {
            HomePageEntityForm form = new HomePageEntityForm();
            AticUtil.copyProperties((Object)homePagePortal, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public void delByZoneId(List<Long> zoneIds) {
        if (null == zoneIds || zoneIds.isEmpty()) {
            return;
        }
        String zoneIdSet = "";
        StringBuffer buf = new StringBuffer();
        for (Long zoneId : zoneIds) {
            buf.append(zoneId + ",");
        }
        zoneIdSet = buf.toString();
        zoneIdSet = zoneIdSet.substring(0, zoneIdSet.length() - 1);
        List<HomePageEntity> result = this.homePageDao.queryByZoneId(zoneIdSet);
        for (HomePageEntity homePage : result) {
            this.delById(homePage.getId(), homePage.getUserId());
        }
    }

    public void delByDevIp(List<String> deviceIps) {
        if (null == deviceIps || deviceIps.isEmpty()) {
            return;
        }
        String deviceIpSet = "";
        StringBuffer buf = new StringBuffer();
        for (String deviceIp : deviceIps) {
            buf.append(deviceIp + ",");
        }
        deviceIpSet = buf.toString();
        deviceIpSet = deviceIpSet.substring(0, deviceIpSet.length() - 1);
        List<HomePageEntity> result = this.homePageDao.queryByDeviceIp(deviceIpSet);
        for (HomePageEntity homePage : result) {
            this.delById(homePage.getId(), homePage.getUserId());
        }
    }

    @Override
    public int deployCmd(AticDevice device, String command) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system");
        cmds.add(command);
        List cmdResults = null;
        Long moid = device.getMoId();
        int returnNum = -1;
        this.logger.info((Object)("begin to deploy cmd to device, the cmd is " + command + ", the device is " + device.getIpAddress()));
        try {
            for (int i = 0; i < 3; ++i) {
                if (returnNum != 0) {
                    cmdResults = CmdUtil.execCmds((long)moid, cmds);
                    this.logger.info((Object)cmdResults.toString());
                    returnNum = this.check(cmdResults);
                }
                if (returnNum != 0) {
                    continue;
                }
                break;
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("connection failed when deploy cmd, the cmd is " + command + ", the device is " + device.getIpAddress()));
            return 1;
        }
        if (returnNum == 2) {
            this.logger.error((Object)("deploy cmd failed, the cmd is " + command + ", the device is " + device.getIpAddress()));
        } else if (returnNum == 3) {
            this.logger.error((Object)("deploy cmd failed, the cmd is " + command + ", the device is " + device.getIpAddress() + ", the IP configured has reach the upper limit."));
        } else {
            this.logger.info((Object)"deploy cmd successful");
        }
        return returnNum;
    }

    private int check(List<String> cmdResults) {
        for (String cmdResult : cmdResults) {
            if (cmdResult.contains("Error:")) {
                return 2;
            }
            if (!cmdResult.contains("INFO: The IP number configured has reached the upper limit.")) continue;
            return 3;
        }
        return 0;
    }

    @Override
    public List<SecReportTrafficObject> getSecReportData(SecReportDataKey secReportDataKey) {
        this.logger.info((Object)("deviceIp: " + secReportDataKey.getDeviceIp() + ",deviceType:" + secReportDataKey.getDeviceType() + ",zoneIp:" + secReportDataKey.getZoneIp() + ",direction:" + secReportDataKey.getDirection()));
        return TrafficData4IpFlowSecReport.getInstance().getDataList(secReportDataKey);
    }

    @Override
    public int getNum(int flowType) {
        List<HomePageEntity> returnList = this.homePageDao.queryByFlowType(flowType);
        return returnList.size();
    }
}

