/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.homepage.util;

import com.hs.atic.homepage.form.HomePageEntityForm;
import com.hs.atic.homepage.util.TrafficData4IpFlowSecReport;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.homepage.model.SecReportDataKey;
import com.hs.atic.sdk.homepage.model.SecReportTrafficObject;
import com.hs.atic.sdk.homepage.model.ZoneCompareObj;
import com.hs.atic.sdk.homepage.service.IHomePageService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectSecReportTraffic {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DASHBOARD);

    public void collect() {
        List<ZoneCompareObj> secReportList = this.getSecReportObjList();
        try {
            if (secReportList.isEmpty()) {
                this.deleteOverdueDeviceData(secReportList);
                return;
            }
            IDataStatService dataStatService = CollectSecReportTraffic.getIDataStatService();
            List secReportDataList = dataStatService.queryDashboardData4SecReport(secReportList);
            if (secReportDataList == null || secReportDataList.isEmpty()) {
                this.deleteOverdueDeviceData(secReportList);
                return;
            }
            this.processData(secReportDataList);
            this.deleteOverdueDeviceData(secReportList);
        }
        catch (Exception e) {
            this.logger.error((Object)("When collect sec report traffic .The Objs are :" + this.getcleanedMessage(secReportList.toString()) + ". "), (Throwable)e);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<ZoneCompareObj> getSecReportObjList() {
        ArrayList<ZoneCompareObj> secReportList = new ArrayList<ZoneCompareObj>();
        IHomePageService iHomePageService = CollectSecReportTraffic.getIHomePageService();
        List<HomePageEntityForm> formList = iHomePageService.getHomePageEntityByFlowType(8);
        ServiceContext context = ServiceContext.getInstance();
        IAticDeviceService aticDeviceService = (IAticDeviceService)context.getService("aticDeviceService", IAticDeviceService.class);
        ICollectorDeviceService collectorDeviceService = (ICollectorDeviceService)context.getService("collectorDeviceService", ICollectorDeviceService.class);
        ICollectorService collectorService = (ICollectorService)context.getService("collectorService", ICollectorService.class);
        for (HomePageEntityForm form : formList) {
            this.processSingleDevice(secReportList, form, aticDeviceService, collectorDeviceService, collectorService);
        }
        return secReportList;
    }

    private void processSingleDevice(List<ZoneCompareObj> secReportList, HomePageEntityForm form, IAticDeviceService aticDeviceService, ICollectorDeviceService collectorDeviceService, ICollectorService collectorService) {
        AticDevice device = aticDeviceService.getDeviceByIp(form.getDeviceIp());
        if (null == device || null == device.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceIp = " + form.getDeviceIp()));
            return;
        }
        Long collectorId = collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,deviceId = " + device.getMoId()));
            return;
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            return;
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            return;
        }
        String collectorIp = collectorInfo.getIpAddress();
        ZoneCompareObj zoneCompareObj = new ZoneCompareObj();
        zoneCompareObj.setDeviceIp(form.getDeviceIp());
        zoneCompareObj.setDevType(form.getDeviceType().intValue());
        zoneCompareObj.setCollectorIp(collectorIp);
        zoneCompareObj.setDirection(form.getDirection().intValue());
        if (!AticUtil.isNull((String)form.getZoneIp())) {
            zoneCompareObj.setZoneIp(AticUtil.formatIpAddress((String)form.getZoneIp()));
        }
        secReportList.add(zoneCompareObj);
    }

    private static IHomePageService getIHomePageService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IHomePageService iHomePageService = (IHomePageService)context.getService("homePageServiceImpl", IHomePageService.class);
            if (iHomePageService != null) {
                return iHomePageService;
            }
            throw new LegoCheckedException(570506L);
        }
        throw new LegoCheckedException(570506L);
    }

    private static IDataStatService getIDataStatService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IDataStatService dataStatService = (IDataStatService)ServiceContext.getInstance().getService("dataStatService", IDataStatService.class);
            if (dataStatService != null) {
                return dataStatService;
            }
            throw new LegoCheckedException(570506L);
        }
        throw new LegoCheckedException(570506L);
    }

    private void deleteOverdueDeviceData(List<ZoneCompareObj> secReportList) {
        Map<SecReportDataKey, List<SecReportTrafficObject>> allSecReportDataMap = TrafficData4IpFlowSecReport.getInstance().getAllSecReportDataMap();
        if (secReportList == null || secReportList.isEmpty()) {
            allSecReportDataMap.clear();
            return;
        }
        ArrayList<String> deviceIpList = new ArrayList<String>();
        for (ZoneCompareObj temp : secReportList) {
            deviceIpList.add(temp.getDeviceIp());
        }
        Iterator<Map.Entry<SecReportDataKey, List<SecReportTrafficObject>>> iterator = allSecReportDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SecReportDataKey, List<SecReportTrafficObject>> entry = iterator.next();
            String deviceIp = entry.getKey().getDeviceIp();
            if (!deviceIpList.contains(deviceIp)) {
                iterator.remove();
                continue;
            }
            Boolean contain = false;
            SecReportDataKey key = entry.getKey();
            for (ZoneCompareObj temp : secReportList) {
                if (!deviceIp.equals(temp.getDeviceIp()) || key.getDeviceType() != temp.getDevType() || !key.getZoneIp().equals(temp.getZoneIp())) continue;
                contain = true;
                break;
            }
            if (!contain.booleanValue()) {
                iterator.remove();
                continue;
            }
            long twoHourBeforTime = System.currentTimeMillis() / 1000L - 7200L;
            Iterator<SecReportTrafficObject> iter = entry.getValue().iterator();
            while (iter.hasNext()) {
                if (iter.next().getLogTime() >= twoHourBeforTime) continue;
                iter.remove();
            }
        }
    }

    private void processData(List<SecReportTrafficObject> secReportDataList) {
        Map<SecReportDataKey, List<SecReportTrafficObject>> allSecReportDataMap = TrafficData4IpFlowSecReport.getInstance().getAllSecReportDataMap();
        for (SecReportTrafficObject item : secReportDataList) {
            List<Object> temp;
            SecReportDataKey secReportDataKey = new SecReportDataKey();
            secReportDataKey.setDeviceIp(item.getDeviceIp());
            secReportDataKey.setDeviceType(item.getDeviceType());
            secReportDataKey.setDirection(item.getDirection());
            if (!AticUtil.isNull((String)item.getZoneIp())) {
                secReportDataKey.setZoneIp(item.getZoneIp());
            }
            if (allSecReportDataMap.containsKey(secReportDataKey)) {
                temp = allSecReportDataMap.get(secReportDataKey);
                if (null == temp || temp.isEmpty()) {
                    allSecReportDataMap.remove(secReportDataKey);
                    continue;
                }
                long lastLogTime = ((SecReportTrafficObject)temp.get(temp.size() - 1)).getLogTime();
                if (lastLogTime == item.getLogTime()) continue;
                allSecReportDataMap.get(secReportDataKey).add(item);
                continue;
            }
            temp = new ArrayList();
            temp.add(item);
            allSecReportDataMap.put(secReportDataKey, temp);
        }
    }
}

