/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.homepage.util;

import com.hs.atic.homepage.form.HomePageEntityForm;
import com.hs.atic.homepage.util.DevIfData4IfFlow;
import com.hs.atic.sdk.homepage.model.DevTrafficObj;
import com.hs.atic.sdk.homepage.model.DeviceObj;
import com.hs.atic.sdk.homepage.model.IfMemoryDataKey;
import com.hs.atic.sdk.homepage.service.IHomePageService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.Interface;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MonitorDevTraffic {
    private Map<String, List<DevTrafficObj>> deviceTrafficMap = new HashMap<String, List<DevTrafficObj>>();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_DASHBOARD);
    private int monitorInterfaceTime = 3;

    public void monitor() {
        List<DeviceObj> deviceList = this.getDeviceObjList();
        if (deviceList.isEmpty()) {
            this.logger.info((Object)"deviceList is null");
            this.deviceTrafficMap.clear();
            Map<IfMemoryDataKey, List<DevTrafficObj>> allDevIfDataMap = DevIfData4IfFlow.getInstance().getAllDevIfDataMap();
            allDevIfDataMap.clear();
            return;
        }
        for (int i = 0; i < deviceList.size(); ++i) {
            DeviceObj dev = deviceList.get(i);
            try {
                List<DevTrafficObj> trafficList = this.monitorIfTraff(dev);
                if (null == trafficList || trafficList.isEmpty()) continue;
                this.processDevData4If(trafficList);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("When monitor decvice(" + dev.getDeviceIp() + ") traffic,some errors happened."), (Throwable)e);
            }
        }
        this.deleteLastDeviceTrafficMap(deviceList);
        this.deleteOverdueDeviceData(deviceList);
    }

    private List<DeviceObj> getDeviceObjList() {
        IHomePageService iHomePageService = MonitorDevTraffic.getIHomePageService();
        List<HomePageEntityForm> formList = iHomePageService.getHomePageEntityByFlowType(1);
        List<HomePageEntityForm> formList1 = iHomePageService.getHomePageEntityByFlowType(7);
        formList.removeAll(formList1);
        formList.addAll(formList1);
        HashMap<String, List> deviceIf = new HashMap<String, List>();
        for (HomePageEntityForm form : formList) {
            List nowList;
            if (deviceIf.containsKey(form.getDeviceIp())) {
                nowList = (List)deviceIf.get(form.getDeviceIp());
                List<Integer> temp = this.getInterfaceList(form);
                for (Integer index : temp) {
                    if (nowList.contains(index)) continue;
                    nowList.add(index);
                }
                continue;
            }
            nowList = this.getInterfaceList(form);
            if (nowList.isEmpty()) continue;
            deviceIf.put(form.getDeviceIp(), nowList);
        }
        ArrayList<DeviceObj> deviceList = new ArrayList<DeviceObj>();
        for (Map.Entry item : deviceIf.entrySet()) {
            DeviceObj obj = new DeviceObj();
            String deviceIp = (String)item.getKey();
            List ifList = (List)item.getValue();
            obj.setDeviceIp(deviceIp);
            obj.setIfIndex(ifList);
            deviceList.add(obj);
        }
        return deviceList;
    }

    private List<Integer> getInterfaceList(HomePageEntityForm form) {
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        if (-1 == form.getIfIndex()) {
            ServiceContext context = ServiceContext.getInstance();
            IAticDeviceService aticDeviceService = (IAticDeviceService)context.getService("aticDeviceService", IAticDeviceService.class);
            AticDevice device = aticDeviceService.getDeviceByIp(form.getDeviceIp());
            if (null == device) {
                return tempList;
            }
            List interfaceList = aticDeviceService.getIfNeedMonitor(device.getMoId());
            for (Interface item : interfaceList) {
                if (item.getIfDescr().contains(".")) continue;
                tempList.add(item.getIfIndex());
            }
        } else {
            tempList.add(form.getIfIndex());
        }
        return tempList;
    }

    private static IHomePageService getIHomePageService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IHomePageService iHomePageService = (IHomePageService)ServiceContext.getInstance().getService("homePageServiceImpl", IHomePageService.class);
            if (iHomePageService != null) {
                return iHomePageService;
            }
            throw new LegoCheckedException(570506L);
        }
        throw new LegoCheckedException(570506L);
    }

    private void deleteOverdueDeviceData(List<DeviceObj> deviceList) {
        Map<IfMemoryDataKey, List<DevTrafficObj>> allDevIfDataMap = DevIfData4IfFlow.getInstance().getAllDevIfDataMap();
        if (deviceList == null || deviceList.isEmpty()) {
            allDevIfDataMap.clear();
            return;
        }
        ArrayList<String> deviceIpList = new ArrayList<String>();
        for (DeviceObj temp : deviceList) {
            deviceIpList.add(temp.getDeviceIp());
        }
        Map<String, List<Integer>> deviceInterface = this.getDeviceInterface();
        Iterator<Map.Entry<IfMemoryDataKey, List<DevTrafficObj>>> iterator = allDevIfDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IfMemoryDataKey, List<DevTrafficObj>> entry = iterator.next();
            String deviceIp = entry.getKey().getDeviceIp();
            if (!deviceIpList.contains(deviceIp)) {
                iterator.remove();
                continue;
            }
            if (!deviceInterface.get(deviceIp).contains(entry.getKey().getIfIndex())) {
                iterator.remove();
            }
            long twoHourBeforTime = System.currentTimeMillis() / 1000L - 7200L;
            Iterator<DevTrafficObj> iter = entry.getValue().iterator();
            while (iter.hasNext()) {
                if (iter.next().getMonitorTime() / 1000L >= twoHourBeforTime) continue;
                iter.remove();
            }
        }
    }

    private void deleteLastDeviceTrafficMap(List<DeviceObj> deviceList) {
        Set<String> ipSet = this.deviceTrafficMap.keySet();
        Iterator<String> ipIterator = ipSet.iterator();
        while (ipIterator.hasNext()) {
            String ip = ipIterator.next();
            boolean isExist = false;
            for (int i = 0; i < deviceList.size(); ++i) {
                if (!deviceList.get(i).getDeviceIp().equals(ip)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            ipIterator.remove();
        }
    }

    private void processDevData4If(List<DevTrafficObj> trafficList) {
        Map<String, List<Integer>> deviceInterface = this.getDeviceInterface();
        Map<IfMemoryDataKey, List<DevTrafficObj>> allDevIfDataMap = DevIfData4IfFlow.getInstance().getAllDevIfDataMap();
        for (DevTrafficObj item : trafficList) {
            if (!deviceInterface.get(item.getDeviceIp()).contains(item.getIfIndex())) continue;
            IfMemoryDataKey ifMemoryDataKey = new IfMemoryDataKey();
            ifMemoryDataKey.setDeviceIp(item.getDeviceIp());
            ifMemoryDataKey.setIfIndex(item.getIfIndex());
            if (allDevIfDataMap.containsKey(ifMemoryDataKey)) {
                allDevIfDataMap.get(ifMemoryDataKey).add(item);
                continue;
            }
            ArrayList<DevTrafficObj> temp = new ArrayList<DevTrafficObj>();
            temp.add(item);
            allDevIfDataMap.put(ifMemoryDataKey, temp);
        }
    }

    private Map<String, List<Integer>> getDeviceInterface() {
        HashMap<String, List<Integer>> deviceInterface = new HashMap<String, List<Integer>>();
        IHomePageService iHomePageService = MonitorDevTraffic.getIHomePageService();
        List<HomePageEntityForm> formList = iHomePageService.getHomePageEntityByFlowType(1);
        List<HomePageEntityForm> formList1 = iHomePageService.getHomePageEntityByFlowType(7);
        formList.removeAll(formList1);
        formList.addAll(formList1);
        for (HomePageEntityForm form : formList) {
            if (deviceInterface.containsKey(form.getDeviceIp())) {
                ((List)deviceInterface.get(form.getDeviceIp())).add(form.getIfIndex());
                continue;
            }
            ArrayList<Integer> interfaceList = new ArrayList<Integer>();
            interfaceList.add(form.getIfIndex());
            deviceInterface.put(form.getDeviceIp(), interfaceList);
        }
        return deviceInterface;
    }

    private List<DevTrafficObj> monitorDevOriginalTraff(DeviceObj deviceObj) {
        ServiceContext context = ServiceContext.getInstance();
        IAticDeviceService aticDeviceService = (IAticDeviceService)context.getService("aticDeviceService", IAticDeviceService.class);
        AticDevice device = aticDeviceService.getDeviceByIp(deviceObj.getDeviceIp());
        ArrayList<DevTrafficObj> list = new ArrayList<DevTrafficObj>();
        if (5 == device.getDeviceType()) {
            for (Integer indexInteger : deviceObj.getIfIndex()) {
                String index = String.valueOf(indexInteger);
                ArrayList<String> oidList = new ArrayList<String>();
                oidList.add("1.3.6.1.2.1.2.2.1.10." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.16." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.11." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.12." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.17." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.18." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.8." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.2." + index);
                ArrayList<String> valueList = new ArrayList();
                for (int i = 0; i < this.monitorInterfaceTime; ++i) {
                    try {
                        valueList = aticDeviceService.snmpGet(oidList, device.getMoId());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("getSnmpAPI error, deviceIp: " + deviceObj.getDeviceIp()), (Throwable)e);
                    }
                    if (null != valueList && !valueList.isEmpty()) break;
                }
                if (null == valueList || valueList.isEmpty()) continue;
                list.addAll(this.processNFAInterfaceFlowList(valueList, deviceObj, indexInteger));
            }
        } else {
            for (Integer indexInteger : deviceObj.getIfIndex()) {
                String index = String.valueOf(indexInteger);
                ArrayList<String> oidList = new ArrayList<String>();
                oidList.add("1.3.6.1.2.1.31.1.1.1.6." + index);
                oidList.add("1.3.6.1.2.1.31.1.1.1.10." + index);
                oidList.add("1.3.6.1.2.1.31.1.1.1.7." + index);
                oidList.add("1.3.6.1.2.1.31.1.1.1.8." + index);
                oidList.add("1.3.6.1.2.1.31.1.1.1.9." + index);
                oidList.add("1.3.6.1.2.1.31.1.1.1.11." + index);
                oidList.add("1.3.6.1.2.1.31.1.1.1.12." + index);
                oidList.add("1.3.6.1.2.1.31.1.1.1.13." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.8." + index);
                oidList.add("1.3.6.1.2.1.2.2.1.2." + index);
                ArrayList<String> valueList = new ArrayList();
                for (int i = 0; i < this.monitorInterfaceTime; ++i) {
                    try {
                        valueList = aticDeviceService.snmpGet(oidList, device.getMoId());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("getSnmpAPI error, deviceIp: " + deviceObj.getDeviceIp()), (Throwable)e);
                    }
                    if (null != valueList && !valueList.isEmpty()) break;
                }
                if (null == valueList || valueList.isEmpty()) continue;
                list.addAll(this.processDdosInterfaceFlowList(valueList, deviceObj, indexInteger));
            }
        }
        if (list.isEmpty()) {
            this.logger.info((Object)("interface list is null,need add 0 data to memory,deviceIp:" + deviceObj.getDeviceIp()));
            this.processSnmpNoConnection(deviceObj);
        }
        return list;
    }

    private List<DevTrafficObj> processNFAInterfaceFlowList(List<String> valueList, DeviceObj deviceObj, Integer indexInteger) {
        ArrayList<DevTrafficObj> list = new ArrayList<DevTrafficObj>();
        try {
            long inKbps = Long.parseLong(valueList.get(0)) * 8L / 1024L;
            long outKbps = Long.parseLong(valueList.get(1)) * 8L / 1024L;
            long inPpsnu = Long.parseLong(valueList.get(2));
            long inPpsu = Long.parseLong(valueList.get(3));
            long inPps = inPpsnu + inPpsu;
            long outPpsnu = Long.parseLong(valueList.get(4));
            long outPpsu = Long.parseLong(valueList.get(5));
            long outPps = outPpsnu + outPpsu;
            int ifState = Integer.parseInt(valueList.get(6));
            String ifName = valueList.get(7);
            long logTime = System.currentTimeMillis();
            this.logger.info((Object)("Device Ip is : " + deviceObj.getDeviceIp() + ". Time is: " + logTime + ". Interface index is: " + indexInteger + "; Total inPPS number is: " + inPps + "; Total inKbps is: " + inKbps + "; Total outPPS number is: " + outPps + "; Total outKbps is: " + outKbps + ". "));
            DevTrafficObj trafficObj = new DevTrafficObj();
            trafficObj.setDeviceIp(deviceObj.getDeviceIp());
            trafficObj.setMonitorTime(logTime);
            trafficObj.setIfIndex(indexInteger);
            trafficObj.setIfName(ifName);
            trafficObj.setIfStatus(ifState);
            trafficObj.setInKbps(inKbps);
            trafficObj.setInPps(inPps);
            trafficObj.setOutKbps(outKbps);
            trafficObj.setOutPps(outPps);
            list.add(trafficObj);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("deviceIp:" + deviceObj.getDeviceIp() + ",index:" + indexInteger + ". unknow error:" + e));
        }
        return list;
    }

    private List<DevTrafficObj> processDdosInterfaceFlowList(List<String> valueList, DeviceObj deviceObj, Integer indexInteger) {
        ArrayList<DevTrafficObj> list = new ArrayList<DevTrafficObj>();
        try {
            long inKbps = Long.parseLong(valueList.get(0)) * 8L / 1024L;
            long outKbps = Long.parseLong(valueList.get(1)) * 8L / 1024L;
            long inPpsnu = Long.parseLong(valueList.get(2));
            long inPpsu = Long.parseLong(valueList.get(3));
            long inPpsb = Long.parseLong(valueList.get(4));
            long inPps = inPpsnu + inPpsu + inPpsb;
            long outPpsnu = Long.parseLong(valueList.get(5));
            long outPpsu = Long.parseLong(valueList.get(6));
            long outPpsb = Long.parseLong(valueList.get(7));
            long outPps = outPpsnu + outPpsu + outPpsb;
            int ifState = Integer.parseInt(valueList.get(8));
            String ifName = valueList.get(9);
            long logTime = System.currentTimeMillis();
            this.logger.info((Object)("Device Ip is : " + deviceObj.getDeviceIp() + ". Time is: " + logTime + ". Interface index is: " + indexInteger + "; Total inPPS number is: " + inPps + "; Total inKbps is: " + inKbps + "; Total outPPS number is: " + outPps + "; Total outKbps is: " + outKbps + ". "));
            DevTrafficObj trafficObj = new DevTrafficObj();
            trafficObj.setDeviceIp(deviceObj.getDeviceIp());
            trafficObj.setMonitorTime(logTime);
            trafficObj.setIfIndex(indexInteger);
            trafficObj.setIfName(ifName);
            trafficObj.setIfStatus(ifState);
            trafficObj.setInKbps(inKbps);
            trafficObj.setInPps(inPps);
            trafficObj.setOutKbps(outKbps);
            trafficObj.setOutPps(outPps);
            list.add(trafficObj);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("deviceIp:" + deviceObj.getDeviceIp() + ",index:" + indexInteger + ". unknow error:" + e));
        }
        return list;
    }

    private void processSnmpNoConnection(DeviceObj deviceObj) {
        ArrayList<DevTrafficObj> result = new ArrayList<DevTrafficObj>();
        long monitorTime = System.currentTimeMillis();
        DevTrafficObj totalTrafficObj = new DevTrafficObj();
        totalTrafficObj.setMonitorTime(monitorTime);
        totalTrafficObj.setIfIndex(Integer.valueOf(-1));
        totalTrafficObj.setDeviceIp(deviceObj.getDeviceIp());
        totalTrafficObj.setInKbps(0L);
        totalTrafficObj.setInPps(0L);
        totalTrafficObj.setOutKbps(0L);
        totalTrafficObj.setOutPps(0L);
        result.add(totalTrafficObj);
        for (Integer indexValue : deviceObj.getIfIndex()) {
            DevTrafficObj ifTrafficObj = new DevTrafficObj();
            ifTrafficObj.setMonitorTime(monitorTime);
            ifTrafficObj.setDeviceIp(deviceObj.getDeviceIp());
            ifTrafficObj.setIfIndex(indexValue);
            ifTrafficObj.setInKbps(0L);
            ifTrafficObj.setInPps(0L);
            ifTrafficObj.setOutKbps(0L);
            ifTrafficObj.setOutPps(0L);
            result.add(ifTrafficObj);
        }
        this.processDevData4If(result);
    }

    private List<DevTrafficObj> monitorIfTraff(DeviceObj device) {
        if (device == null) {
            return null;
        }
        List<DevTrafficObj> nowData = this.monitorDevOriginalTraff(device);
        if (nowData.isEmpty()) {
            return null;
        }
        List<DevTrafficObj> previousData = this.deviceTrafficMap.get(device.getDeviceIp());
        this.deviceTrafficMap.put(device.getDeviceIp(), nowData);
        if (null == previousData || nowData.size() != previousData.size()) {
            return null;
        }
        ArrayList<DevTrafficObj> result = new ArrayList<DevTrafficObj>();
        DevTrafficObj totalTrafficObj = new DevTrafficObj();
        totalTrafficObj.setMonitorTime(nowData.get(0).getMonitorTime());
        totalTrafficObj.setTrafficType(0);
        totalTrafficObj.setIfName("All");
        totalTrafficObj.setIfIndex(Integer.valueOf(-1));
        totalTrafficObj.setDeviceIp(device.getDeviceIp());
        result.add(totalTrafficObj);
        for (int i = 0; i < nowData.size(); ++i) {
            DevTrafficObj nowObj = nowData.get(i);
            DevTrafficObj ifTrafficObj = new DevTrafficObj();
            ifTrafficObj.setDeviceIp(nowObj.getDeviceIp());
            ifTrafficObj.setMonitorTime(nowObj.getMonitorTime());
            ifTrafficObj.setTrafficType(1);
            ifTrafficObj.setIfName(nowObj.getIfName());
            ifTrafficObj.setIfIndex(nowObj.getIfIndex());
            ifTrafficObj.setIfStatus(nowObj.getIfStatus());
            DevTrafficObj preObj = null;
            for (DevTrafficObj temObj : previousData) {
                if (!nowObj.getIfIndex().equals(temObj.getIfIndex())) continue;
                preObj = temObj;
                break;
            }
            if (preObj == null) {
                return null;
            }
            int intTime = (int)(nowObj.getMonitorTime() - preObj.getMonitorTime()) / 1000;
            if (intTime <= 0) {
                this.logger.info((Object)"nowData.get(i).getMonitorTime() - previousData.get(i).getMonitorTime() less than 0.");
                return null;
            }
            long inKbps = (nowObj.getInKbps() - preObj.getInKbps()) / (long)intTime;
            long inPps = (nowObj.getInPps() - preObj.getInPps()) / (long)intTime;
            long outKbps = (nowObj.getOutKbps() - preObj.getOutKbps()) / (long)intTime;
            long outPps = (nowObj.getOutPps() - preObj.getOutPps()) / (long)intTime;
            if (inKbps < 0L) {
                this.logger.info((Object)"InKbps less than 0.");
                return null;
            }
            if (inPps < 0L) {
                this.logger.info((Object)"InPps less than 0.");
                return null;
            }
            if (outKbps < 0L) {
                this.logger.info((Object)"OutKbps less than 0.");
                return null;
            }
            if (outPps < 0L) {
                this.logger.info((Object)"OutPps less than 0.");
                return null;
            }
            this.logger.info((Object)("Device Ip: " + device.getDeviceIp() + "; Time: " + nowObj.getMonitorTime() + "; Interface index: " + nowObj.getIfIndex() + "; InPPS: " + inPps + "; InKbps: " + inKbps + "; OutPPS: " + outPps + "; OutKbps: " + outKbps));
            ifTrafficObj.setInKbps(inKbps);
            ifTrafficObj.setInPps(inPps);
            ifTrafficObj.setOutKbps(outKbps);
            ifTrafficObj.setOutPps(outPps);
            result.add(ifTrafficObj);
            if (nowObj.getIfName().toLowerCase(Locale.getDefault()).contains("trunk") || nowObj.getIfName().toLowerCase(Locale.getDefault()).contains(".")) continue;
            totalTrafficObj.setInKbps(inKbps + totalTrafficObj.getInKbps());
            totalTrafficObj.setInPps(inPps + totalTrafficObj.getInPps());
            totalTrafficObj.setOutKbps(outKbps + totalTrafficObj.getOutKbps());
            totalTrafficObj.setOutPps(outPps + totalTrafficObj.getOutPps());
        }
        return result;
    }
}

