/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.backup;

import com.hs.atic.backup.util.BackupUtil;
import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.form.CmdResult;
import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.atic.sdk.backup.service.IATICConfigBackupService;
import com.hs.atic.sdk.backup.util.BackupCheckKit;
import com.hs.atic.sdk.backup.util.BackupConfigUtil;
import com.hs.atic.sdk.backup.util.MySQLMaintenance;
import com.hs.atic.sdk.backup.util.SystemCmdTool;
import com.hs.atic.sdk.system.service.DatabaseStatusService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class BackupResotre {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);
    private static BackupResotre instance = new BackupResotre();
    private static final String SERVICE_DDOS_LEGOMONITOR = "LEGOMonitor";
    private static final String SERVICE_DDOS_LEGOSERVICE = "LEGOService";
    private static final String SERVICE_DDOS_MYSQLSERVICE = "mysqlservice";
    private static final String SERVICE_DDOS_COLLECTOR = "DDOSCOLLECTORSVC";
    private static final String SERVICE_DDOS_COLLECTOR_MONITOR = "ATICCOLLECTORGUARDSERVICE";
    private static final int QUERY_SERVICE_NUMBER = 3;

    public boolean restoreDatebase(ConfigBackupDBBean configBackupDBBean) throws ConfigBackupException, InterruptedException {
        IATICConfigBackupService aticConfigBackupService = BackupUtil.getATICConfigBackupService();
        boolean result = false;
        boolean collMonitor = SystemCmdTool.queryServiceState(SERVICE_DDOS_COLLECTOR_MONITOR, SERVICE_DDOS_COLLECTOR_MONITOR, 3);
        boolean collector = SystemCmdTool.queryServiceState(SERVICE_DDOS_COLLECTOR, SERVICE_DDOS_COLLECTOR, 3);
        this.stopBackService(SERVICE_DDOS_LEGOMONITOR);
        if (!collMonitor) {
            this.stopBackService(SERVICE_DDOS_COLLECTOR_MONITOR);
        }
        this.stopBackService(SERVICE_DDOS_MYSQLSERVICE);
        result = aticConfigBackupService.recoveryDatabase(configBackupDBBean);
        logger.info((Object)("recoveryDatabase result is:" + result));
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            String path = AticInstallUtil.getInstance().getInstallPath();
            SystemCmdTool.chownFileLinux("mysql:mysql", path + File.separator + "mysql");
        }
        this.startBackService(SERVICE_DDOS_MYSQLSERVICE);
        this.monitorDatabase();
        this.stopBackService(SERVICE_DDOS_LEGOSERVICE);
        if (!collector) {
            this.stopBackService(SERVICE_DDOS_COLLECTOR);
            this.startBackService(SERVICE_DDOS_COLLECTOR);
        }
        this.startBackService(SERVICE_DDOS_LEGOSERVICE);
        this.checkBackServiceStartResult();
        this.startBackService(SERVICE_DDOS_LEGOMONITOR);
        if (!collMonitor) {
            this.startBackService(SERVICE_DDOS_COLLECTOR_MONITOR);
        }
        return result;
    }

    private boolean stopBackService(String stopService) throws ConfigBackupException, InterruptedException {
        logger.info((Object)"stopBackService start");
        String resultDetail = "";
        try {
            String cmdStopMonitor = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            if (1 == version) {
                if (SERVICE_DDOS_LEGOSERVICE.equals(stopService)) {
                    return true;
                }
                if (SERVICE_DDOS_COLLECTOR_MONITOR.equals(stopService) || SERVICE_DDOS_LEGOMONITOR.equals(stopService)) {
                    boolean changeFlag = SystemCmdTool.changeMonitorState4Linux(stopService, false);
                    if (!changeFlag) {
                        logger.error((Object)"stop montor failed.");
                        throw new ConfigBackupException(571650, new String[]{"stop monitor failed."});
                    }
                    logger.info((Object)"stop montor success.");
                    return true;
                }
                cmdStopMonitor = SystemCmdTool.getStopServiceCmd(stopService);
                CmdResult stopMonitorResult = BackupResotre.exeCmd(cmdStopMonitor);
                if (!stopMonitorResult.isSuccess().booleanValue()) {
                    throw new ConfigBackupException(571650, new String[]{stopMonitorResult.getErrorMessage()});
                }
                boolean done = SystemCmdTool.queryServiceState(stopService, "STOP_PENDING", 300);
                if (done) {
                    throw new ConfigBackupException(571651);
                }
                return true;
            }
            cmdStopMonitor = SystemCmdTool.getStopServiceCmd(stopService);
            CmdResult stopMonitorResult = BackupResotre.exeCmd(cmdStopMonitor);
            if (!stopMonitorResult.isSuccess().booleanValue()) {
                throw new ConfigBackupException(571650, new String[]{stopMonitorResult.getErrorMessage()});
            }
            boolean done = SystemCmdTool.queryServiceState(stopService, "STOP_PENDING", 300);
            if (!done) {
                throw new ConfigBackupException(571651);
            }
            return true;
        }
        catch (InterruptedException e) {
            logger.error((Object)resultDetail, (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)resultDetail, (Throwable)e);
        }
        return false;
    }

    private void monitorDatabase() throws ConfigBackupException {
        logger.info((Object)"begin to check the database status.");
        int fail = 0;
        DatabaseStatusService databaseStatusService = (DatabaseStatusService)ServiceContext.getInstance().getService("databaseStatusService", DatabaseStatusService.class);
        if (null == databaseStatusService) {
            logger.error((Object)"cannot get the databaseStatusService instance, so retry 3 times.");
            for (int i = 0; i < 3; ++i) {
                BackupResotre.sleep(5000L);
                databaseStatusService = (DatabaseStatusService)ServiceContext.getInstance().getService("databaseStatusService", DatabaseStatusService.class);
                if (null != databaseStatusService) break;
            }
            if (null == databaseStatusService) {
                logger.error((Object)"cannot get the databaseStatusService instance, so restart LEGO.");
                this.startBackService(SERVICE_DDOS_LEGOSERVICE);
            }
        }
        int status = -1;
        for (int j = 0; j < 3; ++j) {
            try {
                if (null != databaseStatusService) {
                    status = databaseStatusService.checkDatabaseStatus();
                }
                if (status <= -1) continue;
                break;
            }
            catch (Exception e) {
                logger.error((Object)(" check database status failed. exception:" + e.toString()));
                ++fail;
                this.startBackService(SERVICE_DDOS_MYSQLSERVICE);
                BackupResotre.sleep(5000L);
            }
        }
        if (fail > 2) {
            logger.error((Object)" check database status failed for more than 3 times.");
            this.startBackService(SERVICE_DDOS_MYSQLSERVICE);
        } else {
            logger.info((Object)"check the database status finished and the status is OK.");
        }
    }

    public static void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Sleeping has error happened.", (Throwable)e);
        }
    }

    private boolean startBackService(String startService) throws ConfigBackupException {
        logger.info((Object)("startBackService start" + startService));
        try {
            String cmdStartLgeoservice = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            if (1 == version) {
                if (SERVICE_DDOS_LEGOSERVICE.equals(startService)) {
                    return true;
                }
                if (SERVICE_DDOS_COLLECTOR_MONITOR.equals(startService) || SERVICE_DDOS_LEGOMONITOR.equals(startService)) {
                    boolean changeFlag = SystemCmdTool.changeMonitorState4Linux(startService, true);
                    if (!changeFlag) {
                        logger.error((Object)"start montor failed.");
                        throw new ConfigBackupException(571656, new String[]{"start monitor failed."});
                    }
                    logger.info((Object)"start montor success.");
                    return true;
                }
                cmdStartLgeoservice = SystemCmdTool.getStartServiceCmd(startService);
                CmdResult startLegoCmdResult = BackupResotre.exeCmd(cmdStartLgeoservice);
                if (!startLegoCmdResult.isSuccess().booleanValue()) {
                    throw new ConfigBackupException(571656, new String[]{startLegoCmdResult.getErrorMessage()});
                }
                boolean done = SystemCmdTool.queryServiceState(startService, "START_PENDING", 300);
                if (!done) {
                    throw new ConfigBackupException(571657);
                }
                return true;
            }
            cmdStartLgeoservice = SystemCmdTool.getStartServiceCmd(startService);
            CmdResult startLegoCmdResult = BackupResotre.exeCmd(cmdStartLgeoservice);
            if (!startLegoCmdResult.isSuccess().booleanValue()) {
                throw new ConfigBackupException(571656, new String[]{startLegoCmdResult.getErrorMessage()});
            }
            boolean done = SystemCmdTool.queryServiceState(startService, "START_PENDING", 300);
            if (!done) {
                throw new ConfigBackupException(571657);
            }
            return true;
        }
        catch (InterruptedException e) {
            ConfigBackupException ce = new ConfigBackupException(571665, (Throwable)e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void checkBackServiceStartResult() {
        boolean isDone = false;
        int count = 0;
        IATICConfigBackupService backupConfigService = null;
        try {
            while (!isDone) {
                logger.info((Object)("checkBackServiceStartResult-> count:" + ++count));
                try {
                    backupConfigService = BackupUtil.getATICConfigBackupService();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
                Thread.sleep(1000L);
                if (backupConfigService != null || count > 300) {
                    isDone = true;
                }
                if (count % 10 != 0) continue;
                this.checkDatabaseRun();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private boolean checkDatabaseRun() throws InterruptedException, ConfigBackupException {
        boolean result = false;
        result = SystemCmdTool.queryServiceState(SERVICE_DDOS_MYSQLSERVICE, "RUNNING", 5);
        if (result) {
            this.stopBackService(SERVICE_DDOS_LEGOSERVICE);
            this.startBackService(SERVICE_DDOS_MYSQLSERVICE);
            this.startBackService(SERVICE_DDOS_LEGOSERVICE);
        }
        return result;
    }

    public static BackupResotre getInstance() {
        return instance;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CmdResult exeCmd(String cmd) throws ConfigBackupException {
        CmdResult cmdResult;
        BufferedReader errorRead;
        BufferedReader read;
        InputStreamReader erInputStreamReader;
        InputStreamReader inputStreamReader;
        InputStream errorIn;
        block30: {
            String csn = Charset.defaultCharset().name();
            InputStream in = null;
            errorIn = null;
            inputStreamReader = null;
            erInputStreamReader = null;
            read = null;
            errorRead = null;
            cmdResult = new CmdResult();
            cmdResult.setCmd(cmd);
            cmdResult.setSuccess(true);
            try {
                logger.debug((Object)("exe cmd: " + cmd));
                Process p = null;
                int version = AticInstallUtil.getInstance().getAticInstallOS();
                if (1 == version) {
                    String[] cmdPama = new String[]{"/bin/sh", "-c", cmd};
                    p = Runtime.getRuntime().exec(cmdPama);
                } else {
                    p = Runtime.getRuntime().exec(cmd);
                }
                StringBuffer buffer = new StringBuffer();
                in = p.getInputStream();
                if (null != in) {
                    inputStreamReader = new InputStreamReader(in, csn);
                    read = new BufferedReader(inputStreamReader);
                    while (read.read() != -1) {
                        String line = read.readLine();
                        buffer.append(line);
                    }
                }
                cmdResult.setDisplayMessage(buffer.toString());
                logger.info((Object)("run result:" + cmdResult.getDisplayMessage()));
                StringBuffer errorBuffer = new StringBuffer();
                errorIn = p.getErrorStream();
                if (null != errorIn) {
                    erInputStreamReader = new InputStreamReader(errorIn, csn);
                    errorRead = new BufferedReader(erInputStreamReader);
                    while (errorRead.read() != -1) {
                        String line = errorRead.readLine();
                        errorBuffer.append(line);
                    }
                    if (errorBuffer.length() > 0) {
                        logger.error((Object)("errorBuffer content is:" + errorBuffer.toString()));
                    }
                }
                if (errorBuffer.length() > 0 && !errorBuffer.toString().contains("Using a password on the command line interface can be insecure")) {
                    cmdResult.setSuccess(false);
                    cmdResult.setErrorMessage(errorBuffer.toString());
                }
                if (null == in) break block30;
            }
            catch (UnsupportedEncodingException e) {
                try {
                    throw new ConfigBackupException(571636, new String[]{e.getMessage()}, e);
                    catch (IOException e2) {
                        throw new ConfigBackupException(571636, new String[]{e2.getMessage()}, e2);
                    }
                }
                catch (Throwable throwable) {
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (IOException e3) {
                            logger.error((Object)e3.getMessage(), (Throwable)e3);
                        }
                    }
                    if (null != inputStreamReader) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException e4) {
                            logger.error((Object)e4.getMessage(), (Throwable)e4);
                        }
                    }
                    if (null != read) {
                        try {
                            read.close();
                        }
                        catch (IOException e5) {
                            logger.error((Object)e5.getMessage(), (Throwable)e5);
                        }
                    }
                    BackupResotre.closeErrorStream(errorIn, errorRead, erInputStreamReader);
                    throw throwable;
                }
            }
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (null != inputStreamReader) {
            try {
                inputStreamReader.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (null != read) {
            try {
                read.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        BackupResotre.closeErrorStream(errorIn, errorRead, erInputStreamReader);
        return cmdResult;
    }

    private static void closeErrorStream(InputStream errorIn, BufferedReader errorRead, InputStreamReader erInputStreamReader) {
        if (null != errorRead) {
            try {
                errorRead.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (null != erInputStreamReader) {
            try {
                erInputStreamReader.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (null != errorIn) {
            try {
                errorIn.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        BackupCheckKit.setLogger(LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP));
        BackupConfigUtil.setLogger(LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP));
        MySQLMaintenance.setLogger(LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP));
        SystemCmdTool.setLogger(LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP));
    }
}

