/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.backup.action;

import com.hs.atic.backup.BackupResotre;
import com.hs.atic.backup.model.ProgressInfoBean;
import com.hs.atic.backup.util.BackUpExportCreateUtil;
import com.hs.atic.backup.util.BackUpImportParserUtil;
import com.hs.atic.backup.util.BackupUtil;
import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.form.BackupResult;
import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.atic.sdk.backup.service.IATICConfigBackupDBService;
import com.hs.atic.sdk.backup.service.IATICConfigBackupService;
import com.hs.atic.sdk.system.form.HaInfoForm;
import com.hs.atic.sdk.util.BasicInfoUtil;
import com.hs.atic.sdk.zone.util.ProgressManage;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.util.AticInstallUtil;
import com.opensymphony.xwork2.ActionContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;

public class ConfigBackupAction
extends BaseAction {
    public static final String CONFIG_RECOVERY = "atic.system.config.recovery.operation";
    public static final String CONFIG_DELETE = "atic.system.config.delete.operation";
    public static final String CONFIG_BACKUP = "atic.system.config.backup.operation";
    public static final String CONFIG_IMPORT = "atic.system.config.import.operation";
    public static final String CONFIG_EXPORT = "atic.system.config.export.operation";
    public static final String SYSTEM_STATE_CONFIRM = "atic.system.config.syatem.state.confirm.operation";
    private static final long serialVersionUID = 1769261705052273346L;
    private static final int ONE_THOUSAND = 1000;
    private static final String OVERLOAD = "Overload";
    private static final String XML_POST = ".xml";
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);
    private String backupdesc = null;
    private List<ConfigBackupDBBean> backupList = new ArrayList<ConfigBackupDBBean>();
    private List<ProgressInfoBean> recoverStepList = new ArrayList<ProgressInfoBean>();
    private File backupFile = null;
    private String backupFileName = "";
    private String uploadBackupdesc = null;
    private String sortType = null;
    private String sortField = null;
    private int configId = 0;
    private String fileName;
    private String passcode;
    private List<Integer> configFileIdList = new ArrayList<Integer>();
    private int downLoadFileId = 0;
    private String downLoadFileName = null;
    private int checkdMaxMoId = 0;
    private int checkdCountMoId = 0;
    private String downLoadFileWholeName = "";
    private String tempName = "";
    private String filePath = "";
    private String currentPassCode;
    private int importConfigBackupFileSize = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list() {
        ActionContext ctx = ActionContext.getContext();
        if (null != ctx) {
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            this.currentPassCode = request.getSession().getId();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.queryCommonReatime(map);
        }
        catch (Exception e) {
            this.backupList = new ArrayList<ConfigBackupDBBean>();
            this.total = 0;
        }
        finally {
            map.clear();
        }
        return "success";
    }

    public void checkState() {
        int state = 0;
        IATICConfigBackupService backupService = BackupUtil.getATICConfigBackupService();
        state = backupService.getCurrentSystemState();
        if (state == 0) {
            this.responseResult("success");
        } else {
            this.responseResult("error");
        }
    }

    public void responseError(String error) {
        this.responseResult(error);
    }

    public String rollBackConfig() {
        return "success";
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public String getCurrentPassCode() {
        return this.currentPassCode;
    }

    public void setCurrentPassCode(String currentPassCode) {
        this.currentPassCode = currentPassCode;
    }

    private void queryCommonReatime(Map<String, String> map) {
        IATICConfigBackupDBService backupConfigService = BackupUtil.getATICConfigBackupDBService();
        if (null == this.sortType) {
            this.sortType = "desc";
            this.sortField = "backupTime";
        }
        map.put("sortName", this.sortField);
        map.put("sortType", this.sortType);
        Paging paging1 = backupConfigService.getBackupConfigList(map, this.start, this.pageSize);
        this.backupList = paging1.getData();
        this.total = paging1.getCount();
    }

    public String backup() {
        return "success";
    }

    public String showImportFile() {
        logger.info((Object)"prepare to import config file info");
        return "success";
    }

    public void backupOper() {
        logger.info((Object)"backup start");
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        IATICConfigBackupDBService backupDBService = BackupUtil.getATICConfigBackupDBService();
        int count = backupDBService.getCountBackupConfig();
        if (count >= 1000) {
            this.responseResult(OVERLOAD);
            return;
        }
        IATICConfigBackupService backupService = BackupUtil.getATICConfigBackupService();
        ConfigBackupDBBean configBackupDBBean = new ConfigBackupDBBean();
        configBackupDBBean.setAdmin(currentUser.getUserName());
        configBackupDBBean.setFileDesc(this.backupdesc);
        try {
            BackupResult backupResult = backupService.backup(configBackupDBBean);
            if (backupResult.getReuslt() == 3) {
                this.processOpeLog(false, CONFIG_BACKUP);
            } else {
                this.processOpeLog(true, backupResult.getConfigBackup().getFileName(), CONFIG_BACKUP);
                this.responseResult("success");
            }
        }
        catch (ConfigBackupException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.processOpeLog(false, CONFIG_BACKUP);
            this.responseResult(BackupUtil.getExceptionText(this, e));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.processOpeLog(false, CONFIG_BACKUP);
            this.responseResult(BackupUtil.getExceptionText(this, e));
        }
    }

    public boolean checkBackupDesc() {
        String regex = "^(?!null$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\-|\\r|\\n]*$";
        if (AticUtil.isNull((String)this.backupdesc) || this.backupdesc.trim().length() > 500) {
            return false;
        }
        try {
            if (this.backupdesc.trim().equalsIgnoreCase("null")) {
                return false;
            }
            if (!this.backupdesc.trim().matches(regex)) {
                return false;
            }
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    public boolean isNameExisted(String configName) {
        IATICConfigBackupService configBackupService = BackupUtil.getATICConfigBackupService();
        ConfigBackupDBBean configBackupDBBean = configBackupService.getByName(configName);
        return null != configBackupDBBean;
    }

    public void uploadFile() {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        IATICConfigBackupService backupService = BackupUtil.getATICConfigBackupService();
        ConfigBackupDBBean configBackupDBBean = BackUpImportParserUtil.parseConfigImport(this.backupFile);
        if (this.isNameExisted(configBackupDBBean.getFileName())) {
            this.processOpeLog(false, CONFIG_IMPORT);
            this.responseResult(BackupUtil.getExceptionText(this, new LegoCheckedException(571675L)));
            return;
        }
        String currVersion = backupService.getCurrentVersion();
        if (null != currVersion && !currVersion.equalsIgnoreCase(configBackupDBBean.getVersion())) {
            this.processOpeLog(false, CONFIG_IMPORT);
            this.responseResult(BackupUtil.getExceptionText(this, new LegoCheckedException(571676L)));
            return;
        }
        configBackupDBBean.setAdmin(currentUser.getUserName());
        configBackupDBBean.setFileSource("file_upload");
        configBackupDBBean.setFileDesc(this.uploadBackupdesc);
        try {
            BackupResult backupResult = backupService.uploadBackupFile(configBackupDBBean);
            this.processOpeLog(true, backupResult.getConfigBackup().getFileName(), CONFIG_IMPORT);
            String importInfo = this.getText("atic.system.config.system.info.import").replaceFirst("\\{0\\}", configBackupDBBean.getBackupBase().replace("\\", "\\\\"));
            this.responseResult("success;" + importInfo);
        }
        catch (ConfigBackupException e) {
            this.processOpeLog(false, CONFIG_IMPORT);
            this.responseResult(BackupUtil.getExceptionText(this, e));
        }
    }

    public void downloadFile() {
        this.checkBeforeDownload(this.downLoadFileId, this.downLoadFileName);
        String downloadFileWholeName = "";
        IATICConfigBackupDBService backupDBService = BackupUtil.getATICConfigBackupDBService();
        StringBuffer path = new StringBuffer("attachment;filename=");
        StringBuffer result = new StringBuffer("success,");
        String sessionID = this.getSession().getId();
        ConfigBackupDBBean bean = backupDBService.findConfig(this.downLoadFileId);
        if (bean == null || null == BasicInfoUtil.getBasicInfo()) {
            this.responseResult(BackupUtil.getExceptionText(this, new LegoCheckedException(571674L)));
            return;
        }
        String installPath = null;
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        installPath = 1 == version ? AticInstallUtil.getInstance().getAticInstallPath() : AticInstallUtil.getInstance().getInstallPath();
        File file = new File(installPath + File.separator + "backup" + File.separator + bean.getFileName());
        path.append(file.getName() + XML_POST);
        this.filePath = file.getName() + XML_POST;
        bean.setAdmin(sessionID);
        downloadFileWholeName = installPath + File.separator + "backup" + File.separator + file.getName() + XML_POST;
        String exportInfo = this.getText("atic.system.config.system.info.export").replaceFirst("\\{0\\}", bean.getBackupBase().replace("\\", "\\\\"));
        result.append(downloadFileWholeName).append(',').append(this.downLoadFileName).append(',').append(path.toString()).append(',').append(exportInfo);
        ProgressState progressState = ProgressManage.getInstance().createProgress(5, System.currentTimeMillis());
        BackUpExportCreateUtil.createXml(bean, progressState);
        this.responseResult(result.toString());
    }

    public void checkBeforeDownload(Integer fileId, String downloadFileName) {
        if (AticUtil.isNull((String)downloadFileName)) {
            logger.error((Object)"downloadFileName is null");
            throw new LegoCheckedException(570505L);
        }
        String downLoadFileIdRegex = "^\\d++$";
        String downloadFileNameRegex = "^\\w[\\w-_]++$";
        String downloadFileNameRegexLinux = "^[/\\w-_]++$";
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version ? !fileId.toString().matches(downLoadFileIdRegex) || !downloadFileName.matches(downloadFileNameRegexLinux) : !fileId.toString().matches(downLoadFileIdRegex) || !downloadFileName.matches(downloadFileNameRegex)) {
            throw new LegoCheckedException(570505L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportFile() {
        int bytesRead;
        this.getResponse().setContentType("application/x-download");
        this.getResponse().addHeader("Content-Disposition", this.filePath);
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        fileInput = new FileInputStream(this.downLoadFileWholeName);
        bis = new BufferedInputStream(fileInput);
        bos = new BufferedOutputStream((OutputStream)this.getResponse().getOutputStream());
        byte[] buff = new byte[0x100000];
        while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
            bos.write(buff, 0, bytesRead);
        }
        this.processOpeLog(true, this.tempName, CONFIG_EXPORT);
        this.closeStream(bis, bos, fileInput);
        File fileTemp = new File(this.downLoadFileWholeName);
        if (!fileTemp.exists() || fileTemp.delete()) return;
        try {
            this.log.error((Object)("delete file failed.file : " + fileTemp.getCanonicalPath()));
            return;
        }
        catch (IOException e) {
            logger.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
        }
        return;
        catch (IOException e) {
            try {
                logger.error((Object)"downloadFile", (Throwable)e);
                this.processOpeLog(false, this.tempName, CONFIG_EXPORT);
                this.closeStream(bis, bos, fileInput);
                fileTemp = new File(this.downLoadFileWholeName);
                if (!fileTemp.exists() || fileTemp.delete()) return;
            }
            catch (Throwable throwable) {
                this.closeStream(bis, bos, fileInput);
                File fileTemp2 = new File(this.downLoadFileWholeName);
                if (!fileTemp2.exists() || fileTemp2.delete()) throw throwable;
                try {
                    this.log.error((Object)("delete file failed.file : " + fileTemp2.getCanonicalPath()));
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.error((Object)"getCanonicalPath() throws IOException", (Throwable)e2);
                }
                throw throwable;
            }
            try {
                this.log.error((Object)("delete file failed.file : " + fileTemp.getCanonicalPath()));
                return;
            }
            catch (IOException e3) {
                logger.error((Object)"getCanonicalPath() throws IOException", (Throwable)e3);
            }
            return;
        }
    }

    private void closeStream(BufferedInputStream bis, BufferedOutputStream bos, FileInputStream fileInput) {
        if (null != fileInput) {
            try {
                fileInput.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", (Throwable)e);
            }
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", (Throwable)e);
            }
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", (Throwable)e);
            }
        }
    }

    public void recoverFile() {
        if (this.configId < 0) {
            throw new LegoCheckedException(570505L);
        }
        IATICConfigBackupDBService backupDBService = BackupUtil.getATICConfigBackupDBService();
        logger.info((Object)("startRecovery:" + this.configId));
        ConfigBackupDBBean configBackupDBBean = null;
        configBackupDBBean = backupDBService.findConfig(this.configId);
        if (null != configBackupDBBean) {
            try {
                BackupResotre resotre = BackupResotre.getInstance();
                boolean result = resotre.restoreDatebase(configBackupDBBean);
                if (result) {
                    this.processOpeLog(true, configBackupDBBean.getFileName(), CONFIG_RECOVERY);
                    this.responseResult("success");
                } else {
                    this.processOpeLog(false, configBackupDBBean.getFileName(), CONFIG_RECOVERY);
                    this.responseResult("error");
                }
            }
            catch (ConfigBackupException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.processOpeLog(false, configBackupDBBean.getFileName(), CONFIG_RECOVERY);
                this.responseResult("error");
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.processOpeLog(false, configBackupDBBean.getFileName(), CONFIG_RECOVERY);
                this.responseResult("error");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.processOpeLog(false, configBackupDBBean.getFileName(), CONFIG_RECOVERY);
                this.responseResult("error");
            }
        }
    }

    public void deleteFile() {
        IATICConfigBackupService backupService = BackupUtil.getATICConfigBackupService();
        ArrayList<Integer> configIdList = new ArrayList<Integer>();
        configIdList.addAll(this.configFileIdList);
        this.batchOperationResult = backupService.deleteBackupFiles(configIdList);
        List batchOpResult = this.batchOperationResult.getResult();
        for (BatchOperation result : batchOpResult) {
            String deleteResult = result.getOptDetail();
            if (deleteResult.equalsIgnoreCase("success")) {
                this.processOpeLog(true, result.getTargetName(), CONFIG_DELETE);
                continue;
            }
            this.processOpeLog(false, result.getTargetName(), CONFIG_DELETE);
        }
        if (this.batchOperationResult.getFailCount() == 0) {
            this.responseResult("success");
        } else {
            this.bathResult(this.batchOperationResult);
            this.responseResult("error");
        }
    }

    public boolean checkConfigIdList() {
        if (null != this.configFileIdList) {
            for (Integer id : this.configFileIdList) {
                if (id >= 0) continue;
                return false;
            }
        }
        return true;
    }

    private void processOpeLog(Boolean sucess, String configName, String operation) {
        String fromState;
        ISysOptLog sysOptLogMgr = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        SysOptLog sysOptLogLego = new SysOptLog();
        String terminalIp = "127.0.0.1";
        String operator = "";
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTarget("atic.system.config.system.backup");
        sysOptLogLego.setTargetLocal(Boolean.valueOf(true));
        if (sucess.booleanValue()) {
            sysOptLogLego.setResult(1);
            fromState = operation;
            String toState = configName;
            sysOptLogLego.setDetail("atic.system.config.operation.success");
            String[] para = new String[]{fromState, toState};
            sysOptLogLego.setDetailPara(para);
        } else {
            sysOptLogLego.setResult(0);
            fromState = operation;
            String toState = configName;
            String[] para = new String[]{fromState, toState};
            sysOptLogLego.setDetailPara(para);
            sysOptLogLego.setDetail("atic.system.config.operation.failed");
        }
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    private void processOpeLog(Boolean sucess, String operation) {
        String fromState;
        ISysOptLog sysOptLogMgr = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "127.0.0.1";
        String operator = "";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTarget("atic.system.config.system.backup");
        sysOptLogLego.setTargetLocal(Boolean.valueOf(true));
        if (sucess.booleanValue()) {
            sysOptLogLego.setResult(1);
            fromState = operation;
            sysOptLogLego.setDetail("atic.system.config.operation.success1");
            String[] para = new String[]{fromState};
            sysOptLogLego.setDetailPara(para);
        } else {
            sysOptLogLego.setResult(0);
            fromState = operation;
            String[] para = new String[]{fromState};
            sysOptLogLego.setDetailPara(para);
            sysOptLogLego.setDetail("atic.system.config.operation.failed1");
        }
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    public int getImportConfigBackupFileSize() {
        return this.importConfigBackupFileSize;
    }

    public void setImportConfigBackupFileSize(int importConfigBackupFileSize) {
        this.importConfigBackupFileSize = importConfigBackupFileSize;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    public void setBackupFileName(String backupFileName) {
        this.backupFileName = backupFileName;
    }

    public void checkHAState() {
        HaInfoForm haInfo = BasicInfoUtil.hasHaService();
        String result = "0";
        if (haInfo.isInstall()) {
            result = haInfo.isIsStart() ? "1" : "2";
        }
        this.responseResult(result);
    }

    public String getBackupdesc() {
        return this.backupdesc;
    }

    public List<ProgressInfoBean> getRecoverStepList() {
        return this.recoverStepList;
    }

    public void setRecoverStepList(List<ProgressInfoBean> recoverStepList) {
        this.recoverStepList = recoverStepList;
    }

    public void setBackupdesc(String backupdesc) {
        this.backupdesc = backupdesc;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public void setBackupFile(File backupFile) {
        this.backupFile = backupFile;
    }

    public List<Integer> getConfigFileIdList() {
        return this.configFileIdList;
    }

    public void setConfigFileIdList(List<Integer> configFileIdList) {
        this.configFileIdList = configFileIdList;
    }

    public List<ConfigBackupDBBean> getBackupList() {
        return this.backupList;
    }

    public void setBackupList(List<ConfigBackupDBBean> backupList) {
        this.backupList = backupList;
    }

    public int getConfigId() {
        return this.configId;
    }

    public void setConfigId(int configId) {
        this.configId = configId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public int getDownLoadFileId() {
        return this.downLoadFileId;
    }

    public void setDownLoadFileId(int downLoadFileId) {
        this.downLoadFileId = downLoadFileId;
    }

    public String getUploadBackupdesc() {
        return this.uploadBackupdesc;
    }

    public void setUploadBackupdesc(String uploadBackupdesc) {
        this.uploadBackupdesc = uploadBackupdesc;
    }

    public String getDownLoadFileName() {
        return this.downLoadFileName;
    }

    public void setDownLoadFileName(String downLoadFileName) {
        this.downLoadFileName = downLoadFileName;
    }

    public int getCheckdMaxMoId() {
        return this.checkdMaxMoId;
    }

    public void setCheckdMaxMoId(int checkdMaxMoId) {
        this.checkdMaxMoId = checkdMaxMoId;
    }

    public int getCheckdCountMoId() {
        return this.checkdCountMoId;
    }

    public void setCheckdCountMoId(int checkdCountMoId) {
        this.checkdCountMoId = checkdCountMoId;
    }

    public String getDownLoadFileWholeName() {
        return this.downLoadFileWholeName;
    }

    public void setDownLoadFileWholeName(String downLoadFileWholeName) {
        this.downLoadFileWholeName = downLoadFileWholeName;
    }

    public String getTempName() {
        return this.tempName;
    }

    public void setTempName(String tempName) {
        this.tempName = tempName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

