/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.backup.dao;

import com.hs.atic.sdk.backup.form.BackupConfig;
import com.hs.atic.sdk.backup.form.BackupMoInfo;
import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.atic.sdk.backup.util.BackupConfigUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateCallback;

public class BackupConfigDao
extends CommonDaoImpl {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);

    public void remove(int id) {
        String hql = "delete from ConfigBackupDBBean where id = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public ConfigBackupDBBean get(long id) {
        String hql = "from ConfigBackupDBBean where id = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (ConfigBackupDBBean)result.get(0);
    }

    public ConfigBackupDBBean getByName(String fileName) {
        String hql = "from ConfigBackupDBBean where fileName = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, fileName);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (ConfigBackupDBBean)result.get(0);
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from ConfigBackupDBBean where fileSource != 'file_recovery' ";
        String hql4Count = "select count(* ) as rowCount ";
        String isAdmin = conditionMap.get("isAdmin");
        String userName = conditionMap.get("userName");
        if (!AticUtil.isNull((String)isAdmin) && !AticUtil.isNull((String)userName) && isAdmin.equalsIgnoreCase("false")) {
            hql = hql + " and admin = ? ";
            queryMap.put(0, userName.trim());
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        hql = hql + " order by id desc";
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public int queryTotalCount() {
        String hql = "select count(* ) as rowCount from ConfigBackupDBBean";
        Long count = this.getTotalCount(hql);
        return count.intValue();
    }

    public BackupMoInfo getBackupMoInfo(BackupConfig backupConfig) {
        Object[] objects1;
        log.info((Object)"getBackupMoInfo");
        List result = (List)this.getHibernateTemplate().execute((HibernateCallback)new InnerClass(backupConfig));
        BackupMoInfo backupMoInfo = null;
        if (!BackupConfigUtil.isCollectionEmpty(result) && ((BigInteger)(objects1 = (Object[])result.get(0))[0]).intValue() == 1) {
            Integer lgmaxMoid = ((BigInteger)objects1[1]).intValue();
            Integer lgcountMoid = ((BigInteger)objects1[2]).intValue();
            backupMoInfo = new BackupMoInfo();
            backupMoInfo.setMaxMOId(lgmaxMoid);
            backupMoInfo.setMoCount(lgcountMoid);
        }
        return backupMoInfo;
    }

    public List<ConfigBackupDBBean> getBackupRecovery() {
        String hql = "from ConfigBackupDBBean where fileSource = 'file_recovery' order by id desc";
        ArrayList result = this.findByHql(hql);
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private static class InnerClass
    implements HibernateCallback {
        private BackupConfig backupConfig;

        public InnerClass(BackupConfig backupConfig) {
            this.backupConfig = backupConfig;
        }

        public Object doInHibernate(Session session) {
            StringBuffer sqlbuff = new StringBuffer();
            sqlbuff.append("SELECT 1, MAX(moid) maxMoid ,COUNT(moid) countMoid FROM " + this.backupConfig.getSlaveMoTable());
            return session.createSQLQuery(sqlbuff.toString()).list();
        }
    }
}

