/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.backup.service;

import com.hs.atic.backup.dao.BackupConfigDao;
import com.hs.atic.backup.service.ATICConfigBackupDBService;
import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.form.BackupConfig;
import com.hs.atic.sdk.backup.form.BackupFile;
import com.hs.atic.sdk.backup.form.BackupMoInfo;
import com.hs.atic.sdk.backup.form.BackupResult;
import com.hs.atic.sdk.backup.form.CmdResult;
import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.atic.sdk.backup.service.IATICConfigBackupService;
import com.hs.atic.sdk.backup.util.BackupConfigUtil;
import com.hs.atic.sdk.backup.util.MySQLMaintenance;
import com.hs.atic.sdk.backup.util.SystemCmdTool;
import com.hs.atic.system.SysConfigManager;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class ATICConfigBackupService
implements IATICConfigBackupService {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);
    private ATICConfigBackupDBService aticConfigBackupDBService;
    private SysConfigManager sysConfigManager;
    private BackupConfigDao backupConfigDao;
    private IUserMgr userMgr;
    private IAticDeviceService aticDeviceService;

    public BackupConfigDao getBackupConfigDao() {
        return this.backupConfigDao;
    }

    public void setBackupConfigDao(BackupConfigDao backupConfigDao) {
        this.backupConfigDao = backupConfigDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    @Override
    public BackupResult backup(ConfigBackupDBBean bean) throws ConfigBackupException {
        BackupConfig backupConfig = BackupConfigUtil.getCurrentBackupConfig();
        BackupResult backupResult = new BackupResult();
        backupResult.setBackupConfig(backupConfig);
        List onlineUsers = this.userMgr.getAllOnlineUser();
        if (!(null == onlineUsers || onlineUsers.isEmpty() || onlineUsers.size() == 1 && ((User)onlineUsers.get(0)).getUserName().equals(bean.getAdmin()))) {
            throw new LegoCheckedException(571602L);
        }
        try {
            BackupFile backupFile = new BackupFile();
            CmdResult cmdResult = MySQLMaintenance.backup(backupConfig, backupFile);
            if (!cmdResult.isSuccess().booleanValue()) {
                throw new ConfigBackupException(571636, new String[]{cmdResult.getErrorMessage()});
            }
            ConfigBackupDBBean configBackup = new ConfigBackupDBBean();
            configBackup.setAdmin(bean.getAdmin());
            configBackup.setFileDesc(bean.getFileDesc());
            configBackup.setFileSource("db_backup");
            configBackup.setBackupTime(backupFile.getBackupTime());
            configBackup.setBackupBase(backupFile.getFilePath());
            configBackup.setFileName(backupFile.getFileName());
            configBackup.setFileSize(backupFile.getSize());
            configBackup.setVersion(backupConfig.getFileVersion());
            this.aticConfigBackupDBService.addBackConfig(configBackup);
            backupResult.setConfigBackup(configBackup);
            backupResult.setReuslt(1);
        }
        catch (ConfigBackupException ex) {
            this.deleteFileWithLogEx(backupConfig.getBackupFile(), "backup failed,delete file :" + backupConfig.getBackupFile(), ex);
            throw ex;
        }
        catch (DataAccessException ex) {
            this.deleteFileWithLogEx(backupConfig.getBackupFile(), "backup failed,delete file :" + backupConfig.getBackupFile(), ex);
            throw new ConfigBackupException(571669, (Throwable)ex);
        }
        return backupResult;
    }

    private void deleteFileWithLogEx(String fileName, String msg, Throwable ex) {
        try {
            log.error((Object)AticUtil.getcleanedMessage((String)msg), ex);
            SystemCmdTool.deleteFile(fileName);
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean recoveryDatabase(ConfigBackupDBBean bean) throws ConfigBackupException {
        boolean result = false;
        BackupConfig backupConfig = BackupConfigUtil.getCurrentBackupConfig();
        List onlineUsers = this.userMgr.getAllOnlineUser();
        if (!(null == onlineUsers || onlineUsers.size() == 1 && ((User)onlineUsers.get(0)).getUserName().equals(bean.getAdmin()))) {
            throw new LegoCheckedException(571600L);
        }
        try {
            result = MySQLMaintenance.restore(backupConfig, bean.getFileName());
        }
        catch (LegoCheckedException e) {
            log.error((Object)"recovery Database failed.", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode());
        }
        return result;
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    @Override
    public BatchOperationResult deleteBackupFiles(List<Integer> files) {
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        batchOperationResult.setTotalCount(files.size());
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int success = 0;
        int failed = 0;
        for (Integer id : files) {
            BatchOperation result = new BatchOperation();
            ConfigBackupDBBean configBackupDBBean = this.aticConfigBackupDBService.findConfig(id);
            if (configBackupDBBean == null) {
                result.setErrorCode(571674L);
                result.setOptDetail("failed");
                ++failed;
            } else {
                result.setTargetName(configBackupDBBean.getFileName());
                if (SystemCmdTool.deleteFile(configBackupDBBean.getBackupBase())) {
                    try {
                        this.aticConfigBackupDBService.deleteBackConfig(id);
                        result.setOptDetail("success");
                        ++success;
                    }
                    catch (DataAccessException e) {
                        result.setErrorCode(571669L);
                        result.setOptDetail("failed");
                        ++failed;
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (LegoCheckedException e) {
                        result.setErrorCode(e.getErrorCode());
                        result.setDetailParam(e.getParameters());
                        result.setOptDetail("failed");
                        ++failed;
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    result.setErrorCode(571671L);
                    result.setOptDetail("failed");
                    ++failed;
                    log.error((Object)("delete file failed :" + configBackupDBBean.getBackupBase()));
                }
            }
            resultList.add(result);
        }
        batchOperationResult.setResult(resultList);
        batchOperationResult.setSucceedCount(success);
        batchOperationResult.setFailCount(failed);
        return batchOperationResult;
    }

    public ATICConfigBackupDBService getAticConfigBackupDBService() {
        return this.aticConfigBackupDBService;
    }

    public void setAticConfigBackupDBService(ATICConfigBackupDBService aticConfigBackupDBService) {
        this.aticConfigBackupDBService = aticConfigBackupDBService;
    }

    @Override
    public ConfigBackupDBBean getByName(String fileName) {
        return this.backupConfigDao.getByName(fileName);
    }

    @Override
    public BackupResult uploadBackupFile(ConfigBackupDBBean bean) throws ConfigBackupException {
        BackupResult backupResult = new BackupResult();
        try {
            this.aticConfigBackupDBService.addBackConfig(bean);
        }
        catch (DataAccessException ex) {
            throw new ConfigBackupException(571669);
        }
        backupResult.setConfigBackup(bean);
        return backupResult;
    }

    @Override
    public int getCurrentSystemState() {
        try {
            List<ConfigBackupDBBean> result = this.backupConfigDao.getBackupRecovery();
            if (BackupConfigUtil.isCollectionEmpty(result)) {
                return 1;
            }
            return 0;
        }
        catch (DataAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571669L, (Throwable)e);
        }
    }

    @Override
    public BackupMoInfo getCurrentMOInfo() throws ConfigBackupException {
        try {
            BackupConfig backupConfig = BackupConfigUtil.getCurrentBackupConfig();
            return this.backupConfigDao.getBackupMoInfo(backupConfig);
        }
        catch (DataAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new LegoCheckedException(571669L, (Throwable)e);
        }
    }

    @Override
    public int getImportConfigBackupFileSize() throws ConfigBackupException {
        int fileSize = 500;
        String importConfigBackupFileSize = this.sysConfigManager.getSystemValue("import_backupfile_size");
        if (!AticUtil.isNull((String)importConfigBackupFileSize)) {
            try {
                fileSize = Integer.parseInt(importConfigBackupFileSize);
            }
            catch (NumberFormatException e) {
                log.error((Object)"Integer.parseInt NumberFormatException");
            }
        }
        return fileSize;
    }

    @Override
    public String getCurrentVersion() {
        try {
            BackupConfig backupConfig = BackupConfigUtil.getCurrentBackupConfig();
            return backupConfig.getFileVersion();
        }
        catch (ConfigBackupException e) {
            log.error((Object)"get BackupConfig is error", (Throwable)e);
            return null;
        }
    }

    public SysConfigManager getSysConfigManager() {
        return this.sysConfigManager;
    }

    public void setSysConfigManager(SysConfigManager sysConfigManager) {
        this.sysConfigManager = sysConfigManager;
    }
}

