/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.backup.util;

import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class BackUpExportCreateUtil {
    private static BackUpExportCreateUtil backUpExportCreateUtil = null;
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);

    private BackUpExportCreateUtil() {
    }

    public static BackUpExportCreateUtil getInstance() {
        if (null == backUpExportCreateUtil) {
            try {
                backUpExportCreateUtil = (BackUpExportCreateUtil)BackUpExportCreateUtil.class.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return backUpExportCreateUtil;
    }

    public static void createXml(ConfigBackupDBBean configBackup, ProgressState progressState) {
        Document document = null;
        try {
            document = DocumentHelper.createDocument();
            Element root = document.addElement("root");
            Element time = root.addElement("time");
            time.setText(BackUpExportCreateUtil.dealNull(BackUpExportCreateUtil.getTimeStamp(System.currentTimeMillis())));
            progressState.next();
            Element configNode = root.addElement("config-backup");
            BackUpExportCreateUtil.dealBackConfig(configNode, configBackup);
            progressState.next();
            if (null == AticInstallUtil.getInstance()) {
                log.error((Object)"AticInstallUtil.getInstance() is null.");
                throw new LegoCheckedException(571633L);
            }
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            if (1 == version) {
                BackUpExportCreateUtil.outPutXml(document, AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "backup" + File.separator + configBackup.getFileName() + ".xml");
            } else {
                BackUpExportCreateUtil.outPutXml(document, AticInstallUtil.getInstance().getInstallPath() + File.separator + "backup" + File.separator + configBackup.getFileName() + ".xml");
            }
            progressState.next();
        }
        catch (RuntimeException e) {
            log.error((Object)"Generate XML file node failure :", (Throwable)e);
            throw new LegoCheckedException(571633L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outPutXml(Document doc, String exportFilePath) {
        XMLWriter writer = null;
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        File file = new File(exportFilePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"File found failure :");
        }
        try {
            writer = new XMLWriter((OutputStream)fos, format);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"create XMLWriter is failure :", (Throwable)e);
        }
        try {
            if (null != writer) {
                writer.write(doc);
            }
        }
        catch (IOException e) {
            log.error((Object)"write out XML file is failure :", (Throwable)e);
        }
        finally {
            try {
                if (null != writer) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Close writer is error", (Throwable)e);
            }
            BackUpExportCreateUtil.closeFileOutput(fos);
        }
    }

    private static void closeFileOutput(FileOutputStream fileOutput) {
        try {
            if (null != fileOutput) {
                fileOutput.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Close FileOutputStream is error", (Throwable)e);
        }
    }

    private static String dealNull(Object str) {
        return null != str ? str.toString() : "";
    }

    private static void dealBackConfig(Element node, ConfigBackupDBBean configBackup) {
        Element fileName = node.addElement("name");
        Element version = node.addElement("version");
        Element fileSize = node.addElement("file-size");
        Element administrator = node.addElement("administrator");
        Element description = node.addElement("description");
        Element backUpTime = node.addElement("backup-time");
        Element backUpBase = node.addElement("backup-base");
        Element fileSource = node.addElement("file-source");
        fileName.setText(null == configBackup ? "" : BackUpExportCreateUtil.dealNull(configBackup.getFileName()));
        version.setText(null == configBackup ? "" : BackUpExportCreateUtil.dealNull(configBackup.getVersion()));
        fileSize.setText(null == configBackup ? "" : BackUpExportCreateUtil.dealNull(configBackup.getFileSize()));
        administrator.setText(null == configBackup ? "" : BackUpExportCreateUtil.dealNull(configBackup.getAdmin()));
        description.setText(null == configBackup ? "" : BackUpExportCreateUtil.dealNull(configBackup.getFileDesc()));
        backUpTime.setText(null == configBackup ? "" : BackUpExportCreateUtil.dealNull(configBackup.getBackupTime()));
        fileSource.setText(null == configBackup ? "" : BackUpExportCreateUtil.dealNull(configBackup.getFileSource()));
        backUpBase.setText(null == configBackup ? "" : BackUpExportCreateUtil.dealNull(configBackup.getBackupBase()));
    }

    public static String getTimeStamp(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(time));
    }
}

