/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.backup.util;

import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.springframework.util.StringUtils;
import org.xml.sax.SAXException;

public final class BackUpImportParserUtil {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);
    private static BackUpImportParserUtil backUpImportParser = null;

    private BackUpImportParserUtil() {
    }

    public static BackUpImportParserUtil getInstance() {
        if (null == backUpImportParser) {
            try {
                backUpImportParser = (BackUpImportParserUtil)BackUpImportParserUtil.class.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return backUpImportParser;
    }

    public static ConfigBackupDBBean parseConfigImport(File file) {
        FileInputStream fileInputStream = null;
        ConfigBackupDBBean configBackupDBBean = new ConfigBackupDBBean();
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            log.error((Object)"file is null");
            throw new LegoCheckedException(571980L, (Throwable)e);
        }
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            dbf.setExpandEntityReferences(false);
            dbf.setXIncludeAware(false);
            dbf.setValidating(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = new DOMReader().read(db.parse(fileInputStream));
            if (null == document) {
                log.error((Object)"document is null");
                throw new LegoCheckedException(571982L);
            }
            Element root = document.getRootElement();
            String time = root.elementText("time");
            if (StringUtils.isEmpty((Object)time)) {
                log.error((Object)"time is null");
                throw new LegoCheckedException(571981L);
            }
            ConfigBackupDBBean configBackupDBBean2 = BackUpImportParserUtil.parseConfigInfo(root, configBackupDBBean);
            return configBackupDBBean2;
        }
        catch (LegoCheckedException le) {
            log.error((Object)"File format is incorrect:", (Throwable)le);
            if (571988L == le.getErrorCode()) {
                throw new LegoCheckedException(571988L, (Throwable)le);
            }
            throw new LegoCheckedException(571981L, (Throwable)le);
        }
        catch (SAXException e1) {
            log.error((Object)"File format is incorrect:", (Throwable)e1);
            throw new LegoCheckedException(571981L, (Throwable)e1);
        }
        catch (IOException e2) {
            log.error((Object)"File format is incorrect:", (Throwable)e2);
            throw new LegoCheckedException(571981L, (Throwable)e2);
        }
        catch (ParserConfigurationException e3) {
            log.error((Object)"File format is incorrect:", (Throwable)e3);
            throw new LegoCheckedException(571981L, (Throwable)e3);
        }
        catch (RuntimeException e4) {
            log.error((Object)"File format is incorrect:", (Throwable)e4);
            throw new LegoCheckedException(571981L, (Throwable)e4);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    fileInputStream = null;
                }
            }
        }
    }

    private static ConfigBackupDBBean parseConfigInfo(Element root, ConfigBackupDBBean configBackupDBBean) {
        if (null == root) {
            return configBackupDBBean;
        }
        Element configElement = root.element("config-backup");
        String fileNameContent = configElement.elementText("name");
        configBackupDBBean.setFileName(BackUpImportParserUtil.dealNull(fileNameContent));
        String versionContent = configElement.elementText("version");
        configBackupDBBean.setVersion(BackUpImportParserUtil.dealNull(versionContent));
        String fileSizeContent = configElement.elementText("file-size");
        configBackupDBBean.setFileSize(Long.parseLong(null != fileSizeContent ? fileSizeContent : "0"));
        String administratorContent = configElement.elementText("administrator");
        configBackupDBBean.setAdmin(BackUpImportParserUtil.dealNull(administratorContent));
        String descriptionContent = configElement.elementText("description");
        configBackupDBBean.setFileDesc(BackUpImportParserUtil.dealNull(descriptionContent));
        String backUpTimeContent = configElement.elementText("backup-time");
        configBackupDBBean.setBackupTime(Long.parseLong(null != backUpTimeContent ? backUpTimeContent : "0"));
        String backUpBaseContent = configElement.elementText("backup-base");
        configBackupDBBean.setBackupBase(BackUpImportParserUtil.dealNull(backUpBaseContent));
        String fileSourceContent = configElement.elementText("file-source");
        configBackupDBBean.setFileSource(BackUpImportParserUtil.dealNull(fileSourceContent));
        return configBackupDBBean;
    }

    private static String dealNull(Object str) {
        return null != str ? str.toString() : "";
    }
}

