/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.backup.util;

import com.hs.atic.backup.model.ErrorInfo;
import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.service.IATICConfigBackupDBService;
import com.hs.atic.sdk.backup.service.IATICConfigBackupService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;

public final class BackupUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);

    private BackupUtil() {
    }

    public static IATICConfigBackupDBService getATICConfigBackupDBService() {
        IATICConfigBackupDBService backupConfigDBService = (IATICConfigBackupDBService)AticUtil.getServiceContext().getService("aticConfigBackupDBService", IATICConfigBackupDBService.class);
        if (null == backupConfigDBService) {
            throw new LegoCheckedException(570506L);
        }
        return backupConfigDBService;
    }

    public static IATICConfigBackupService getATICConfigBackupService() {
        IATICConfigBackupService backupConfigService = (IATICConfigBackupService)AticUtil.getServiceContext().getService("backupConfigService", IATICConfigBackupService.class);
        if (null == backupConfigService) {
            throw new LegoCheckedException(570506L);
        }
        return backupConfigService;
    }

    public static ErrorInfo getErrorInfo(Throwable ex) {
        ErrorInfo errorInfo = new ErrorInfo();
        if (ex instanceof ConfigBackupException) {
            ConfigBackupException cex = (ConfigBackupException)ex;
            errorInfo.setErrorCode(cex.getErrorResourceId());
            errorInfo.setParams(cex.getParams());
        } else if (ex instanceof LegoCheckedException) {
            LegoCheckedException lex = (LegoCheckedException)ex;
            errorInfo.setErrorCode("lego.err." + lex.getErrorCode());
            errorInfo.setParams(lex.getParameters());
        } else {
            errorInfo.setErrorCode("lego.err.571673");
            errorInfo.setParams(new String[]{ex.getMessage()});
        }
        errorInfo.setEx(ex);
        return errorInfo;
    }

    public static String getErrorInfoText(BaseAction currentAction, ErrorInfo ex) {
        if (ex == null) {
            return "";
        }
        String text = ex.getErrorCode();
        if (currentAction != null) {
            text = ex.getParams().length > 0 ? currentAction.getText(ex.getErrorCode(), ex.getParams()) : currentAction.getText(ex.getErrorCode());
        }
        return text;
    }

    public static String getExceptionText(BaseAction currentAction, Throwable ex) {
        String result = "";
        try {
            if (ex == null) {
                return result;
            }
            ErrorInfo errorInfo = BackupUtil.getErrorInfo(ex);
            result = BackupUtil.getErrorInfoText(currentAction, errorInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

