/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.backup.form;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ConfigBackupDBBean
implements Serializable {
    public static final int ROUND_PRECISION = 2;
    public static final double FILE_SIZE_UNIT_BYTE = 1024.0;
    public static final String UNIT_OF_B = "B";
    public static final String UNIT_OF_KB = "KB";
    public static final String UNIT_OF_MB = "MB";
    public static final String UNIT_OF_GB = "GB";
    public static final String UNIT_OF_TB = "TB";
    private static final long serialVersionUID = 8699310449427945160L;
    private int id;
    private String fileName;
    private String version;
    private Long fileSize;
    private String admin;
    private String fileDesc;
    private Long backupTime;
    private String backupTimeStr;
    private String backupBase;
    private String fileHashCode;
    private String fileSource;
    private int maxMoId;
    private int countMoId;
    private String fileSizeStr;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getAdmin() {
        return this.admin;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public String getFileDesc() {
        return this.fileDesc;
    }

    public void setFileDesc(String fileDesc) {
        this.fileDesc = fileDesc;
    }

    public Long getBackupTime() {
        return this.backupTime;
    }

    public void setBackupTime(Long backupTime) {
        this.backupTime = backupTime;
    }

    public String getBackupBase() {
        return this.backupBase;
    }

    public void setBackupBase(String backupBase) {
        this.backupBase = backupBase;
    }

    public String getFileHashCode() {
        return this.fileHashCode;
    }

    public void setFileHashCode(String fileHashCode) {
        this.fileHashCode = fileHashCode;
    }

    public String getFileSource() {
        return this.fileSource;
    }

    public void setFileSource(String fileSource) {
        this.fileSource = fileSource;
    }

    public String getBackupTimeStr() {
        Date date = new Date(this.getBackupTime());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.backupTimeStr = format.format(date);
        return this.backupTimeStr;
    }

    public int getMaxMoId() {
        return this.maxMoId;
    }

    public void setMaxMoId(int maxMoId) {
        this.maxMoId = maxMoId;
    }

    public int getCountMoId() {
        return this.countMoId;
    }

    public void setCountMoId(int countMoId) {
        this.countMoId = countMoId;
    }

    public Map<String, Object> getSQLMap(int target) {
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        String desc = this.fileDesc;
        if (null != desc && this.fileDesc.length() > 65535) {
            desc = this.fileDesc.substring(0, 65535);
        }
        if (2 == target) {
            sqlMap.put("file_desc", desc);
        } else {
            sqlMap.put("file_name", this.fileName);
            sqlMap.put("VERSION", this.version);
            sqlMap.put("file_size", this.fileSize);
            sqlMap.put("admin", this.admin);
            sqlMap.put("file_desc", desc);
            sqlMap.put("backup_Time", this.backupTime);
            sqlMap.put("backup_base", this.backupBase);
            sqlMap.put("file_Md5", this.fileHashCode);
            sqlMap.put("file_source", this.fileSource);
            sqlMap.put("max_MoId", this.maxMoId);
            sqlMap.put("count_MoId", this.countMoId);
        }
        return sqlMap;
    }

    public String getIdName() {
        return "pkid";
    }

    public void setBackupTimeStr(String backupTimeStr) {
        this.backupTimeStr = backupTimeStr;
    }

    public String getFileSizeStr() {
        if (null != this.fileSize) {
            String unit = ConfigBackupDBBean.getUnitByFileSize(this.fileSize);
            this.fileSizeStr = ConfigBackupDBBean.getSizeStr(this.fileSize, unit);
        }
        return this.fileSizeStr;
    }

    public void setFileSizeStr(String fileSizeStr) {
        this.fileSizeStr = fileSizeStr;
    }

    private static String getSizeStr(long fileSize, String unit) {
        double fileSizeAbs = fileSize;
        String strPre = "";
        if (fileSizeAbs < 0.0) {
            strPre = "";
        }
        if (unit.equals(UNIT_OF_B)) {
            BigDecimal bFileSize = ConfigBackupDBBean.getRoundData(String.valueOf(fileSizeAbs));
            return strPre + bFileSize + UNIT_OF_B;
        }
        if (unit.equals(UNIT_OF_KB)) {
            BigDecimal kbFileSize = ConfigBackupDBBean.getRoundData(String.valueOf(fileSizeAbs / 1024.0));
            return strPre + kbFileSize + UNIT_OF_KB;
        }
        if (unit.equals(UNIT_OF_MB)) {
            BigDecimal mbFileSize = ConfigBackupDBBean.getRoundData(String.valueOf(fileSizeAbs / 1048576.0));
            return strPre + mbFileSize + UNIT_OF_MB;
        }
        if (unit.equals(UNIT_OF_GB)) {
            BigDecimal gbFileSize = ConfigBackupDBBean.getRoundData(String.valueOf(fileSizeAbs / 1.073741824E9));
            return strPre + gbFileSize + UNIT_OF_GB;
        }
        BigDecimal tbFileSize = ConfigBackupDBBean.getRoundData(String.valueOf(fileSizeAbs / 1.099511627776E12));
        return strPre + tbFileSize + UNIT_OF_TB;
    }

    private static BigDecimal getRoundData(String data) {
        BigDecimal bd = new BigDecimal(data);
        bd = bd.setScale(2, 4);
        return bd;
    }

    private static String getUnitByFileSize(long fileSize) {
        long fileSizeAbs = fileSize;
        if ((double)fileSizeAbs < 1024.0) {
            return UNIT_OF_B;
        }
        if ((double)fileSizeAbs < 1048576.0) {
            return UNIT_OF_KB;
        }
        if ((double)fileSizeAbs < 1.073741824E9) {
            return UNIT_OF_MB;
        }
        if ((double)fileSizeAbs < 1.099511627776E12) {
            return UNIT_OF_GB;
        }
        return UNIT_OF_TB;
    }
}

