/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.backup.util;

import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.form.BackupConfig;
import com.hs.atic.sdk.backup.form.BackupFile;
import com.hs.atic.sdk.backup.form.CmdResult;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class MySQLMaintenance {
    private static final int MAX_STRING_SIZE = 10240;
    private static final String MYSQLBACKUP_COMPLETE_OK = "ysqlbackup completed OK!";
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);

    private MySQLMaintenance() {
    }

    public static void setLogger(Log logger) {
        log = logger;
    }

    private static String getBackupCmd(BackupConfig backupConfig) throws ConfigBackupException {
        log.info((Object)"getBackupCmd start");
        StringBuffer cmdBuf = new StringBuffer();
        String installPath = backupConfig.getInstallPath();
        if (null != installPath && installPath.contains("Runtime")) {
            installPath = installPath.split("Runtime")[0];
        }
        cmdBuf.append(installPath);
        cmdBuf.append("MySQL\\bin\\mysqlbackup.exe");
        cmdBuf.append(" --");
        cmdBuf.append("defaults-file=");
        cmdBuf.append(installPath);
        cmdBuf.append("MySQL\\my.ini");
        cmdBuf.append(" --");
        cmdBuf.append("user=");
        cmdBuf.append(backupConfig.getUserName());
        cmdBuf.append(" --");
        cmdBuf.append("password=");
        cmdBuf.append(DataProtectServiceConst.sdpDecryptLocal((String)backupConfig.getPassword()));
        cmdBuf.append(" --compress");
        cmdBuf.append(" --");
        cmdBuf.append("databases=\"lego\"");
        cmdBuf.append(" --");
        cmdBuf.append("with-timestamp");
        cmdBuf.append(" --");
        cmdBuf.append("backup-dir=");
        cmdBuf.append(installPath);
        cmdBuf.append("backup   backup");
        return cmdBuf.toString();
    }

    private static String getBackupCmdLinux(BackupConfig backupConfig) throws ConfigBackupException {
        log.info((Object)"getBackupCmd start");
        String backupCmdPath = "sudo " + File.separator + "opt" + File.separator + "huawei" + File.separator + "atic" + File.separator + "mysql" + File.separator + "bin" + File.separator + "mysqlbackup";
        String myIniPath = File.separator + "etc" + File.separator + "my.cnf";
        StringBuffer cmdBuf = new StringBuffer();
        String installPath = backupConfig.getInstallPath();
        if (null != installPath && installPath.contains("Runtime")) {
            installPath = installPath.split("Runtime")[0];
        }
        cmdBuf.append(backupCmdPath);
        cmdBuf.append(" --");
        cmdBuf.append("defaults-file=");
        cmdBuf.append(myIniPath);
        cmdBuf.append(" --");
        cmdBuf.append("user=");
        cmdBuf.append(backupConfig.getUserName());
        cmdBuf.append(" --");
        cmdBuf.append("password=");
        cmdBuf.append(DataProtectServiceConst.sdpDecryptLocal((String)backupConfig.getPassword()));
        cmdBuf.append(" --compress");
        cmdBuf.append(" --");
        cmdBuf.append("databases=\"lego\"");
        cmdBuf.append(" --");
        cmdBuf.append("with-timestamp");
        cmdBuf.append(" --");
        cmdBuf.append("backup-dir=");
        cmdBuf.append(installPath + File.separator);
        cmdBuf.append("backup   backup");
        return cmdBuf.toString();
    }

    public static CmdResult backup(BackupConfig backupConfig, BackupFile backupFile) throws ConfigBackupException {
        String backupCmd = null;
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        backupCmd = 1 == version ? MySQLMaintenance.getBackupCmdLinux(backupConfig) : MySQLMaintenance.getBackupCmd(backupConfig);
        CmdResult result = MySQLMaintenance.exeBackupCmd(backupCmd, backupFile);
        return result;
    }

    public static void logErrorSafely(Throwable e) {
        try {
            log.error((Object)e.getMessage(), e);
        }
        catch (Exception ex) {
            log.error((Object)"log.error", e);
        }
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private static CmdResult exeBackupCmd(String cmd, BackupFile backupFile) throws ConfigBackupException {
        log.info((Object)"begin to backup.");
        List<String> errorList = MySQLMaintenance.exeCmd(cmd);
        CmdResult cmdResult = new CmdResult();
        cmdResult.setCmd(cmd);
        cmdResult.setSuccess(true);
        if (errorList.size() > 0 && !errorList.get(errorList.size() - 1).contains(MYSQLBACKUP_COMPLETE_OK)) {
            cmdResult.setSuccess(false);
            cmdResult.setErrorMessage(errorList.toString());
            log.error((Object)("errorBuffer content is:" + MySQLMaintenance.getcleanedMessage(errorList.toString())));
        } else {
            backupFile.setBackupTime(System.currentTimeMillis());
            cmdResult.setSuccess(true);
            cmdResult.setDisplayMessage(MYSQLBACKUP_COMPLETE_OK);
            MySQLMaintenance.handleResult(errorList, backupFile);
            log.info((Object)MYSQLBACKUP_COMPLETE_OK);
        }
        return cmdResult;
    }

    private static void readBufferString(BufferedReader errorRead, List<String> errorList) {
        try {
            while (errorRead.read() != -1) {
                String line = errorRead.readLine();
                if (errorList.size() > 10240 || null == line || line.length() > 10240) continue;
                errorList.add(line);
            }
        }
        catch (IOException e) {
            log.error((Object)"read StringBuffer is error.", (Throwable)e);
        }
    }

    private static List<String> exeCmd(String cmd) throws ConfigBackupException {
        InputStream errorIn = null;
        InputStream resultIn = null;
        BufferedReader errorRead = null;
        ArrayList<String> errorList = new ArrayList<String>();
        String csn = Charset.defaultCharset().name();
        try {
            Process p = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            if (1 == version) {
                String[] cmdPama = new String[]{"/bin/sh", "-c", cmd};
                p = Runtime.getRuntime().exec(cmdPama);
            } else {
                p = Runtime.getRuntime().exec(cmd);
            }
            errorIn = p.getErrorStream();
            resultIn = p.getInputStream();
            if (null != errorIn) {
                errorRead = new BufferedReader(new InputStreamReader(errorIn, csn));
                MySQLMaintenance.readBufferString(errorRead, errorList);
            }
            if (null != resultIn && errorList.isEmpty()) {
                errorRead = new BufferedReader(new InputStreamReader(resultIn, csn));
                MySQLMaintenance.readBufferString(errorRead, errorList);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigBackupException(571636, new String[]{e.getMessage()}, e);
        }
        catch (IOException e) {
            throw new ConfigBackupException(571636, new String[]{e.getMessage()}, e);
        }
        finally {
            if (null != errorIn) {
                try {
                    errorIn.close();
                }
                catch (Exception e) {
                    MySQLMaintenance.logErrorSafely(e);
                }
            }
            if (null != errorRead) {
                try {
                    errorRead.close();
                }
                catch (Exception e) {
                    MySQLMaintenance.logErrorSafely(e);
                }
            }
        }
        return errorList;
    }

    private static void handleResult(List<String> params, BackupFile backupFile) {
        for (String result : params) {
            String[] param2;
            String[] param;
            if (result.contains("files compressed to") && (param = result.split("files compressed to")).length >= 2) {
                param2 = param[1].split("kbytes");
                backupFile.setSize(Long.parseLong(param2[0].trim()) * 1024L);
            }
            if (!result.contains("created in directory") || (param = result.split("created in directory")).length <= 1) continue;
            param2 = param[1].split("'");
            backupFile.setFilePath(param2[1].trim());
            String[] param3 = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            param3 = 1 == version ? param2[1].split("/") : param2[1].split("\\\\");
            backupFile.setFileName(param3[param3.length - 1].trim());
        }
    }

    public static boolean restore(BackupConfig backupConfig, String fileName) throws ConfigBackupException {
        List<String> restoreResult = MySQLMaintenance.exeCmd(MySQLMaintenance.getRestore(backupConfig, fileName));
        log.info((Object)"restoreResult start:");
        for (String string : restoreResult) {
            log.info((Object)string);
        }
        log.info((Object)"restoreResult end.");
        int size = restoreResult.size();
        if (size > 1 && restoreResult.get(size - 1).contains(MYSQLBACKUP_COMPLETE_OK)) {
            log.info((Object)"restore is successful");
            return true;
        }
        return false;
    }

    private static String getRestore(BackupConfig backupConfig, String fileName) {
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            return MySQLMaintenance.getRestoreLinux(backupConfig, fileName);
        }
        return MySQLMaintenance.getRestoreWindow(backupConfig, fileName);
    }

    private static String getRestoreLinux(BackupConfig backupConfig, String fileName) {
        log.info((Object)"getRestore start");
        String backupCmdPath = "sudo " + File.separator + "opt" + File.separator + "huawei" + File.separator + "atic" + File.separator + "mysql" + File.separator + "bin" + File.separator + "mysqlbackup";
        String myIniPath = File.separator + "etc" + File.separator + "my.cnf";
        StringBuffer cmdBuf = new StringBuffer();
        String installPath = backupConfig.getInstallPath();
        String aticInstallPath = AticInstallUtil.getInstance().getInstallPath();
        if (null != installPath && installPath.contains("Runtime")) {
            installPath = installPath.split("Runtime")[0];
        }
        cmdBuf.append(backupCmdPath);
        cmdBuf.append(" --");
        cmdBuf.append("defaults-file=");
        cmdBuf.append(myIniPath);
        cmdBuf.append(" -u");
        cmdBuf.append(backupConfig.getUserName());
        cmdBuf.append(" --");
        cmdBuf.append("backup-dir=");
        cmdBuf.append(installPath + File.separator + "backup" + File.separator);
        cmdBuf.append(fileName);
        cmdBuf.append(File.separator + " --datadir=");
        cmdBuf.append(aticInstallPath);
        cmdBuf.append(File.separator + "mysql" + File.separator + "data");
        cmdBuf.append(" --uncompress copy-back-and-apply-log");
        log.info((Object)("RestoreCmd:" + cmdBuf));
        return cmdBuf.toString();
    }

    private static String getRestoreWindow(BackupConfig backupConfig, String fileName) {
        log.info((Object)"getRestore start");
        StringBuffer cmdBuf = new StringBuffer();
        String installPath = backupConfig.getInstallPath();
        if (null != installPath && installPath.contains("Runtime")) {
            installPath = installPath.split("Runtime")[0];
        }
        cmdBuf.append(installPath);
        cmdBuf.append("MySQL\\bin\\mysqlbackup.exe");
        cmdBuf.append(" --");
        cmdBuf.append("defaults-file=");
        cmdBuf.append(installPath);
        cmdBuf.append("MySQL\\my.ini");
        cmdBuf.append(" -u");
        cmdBuf.append(backupConfig.getUserName());
        cmdBuf.append(" --");
        cmdBuf.append("backup-dir=");
        cmdBuf.append(installPath + "backup\\");
        cmdBuf.append(fileName);
        cmdBuf.append("\\ --datadir=");
        cmdBuf.append(installPath);
        cmdBuf.append("MySQL\\data");
        cmdBuf.append(" --uncompress copy-back-and-apply-log");
        log.info((Object)("RestoreCmd:" + cmdBuf));
        return cmdBuf.toString();
    }
}

