/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.backup.util;

import com.hs.atic.sdk.backup.exception.ConfigBackupException;
import com.hs.atic.sdk.backup.form.BackupFile;
import com.hs.atic.sdk.backup.form.BackupInfo;
import com.hs.atic.sdk.backup.form.CmdResult;
import com.hs.atic.sdk.backup.form.ConfigBackupDBBean;
import com.hs.atic.sdk.backup.util.BackupCheckKit;
import com.hs.atic.sdk.backup.util.BackupConfigUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class SystemCmdTool {
    public static final int QUERY_MAX_TIME = 300;
    public static final String SERVICE_STATE_STOP_PENDING = "STOP_PENDING";
    public static final String SERVICE_STATE_START_PENDING = "START_PENDING";
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);
    private static final String SC_OPT_STOP = "sc stop ";
    private static final String SC_OPT_START = "sc start ";
    private static final String SC_OPT_QUERY = "sc query ";
    private static final int MAX_COUNT = 0x100000;
    private static final String SERVICE_DDOS_LEGOMONITOR = "LEGOMonitor";
    private static final String SERVICE_DDOS_LEGOSERVICE = "LEGOService";
    private static final String SERVICE_DDOS_MYSQLSERVICE = "mysqlservice";
    private static final String SERVICE_DDOS_COLLECTOR = "DDOSCOLLECTORSVC";
    private static final String SERVICE_DDOS_COLLECTOR_MONITOR = "ATICCOLLECTORGUARDSERVICE";
    private static final String SERVICE_DDOS_MYSQLSERVICE_LINUX = "ps -ef | grep mysqld | grep mysqld_safe | grep atic | grep -v grep | awk '{print $2}'";
    private static final String SERVICE_DDOS_COLLECTOR_LINUX = "ps -ef | grep java | grep antiddos_collector | grep -v grep | awk '{print $2}'";
    private static final String MONITOR_FILE_PATH_LINUX = AticInstallUtil.getInstance().getInstallPath() + File.separator + "engineering" + File.separator + "hmonitor" + File.separator + "conf" + File.separator + "hmonitor.xml";
    private static final String DELETE_CMD_LINUX = "sudo " + File.separator + "opt" + File.separator + "huawei" + File.separator + "atic" + File.separator + "components" + File.separator + "atic" + File.separator + "backup" + File.separator + "atic_delete.sh ";
    private static final String CHOWN_CMD_LINUX = "sudo " + File.separator + "opt" + File.separator + "huawei" + File.separator + "atic" + File.separator + "components" + File.separator + "atic" + File.separator + "backup" + File.separator + "atic_chown.sh ";

    private SystemCmdTool() {
    }

    public static void setLogger(Log logger) {
        log = logger;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CmdResult exeCmd(String cmd) throws ConfigBackupException {
        CmdResult cmdResult;
        BufferedReader errorRead;
        BufferedReader read;
        InputStream errorIn;
        block24: {
            String csn = Charset.defaultCharset().name();
            InputStream in = null;
            errorIn = null;
            read = null;
            errorRead = null;
            cmdResult = new CmdResult();
            cmdResult.setCmd(cmd);
            cmdResult.setSuccess(true);
            try {
                Process p = null;
                int version = AticInstallUtil.getInstance().getAticInstallOS();
                if (1 == version) {
                    String[] cmdPara = new String[]{"/bin/sh", "-c", cmd};
                    p = Runtime.getRuntime().exec(cmdPara);
                } else {
                    p = Runtime.getRuntime().exec(cmd);
                }
                StringBuffer buffer = new StringBuffer();
                in = p.getInputStream();
                if (null != in) {
                    read = new BufferedReader(new InputStreamReader(in, csn));
                    while (read.read() != -1 && buffer.length() <= 0x100000) {
                        String line = read.readLine();
                        buffer.append(line);
                    }
                }
                cmdResult.setDisplayMessage(buffer.toString());
                log.info((Object)("run result:" + SystemCmdTool.getcleanedMessage(cmdResult.getDisplayMessage())));
                StringBuffer errorBuffer = new StringBuffer();
                errorIn = p.getErrorStream();
                if (null != errorIn) {
                    errorRead = new BufferedReader(new InputStreamReader(errorIn, csn));
                    while (errorRead.read() != -1) {
                        String line = errorRead.readLine();
                        errorBuffer.append(line);
                    }
                    if (errorBuffer.length() > 0) {
                        log.error((Object)("errorBuffer content is:" + SystemCmdTool.getcleanedMessage(errorBuffer.toString())));
                    }
                }
                if (errorBuffer.length() > 0 && !errorBuffer.toString().contains("Using a password on the command line interface can be insecure")) {
                    cmdResult.setSuccess(false);
                    cmdResult.setErrorMessage(errorBuffer.toString());
                }
                if (null == in) break block24;
            }
            catch (UnsupportedEncodingException e) {
                try {
                    throw new ConfigBackupException(571636, new String[]{e.getMessage()}, e);
                    catch (IOException e2) {
                        throw new ConfigBackupException(571636, new String[]{e2.getMessage()}, e2);
                    }
                }
                catch (Throwable throwable) {
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (Exception e3) {
                            SystemCmdTool.logErrorSafely(e3);
                        }
                    }
                    if (null != read) {
                        try {
                            read.close();
                        }
                        catch (Exception e4) {
                            SystemCmdTool.logErrorSafely(e4);
                        }
                    }
                    SystemCmdTool.closeErrorStream(errorIn, errorRead);
                    throw throwable;
                }
            }
            try {
                in.close();
            }
            catch (Exception e) {
                SystemCmdTool.logErrorSafely(e);
            }
        }
        if (null != read) {
            try {
                read.close();
            }
            catch (Exception e) {
                SystemCmdTool.logErrorSafely(e);
            }
        }
        SystemCmdTool.closeErrorStream(errorIn, errorRead);
        return cmdResult;
    }

    public static void closeErrorStream(InputStream errorIn, BufferedReader errorRead) {
        if (null != errorIn) {
            try {
                errorIn.close();
            }
            catch (Exception e) {
                SystemCmdTool.logErrorSafely(e);
            }
        }
        if (null != errorRead) {
            try {
                errorRead.close();
            }
            catch (Exception e) {
                SystemCmdTool.logErrorSafely(e);
            }
        }
    }

    public static boolean queryServiceState(String serviceName, String stateMatchedContinue, int maxTimes) throws InterruptedException, ConfigBackupException {
        log.info((Object)("begin to query:" + serviceName + ",query times:" + maxTimes));
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            String cmdQueryService = null;
            if (!Pattern.matches("[0-9A-Za-z@]+", serviceName)) {
                log.error((Object)("serviceName error : " + SystemCmdTool.getcleanedMessage(serviceName)));
                return false;
            }
            if (SERVICE_DDOS_MYSQLSERVICE.equals(serviceName)) {
                cmdQueryService = SERVICE_DDOS_MYSQLSERVICE_LINUX;
            } else {
                if ((SERVICE_DDOS_COLLECTOR_MONITOR.equals(serviceName) || SERVICE_DDOS_LEGOMONITOR.equals(serviceName)) && SERVICE_STATE_START_PENDING.equals(stateMatchedContinue)) {
                    return SystemCmdTool.isMonitorRunning4Linux(serviceName);
                }
                if ((SERVICE_DDOS_COLLECTOR_MONITOR.equals(serviceName) || SERVICE_DDOS_LEGOMONITOR.equals(serviceName)) && SERVICE_STATE_STOP_PENDING.equals(stateMatchedContinue)) {
                    return !SystemCmdTool.isMonitorRunning4Linux(serviceName);
                }
                if (SERVICE_DDOS_COLLECTOR.equals(serviceName)) {
                    cmdQueryService = SERVICE_DDOS_COLLECTOR_LINUX;
                } else {
                    if (SERVICE_DDOS_LEGOSERVICE.equals(serviceName)) {
                        return false;
                    }
                    return false;
                }
            }
            String regSuccess = "^[\\d ]+$";
            CmdResult result = null;
            int trytimes = 0;
            while (true) {
                if (!(result = SystemCmdTool.exeCmd(cmdQueryService)).isSuccess().booleanValue()) {
                    log.error((Object)"queryServiceState result is not Successful.");
                    return false;
                }
                if (Pattern.matches(regSuccess, result.getDisplayMessage())) break;
                if (SERVICE_STATE_STOP_PENDING.equals(stateMatchedContinue) && "".equals(result.getDisplayMessage())) {
                    return false;
                }
                if (SERVICE_STATE_STOP_PENDING.equals(stateMatchedContinue) && "not exist".equals(result.getDisplayMessage())) {
                    return false;
                }
                if (maxTimes > 0 && ++trytimes > maxTimes) {
                    log.error((Object)("try max times :" + trytimes));
                    return false;
                }
                Thread.sleep(1000L);
            }
            return true;
        }
        String cmdQueryService = SC_OPT_QUERY + serviceName;
        if (!Pattern.matches("[0-9A-Za-z@]+", serviceName)) {
            log.error((Object)("serviceName error : " + SystemCmdTool.getcleanedMessage(serviceName)));
            return false;
        }
        CmdResult result = null;
        int trytimes = 0;
        while (true) {
            if (!(result = SystemCmdTool.exeCmd(cmdQueryService)).isSuccess().booleanValue()) {
                log.error((Object)"queryServiceState result is not Successful.");
                return false;
            }
            if (!result.getDisplayMessage().contains(stateMatchedContinue)) break;
            if (maxTimes > 0 && ++trytimes > maxTimes) {
                log.error((Object)("try max times :" + trytimes));
                return false;
            }
            Thread.sleep(1000L);
        }
        return true;
    }

    public static boolean deleteFile(String fileName) {
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            return SystemCmdTool.deleteFileLinux(fileName);
        }
        return SystemCmdTool.deleteFileWindow(fileName);
    }

    private static boolean deleteFileWindow(String fileName) {
        File dirFile = new File(fileName);
        if (dirFile.exists()) {
            if (dirFile.isFile()) {
                return dirFile.delete();
            }
            if (dirFile.isDirectory()) {
                File[] files = dirFile.listFiles();
                if (null != files && files.length > 0) {
                    for (int i = 0; i < files.length; ++i) {
                        SystemCmdTool.deleteFile(files[i].getAbsolutePath());
                    }
                }
                return dirFile.delete();
            }
        }
        return true;
    }

    public static boolean chownFileLinux(String userGroup, String fileName) {
        File dirFile = new File(fileName);
        if (dirFile.exists()) {
            try {
                log.info((Object)("chown file is " + fileName));
                CmdResult rs = SystemCmdTool.exeCmd(CHOWN_CMD_LINUX + " " + userGroup + " " + fileName);
                log.info((Object)("chown rs is " + rs.getErrorMessage()));
            }
            catch (ConfigBackupException e) {
                log.error((Object)"chown file failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static boolean deleteFileLinux(String fileName) {
        File dirFile = new File(fileName);
        if (dirFile.exists()) {
            try {
                CmdResult rs = SystemCmdTool.exeCmd(DELETE_CMD_LINUX + " " + fileName);
                log.info((Object)("delete rs is " + rs.getErrorMessage()));
            }
            catch (ConfigBackupException e) {
                log.error((Object)"delete file failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupInfo readFileBackupInfo(File fromfile, String charSet, boolean isOnlyFileInfo) throws ConfigBackupException {
        log.info((Object)("readFileBackupInfo-> isOnlyFileInfo:" + isOnlyFileInfo));
        FileInputStream from = null;
        BufferedReader in = null;
        String fi = "";
        String fp = "";
        String cf = "";
        try {
            from = new FileInputStream(fromfile);
            in = new BufferedReader(new InputStreamReader((InputStream)from, charSet));
            String buff = in.readLine();
            while (buff != null) {
                if (BackupCheckKit.isMatchFileInfo(buff)) {
                    fi = buff;
                    log.info((Object)("fi:" + SystemCmdTool.getcleanedMessage(fi)));
                } else if (BackupCheckKit.isMatchFingerPrint(buff)) {
                    fp = buff;
                    log.info((Object)("fp:" + SystemCmdTool.getcleanedMessage(fp)));
                } else if (BackupCheckKit.isMatchCF(buff)) {
                    cf = buff;
                    log.info((Object)("cf:" + SystemCmdTool.getcleanedMessage(cf)));
                    break;
                }
                buff = in.readLine();
            }
        }
        catch (IOException e) {
            throw new ConfigBackupException(571622, (Throwable)e);
        }
        finally {
            try {
                if (null != from) {
                    try {
                        from.close();
                    }
                    catch (Exception e) {
                        SystemCmdTool.logErrorSafely(e);
                    }
                }
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        SystemCmdTool.logErrorSafely(e);
                    }
                }
            }
        }
        BackupFile fileinfoObj = BackupCheckKit.getFileInfoFromUploadFile(fi, fp, isOnlyFileInfo);
        BackupInfo backupInfo = new BackupInfo(fp, cf, fileinfoObj);
        return backupInfo;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public static void appendInfoToFile(BackupFile backupFile) throws ConfigBackupException {
        String fileInfo = BackupCheckKit.getBackupFileInfo(backupFile);
        log.info((Object)("appendInfoToFile-> fileInfo:" + SystemCmdTool.getcleanedMessage(fileInfo) + " file:"));
        File fromFile = new File(backupFile.getFilePath());
        if (!fromFile.exists()) {
            throw new ConfigBackupException(571618, new String[]{backupFile.getFilePath()});
        }
        if (!fromFile.isFile()) {
            throw new ConfigBackupException(571619, new String[]{backupFile.getFilePath()});
        }
        if (!fromFile.canRead() || !fromFile.canWrite()) {
            throw new ConfigBackupException(571620, new String[]{backupFile.getFilePath()});
        }
        RandomAccessFile randomFile = null;
        try {
            randomFile = new RandomAccessFile(backupFile.getFilePath(), "rw");
            long fileLength = randomFile.length();
            randomFile.seek(fileLength);
            randomFile.writeBytes(fileInfo);
        }
        catch (FileNotFoundException e) {
            throw new ConfigBackupException(571621, (Throwable)e);
        }
        catch (IOException e) {
            throw new ConfigBackupException(571621, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new ConfigBackupException(571621, (Throwable)e);
        }
        finally {
            if (randomFile != null) {
                try {
                    randomFile.close();
                }
                catch (Exception e) {
                    SystemCmdTool.logErrorSafely(e);
                }
            }
        }
    }

    private static void checkCopyFilesForUpload(File fromfile, File tofile) throws ConfigBackupException {
        String fromFilePath = null;
        String toFilePath = null;
        try {
            fromFilePath = fromfile.getCanonicalPath();
            toFilePath = tofile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
        }
        if (!fromfile.exists()) {
            throw new ConfigBackupException(571623, new String[]{fromFilePath});
        }
        if (!fromfile.isFile()) {
            throw new ConfigBackupException(571624, new String[]{fromFilePath});
        }
        if (!fromfile.canRead()) {
            throw new ConfigBackupException(571625, new String[]{fromFilePath});
        }
        if (tofile.isDirectory()) {
            throw new ConfigBackupException(571626, new String[]{toFilePath});
        }
        if (tofile.exists()) {
            if (!tofile.canWrite()) {
                throw new ConfigBackupException(571627, new String[]{toFilePath});
            }
        } else {
            File dir;
            String parent = tofile.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                throw new ConfigBackupException(571628, new String[]{parent});
            }
            if (dir.isFile()) {
                throw new ConfigBackupException(571629, new String[]{parent});
            }
            if (!dir.canWrite()) {
                throw new ConfigBackupException(571630, new String[]{parent});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupFile copyFileWithoutBackupInfo(String uploadFile, String toname, String charSet) throws ConfigBackupException {
        log.info((Object)("copyFileWithoutBackupInfo-> uploadFile:" + SystemCmdTool.getcleanedMessage(uploadFile) + " to_name:" + SystemCmdTool.getcleanedMessage(toname)));
        String csn = Charset.defaultCharset().name();
        File fromFile = new File(uploadFile);
        File toFile = new File(toname);
        SystemCmdTool.checkCopyFilesForUpload(fromFile, toFile);
        FileInputStream from = null;
        FileOutputStream to = null;
        MessageDigest digest = null;
        BackupInfo backupInfo = SystemCmdTool.readFileBackupInfo(fromFile, charSet, false);
        String fileVersion = backupInfo.getFileinfoObj().getVersion();
        String currentVersion = BackupConfigUtil.currentATICVersion();
        if (!currentVersion.equalsIgnoreCase(fileVersion)) {
            throw new ConfigBackupException(571670, new String[]{fileVersion, currentVersion});
        }
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            digest = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[4096];
            long filesize = backupInfo.getFileinfoObj().getSize();
            long totalRead = 0L;
            long preTotalRead = 0L;
            while ((bytesRead = from.read(buffer)) != -1) {
                preTotalRead = totalRead;
                if ((totalRead += (long)bytesRead) <= filesize) {
                    to.write(buffer, 0, bytesRead);
                    digest.update(buffer, 0, bytesRead);
                    continue;
                }
                int rest = (int)(filesize - preTotalRead);
                to.write(buffer, 0, rest);
                digest.update(buffer, 0, rest);
                break;
            }
            digest.update(backupInfo.getFp().getBytes(csn));
            digest.update("/*======F\n".getBytes(csn));
            BigInteger bigInt = new BigInteger(1, digest.digest());
            String filecf = bigInt.toString(16);
            log.info((Object)("copyFileWithoutBackupInfo-> filecf:" + SystemCmdTool.getcleanedMessage(filecf) + "  backupInfo.getCf():" + SystemCmdTool.getcleanedMessage(backupInfo.getCf())));
            backupInfo.getFileinfoObj().setFilePath(toFile.getCanonicalPath());
            BackupCheckKit.checkFingerprintFromUploadFile(backupInfo.getFileinfoObj(), filecf, backupInfo.getCf());
            BackupFile backupFile = backupInfo.getFileinfoObj();
            return backupFile;
        }
        catch (IOException e) {
            throw new ConfigBackupException(571631, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigBackupException(571607, new String[]{"SHA-256"}, e);
        }
        finally {
            try {
                if (null != from) {
                    try {
                        from.close();
                    }
                    catch (Exception e) {
                        SystemCmdTool.logErrorSafely(e);
                    }
                }
            }
            finally {
                if (null != to) {
                    try {
                        to.close();
                    }
                    catch (Exception e) {
                        SystemCmdTool.logErrorSafely(e);
                    }
                }
            }
        }
    }

    private static void checkCopyFiles(File fromfile, File tofile) throws ConfigBackupException {
        String fromFilePath = null;
        String toFilePath = null;
        try {
            fromFilePath = fromfile.getCanonicalPath();
            toFilePath = tofile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
        }
        if (!fromfile.exists()) {
            throw new ConfigBackupException(571633, new String[]{fromFilePath});
        }
        if (!fromfile.isFile()) {
            throw new ConfigBackupException(571634, new String[]{fromFilePath});
        }
        if (!fromfile.canRead()) {
            throw new ConfigBackupException(571635, new String[]{fromFilePath});
        }
        if (tofile.isDirectory()) {
            throw new ConfigBackupException(571626, new String[]{toFilePath});
        }
        if (tofile.exists()) {
            if (!tofile.canWrite()) {
                throw new ConfigBackupException(571627, new String[]{toFilePath});
            }
        } else {
            File dir;
            String parent = tofile.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                throw new ConfigBackupException(571628, new String[]{parent});
            }
            if (dir.isFile()) {
                throw new ConfigBackupException(571629, new String[]{parent});
            }
            if (!dir.canWrite()) {
                throw new ConfigBackupException(571630, new String[]{parent});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileWithBackupInfo(ConfigBackupDBBean file, String toname) throws ConfigBackupException {
        String fpCode = BackupCheckKit.getBackupFileFPInfo(file);
        String csn = Charset.defaultCharset().name();
        String backupFilePath = file.getBackupBase();
        log.info((Object)"copyFileWithBackupInfo-> backupFilePath.");
        File fromFile = new File(backupFilePath);
        File toFile = new File(toname);
        SystemCmdTool.checkCopyFiles(fromFile, toFile);
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            MessageDigest digest = null;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            digest = MessageDigest.getInstance("SHA-256");
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
                digest.update(buffer, 0, bytesRead);
            }
            to.write(fpCode.getBytes(csn));
            digest.update(fpCode.getBytes(csn));
            digest.update("/*======F\n".getBytes(csn));
            BigInteger bigInt = new BigInteger(1, digest.digest());
            String cf = bigInt.toString(16);
            log.info((Object)("copyFileWithBackupInfo-> cf:" + SystemCmdTool.getcleanedMessage(cf)));
            to.write(BackupCheckKit.getFileConfirmInfo(cf));
        }
        catch (IOException e) {
            throw new ConfigBackupException(571631, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigBackupException(571607, new String[]{"SHA-256"}, e);
        }
        finally {
            try {
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (Exception e) {
                        SystemCmdTool.logErrorSafely(e);
                    }
                }
            }
            finally {
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (Exception e) {
                        SystemCmdTool.logErrorSafely(e);
                    }
                }
            }
        }
    }

    public static void logErrorSafely(Throwable e) {
        try {
            log.error((Object)e.getMessage(), e);
        }
        catch (Exception ex) {
            log.error((Object)"log.error", e);
        }
    }

    public static String getStopServiceCmd(String serviceName) {
        String cmdString = null;
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            String installPath = AticInstallUtil.getInstance().getAticInstallPath();
            File install = new File(installPath);
            if (SERVICE_DDOS_LEGOSERVICE.equals(serviceName)) {
                return SERVICE_DDOS_LEGOSERVICE;
            }
            if (SERVICE_DDOS_COLLECTOR.equals(serviceName)) {
                cmdString = install.getParent() + File.separator + "antiddos_collector" + File.separator + "shutdown.sh";
            } else if (SERVICE_DDOS_COLLECTOR_MONITOR.equals(serviceName) || SERVICE_DDOS_LEGOMONITOR.equals(serviceName)) {
                cmdString = serviceName;
            } else if (SERVICE_DDOS_MYSQLSERVICE.equals(serviceName)) {
                cmdString = "sudo " + File.separator + "etc" + File.separator + "init.d" + File.separator + "mysql stop";
            }
        } else {
            cmdString = SC_OPT_STOP + serviceName;
        }
        return cmdString;
    }

    public static String getStartServiceCmd(String serviceName) {
        String cmdString = null;
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            String installPath = AticInstallUtil.getInstance().getAticInstallPath();
            File install = new File(installPath);
            if (SERVICE_DDOS_LEGOSERVICE.equals(serviceName)) {
                return SERVICE_DDOS_LEGOSERVICE;
            }
            if (SERVICE_DDOS_COLLECTOR.equals(serviceName)) {
                cmdString = install.getParent() + File.separator + "antiddos_collector" + File.separator + "startup.sh";
            } else if (SERVICE_DDOS_COLLECTOR_MONITOR.equals(serviceName) || SERVICE_DDOS_LEGOMONITOR.equals(serviceName)) {
                cmdString = serviceName;
            } else if (SERVICE_DDOS_MYSQLSERVICE.equals(serviceName)) {
                cmdString = "sudo " + File.separator + "etc" + File.separator + "init.d" + File.separator + "mysql start";
            }
        } else {
            cmdString = SC_OPT_START + serviceName;
        }
        return cmdString;
    }

    private static boolean isMonitorRunning4Linux(String service) {
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(MONITOR_FILE_PATH_LINUX);
            if (document != null) {
                Element rootElement = document.getRootElement();
                List elements = rootElement.elements();
                for (Element element : elements) {
                    if (null == element.attribute("name") || !service.equals(element.attribute("name").getValue())) continue;
                    List eles = element.elements();
                    for (Element ele : eles) {
                        if (!"check".equals(ele.getName()) || null == ele.getText() || !"yes".equalsIgnoreCase(ele.getText())) continue;
                        return true;
                    }
                }
            }
        }
        catch (DocumentException e) {
            log.error((Object)("read monitor file filed: " + service));
        }
        return false;
    }

    public static boolean changeMonitorState4Linux(String serviceName, boolean isOn) {
        String service = null;
        if (SERVICE_DDOS_COLLECTOR_MONITOR.equals(serviceName)) {
            service = "antiddos_collector";
        } else if (SERVICE_DDOS_LEGOMONITOR.equals(serviceName)) {
            service = "atic";
        }
        if (null == service) {
            return false;
        }
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(MONITOR_FILE_PATH_LINUX);
            if (document != null) {
                String checkYes = "yes";
                String checkNo = "no";
                Element rootElement = document.getRootElement();
                List elements = rootElement.elements();
                for (Element element : elements) {
                    if (null == element.attribute("name") || !service.equals(element.attribute("name").getValue())) continue;
                    List eles = element.elements();
                    for (Element ele : eles) {
                        if (!"check".equals(ele.getName())) continue;
                        if (isOn && checkYes.equals(ele.getText())) {
                            log.info((Object)("monitor no change :" + service + "," + isOn));
                            return true;
                        }
                        if (!isOn && checkNo.equals(ele.getText())) {
                            log.info((Object)("monitor no change :" + service + "," + isOn));
                            return true;
                        }
                        if (isOn) {
                            ele.setText(checkYes);
                        } else {
                            ele.setText(checkNo);
                        }
                        return SystemCmdTool.outputXml(MONITOR_FILE_PATH_LINUX, document);
                    }
                }
            }
        }
        catch (DocumentException e) {
            log.error((Object)("read monitor file filed: " + service));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean outputXml(String path, Document doc) {
        XMLWriter writer = null;
        FileOutputStream out = null;
        File f = new File(path);
        if (f.exists()) {
            try {
                out = new FileOutputStream(path);
                OutputFormat format = OutputFormat.createPrettyPrint();
                format.setEncoding("UTF-8");
                writer = new XMLWriter((OutputStream)out, format);
                writer.write(doc);
                log.error((Object)"write xml success.");
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException e) {
                log.error((Object)("file not find:" + path));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("unsupport encoding:" + path));
            }
            catch (IOException e) {
                log.error((Object)("IO exception:" + path));
            }
            finally {
                try {
                    if (null != writer) {
                        writer.close();
                    }
                    if (null != out) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Close io error" + path));
                }
            }
        }
        return false;
    }
}

