/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.sdk.util;

import com.hs.atic.sdk.system.form.BasicInfoForm;
import com.hs.atic.sdk.system.form.HaInfoForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class BasicInfoUtil {
    public static final String INSTALL_CONFIG_FILE_NAME = "legoPlatInstalled.xml";
    private static final String HA_SERVICE = "ps -ef | grep java | grep ha.jar | grep -v grep | awk '{print $2}'";
    private static final String HA_FILE = "find / -name vsm_ha_server";
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_BACKUP);

    private BasicInfoUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicInfoForm getBasicInfo() {
        BasicInfoForm form = new BasicInfoForm();
        String installedFile = "";
        SAXReader sax = new SAXReader();
        FileInputStream fin = null;
        try {
            String installPathStr = AticInstallUtil.getInstance().getInstallPath();
            boolean isSpLinux = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("/");
            boolean isSpWindows = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("\\");
            if (!isSpLinux && !isSpWindows) {
                installPathStr = installPathStr + File.separator;
            }
            form.setInstallPath(installPathStr);
            installedFile = installPathStr + INSTALL_CONFIG_FILE_NAME;
            sax.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document document = sax.read(new File(installedFile));
            Element rootElem = document.getRootElement();
            Element propMapElem = rootElem.element("propMap");
            List entryElems = propMapElem.elements("entry");
            form.setDbType(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.type"));
            form.setHost(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.ipaddress"));
            form.setPort(Integer.valueOf(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.port")));
            form.setUser(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.username"));
            form.setPassword(BasicInfoUtil.praseEntryValue(entryElems, "lego.db.password.encrypt"));
            String configFile = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "version.txt";
            Properties config = new Properties();
            fin = new FileInputStream(configFile);
            config.load(fin);
            String version = config.getProperty("Server", "VSB");
            version = version.split("=")[1].trim();
            form.setVersion(version);
        }
        catch (SAXException e) {
            logger.error((Object)e.getMessage());
            BasicInfoForm basicInfoForm = null;
            return basicInfoForm;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"getBasicInfo FileNotFoundException error, fileName: legoPlatInstalled.xml");
            BasicInfoForm basicInfoForm = null;
            return basicInfoForm;
        }
        catch (DocumentException e) {
            logger.error((Object)"getBasicInfo DocumentException:", (Throwable)e);
            BasicInfoForm basicInfoForm = null;
            return basicInfoForm;
        }
        catch (IOException e) {
            logger.error((Object)"getBasicInfo IOException:", (Throwable)e);
            BasicInfoForm basicInfoForm = null;
            return basicInfoForm;
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close fin IOException:", (Throwable)e);
                }
            }
        }
        return form;
    }

    private static String praseEntryValue(List<Element> entryElems, String entryType) {
        String entryValue = "";
        for (Element element : entryElems) {
            String type = element.elementText("string");
            Element tempElem = element.element("com.huawei.elog.base.model.ContextPropVal");
            String value = tempElem.elementText("value");
            if (!entryType.equals(type)) continue;
            entryValue = value;
            break;
        }
        return entryValue;
    }

    public static HaInfoForm hasHaService() {
        HaInfoForm form = new HaInfoForm();
        try {
            String cmdResult = "";
            if (AticInstallUtil.getInstance().getAticInstallOS() == 1) {
                cmdResult = BasicInfoUtil.execCmdResult(HA_SERVICE);
                form.setInstall(cmdResult.contains("vsm_ha_servier"));
                cmdResult = BasicInfoUtil.execCmdResult(HA_FILE);
                form.setStart(Pattern.matches("^[\\d]+$", cmdResult));
            } else {
                cmdResult = BasicInfoUtil.execCmdResult("sc query VSMHA");
                form.setInstall(cmdResult.contains("VSMHA"));
                if (cmdResult.contains("STATE") && cmdResult.contains("RUNNING")) {
                    form.setStart(true);
                } else if (cmdResult.contains("STATE") && cmdResult.contains("STOPPED")) {
                    form.setStart(false);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"hasHaService error", (Throwable)e);
        }
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execCmdResult(String cmd) throws IOException {
        Process p = null;
        BufferedReader br = null;
        StringBuffer result = new StringBuffer();
        String csn = Charset.defaultCharset().name();
        try {
            if (AticInstallUtil.getInstance().getAticInstallOS() == 1) {
                String[] cmdPara = new String[]{"/bin/sh", "-c", cmd};
                p = Runtime.getRuntime().exec(cmdPara);
            } else {
                p = Runtime.getRuntime().exec("cmd /c  " + cmd);
            }
            br = new BufferedReader(new InputStreamReader(p.getInputStream(), csn));
            String line = null;
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
        }
        finally {
            if (null != br) {
                br.close();
            }
        }
        return result.toString();
    }
}

