/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect;

import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.hs.lego.core.sdk.base.dataprotect.KmcManager;
import com.hs.lego.core.sdk.util.StringConverter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProtector {
    public static final String CHARSETNAME = "UTF-8";
    private static Logger log = LoggerFactory.getLogger(DataProtector.class);
    private static final int MAX_TRY = 4;
    private static final int IV_LEN = 16;
    private static final int INT_LEN = 4;
    private static final long SUCCESS = 0L;
    private static final int MIN_CIPHER_BUFF_LEN = 144;
    private static Object lock = new Object();
    private KmcManager kmc = null;
    private byte[] dhParamP = null;
    private byte[] dhParamG = null;

    public DataProtector(String libFolderPath, KmcFiles kmcFileNames) {
        KmcManager.loadKmcLib(libFolderPath);
        this.kmc = new KmcManager(kmcFileNames);
    }

    public DataProtector(String libFolderPath, KmcFiles kmcFileNames, byte[] dhParamP, byte[] dhParamG) {
        KmcManager.loadKmcLib(libFolderPath);
        this.kmc = new KmcManager(kmcFileNames);
        this.dhParamP = new byte[dhParamP.length];
        System.arraycopy(dhParamP, 0, this.dhParamP, 0, dhParamP.length);
        this.dhParamG = new byte[dhParamG.length];
        System.arraycopy(dhParamG, 0, this.dhParamG, 0, dhParamG.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sdpEncrypt(long domainId, String pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = "";
        }
        String pucCipherText = null;
        try {
            byte[] pucPlainBytes = pucPlainText.getBytes(CHARSETNAME);
            long pulCipherLen = 0L;
            Object object = lock;
            synchronized (object) {
                this.kmc.doBeforeUse();
                pulCipherLen = this.kmc.sdpGetCipherDataLen(pucPlainBytes.length);
            }
            if (pulCipherLen <= 0L) {
                log.error("KMC sdpGetCipherDataLen error");
                return null;
            }
            byte[] pucCipherBytes = new byte[Integer.parseInt(String.valueOf(pulCipherLen))];
            Object object2 = lock;
            synchronized (object2) {
                this.kmc.doBeforeUse();
                pulCipherLen = this.kmc.sdpEncrypt(domainId, pucPlainBytes, pucPlainBytes.length, pucCipherBytes, pulCipherLen);
            }
            if (pulCipherLen <= 0L) {
                log.error("KMC sdpEncrypt error ");
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(pucCipherBytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] result = new byte[Integer.parseInt(String.valueOf(pulCipherLen))];
            buffer.get(result, 0, result.length);
            pucCipherText = StringConverter.getInstanse().parseByte2HexStr(result);
        }
        catch (UnsupportedEncodingException e) {
            log.error("sdpEncrypt UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            log.error("sdpEncrypt Exception", (Throwable)e);
        }
        return pucCipherText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sdpDecrypt(long domainId, String pucCipherText) {
        String pucPlain = null;
        if (null == pucCipherText || pucCipherText.isEmpty()) {
            log.error("KMC sdpDecrypt input error,pucCipherText is null or empty");
            return pucCipherText;
        }
        try {
            byte[] pucCipherBytes = StringConverter.getInstanse().parseHexStr2Byte(pucCipherText);
            if (pucCipherBytes.length == 0) {
                log.error("sdpDecrypt error, pucCipherBytes is null");
                return pucPlain;
            }
            Integer pulPTLen = Math.max(pucCipherBytes.length * 2, 144);
            byte[] pucPlainByte = new byte[pulPTLen.intValue()];
            long errorCode = 0L;
            Object object = lock;
            synchronized (object) {
                this.kmc.doBeforeUse();
                errorCode = this.kmc.sdpDecrypt(domainId, pucCipherBytes, pucCipherBytes.length, pucPlainByte, pulPTLen);
            }
            if (0L != errorCode) {
                log.error("KMC sdpDecrypt error,errorCode=" + errorCode);
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(pucPlainByte);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] result = new byte[pulPTLen.intValue()];
            buffer.get(result, 0, result.length);
            pucPlain = new String(result, CHARSETNAME);
        }
        catch (UnsupportedEncodingException e) {
            log.error("sdpDecrypt UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            log.error("sdpDecrypt Exception", (Throwable)e);
        }
        return pucPlain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sdpProtectPwd(String pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = "";
        }
        String pucCipherText = null;
        try {
            byte[] pucPlainBytes = pucPlainText.getBytes(CHARSETNAME);
            long pulCipherLen = 0L;
            Object object = lock;
            synchronized (object) {
                this.kmc.doBeforeUse();
                pulCipherLen = this.kmc.sdpGetPwdCipherLen(pucPlainBytes.length);
            }
            if (pulCipherLen <= 0L) {
                log.error("KMC sdpGetPwdCipherLen error ");
                return null;
            }
            byte[] pulCipherBytes = new byte[Integer.parseInt(String.valueOf(pulCipherLen))];
            long errorCode = 0L;
            Object object2 = lock;
            synchronized (object2) {
                this.kmc.doBeforeUse();
                errorCode = this.kmc.sdpProtectPwd(pucPlainBytes, pucPlainBytes.length, pulCipherBytes, pulCipherLen);
            }
            if (0L != errorCode) {
                log.error("KMC sdpProtectPwd error ,errorCode=" + errorCode);
                return null;
            }
            pucCipherText = StringConverter.getInstanse().parseByte2HexStr(pulCipherBytes);
        }
        catch (UnsupportedEncodingException e) {
            log.error("sdpProtectPwd UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            log.error("sdpProtectPwd Exception", (Throwable)e);
        }
        return pucCipherText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        boolean result = false;
        if (null == pucPlainText) {
            pucPlainText = "";
        }
        if (null == pucCipherText || pucCipherText.isEmpty()) {
            log.error("KMC sdpVerifyPwd input error,pucCipherText is null or empty");
        }
        try {
            byte[] pucPlainByte = pucPlainText.getBytes(CHARSETNAME);
            byte[] pucCipherBytes = StringConverter.getInstanse().parseHexStr2Byte(pucCipherText);
            long errorCode = 0L;
            if (pucCipherBytes.length == 0) {
                log.error("sdpVerifyPwd error, pucCipherBytes is null");
                return result;
            }
            Object object = lock;
            synchronized (object) {
                this.kmc.doBeforeUse();
                errorCode = this.kmc.sdpVerifyPwd(pucPlainByte, pucPlainByte.length, pucCipherBytes, pucCipherBytes.length);
            }
            if (0L == errorCode) {
                result = true;
            } else {
                log.error("KMC sdpVerifyPwd error ,errorCode=" + errorCode);
                result = false;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("sdpVerifyPwd UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            log.error("sdpVerifyPwd Exception", (Throwable)e);
        }
        return result;
    }

    public byte[] sdpEncryptByShareKeyAES256(byte[] secretKey, String pucPlainText) {
        if (null == secretKey || secretKey.length == 0) {
            log.error("decrypt error,secretKey can not be null or empty");
            return new byte[0];
        }
        if (null == pucPlainText) {
            pucPlainText = "";
        }
        byte[] cipertext = new byte[]{};
        byte[] iv = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        for (int i = 0; i < 4; ++i) {
            byte[] temp = null;
            try {
                byte[] byteIn = pucPlainText.getBytes(CHARSETNAME);
                temp = this.encryptByAES256Inner(secretKey, byteIn, iv);
                if (temp == null) continue;
                int tLen = temp.length;
                int resultTmpLen = tLen + 16;
                byte[] resultTemp = new byte[resultTmpLen];
                System.arraycopy(temp, 0, resultTemp, 0, tLen);
                System.arraycopy(iv, 0, resultTemp, tLen, 16);
                byte[] iv2 = new byte[16];
                System.arraycopy(secretKey, 0, iv2, 0, 16);
                byte[] resultTmp2 = this.encryptByAES256Inner(secretKey, resultTemp, iv2);
                int resultLen = resultTmp2.length;
                cipertext = new byte[resultLen + 4 + 4];
                byte[] lenByte1 = this.int2byte(resultTmpLen);
                byte[] lenByte2 = this.int2byte(resultLen);
                System.arraycopy(lenByte2, 0, cipertext, 0, 4);
                System.arraycopy(lenByte1, 0, cipertext, 4, 4);
                System.arraycopy(resultTmp2, 0, cipertext, 8, resultLen);
                break;
            }
            catch (Exception e) {
                log.error("sdpEncryptByShareKeyAES256 error", (Throwable)e);
            }
        }
        return cipertext;
    }

    private byte[] int2byte(int res) {
        byte[] targets = new byte[]{(byte)(res & 0xFF), (byte)(res >> 8 & 0xFF), (byte)(res >> 16 & 0xFF), (byte)(res >>> 24)};
        return targets;
    }

    private byte[] encryptByAES256Inner(byte[] secretKey, byte[] byteIn, byte[] iv) {
        byte[] cipertext = null;
        try {
            IvParameterSpec ivps = new IvParameterSpec(iv);
            SecretKeySpec sks = new SecretKeySpec(secretKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)sks, ivps);
            byte[] plaintext = this.prepareAesPlanBytes(byteIn);
            cipertext = cipher.doFinal(plaintext);
        }
        catch (RuntimeException e) {
            log.error("Error: runtime exception: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("encryptByAES256Inner error", (Throwable)e);
        }
        return cipertext;
    }

    private byte[] prepareAesPlanBytes(byte[] byteIn) {
        int len = byteIn.length;
        int v = len / 16;
        if (v * 16 < len) {
            ++v;
        }
        byte[] plaintext = new byte[v * 16];
        System.arraycopy(byteIn, 0, plaintext, 0, byteIn.length);
        for (int i2 = byteIn.length; i2 < plaintext.length; ++i2) {
            plaintext[i2] = 0;
        }
        return plaintext;
    }

    public String sdpDecryptByShareKeyAES256(byte[] secretKey, byte[] datades) {
        if (null == secretKey || secretKey.length == 0) {
            log.error("decrypt error,secretKey can not be null or empty");
            return null;
        }
        if (null == datades || datades.length == 0) {
            log.error("decrypt error,datades can not be null or empty");
            return null;
        }
        if (datades.length <= 8) {
            log.error("decrypt error,datades is not correct");
            return null;
        }
        String newPlainStr = null;
        try {
            byte[] iv2 = new byte[16];
            System.arraycopy(secretKey, 0, iv2, 0, 16);
            byte[] toDecry = new byte[datades.length - 8];
            System.arraycopy(datades, 8, toDecry, 0, toDecry.length);
            byte[] newPlainTextTemp = this.decryptByAES256Inner(secretKey, toDecry, iv2);
            if (null == newPlainTextTemp) {
                return null;
            }
            int tLen = newPlainTextTemp.length;
            if (tLen <= 16) {
                log.error("decrypt error,temp length is not correct.");
                return null;
            }
            int cLen = tLen - 16;
            byte[] decrypt1 = new byte[cLen];
            byte[] iv = new byte[16];
            System.arraycopy(newPlainTextTemp, 0, decrypt1, 0, cLen);
            System.arraycopy(newPlainTextTemp, cLen, iv, 0, 16);
            byte[] newPlainText = this.decryptByAES256Inner(secretKey, decrypt1, iv);
            if (null != newPlainText) {
                newPlainStr = new String(newPlainText, CHARSETNAME).trim();
            }
        }
        catch (Exception e) {
            log.error("decrypt error:", (Throwable)e);
        }
        return newPlainStr;
    }

    private byte[] decryptByAES256Inner(byte[] secretKey, byte[] datades, byte[] iv) {
        byte[] newPlainText = null;
        try {
            IvParameterSpec ivps = new IvParameterSpec(iv);
            SecretKeySpec sks = new SecretKeySpec(secretKey, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)sks, ivps);
            newPlainText = cipher.doFinal(datades);
        }
        catch (RuntimeException e) {
            log.error("Error: runtime exception: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error("decryptByAES256Inner error: ", (Throwable)e);
        }
        return newPlainText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sdpHmac(String pucPlainText) {
        if (null == pucPlainText) {
            pucPlainText = "";
        }
        String pucCipherText = null;
        try {
            byte[] pucPlainByte = pucPlainText.getBytes(CHARSETNAME);
            byte[] pucCipherBytes = null;
            Object object = lock;
            synchronized (object) {
                pucCipherBytes = this.kmc.sdpHmac(pucPlainByte);
            }
            pucCipherText = StringConverter.getInstanse().parseByte2HexStr(pucCipherBytes);
        }
        catch (UnsupportedEncodingException e) {
            log.error("sdpDecrypt UnsupportedEncodingException", (Throwable)e);
        }
        catch (Exception e) {
            log.error("sdpDecrypt Exception", (Throwable)e);
        }
        return pucCipherText;
    }
}

