/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect;

import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.SystemExitUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmcManager {
    private static Logger log = LoggerFactory.getLogger(KmcManager.class);
    private static KmcFiles currKmcFiles = null;
    private KmcFiles kmcFileNames = null;

    public KmcManager(KmcFiles kmcFileNames) {
        this.kmcFileNames = kmcFileNames;
    }

    public static void loadKmcLib(String libFolderPath) {
        if (null == libFolderPath) {
            return;
        }
        try {
            System.load(libFolderPath + "/libeay32.dll");
            System.load(libFolderPath + "/libSDP4j.dll");
        }
        catch (UnsatisfiedLinkError ule) {
            log.error("UnsatisfiedLinkError,Can not find the shared library for kmc:" + ule);
            String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
            String errMsgx = ResourceManager.getString("INSTALL.KMC.ERROR", OS_NAME);
            OptionPane.showErrorDialog(errMsgx);
            SystemExitUtil.systemExit(0);
        }
        catch (Exception e) {
            log.error("Exception when loading kmc:" + e);
            String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
            String errMsgx = ResourceManager.getString("INSTALL.KMC.ERROR", OS_NAME);
            OptionPane.showErrorDialog(errMsgx);
            SystemExitUtil.systemExit(0);
        }
    }

    public void doBeforeUse() {
        if (this.kmcFileNames != null && !this.kmcFileNames.equals(currKmcFiles)) {
            this.reload();
        }
    }

    private void init() {
        long errorCode = this.wsecInitialize(this.kmcFileNames.getKeyStoreFile(), this.kmcFileNames.getKeyStoreBakFile(), this.kmcFileNames.getKmcCfgFile(), this.kmcFileNames.getKmcCfgBakFile(), this.kmcFileNames.getLogConfigFile());
        if (errorCode > 0L) {
            log.error("wsecInitialize errorCode=" + errorCode);
        }
        currKmcFiles = this.kmcFileNames;
    }

    private void reload() {
        if (null != currKmcFiles) {
            this.wsecFinalize();
        }
        this.init();
    }

    public native long wsecInitialize(String var1, String var2, String var3, String var4, String var5);

    public native long wsecFinalize();

    public native long sdpGetCipherDataLen(long var1);

    public native long sdpEncrypt(long var1, byte[] var3, long var4, byte[] var6, long var7);

    public native long sdpDecrypt(long var1, byte[] var3, long var4, byte[] var6, Integer var7);

    public native long sdpGetPwdCipherLen(long var1);

    public native long sdpProtectPwd(byte[] var1, long var2, byte[] var4, long var5);

    public native long sdpVerifyPwd(byte[] var1, long var2, byte[] var4, long var5);

    public byte[] sdpHmac(byte[] pucPlainText) {
        MessageDigest md = null;
        String encName = "SHA-256";
        try {
            md = MessageDigest.getInstance(encName);
            md.update(pucPlainText);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("sdpHmac NoSuchAlgorithmException", (Throwable)e);
        }
        catch (Exception e) {
            log.error("sdpHmac Exception", (Throwable)e);
        }
        return new byte[0];
    }
}

