/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect.util;

import com.hs.lego.core.sdk.base.dataprotect.DataProtector;
import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectConfigHelper;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LegoDataProtector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LegoDataProtector");
    private static DataProtector dataProtector = null;
    private static DataProtector dataProtectorInit = null;

    private static synchronized DataProtector getInstance() {
        if (null == dataProtector) {
            String libFolderPath = DataProtectConfigHelper.getKmclibPath();
            String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
            String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcLogConfigFile");
            String dhP = DataProtectConfigHelper.getConfigValue("dh_p");
            byte[] dhPBytes = new byte[]{};
            try {
                dhPBytes = dhP.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e1) {
                LOGGER.error("DataProtector", (Throwable)e1);
            }
            String dhG = DataProtectConfigHelper.getConfigValue("dh_g");
            byte[] dhGBytes = new byte[]{};
            try {
                dhGBytes = dhG.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("DataProtector", (Throwable)e);
            }
            String keyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("keyStoreFile");
            String keyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("keyStoreBakFile");
            String kmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcCfgFile");
            String kmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcCfgBakFile");
            KmcFiles kf = new KmcFiles();
            kf.setKeyStoreFile(keyStoreFile);
            kf.setKeyStoreBakFile(keyStoreBakFile);
            kf.setKmcCfgFile(kmcCfgFile);
            kf.setKmcCfgBakFile(kmcCfgBakFile);
            kf.setLogConfigFile(kmcLogConfigFile);
            dataProtector = new DataProtector(libFolderPath, kf, dhPBytes, dhGBytes);
            LOGGER.info("dataProtector init end");
        }
        return dataProtector;
    }

    private static synchronized DataProtector getInitInstance() {
        if (null == dataProtectorInit) {
            String libFolderPath = DataProtectConfigHelper.getKmclibPath();
            String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
            String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcLogConfigFile");
            String dhP = DataProtectConfigHelper.getConfigValue("dh_p");
            byte[] dhPBytes = new byte[]{};
            try {
                dhPBytes = dhP.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("DataProtector", (Throwable)e);
            }
            String dhG = DataProtectConfigHelper.getConfigValue("dh_g");
            byte[] dhGBytes = new byte[]{};
            try {
                dhGBytes = dhG.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("DataProtector", (Throwable)e);
            }
            String initkeyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreFile");
            String initkeyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreBakFile");
            String initkmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgFile");
            String initkmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgBakFile");
            KmcFiles kfInit = new KmcFiles();
            kfInit.setKeyStoreFile(initkeyStoreFile);
            kfInit.setKeyStoreBakFile(initkeyStoreBakFile);
            kfInit.setKmcCfgFile(initkmcCfgFile);
            kfInit.setKmcCfgBakFile(initkmcCfgBakFile);
            kfInit.setLogConfigFile(kmcLogConfigFile);
            dataProtectorInit = new DataProtector(libFolderPath, kfInit, dhPBytes, dhGBytes);
        }
        return dataProtectorInit;
    }

    public static String sdpEncrypt(long domainId, String pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(domainId, pucPlainText);
    }

    public static String sdpEncryptLocal(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpEncryptInitData(String pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpDecrypt(long domainId, String pucCipherText) {
        String plainText = LegoDataProtector.getInstance().sdpDecrypt(domainId, pucCipherText);
        if (null == plainText) {
            LOGGER.info("sdpDecrypt fail,try sdpDecryptInitData.");
            plainText = LegoDataProtector.sdpDecryptInitData(pucCipherText);
            if (null == plainText) {
                LOGGER.error("sdpDecrypt try decrypt init data fail.");
            }
        }
        return plainText;
    }

    public static String sdpDecryptLocal(String pucCipherText) {
        return LegoDataProtector.sdpDecrypt(0L, pucCipherText);
    }

    public static String sdpDecryptInitData(String pucCipherText) {
        String plainText = LegoDataProtector.getInitInstance().sdpDecrypt(0L, pucCipherText);
        if (null == plainText) {
            LOGGER.error("sdpDecryptInitData fail.");
        }
        return plainText;
    }

    public static String sdpProtectPwd(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpProtectPwd(pucPlainText);
    }

    public static String sdpProtectPwdInitData(String pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpProtectPwd(pucPlainText);
    }

    public static boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        boolean result = LegoDataProtector.getInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        if (!result) {
            result = LegoDataProtector.getInitInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        }
        return result;
    }

    public static byte[] sdpEncryptByShareKeyAES256(byte[] secretKey, String pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncryptByShareKeyAES256(secretKey, pucPlainText);
    }

    public static String sdpDecryptByShareKeyAES256(byte[] secretKey, byte[] pucCipherText) {
        return LegoDataProtector.getInstance().sdpDecryptByShareKeyAES256(secretKey, pucCipherText);
    }

    public static String sdpHmac(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpHmac(pucPlainText);
    }
}

