/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.file.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesLoader.class);

    private PropertiesLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String fileFullPath, boolean fromClassPath) throws IOException {
        InputStream in = null;
        Properties prop = null;
        try {
            in = fromClassPath ? PropertiesLoader.class.getClassLoader().getResourceAsStream(fileFullPath) : new FileInputStream(fileFullPath);
            if (in != null) {
                prop = new Properties();
                if (fileFullPath.endsWith("xml")) {
                    prop.loadFromXML(in);
                } else {
                    prop.load(in);
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("Close file stream failed: ", (Throwable)e);
                }
            }
        }
        return prop;
    }
}

