/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectorHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectorHelper.class);

    private CollectorHelper() {
    }

    public static void parseClStoreConfig() {
        String installMode = InstallContext.getInstance().getInstallMode();
        if ("install".equalsIgnoreCase(installMode)) {
            String hightOrLowCfg = ContextUtil.getStrValueFromCtx("collector.install.config.high.or.low");
            if (null == hightOrLowCfg || hightOrLowCfg.trim().isEmpty()) {
                ContextUtil.saveSearalizeValue2Ctx("collector.install.config.high.or.low", "32G");
            }
        } else if ("update".equalsIgnoreCase(installMode)) {
            LOGGER.error("unknown modified type.");
        }
    }

    public static void parsePerformanceConf() {
        Double mem = Double.parseDouble(ContextUtil.getStrValueFromCtx("lego.base.osmemory"));
        String scene = CommonUtil.getInstallScene();
        if (4096.0 > mem * 1024.0) {
            if ("Integrated Scene".equals(scene)) {
                ContextUtil.saveSearalizeValue2Ctx("performance.conf", "1");
            } else {
                ContextUtil.saveSearalizeValue2Ctx("performance.conf", "2");
            }
        } else if (4096.0 <= mem * 1024.0 && 8000.0 > mem * 1024.0) {
            ContextUtil.saveSearalizeValue2Ctx("performance.conf", "2");
        } else if (8000.0 <= mem * 1024.0 && 16000.0 > mem * 1024.0) {
            if ("Integrated Scene".equals(scene)) {
                ContextUtil.saveSearalizeValue2Ctx("performance.conf", "2");
            } else {
                ContextUtil.saveSearalizeValue2Ctx("performance.conf", "3");
            }
        } else if (16000.0 <= mem * 1024.0) {
            ContextUtil.saveSearalizeValue2Ctx("performance.conf", "4");
        }
    }
}

