/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.action;

import com.huawei.elog.base.exception.StartException;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.window.StartActionInvoke;
import com.huawei.elog.ui.window.StartWindow;
import com.huawei.elog.ui.window.WindowProcessManager;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectorAction {
    private static final Logger LOG = LoggerFactory.getLogger(CollectorAction.class);

    private CollectorAction() {
    }

    public static void startCollector() {
        LOG.info("################ " + Calendar.getInstance().getTime().toString() + " Start elog collector service begin.##############", (Object)"eLogCollector");
        boolean needShutDown = false;
        try {
            StartActionInvoke.checkCollectorPort();
            StartActionInvoke.checkElog();
            needShutDown = true;
            StartActionInvoke.startElog();
            WindowProcessManager.dealWithProcess();
        }
        catch (StartException e) {
            LOG.error("StartUp Error: " + e.getErrorCode() + ", meg: " + e, (Object)"eLogCollector");
            String errorMessage = ResourceManager.getString("start.err." + e.getErrorCode());
            if (e.getErrorCode() == 10002L) {
                errorMessage = ResourceManager.getString("start.err." + e.getErrorCode(), e.getMessage());
            }
            StartWindow.getInstance().setVisible(false);
            if (e.getErrorCode() == 20007L) {
                errorMessage = ResourceManager.getString("start.err." + e.getErrorCode(), e.getMessage());
            }
            OptionPane.showErrorDialog(errorMessage);
            if (needShutDown) {
                StartActionInvoke.shutdownElog();
            }
            LOG.info("Start elog end.##########################################################", (Object)"eLogCollector");
            CommonUtil.shutDownJvm(0);
        }
        catch (Exception e) {
            LOG.error("Start elog collector Error:" + e, (Object)"eLogCollector");
            StartWindow.getInstance().setVisible(false);
            OptionPane.showErrorDialog(ResourceManager.getString("start.err.10000"));
            if (needShutDown) {
                StartActionInvoke.shutdownElog();
            }
            LOG.info("Start Elog collector end.##########################################################", (Object)"eLogCollector");
            CommonUtil.shutDownJvm(0);
        }
        StartWindow.getInstance().setVisible(false);
        OptionPane.showInfoDialog(ResourceManager.getString("LEGO.START.SUCCESS", PropertyManager.getProValue("collector.software.install.elog")));
        LOG.info("Start LEGO end.##########################################################", (Object)"eLogCollector");
        CommonUtil.shutDownJvm(0);
    }

    public static void checkDisk() {
        CollectorAction collector = new CollectorAction();
        String onlinesavePath = ContextUtil.getStrValueFromCtx("online.data.path");
        String dumpsavePath = ContextUtil.getStrValueFromCtx("dump.data.path");
        if (onlinesavePath != null && !onlinesavePath.isEmpty()) {
            collector.mountDisk(onlinesavePath);
        }
        if (dumpsavePath != null && !dumpsavePath.isEmpty()) {
            collector.mountDisk(dumpsavePath);
        }
    }

    public void mountDisk(String filePath) {
        List<File> dataFiles = CollectorAction.getALLDataFiles(filePath);
        for (File f : dataFiles) {
            String path;
            if (!f.isDirectory() || !this.checkMountPath(path = f.getPath())) continue;
            this.mkMountDist(path);
        }
    }

    public static List<File> getALLDataFiles(String path) {
        if (null == path) {
            return null;
        }
        return CollectorAction.getFiles(path, "^data_{1}[0-9]{1,}");
    }

    public static List<File> getFiles(String filePath, String name) {
        ArrayList<File> refile = new ArrayList<File>();
        File root = new File(filePath);
        if (!root.exists()) {
            return refile;
        }
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                String s = file.getName();
                if (!s.matches(name)) continue;
                refile.add(file);
            }
        }
        return refile;
    }

    public boolean checkMountPath(String filePath) {
        if (OSUtil.isWindows()) {
            return this.checkDiskToWin(filePath);
        }
        return this.checkDiskToLinux(filePath);
    }

    private boolean checkDiskToWin(String filePath) {
        String str = this.creartFlie("mountdisk.txt");
        this.writeFile(str);
        String content = this.getMountContent(str);
        return null != content && content.contains(filePath);
    }

    public boolean checkDiskToLinux(String filePath) {
        String content = this.getMountContent("df -lh |awk -F ' ' '{print $6}'");
        return null != content && content.contains(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String path) {
        String filePath = path;
        File file = new File(filePath);
        FileOutputStream fos = null;
        try {
            byte[] bytes = "list volume\n".getBytes("UTF-8");
            int b = bytes.length;
            fos = new FileOutputStream(file);
            fos.write(bytes, 0, b);
        }
        catch (FileNotFoundException e) {
            LOG.error("FileNotFoundException error.");
        }
        catch (IOException e) {
            LOG.error("fos write error.");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LOG.error(" fos close error" + fos);
            }
        }
    }

    private void mkMountDist(String filePath) {
        try {
            if (OSUtil.isWindows()) {
                File file = new File(filePath + File.separator + "mountdisk");
                if (!file.exists()) {
                    boolean createNewFileResult = file.createNewFile();
                    LOG.debug("createNewFile result:" + createNewFileResult);
                }
            } else {
                File file = new File(filePath + File.separator + ".mountdisk");
                if (!file.exists()) {
                    boolean createNewFileResult = file.createNewFile();
                    LOG.debug("createNewFile result:" + createNewFileResult);
                }
            }
        }
        catch (IOException e) {
            LOG.error("createNewFile or del error" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMountContent(String filePath) {
        StringBuffer contentBuffer = new StringBuffer();
        InputStream in = null;
        InputStreamReader inStreamTemp = null;
        OutputStream out = null;
        Process process = null;
        BufferedReader lnr = null;
        BufferedReader br = null;
        if (!CollectorAction.validateCmd(filePath)) {
            LOG.error("executeCommand error, filePath is valid.");
            return null;
        }
        try {
            if (OSUtil.isWindows()) {
                StringBuffer parmeter = new StringBuffer();
                parmeter.append("diskpart /s ");
                parmeter.append(filePath);
                ProcessBuilder pb = new ProcessBuilder(parmeter.toString().split(" "));
                pb.redirectErrorStream(true);
                process = pb.start();
                in = process.getInputStream();
                inStreamTemp = new InputStreamReader(in, "GBK");
                br = new BufferedReader(inStreamTemp);
                String line = null;
                while ((line = br.readLine()) != null) {
                    contentBuffer.append(line + "\n");
                }
                out = process.getOutputStream();
                out.write(10);
                process.waitFor();
            }
        }
        catch (IOException e) {
            LOG.error(" getMountContent error");
        }
        catch (InterruptedException e) {
            LOG.error(" getMountContent error");
        }
        finally {
            StreamProcUtil.close(br);
            StreamProcUtil.close(inStreamTemp);
            StreamProcUtil.close(lnr);
            if (null != process) {
                process.destroy();
            }
        }
        return contentBuffer.toString();
    }

    private String creartFlie(String file) {
        String toolPath = System.getProperty("user.dir") + File.separator + "logs" + File.separator;
        StringBuffer parmeter = new StringBuffer();
        parmeter.append(toolPath);
        parmeter.append(file);
        File sbfile = new File(toolPath);
        File nn = new File(toolPath, file);
        if (!sbfile.exists()) {
            boolean mkdirsResult = sbfile.mkdirs();
            LOG.debug("mkdirsResult result:" + mkdirsResult);
            try {
                boolean createNewFileResult = nn.createNewFile();
                LOG.debug("createNewFile result:" + createNewFileResult);
            }
            catch (IOException e) {
                LOG.error(" createNewFile error.");
            }
        } else {
            try {
                boolean deleteResult = nn.delete();
                LOG.debug("deleteResult result:" + deleteResult);
                boolean createNewFileResult = nn.createNewFile();
                LOG.debug("createNewFile result:" + createNewFileResult);
            }
            catch (IOException e) {
                LOG.error(" createNewFile or del error", (Throwable)e);
            }
        }
        return parmeter.toString();
    }

    private static boolean validateCmd(String arg) {
        String[] badInput;
        for (String bad : badInput = new String[]{"&&", "&", "||", "|", ";", "$", ">", ">>", "<"}) {
            if (!arg.contains(bad)) continue;
            return false;
        }
        return true;
    }
}

