/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.action;

import com.huawei.elog.base.exception.StartException;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.ProUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpCheckAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCheckAction.class);
    private static final String LEGO_PROPERTIES_FILE_NAME = "/installConf.properties";
    private static final int RETRY_TIME;

    public static void doAction() {
        int httpPort = ProUtil.getHttpPort();
        if (0 != httpPort) {
            int index = 0;
            while (index++ < RETRY_TIME) {
                String testUrl = "http://" + ContextUtil.getStrValueFromCtx("lego.base.serverIpAddress") + ":" + httpPort + "/legotestpage.jsp";
                if (HttpCheckAction.testHttpConnection(testUrl) && ProUtil.checkStartStatusFlag()) {
                    LOGGER.info("HttpTest succ.", (Object)"doAction");
                    return;
                }
                try {
                    LOGGER.info("HttpTest failed, retry after sleep five seconds.", (Object)"doAction");
                    TimeUnit.SECONDS.sleep(10L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("HttpTest failed:" + e, (Object)"doAction");
                }
            }
        }
        throw new StartException(10008L);
    }

    public static boolean testHttpConnection(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Testing http connection has error happened." + e, (Object)"testHttpConnection");
            return false;
        }
        URLConnection connection = null;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            LOGGER.error("Testing http connection has error happened." + e, (Object)"testHttpConnection");
            return false;
        }
        connection.setConnectTimeout(5000);
        try {
            connection.connect();
        }
        catch (IOException e) {
            LOGGER.error("Testing http connection has error happened." + e, (Object)"testHttpConnection");
            return false;
        }
        return true;
    }

    static {
        String retStr = (String)ProUtil.getLocalPro(LEGO_PROPERTIES_FILE_NAME, "retry.http.test.time");
        RETRY_TIME = null != retStr ? Integer.parseInt(retStr) : 24;
    }
}

