/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.action;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.exception.RunningException;
import com.huawei.elog.base.exception.ServiceException;
import com.huawei.elog.base.exception.StartException;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.window.SetStartWindowsThread;
import com.huawei.elog.ui.window.StartWindow;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.DBConnectionFactory;
import com.huawei.elog.util.IDBConnection;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PortCheckUtil;
import com.huawei.elog.util.ProUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.ServiceUtil;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.elog.util.WindowUtil;
import com.huawei.elog.util.db.DBUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StartCheckAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartCheckAction.class);

    public static void doAction() {
        boolean isWebRun;
        boolean isMonitorRun = ServiceUtil.isServiceRunning("LEGOMonitor");
        if (isMonitorRun && (isWebRun = ServiceUtil.isServiceRunning("LEGOWebSrv"))) {
            String errMsg = "The Monitor Or WebService is different from the running state.";
            LOGGER.info(errMsg, (Object)"isRunMonitorService");
            SetStartWindowsThread.getInstance().setMaxNumber(1);
            OptionPane.showInfoDialog(ResourceManager.getString("SHOW.THE.SERVICE.IS.RESTART.HIMSELF"));
            throw new RunningException(errMsg);
        }
        if (!PortCheckUtil.isCheckSystemUsing()) {
            String errMsg = ResourceManager.getString("start.err.10001");
            OptionPane.showInfoDialog(errMsg);
            throw new RunningException(10001L);
        }
        if (!StartCheckAction.checkDataBase()) {
            // empty if block
        }
        if (StartCheckAction.isIPInvalid()) {
            throw new RunningException(ResourceManager.getString("VSM.IP.NOT.IN.LIST.ERROR"));
        }
        try {
            StartCheckAction.checkServices();
        }
        catch (RunningException e) {
            LOGGER.error("RunningException", (Throwable)e);
            SetStartWindowsThread.getInstance().setMaxNumber(1);
            OptionPane.showErrorDialog(ResourceManager.getString("VSM.COLLECTOR.SYSTEM.INUSING.SERVER"));
            SystemExitUtil.systemExit(0);
        }
        catch (ServiceException e) {
            LOGGER.error("ServiceException", (Throwable)e);
            SetStartWindowsThread.getInstance().setMaxNumber(1);
            OptionPane.showErrorDialog(ResourceManager.getString("VSM.COLLECTOR.SYSTEM.INUSING.SERVER"));
            SystemExitUtil.systemExit(0);
        }
        catch (StartException e) {
            LOGGER.error("StartException", (Throwable)e);
            SetStartWindowsThread.getInstance().setMaxNumber(1);
            OptionPane.showErrorDialog(ResourceManager.getString("start.err." + e.getErrorCode(), e.getMessage()));
            SystemExitUtil.systemExit(0);
        }
    }

    public static boolean checkServices() {
        boolean state = true;
        try {
            StartCheckAction.checkServiceState("LEGOWebSrv");
            StartCheckAction.checkLegoReg("LEGOWebSrv");
            StartCheckAction.checkServiceState("LEGOMonitor");
            StartCheckAction.checkLegoReg("LEGOMonitor");
            List<String> servicesList = ProUtil.getProductServices();
            LOGGER.info("Lego Service size: " + servicesList.size() + " : " + servicesList, (Object)"checkServices");
            for (String service : servicesList) {
                LOGGER.debug("-------------- Check Lego Service " + service + " --------------", (Object)"servicesList");
                StartCheckAction.checkServiceState(service);
                StartCheckAction.checkProductReg(service);
            }
        }
        catch (Exception e) {
            LOGGER.error("In StartCheckAction of checkServices:", (Throwable)e);
        }
        return state;
    }

    private static boolean checkServiceState(String serviceName) {
        boolean isValid = true;
        LOGGER.debug("check serivce exist or not: " + serviceName, (Object)"checkServiceState");
        if (ServiceUtil.isServiceNotExist(serviceName)) {
            isValid = false;
            String errMsg = ResourceManager.getString("VSM.SERVICE.NOT.FOUND.ERROR", serviceName);
            OptionPane.showErrorDialog(errMsg);
            LOGGER.error(errMsg, (Object)"checkServiceState");
            throw new ServiceException(errMsg);
        }
        LOGGER.debug("check serivce is disabled: " + serviceName, (Object)"checkServiceState");
        if (ServiceUtil.isServiceDisabled(serviceName)) {
            isValid = false;
            StartWindow.getInstance().setVisible(false);
            String errMsg = ResourceManager.getString("VSM.SERVICE.STATUS.TYPE.DISABLED.ERROR", serviceName);
            OptionPane.showErrorDialog(errMsg);
            LOGGER.error(errMsg, (Object)"checkServiceState");
            throw new ServiceException(errMsg);
        }
        LOGGER.debug("check serivce is running: " + serviceName, (Object)"checkServiceState");
        if (ServiceUtil.isServiceRunning(serviceName)) {
            isValid = false;
            StartWindow.getInstance().setVisible(false);
            String errMsg = ResourceManager.getString("VSM.SERVICE.RUNNING.ERROR", serviceName);
            OptionPane.showErrorDialog(errMsg);
            LOGGER.error(errMsg, (Object)"checkServiceState");
            throw new ServiceException(errMsg);
        }
        LOGGER.debug("Check Service " + serviceName + " OK", (Object)"checkServiceState");
        return isValid;
    }

    public static void checkLegoReg(String service) {
        String info = null;
        try {
            info = StartCheckAction.getLegoRegInfo(service);
            File file = new File(info);
            if (!file.exists()) {
                StartWindow.getInstance().setVisible(false);
                OptionPane.showErrorDialog(ResourceManager.getString("REG.ADDRESS.NOT.EXISTS.ERROR", service));
                LOGGER.info("jvm info of file not exist, the system will withdraw.");
                CommonUtil.shutDownJvm(1);
            } else {
                LOGGER.debug("Check Lego Regedit OK. " + service, (Object)"checkLegoReg");
            }
        }
        catch (Exception e) {
            LOGGER.error("Get Lego Service Regedit Error" + e, (Object)"checkLegoReg");
        }
    }

    public static String getLegoRegInfo(String pathName) {
        String infoStr = "";
        Map<String, String> regmap = WindowUtil.readRegPath("HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Apache Software Foundation\\Procrun 2.0\\" + pathName + "\\Parameters\\Java");
        if (regmap.containsKey("Jvm")) {
            infoStr = regmap.get("Jvm");
        }
        return infoStr;
    }

    public static void checkProductReg(String service) {
        File file;
        String info = null;
        String localIP = null;
        InstallContext context = InstallContext.getInstance();
        ContextPropVal iPVal = context.getEnvirments().getPropertyMap().getProp("lego.base.installIpAddress");
        if (iPVal != null) {
            localIP = iPVal.getValue().toString();
            LOGGER.debug("Local IP = " + localIP, (Object)"checkProductReg");
        }
        if (service.equalsIgnoreCase("LogCollector") && !(file = new File(info = StartCheckAction.getProductRegInfo(service))).exists()) {
            StartWindow.getInstance().setVisible(false);
            String errMsg = ResourceManager.getString("REG.ADDRESS.NOT.EXISTS.ERROR", service);
            OptionPane.showErrorDialog(errMsg);
            LOGGER.error(errMsg, (Object)"checkProductReg");
            throw new ServiceException(errMsg);
        }
    }

    public static String getProductRegInfo(String pathName) {
        String infoStr = "";
        Map<String, String> regmap = WindowUtil.readRegPath("HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Huawei\\Secoway_eLog\\" + pathName);
        if (regmap.containsKey("InstallLocation")) {
            infoStr = regmap.get("InstallLocation");
        }
        if (regmap.containsKey("TaoNamingServiceOptions")) {
            infoStr = regmap.get("TaoNamingServiceOptions");
        }
        return infoStr;
    }

    private static boolean checkDataBase() {
        DataBaseInfo dbInfo = DBUtil.getBaseInfo();
        IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfo);
        if (null != dbConnection && dbConnection.isConnected(dbInfo, true)) {
            LOGGER.debug("CheckDataBase connection success, dbtype is " + dbInfo.getDbType(), (Object)"checkDataBase");
            return true;
        }
        return false;
    }

    public static boolean isIPInvalid() {
        boolean isInvalid = false;
        String collectorIP = ContextUtil.getStrValueFromCtx("lego.base.installIpAddress");
        String serverIP = ContextUtil.getStrValueFromCtx("lego.base.serverIpAddress");
        LOGGER.info("lego.base.installIpAddress: " + collectorIP, (Object)"isIPValid");
        LOGGER.info("lego.base.serverIpAddress: " + serverIP, (Object)"isIPValid");
        LOGGER.debug("collector installed ip is: " + collectorIP, (Object)"isIPValid");
        LOGGER.debug("server installed ip is: " + serverIP, (Object)"isIPValid");
        List<String> ipList = OSUtil.getLocalAllIps();
        if (!ipList.contains(collectorIP)) {
            String errMsg = ResourceManager.getString("VSM.IP.NOT.IN.LIST.ERROR");
            OptionPane.showErrorDialog(errMsg);
            LOGGER.error("collectorIP " + collectorIP + " is not in installed iplist: " + ipList + " , and jvm will be shutdown with code 1...", (Object)"isIPValid");
            LOGGER.error(errMsg);
            isInvalid = true;
            return isInvalid;
        }
        if (!ipList.contains(serverIP)) {
            String errMsg = ResourceManager.getString("VSM.IP.NOT.IN.LIST.ERROR");
            OptionPane.showErrorDialog(errMsg);
            LOGGER.error("serverIP " + serverIP + " is not in installed iplist: " + ipList + " , and jvm will be shutdown with code 1...", (Object)"isIPValid");
            LOGGER.error(errMsg);
            isInvalid = true;
            return isInvalid;
        }
        return isInvalid;
    }
}

