/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.action;

import com.huawei.elog.util.ProUtil;
import com.huawei.elog.util.ProgramUtil;
import com.huawei.elog.util.StartsvcUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StartSystemAction {
    private static final String LEGO_PROPERTIES_FILE_NAME = "/installConf.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(StartSystemAction.class);
    private static final String STATUS_STARTED = "started";
    private static final int RETRY_TIME;
    private static int iRETRYSTART;
    private static final int RETRY_INCREMENT;
    private static final int OSGI_SERVICES_DETECTED_INTERVAL_SECONDS = 10;

    public static void doStartLegoAction() {
        LOGGER.info("Start Lego system...", (Object)"StartLegoAction");
        ProgramUtil.execCommand("cmd /c call net start LEGOWebSrv");
        if (StartsvcUtil.isIndexServerEnabled()) {
            StartsvcUtil.startService("IndexServer");
            StartsvcUtil.startService("IndexDataServer");
        }
        if (StartsvcUtil.checkJDBCStatus("uninstall")) {
            StartsvcUtil.startService(StartsvcUtil.SVC_JDBC_NAME);
        }
    }

    public static void doStartProductService() {
        List<String> services = ProUtil.getProductServices();
        LOGGER.info("Product service size: " + services.size() + " : " + services, (Object)"doStartProductService");
        for (String cmd : services) {
            LOGGER.info("====================== Begin start service: {} ===================== ", (Object)cmd);
            if (null == cmd) continue;
            StartsvcUtil.startService(cmd);
        }
    }

    private static boolean checkStartStatus() {
        LOGGER.debug("^^^^^^^^^^^^ START LEGO SERVICE STATE: {}^^^^^^^^^^^^", (Object)(iRETRYSTART / 30));
        int i = 0;
        String status = null;
        while (i++ < iRETRYSTART) {
            status = ProUtil.getStartStatus();
            if (null != status) {
                if (STATUS_STARTED.equals(status)) {
                    LOGGER.info("Server Start successful!", (Object)"checkStartStatus");
                    return true;
                }
                LOGGER.info("startup status: {} is unknown ", (Object)status);
            }
            try {
                LOGGER.info("Test failed, the current number of times= {} ,retry after sleep {} seconds.", (Object)i, (Object)10);
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Test failed:" + e.getMessage(), (Object)"checkStartStatus");
            }
        }
        LOGGER.debug("^^^^^^^^^^^^ END LEGO SERVICE STATE ^^^^^^^^^^^^", (Object)"checkStartStatus");
        LOGGER.error("OSGI Service Start failed!", (Object)"checkStartStatus");
        return false;
    }

    public static void doStartMonitorAction() {
        LOGGER.info("Do Start Monitor:", (Object)"Start LEGO system...");
        String command = "cmd /c sc start LEGOMonitor";
        ProgramUtil.execCommand(command);
    }

    static {
        String retTimes = (String)ProUtil.getLocalPro(LEGO_PROPERTIES_FILE_NAME, "retry.backend.time");
        String retryStart = (String)ProUtil.getLocalPro(LEGO_PROPERTIES_FILE_NAME, "retry.backend.start");
        String retryIncrement = (String)ProUtil.getLocalPro(LEGO_PROPERTIES_FILE_NAME, "retry.backend.increment");
        RETRY_TIME = null == retTimes ? 180 : Integer.parseInt(retTimes);
        iRETRYSTART = null == retryStart ? 30 : Integer.parseInt(retryStart);
        RETRY_INCREMENT = null == retryIncrement ? 10 : Integer.parseInt(retryIncrement);
        LOGGER.debug("RETRY_TIME: {} , RETRY_START: {} , RETRY_INCREMENT: {}" + RETRY_TIME, (Object)iRETRYSTART, (Object)RETRY_INCREMENT);
    }
}

