/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.action;

import com.huawei.elog.action.CollectorAction;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.context.ContextLoader;
import com.huawei.elog.base.exception.ParseParmeterException;
import com.huawei.elog.base.exception.StartException;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.window.StartWindow;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.EnvUtil;
import com.huawei.elog.util.ProUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StartupAction {
    private static final Logger LOG = LoggerFactory.getLogger(StartupAction.class);
    private static String scene = null;
    private static int counter = 1;
    private static boolean isIntegratedScene = false;

    private StartupAction() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseParameters(String[] args) throws ParseParmeterException {
        String softName = null;
        String str = EnvUtil.getEnv("LOGCENTER_ROOT");
        LOG.info("********LOGCENTER_ROOT\uff1a {} ********", (Object)str);
        if (null == str || str.equals("")) {
            throw new StartException(10009L);
        }
        if (null != args && args.length > 0) {
            if (!args[0].equals("startelog")) {
                String errMsg = "Unknown parameters, " + args[0];
                LOG.error(errMsg, (Object)"parseParameters");
                throw new ParseParmeterException(errMsg);
            }
            scene = "Collector Scene";
            InstallContext.getInstance().getEnvirments().setBasePath(str + "/antiddos_collector/uninstall/");
            InstallContext.getInstance().setInstallType("Collector");
            softName = PropertyManager.getProValue("collector.software.install.elog");
        } else {
            scene = "Independent Scene";
            InstallContext.getInstance().getEnvirments().setBasePath(str + "/Runtime/bin/");
            softName = PropertyManager.getProValue("software.install.name");
        }
        StartWindow.getInstance().setSoftName(softName);
        LOG.debug("Get software name is: " + softName, (Object)"parseParameters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(String[] args) {
        boolean exceptionFlag = false;
        try {
            StartupAction.parseParameters(args);
            ContextLoader.loadConetext();
            ProUtil.cleanStartStatusFlag();
            StartWindow.getInstance().showWindow(!isIntegratedScene);
            if ("Integrated Scene".equals(scene)) {
                StartupAction.startup(counter);
            } else if ("Independent Scene".equals(scene)) {
                StartupAction.startup(counter);
            } else if ("Collector Scene".equals(scene)) {
                CollectorAction.startCollector();
            } else {
                LOG.error("Unknown scene, scene: " + scene, (Object)"launch");
            }
        }
        catch (ParseParmeterException e) {
            exceptionFlag = true;
            LOG.error("launch", (Throwable)e);
        }
        catch (StartException e) {
            if (e.getErrorCode() == 10009L) {
                String errMsg = ResourceManager.getString("start.err." + e.getErrorCode(), e.getMessage());
                LOG.error(errMsg);
                OptionPane.showErrorDialog(errMsg);
                exceptionFlag = true;
            }
        }
        catch (Exception e) {
            exceptionFlag = true;
            LOG.error("launch", (Throwable)e);
        }
        finally {
            if (exceptionFlag) {
                CommonUtil.shutDownJvm(1);
            } else {
                CommonUtil.shutDownJvm(0);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static void startup(int counterParam) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

