/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant;

import com.huawei.elog.util.PropertyUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class I18nParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(I18nParser.class);
    private static final String I18N_PATH = File.separator + "resource" + File.separator + "i18n" + File.separator;
    private static final String EN_FILE = "_en";
    private static final String CN_FILE = "_zh";
    private static List<String> i18nFiles;
    private static I18nParser parser;

    public static I18nParser getInstance() {
        return parser;
    }

    public Map<Locale, Map<String, String>> initI18nFile() {
        HashMap<Locale, Map<String, String>> map = new HashMap<Locale, Map<String, String>>();
        if (null == i18nFiles || i18nFiles.isEmpty()) {
            return map;
        }
        for (String i18nPath : i18nFiles) {
            File dir = new File(i18nPath);
            File[] files = dir.listFiles();
            if (null == files || files.length <= 0) continue;
            HashMap<String, String> enMap = new HashMap<String, String>();
            HashMap<String, String> cnMap = new HashMap<String, String>();
            for (File file : files) {
                String value;
                String key;
                Set<Map.Entry<Object, Object>> entrSet;
                if (file.getName().contains(CN_FILE)) {
                    PropertyUtil cnProperties = new PropertyUtil(file);
                    Properties cnpro = cnProperties.getProp();
                    entrSet = cnpro.entrySet();
                    for (Map.Entry<Object, Object> entry : entrSet) {
                        key = (String)entry.getKey();
                        value = (String)entry.getValue();
                        cnMap.put(key, value);
                    }
                    continue;
                }
                if (!file.getName().contains(EN_FILE)) continue;
                PropertyUtil enProperties = new PropertyUtil(file);
                Properties enpro = enProperties.getProp();
                entrSet = enpro.entrySet();
                for (Map.Entry<Object, Object> entry : entrSet) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    enMap.put(key, value);
                }
            }
            map.put(Locale.CHINESE, cnMap);
            map.put(Locale.ENGLISH, enMap);
        }
        return map;
    }

    static {
        parser = new I18nParser();
    }
}

