/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.executor;

import com.huawei.elog.ant.listener.CollectorInstallBuildListener;
import com.huawei.elog.ant.listener.CollectorUninstallBuildListener;
import com.huawei.elog.ant.listener.LegoInstallBuildListener;
import com.huawei.elog.ant.listener.LegoUninstallBuildListener;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.exception.EnvException;
import com.huawei.elog.base.exception.InstallException;
import com.huawei.elog.base.model.Bundles;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.base.tools.StartInstallWindow;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.card.install.CopyFilesCard;
import com.huawei.elog.ui.card.uninstall.NeedUninstallBundles;
import com.huawei.elog.ui.card.uninstall.UninstallCard;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.EnvUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import java.io.File;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntExecutor4Esight
implements Runnable {
    public static final String ANTHOME_PROPERTY = "ant.home";
    public static final String ANTLIBDIR_PROPERTY = "ant.library.dir";
    public static final String USER_LIBDIR = ".ant/lib";
    public static final String MAIN_CLASS = "org.apache.tools.ant.Main";
    private static final Logger LOGGER = LoggerFactory.getLogger(AntExecutor4Esight.class);
    private static final String MYSQL = "MySQL";
    private static final String SQLSERVER = "Microsoft SQL Server";
    private static IInstallContext ctx = InstallContext.getInstance();
    private static List<Bundles> installBundles = new LinkedList<Bundles>();
    private static boolean exceptionFlag = false;
    private List<String> noteList = new ArrayList<String>();
    private CountDownLatch latch;

    public AntExecutor4Esight(CountDownLatch latch) {
        this.latch = latch;
    }

    public static boolean isExceptionFlag() {
        return exceptionFlag;
    }

    @Override
    public void run() {
        try {
            this.parseBundles();
            String antHome = ctx.getEnvirments().getBasePath() + "/lib";
            System.setProperty(ANTHOME_PROPERTY, antHome);
            if ("uninstall".equalsIgnoreCase(ctx.getInstallMode())) {
                this.uninstallOperation();
            } else if ("patch".equalsIgnoreCase(ctx.getInstallMode())) {
                LOGGER.debug("patchOperation....", (Object)"patchOperation");
            } else {
                String dbType = ContextUtil.getStrValueFromCtx("lego.db.type");
                if (MYSQL.equalsIgnoreCase(dbType)) {
                    LOGGER.debug("dbType is MYSQL...", (Object)"AntExecutor4Esight");
                } else if (SQLSERVER.equalsIgnoreCase(dbType)) {
                    LOGGER.debug("dbType is SQLSERVER...", (Object)"AntExecutor4Esight");
                }
                this.installOperation();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exec AntExecutor ERROR", (Throwable)e);
        }
        finally {
            this.latch.countDown();
        }
    }

    private void parseBundles() {
        Map platformbundleMap = (Map)ctx.getPropertyMap().getProp("lego.base.components.plat").getValue();
        Map productbundleMap = (Map)ctx.getPropertyMap().getProp("lego.base.components.product").getValue();
        installBundles.addAll(platformbundleMap.values());
        installBundles.addAll(productbundleMap.values());
    }

    private void uninstallOperation() {
        try {
            List<String> frontJarsFiles;
            List<String> backJarsFiles;
            List<Bundles> productBundles;
            String antFileName = "";
            String uninstallPath = "";
            ContextPropVal propVal = ContextUtil.getCpvValueFromCtx("lego.base.is.uninstall.all");
            if (Boolean.valueOf(propVal.getValue().toString()).booleanValue()) {
                productBundles = NeedUninstallBundles.getProductBundles();
                backJarsFiles = null;
                frontJarsFiles = null;
                int index = -1;
                for (Bundles bundles : productBundles) {
                    index = NeedUninstallBundles.getAllBundles().indexOf(bundles);
                    if (index == -1) continue;
                    uninstallPath = bundles.getUninstallPath();
                    backJarsFiles = bundles.getBackJarsFile();
                    frontJarsFiles = bundles.getFrontJarsFile();
                    ContextUtil.saveAntValue2Ctx("uninstallbundle.backend.jar", this.covertList2String(backJarsFiles));
                    ContextUtil.saveAntValue2Ctx("uninstallbundle.frontend.jar", this.covertList2String(frontJarsFiles));
                    ContextUtil.saveAntValue2Ctx("uninstall.bundle.name", bundles.getAntSymbol());
                    StringBuilder title = new StringBuilder();
                    title.append('[');
                    title.append(index + 1);
                    title.append('/');
                    title.append(NeedUninstallBundles.getAllBundles().size());
                    title.append(']');
                    antFileName = uninstallPath.concat(ctx.getInstallMode()).concat("script.xml");
                    this.executeAntProject(ctx, antFileName, bundles.getName(), title.toString());
                }
                List<Bundles> platBundles = NeedUninstallBundles.getPlatformBundles();
                Iterator iterator = platBundles.iterator();
                while (iterator.hasNext()) {
                    Bundles bundle3 = (Bundles)iterator.next();
                    index = NeedUninstallBundles.getAllBundles().indexOf(bundle3);
                    if (index == -1) continue;
                    uninstallPath = bundle3.getUninstallPath();
                    antFileName = uninstallPath.concat(ctx.getInstallMode()).concat("script.xml");
                    StringBuilder title = new StringBuilder();
                    title.append('[');
                    title.append(index + 1);
                    title.append('/');
                    title.append(NeedUninstallBundles.getAllBundles().size());
                    title.append(']');
                    this.executeAntProject(ctx, antFileName, bundle3.getName(), title.toString());
                }
            } else {
                productBundles = NeedUninstallBundles.getProductBundles();
                backJarsFiles = null;
                frontJarsFiles = null;
                String uninstallName = "";
                for (Bundles bundles : productBundles) {
                    uninstallPath = bundles.getUninstallPath();
                    antFileName = uninstallPath.concat(ctx.getInstallMode()).concat("script.xml");
                    backJarsFiles = bundles.getBackJarsFile();
                    this.storeAntInfo2Context(ctx, this.covertList2String(backJarsFiles), "uninstallbundle.backend.jar");
                    frontJarsFiles = bundles.getFrontJarsFile();
                    this.storeAntInfo2Context(ctx, this.covertList2String(frontJarsFiles), "uninstallbundle.frontend.jar");
                    uninstallName = bundles.getAntSymbol();
                    this.storeAntInfo2Context(ctx, uninstallName, "uninstall.bundle.name");
                    this.executeAntProject(ctx, antFileName, null, null);
                }
                if (InstallContext.getInstance().getInstallType().contains("legoPlat")) {
                    this.executeAntProject(ctx, antFileName, null, null);
                }
            }
            String entEnvRoot = PropertyManager.getProValue("ent.env.root");
            try {
                if (!"linux".equalsIgnoreCase(ContextUtil.getStrValueFromCtx("lego.osname.short"))) {
                    String strPath = EnvUtil.getEnv(entEnvRoot);
                    EnvUtil.removeEnv(entEnvRoot);
                    this.removeCollectorPath(strPath + "\\indexserver");
                }
            }
            catch (EnvException enve) {
                String softName = PropertyManager.getProValue("software.install.name");
                String errorMsg = "remove system environment env error, EnvException: " + enve;
                LOGGER.error(errorMsg, (Object)"executeMultiInstallScene");
                char[] mnemonicKeys = new char[]{'O', 'D'};
                OptionPane.showDetailDialog(OptionPane.STRING_ERROR, ResourceManager.getString("VSM.OPERATION.FALIURE.TIP", softName), enve.toString(), 0, false, ResourceManager.getString("InputDBPara.OK"), null, mnemonicKeys);
            }
            LOGGER.info("remove system environment env success.");
        }
        catch (InstallException e) {
            LOGGER.error("Exec AntExecutor ERROR", (Throwable)e);
        }
        String entEnvRoot = PropertyManager.getProValue("ent.env.root");
        try {
            String strPath = EnvUtil.getEnv(entEnvRoot);
            EnvUtil.removeEnv(entEnvRoot);
            this.removeCollectorPath(strPath + "\\indexserver");
        }
        catch (EnvException enve) {
            String softName = PropertyManager.getProValue("software.install.name");
            String errorMsg = "remove system environment env error, EnvException: " + enve;
            LOGGER.error(errorMsg, (Object)"executeMultiInstallScene");
            char[] mnemonicKeys = new char[]{'O', 'D'};
            OptionPane.showDetailDialog(OptionPane.STRING_ERROR, ResourceManager.getString("VSM.OPERATION.FALIURE.TIP", softName), enve.toString(), 0, false, ResourceManager.getString("InputDBPara.OK"), null, mnemonicKeys);
        }
        LOGGER.info("remove system environment env success, executeMultiInstallScene");
    }

    private void removeCollectorPath(String strLogCenterPath) {
        if (new File(strLogCenterPath).exists()) {
            String strPath = "";
            if (EnvUtil.hasEnv("Path")) {
                strPath = EnvUtil.getEnv("Path");
                String[] arrayPath = strPath.split(";");
                strPath = "";
                for (String path : arrayPath) {
                    String normalizePath = Normalizer.normalize(path, Normalizer.Form.NFKC);
                    if ("".equals(normalizePath) || normalizePath.contains(strLogCenterPath + "\\bin")) continue;
                    strPath = strPath.concat(path).concat(";");
                }
                if (!"".equals(strPath)) {
                    if (!strPath.endsWith("/;") && !strPath.endsWith("\\;")) {
                        strPath = strPath.substring(0, strPath.length() - 1);
                    }
                    EnvUtil.setEnv("Path", strPath, "REG_EXPAND_SZ");
                }
            }
        }
    }

    private void installOperation() {
        try {
            StringBuilder title;
            String antFileName = "";
            String uninstallPath = "";
            for (Bundles bundle : installBundles) {
                if ("uninstall".equalsIgnoreCase(ctx.getInstallMode())) {
                    uninstallPath = bundle.getUninstallPath();
                    antFileName = uninstallPath.concat(ctx.getInstallMode()).concat("script.xml");
                } else {
                    antFileName = bundle.getMainFolder().concat(File.separatorChar + "").concat(ctx.getInstallMode()).concat("script.xml");
                }
                if (!bundle.isIsBaseBundle()) continue;
                title = new StringBuilder();
                title.append('[');
                title.append(installBundles.indexOf(bundle) + 1);
                title.append('/');
                title.append(installBundles.size());
                title.append(']');
                this.executeAntProject(ctx, antFileName, bundle.getName(), title.toString());
            }
            for (Bundles bundle : installBundles) {
                if ("uninstall".equalsIgnoreCase(ctx.getInstallMode())) {
                    uninstallPath = bundle.getUninstallPath();
                    antFileName = uninstallPath.concat(ctx.getInstallMode()).concat("script.xml");
                } else {
                    antFileName = bundle.getMainFolder().concat(File.separatorChar + "").concat(ctx.getInstallMode()).concat("script.xml");
                }
                if (!bundle.isIsBaseBundle()) {
                    LOGGER.debug("bundle is: " + bundle.getAntFileName(), (Object)"exec");
                    this.addBundleInfor(ctx, bundle);
                    title = new StringBuilder();
                    title.append('[');
                    title.append(installBundles.indexOf(bundle) + 1);
                    title.append('/');
                    title.append(installBundles.size());
                    title.append(']');
                    this.executeAntProject(ctx, antFileName, bundle.getName(), title.toString());
                }
                if (bundle.isIsBaseBundle()) continue;
                this.removeBundleInfor(ctx);
            }
        }
        catch (InstallException e) {
            LOGGER.error("execute ant script occurs error.", (Throwable)e);
        }
    }

    private String covertList2String(List<String> strLst) {
        StringBuffer sb = new StringBuffer();
        if (null == strLst) {
            return "";
        }
        boolean isFirst = true;
        for (String str : strLst) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(str);
        }
        return sb.toString();
    }

    protected void storeAntInfo2Context(IInstallContext context, String val, String key) {
        ContextPropVal propVal = new ContextPropVal();
        propVal.setIsAntProperty(true);
        propVal.setModifiable(false);
        propVal.setSearalize(false);
        propVal.setValue(val);
        context.getPropertyMap().addProp(key, propVal);
    }

    private void addBundleInfor(IInstallContext contex, Bundles bundle) {
        ContextUtil.saveSearalizeValue2Ctx("install.bundle.name", bundle.getAntSymbol());
        ContextUtil.saveSearalizeValue2Ctx("install.bundle.id", bundle.getId());
        if (null != bundle.getBackJarsFile()) {
            String backJar = bundle.getBackJarsFile().toString();
            backJar = backJar.substring(1, backJar.length() - 1);
            ContextUtil.saveSearalizeValue2Ctx("installbundle.backend.jar", backJar);
        }
        if (null != bundle.getFrontJarsFile()) {
            String frontJar = bundle.getFrontJarsFile().toString();
            frontJar = frontJar.substring(1, frontJar.length() - 1);
            ContextUtil.saveSearalizeValue2Ctx("installbundle.frontend.jar", frontJar);
        }
    }

    private void removeBundleInfor(IInstallContext contex) {
        ContextUtil.removePorp4Context("install.bundle.name");
        ContextUtil.removePorp4Context("install.bundle.id");
        ContextUtil.removePorp4Context("installbundle.backend.jar");
        ContextUtil.removePorp4Context("installbundle.frontend.jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAntProject(IInstallContext context, String antFileName, String bundleName, String title) throws InstallException {
        Project antProject = new Project();
        try {
            File buildFile = new File(antFileName);
            if (!buildFile.exists()) {
                LOGGER.warn("ant file don's exist.");
                return;
            }
            antProject.setBasedir(buildFile.getParentFile().getPath());
            antProject.setUserProperty("ant.file", antFileName);
            antProject.init();
            LOGGER.info("Start to excute the ant file.");
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            helper.parse(antProject, (Object)buildFile);
            ContextUtil.setAntPropertyByContext(antProject);
            Object builderListener = null;
            if ("uninstall".equalsIgnoreCase(context.getInstallMode())) {
                this.noteList.clear();
                for (Bundles b : NeedUninstallBundles.getAllBundles()) {
                    this.noteList.add(ResourceManager.getString(b.getName()));
                }
                if ("legoPlat".equals(context.getInstallType())) {
                    builderListener = new LegoUninstallBuildListener(UninstallCard.getInstance(), this.noteList, bundleName, title);
                } else if ("Collector".equals(context.getInstallType())) {
                    builderListener = new CollectorUninstallBuildListener(UninstallCard.getInstance(), this.noteList, bundleName, title);
                } else {
                    LOGGER.error("install type is unknown, either legPlat nor Collector...", (Object)"executeAntProject");
                }
            } else if ("patch".equalsIgnoreCase(context.getInstallMode())) {
                LOGGER.info("OPERATION_TYPE_PATCH", (Object)"executeAntProject");
            } else if ("install".equalsIgnoreCase(context.getInstallMode())) {
                if ("legoPlat".equals(context.getInstallType())) {
                    builderListener = new LegoInstallBuildListener(CopyFilesCard.getInstance(), bundleName, title);
                } else if ("Collector".equals(context.getInstallType())) {
                    builderListener = new CollectorInstallBuildListener(CopyFilesCard.getInstance(), bundleName, title);
                } else {
                    LOGGER.error("install type is unknown, either legPlat nor Collector...", (Object)"executeAntProject");
                }
            }
            antProject.addBuildListener(builderListener);
            antProject.executeTarget(antProject.getDefaultTarget());
            antProject.fireBuildStarted();
            antProject.fireBuildFinished(null);
        }
        catch (BuildException e) {
            exceptionFlag = true;
            LOGGER.error("executeAntProject", (Throwable)e);
            StartInstallWindow.getInstance().setVisible(false);
            String softName = PropertyManager.getProValue("software.install.name");
            if (e.getMessage() != null && e.getMessage().contains("rename")) {
                char[] mnemonicKeys = new char[]{'O', 'D'};
                OptionPane.showDetailDialog(OptionPane.STRING_ERROR, ResourceManager.getString("LEGO.RENAME.FAIL"), e.toString(), 0, false, ResourceManager.getString("InputDBPara.OK"), null, mnemonicKeys);
            } else {
                char[] mnemonicKeys = new char[]{'O', 'D'};
                OptionPane.showDetailDialog(OptionPane.STRING_ERROR, ResourceManager.getString("VSM.OPERATION.FALIURE.TIP", softName), e.toString(), 0, false, ResourceManager.getString("InputDBPara.OK"), null, mnemonicKeys);
            }
        }
        catch (Exception ex) {
            exceptionFlag = true;
            LOGGER.error("executeAntProject", (Throwable)ex);
            StartInstallWindow.getInstance().setVisible(false);
            String softName = PropertyManager.getProValue("software.install.name");
            char[] mnemonicKeys = new char[]{'O', 'D'};
            OptionPane.showDetailDialog(OptionPane.STRING_ERROR, ResourceManager.getString("VSM.OPERATION.FALIURE.TIP", softName), ex.toString(), 0, false, ResourceManager.getString("InputDBPara.OK"), null, mnemonicKeys);
        }
        finally {
            if (exceptionFlag) {
                if ("install".equalsIgnoreCase(ctx.getInstallMode())) {
                    try {
                        antProject.executeTarget("installError");
                        antProject.fireBuildStarted();
                        antProject.fireBuildFinished(null);
                    }
                    catch (Exception ee) {
                        LOGGER.error("rooling back defeat,exception: " + ee, (Object)"executeAntProject");
                        CommonUtil.shutDownJvm(-1);
                    }
                }
                LOGGER.error("exit the system.", (Object)"executeAntProject");
                CommonUtil.shutDownJvm(0);
            }
        }
    }
}

