/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.executor;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.exception.AccessException;
import com.huawei.elog.base.exception.InstallException;
import com.huawei.elog.base.model.Bundles;
import com.huawei.elog.base.model.Disk;
import com.huawei.elog.base.model.Validport;
import com.huawei.elog.base.sdk.IExecute;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.EnvUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.JarFileUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.ServiceUtil;
import com.huawei.elog.util.UIUtil;
import com.huawei.elog.util.WindowUtil;
import com.huawei.elog.util.WindowsGetMem;
import com.huawei.elog.util.sdp.EncryptData;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvScanExecutor
implements IExecute {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvScanExecutor.class);
    private static final String ELOG_PATH = System.getProperty("user.home");
    private static final String ELOG_CORE_CFG_PATH = "/legoPlatInstalled.xml";
    private static final String COLLECTOR_CORE_CFG_PATH = "/CollectorInstalled.xml";
    private static final String VERSION_V2R2_FEATURE = "com.huawei.vsm.install.common.util.PropertyMap";
    private static final String VERSION_V2R3_FEATURE = "com.huawei.elog.base.model.PropertyMap";
    private static String[] serviceArray = new String[]{"LEGOMonitor", "LEGOWebSrv", "DDOSCOLLECTORSVC", "ATICCOLLECTORGUARDSERVICE"};
    private String coreCfgPath = null;
    private boolean isV2R2 = false;
    private boolean isV2R3 = false;
    private IInstallContext ctx;

    public boolean checkDefaultLanguange() {
        Locale lf = Locale.getDefault(Locale.Category.FORMAT);
        LOGGER.info("local language formated:" + lf);
        if (lf.toString().equals("zh_CN") || lf.toString().equals("en_US")) {
            LOGGER.info("local language formated:" + lf);
            return true;
        }
        OptionPane.showInfoDialog(ResourceManager.getString("OS.Lan.info"));
        return false;
    }

    public boolean checkDisplayLanguange() {
        Locale ld = Locale.getDefault(Locale.Category.DISPLAY);
        LOGGER.info("local language :" + ld);
        if (ld.toString().equals("zh_CN") || ld.toString().equals("en_US")) {
            LOGGER.info("local language:" + ld);
            return true;
        }
        OptionPane.showInfoDialog(ResourceManager.getString("OS.Lan.info"));
        return false;
    }

    @Override
    public boolean exec(IInstallContext context) throws InstallException {
        String softwareName;
        this.ctx = context;
        LOGGER.debug("context.getInstallType(): {}", (Object)context.getInstallType());
        if (!this.checkDefaultLanguange()) {
            CommonUtil.shutDownJvm(-1);
        }
        if (!this.checkDisplayLanguange()) {
            CommonUtil.shutDownJvm(-1);
        }
        ContextUtil.saveSearalizeValue2Ctx("lego.base.path", context.getEnvirments().getBasePath());
        ContextUtil.saveSearalizeValue2Ctx("lego.osname.short", context.getEnvirments().getOsName());
        ContextUtil.saveSimpleValue2Ctx("install.lang", Locale.getDefault());
        ContextUtil.saveSearalizeValue2Ctx("esight.install.scene", "Independent Scene");
        this.parseBundles();
        if ("install".equalsIgnoreCase(context.getInstallMode())) {
            ContextUtil.saveSearalizeValue2Ctx("lego.base.path", context.getEnvirments().getBasePath());
            this.coreCfgPath = ELOG_PATH + ELOG_CORE_CFG_PATH;
            File coreCfgFile = new File(this.coreCfgPath);
            if (!coreCfgFile.exists()) {
                LOGGER.debug("logcenter core config file does not exist.");
                this.coreCfgPath = ELOG_PATH + COLLECTOR_CORE_CFG_PATH;
                coreCfgFile = new File(this.coreCfgPath);
            }
            if (coreCfgFile.exists()) {
                LOGGER.debug("core config file is exist.");
                this.isV2R2 = this.isCoreCfgFileContained(coreCfgFile, VERSION_V2R2_FEATURE);
            } else {
                this.coreCfgPath = WindowUtil.getInstallPath() + ELOG_CORE_CFG_PATH;
                coreCfgFile = new File(this.coreCfgPath);
                if (!coreCfgFile.exists()) {
                    this.coreCfgPath = WindowUtil.getInstallPath() + COLLECTOR_CORE_CFG_PATH;
                    coreCfgFile = new File(this.coreCfgPath);
                }
                if (coreCfgFile.exists()) {
                    LOGGER.info("core config file is exist.");
                    this.isV2R3 = this.isCoreCfgFileContained(coreCfgFile, VERSION_V2R3_FEATURE);
                }
            }
            LOGGER.info("isV2R2: {}, isV2R3: {}", (Object)this.isV2R2, (Object)this.isV2R3);
            String haOrNot = ContextUtil.getStrValueFromCtx("vsm.install.mode.ha");
            if ("HA".equalsIgnoreCase(haOrNot)) {
                LOGGER.info("vcs is installed ,this is HA mode");
            } else if (this.isV2R2) {
                if ("Collector".equals(this.ctx.getInstallType())) {
                    OptionPane.showErrorDialog(ResourceManager.getString("LogCollectorAndLogCenter.Version.NotMatched"));
                    CommonUtil.shutDownJvm(-1);
                }
            } else if (this.isV2R3) {
                String softNameValue = ContextUtil.getStrValueFromCtx("software.install.name");
                if ("Collector".equals(this.ctx.getInstallType())) {
                    String collectorInstalled = ContextUtil.getStrValueFromCtx("collector.install.is.or.not");
                    LOGGER.debug("collectorInstalled: {}", (Object)collectorInstalled);
                    if ("true".equalsIgnoreCase(collectorInstalled)) {
                        OptionPane.showErrorDialog(ResourceManager.getString("LogCollector.IsInstalled", softNameValue));
                        CommonUtil.shutDownJvm(-1);
                    }
                    if (!UIUtil.isSilentMode()) {
                        OptionPane.showErrorDialog(ResourceManager.getString("Introduction.IsInstalled", softNameValue));
                        CommonUtil.shutDownJvm(-1);
                    }
                } else if (!UIUtil.isSilentMode()) {
                    OptionPane.showErrorDialog(ResourceManager.getString("Introduction.IsInstalled", softNameValue));
                    CommonUtil.shutDownJvm(-1);
                }
            }
            if (OSUtil.isWindows()) {
                EnvUtil.removeReg("logCenterUninstall");
                List<String> services = this.getInstalledService();
                if (!services.isEmpty()) {
                    String isServiceInstalledErrMsg = ResourceManager.getString("VSM.SERVICE.FOUND.ERROR", services.toString());
                    LOGGER.error(services + " services is exist, please check services.", (Object)"EnvirmentScanExecutor.isServicesInstalled");
                    int result = OptionPane.showWarnConfirmDialog(isServiceInstalledErrMsg);
                    if (0 == result) {
                        try {
                            this.clearServiceInstalled(services);
                        }
                        catch (AccessException ae) {
                            LOGGER.error("exec", (Throwable)ae);
                            OptionPane.showErrorDialog(ResourceManager.getString("start.err.30001"));
                            return false;
                        }
                        String msg = ResourceManager.getString("Uninstall.Success.Installornot");
                        String msgTitle = OptionPane.STRING_CONFIRMATION;
                        int sel = OptionPane.showInfoConfirmDialog(msg, msgTitle, 0);
                        if (sel != 0) {
                            return false;
                        }
                    } else if (1 == result) {
                        return false;
                    }
                }
            }
            LOGGER.debug("It is installing branch...", (Object)"EnvirmentScanExecutor.exec");
        } else if ("update".equalsIgnoreCase(context.getInstallMode())) {
            softwareName = PropertyManager.getProValue("software.install.name");
            LOGGER.debug("It is upgrading branch...", (Object)"EnvirmentScanExecutor.exec");
            String errorMsg = ResourceManager.getString("Introduction.NotUpgradeCD", softwareName);
            OptionPane.showErrorDialog(errorMsg);
            LOGGER.error(errorMsg, (Object)"checkStandardEdtion");
            CommonUtil.shutDownJvm(-1);
        } else {
            this.decryptPassword();
            if ("Collector".equals(context.getInstallType()) && OSUtil.isWindows() && ServiceUtil.isServiceExist("DDOSCOLLECTORSVC") && ServiceUtil.isServiceRunning("DDOSCOLLECTORSVC")) {
                String errorMsg = ResourceManager.getString("LEGO.BUNDLE.UNINSTALL.COLLECTOR.ON");
                OptionPane.showErrorDialog(errorMsg);
                return false;
            }
        }
        softwareName = PropertyManager.getProValue("software.install.name");
        LOGGER.debug("softwareName: " + softwareName, (Object)"EnvirmentScanExecutor.exec");
        ContextUtil.saveSearalizeValue2Ctx("software.install.name", softwareName);
        ContextUtil.saveSearalizeValue2Ctx("lego.base.iplist", OSUtil.getLocalAllIps());
        this.initSystemInfor();
        return true;
    }

    private List<String> getInstalledService() {
        List<String> services = new ArrayList<String>();
        StringBuilder serviceInstalled = new StringBuilder(16);
        boolean isExist = false;
        for (int i = 0; i < serviceArray.length; ++i) {
            isExist = ServiceUtil.isServiceExist(serviceArray[i]);
            if (isExist) {
                LOGGER.debug(serviceArray[i] + " service is exist...", (Object)"isServicesInstalled");
                serviceInstalled.append(serviceArray[i]);
                if (i != serviceArray.length - 1) {
                    serviceInstalled.append(',');
                }
            } else {
                LOGGER.debug(serviceArray[i] + " service is not exist...", (Object)"isServicesInstalled");
            }
            isExist = false;
        }
        if (serviceInstalled.length() > 1) {
            services = Arrays.asList(serviceInstalled.toString().split(","));
        }
        return services;
    }

    private boolean clearServiceInstalled(List<String> services) {
        LOGGER.debug("services :" + services, (Object)"clearServiceInstalled");
        boolean result = true;
        try {
            for (String service : services) {
                LOGGER.debug("service :" + service, (Object)"clearServiceInstalled");
                if (!"WMIReceiverMgr".equals(service) || (result = ServiceUtil.deleteService("WMIReceiverMgr"))) continue;
                return result;
            }
            for (String service : services) {
                if (null != service && !(result = ServiceUtil.deleteService(service.trim()))) break;
            }
        }
        catch (AccessException ae) {
            LOGGER.error("clearServiceInstalled", (Throwable)ae);
            throw ae;
        }
        return result;
    }

    private void initSystemInfor() {
        long gb = 0x100000L;
        double totalMemorySize = 0.0;
        if (OSUtil.isWindows()) {
            totalMemorySize = WindowsGetMem.getTotalMemInfo();
        }
        LOGGER.debug("totalMemorySize: " + totalMemorySize, (Object)"initSystemInfor");
        double totoMemory = totalMemorySize / (double)gb;
        LOGGER.debug("totoMemory: " + totoMemory, (Object)"initSystemInfor");
        ContextUtil.saveSearalizeValue2Ctx("lego.base.osmemory", totoMemory);
        if (totoMemory <= 4.0) {
            ContextUtil.saveSearalizeValue2Ctx("vsm.check.system.memory.level", "4");
        } else if (totoMemory > 4.0 && totoMemory <= 8.0) {
            ContextUtil.saveSearalizeValue2Ctx("vsm.check.system.memory.level", "8");
        } else if (totoMemory > 8.0 && totoMemory <= 16.0) {
            ContextUtil.saveSearalizeValue2Ctx("vsm.check.system.memory.level", "16");
        } else {
            ContextUtil.saveSearalizeValue2Ctx("vsm.check.system.memory.level", "32");
        }
        ArrayList<Disk> tmpDisks = new ArrayList<Disk>();
        File[] disks = File.listRoots();
        if (null == disks) {
            LOGGER.error("disks is null.", (Object)"initSystemInfor");
            return;
        }
        int diskNumber = disks.length;
        long constm = 0x40000000L;
        for (int i = 0; i < diskNumber; ++i) {
            File disk = disks[i];
            if (disk.getTotalSpace() <= 0L || disk.getFreeSpace() <= 0L) continue;
            Disk diskObj = new Disk();
            try {
                diskObj.setDiskName(disk.getCanonicalPath());
            }
            catch (IOException e1) {
                LOGGER.error("path Exception", (Throwable)e1);
            }
            double totalSize = disk.getTotalSpace();
            double freesize = disk.getFreeSpace();
            diskObj.setDiskSize(String.valueOf(totalSize / (double)constm));
            diskObj.setDiskFreeSize(String.valueOf(freesize / (double)constm));
            LOGGER.debug("disk: " + disk + " size: " + diskObj.getDiskSize() + " freeSize: " + diskObj.getDiskFreeSize(), (Object)"initSystemInfor");
            tmpDisks.add(diskObj);
        }
        ContextUtil.saveSearalizeValue2Ctx("lego.base.osdisk", tmpDisks);
    }

    private void parseBundles() {
        this.changeReadPath(this.ctx);
        HashMap<String, Bundles> platbundleMap = new HashMap<String, Bundles>();
        HashMap<String, Bundles> productbundleMap = new HashMap<String, Bundles>();
        this.readPlatBundle(this.ctx, platbundleMap);
        this.readProductBundle(this.ctx, productbundleMap);
        this.reviseReadPath(this.ctx);
        ContextUtil.saveSearalizeValue2Ctx("lego.base.components.plat", platbundleMap);
        ContextUtil.saveSearalizeValue2Ctx("lego.base.components.product", productbundleMap);
    }

    private void changeReadPath(IInstallContext context) {
        String normalizeInstallType = Normalizer.normalize(context.getInstallType(), Normalizer.Form.NFKC);
        if (normalizeInstallType.contains("Collector")) {
            String basePath = context.getEnvirments().getBasePath();
            context.getEnvirments().setBasePath(basePath + "Plug-In/collector/");
        }
    }

    private void reviseReadPath(IInstallContext context) {
        String normalizeInstallType = Normalizer.normalize(context.getInstallType(), Normalizer.Form.NFKC);
        if (normalizeInstallType.contains("Collector")) {
            String basePath = context.getEnvirments().getBasePath();
            basePath = basePath.substring(0, basePath.indexOf("Plug-In"));
            context.getEnvirments().setBasePath(basePath);
        }
    }

    private void decryptPassword() {
        String pwd = ContextUtil.getStrValueFromCtx("lego.db.password.encrypt");
        if (pwd != null) {
            pwd = EncryptData.getInstanse().decrypt(pwd);
            ContextUtil.saveSearalizeValue2Ctx("lego.db.password", pwd);
        } else {
            LOGGER.error("Can't get information from source context.");
        }
        String nmspwd = ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword.encrypt");
        if (nmspwd != null) {
            nmspwd = EncryptData.getInstanse().decrypt(nmspwd);
            ContextUtil.saveSearalizeValue2Ctx("esight.db.nmsdbpassword", nmspwd);
        } else {
            LOGGER.error("Can't get nms information from source context.");
        }
    }

    protected void readPlatBundle(IInstallContext context, Map<String, Bundles> platbundleMap) {
        try {
            String basePath = context.getEnvirments().getBasePath();
            if (null == basePath || basePath.trim().isEmpty()) {
                basePath = JarFileUtil.getProjectPath();
            }
            String installMode = InstallContext.getInstance().getInstallMode();
            String installFileName = null;
            installFileName = "install".equalsIgnoreCase(installMode) ? basePath + "/PlatForm/bundle.xml" : basePath + "/uninstall/PlatForm/bundle.xml";
            File platbundleFile = new File(installFileName);
            if (platbundleFile.isFile()) {
                Bundles platFormBundle = this.parseBundles(platbundleFile, "platform");
                if (null == platFormBundle) {
                    LOGGER.error("platFormBundle is null.");
                    return;
                }
                platFormBundle.setBaseBundle(true);
                platFormBundle.setMainFolder(platbundleFile.getParentFile().getPath());
                String antFileName = platFormBundle.getMainFolder().concat(File.separatorChar + "").concat(context.getInstallMode()).concat("script.xml");
                platFormBundle.setAntFileName(antFileName);
                platbundleMap.put(platFormBundle.getId(), platFormBundle);
                LOGGER.debug("get platform bundle success", (Object)"exec");
            } else {
                LOGGER.warn("No plat bundle", (Object)"exec");
            }
        }
        catch (Exception e) {
            LOGGER.error("No plat bundle", (Throwable)e);
        }
    }

    protected void readProductBundle(IInstallContext context, Map<String, Bundles> productbundleMap) {
        try {
            String basePath = context.getEnvirments().getBasePath();
            if (null == basePath || basePath.trim().isEmpty()) {
                basePath = JarFileUtil.getProjectPath();
            }
            String installMode = InstallContext.getInstance().getInstallMode();
            String installFileFolder = basePath;
            File pluginFile = null;
            if ("install".equalsIgnoreCase(installMode)) {
                installFileFolder = basePath + "/Plug-In";
                pluginFile = new File(installFileFolder);
                if (!pluginFile.exists()) {
                    installFileFolder = basePath + "/etc/resource/install/Plug-In";
                }
            } else if ("legoPlat".equals(context.getInstallType()) && !(pluginFile = new File(installFileFolder = basePath + "/uninstall/Plug-In")).exists()) {
                installFileFolder = basePath + "/etc/resource/uninstall/Plug-In";
            }
            if (installFileFolder == null) {
                LOGGER.error("installFileFolder is null");
                return;
            }
            File productDir = new File(installFileFolder);
            if (!productDir.exists()) {
                LOGGER.error("product dir does not exist, dir:{}", (Object)productDir.getPath());
                return;
            }
            LinkedHashMap<String, File> bundleXmlMap = new LinkedHashMap<String, File>();
            this.initBundleXml(productDir, bundleXmlMap);
            Collection collection = bundleXmlMap.values();
            for (File file : collection) {
                String str;
                Bundles bundle = this.parseBundles(file, "product");
                if (null == bundle) continue;
                bundle.setBaseBundle(false);
                bundle.setAntSymbol(file.getParentFile().getName());
                bundle.setMainFolder(file.getParentFile().getPath());
                String scriptFileName = bundle.getMainFolder().concat(File.separatorChar + "").concat(context.getInstallMode()).concat("script.xml");
                bundle.setAntFileName(scriptFileName);
                LOGGER.debug("^^^^^^^^^^^^^^^buildAntPropers: {} ^^^^^^^^^^^^^^^^^^^^", (Object)bundle.getAntSymbol());
                List<String> frontJarsFile = bundle.getFrontJarsFile();
                List<String> backJarsFile = bundle.getBackJarsFile();
                String mainFolder = bundle.getMainFolder();
                String antSymbol = bundle.getAntSymbol();
                if (backJarsFile == null || backJarsFile.isEmpty()) {
                    LOGGER.debug("backJarsFile is null or empty", (Object)"buildAntPropers");
                } else {
                    str = backJarsFile.toString().substring(1, backJarsFile.toString().length() - 1);
                    ContextUtil.saveSearalizeValue2Ctx(antSymbol.concat(".").concat("vsm.backend.jars"), str);
                }
                if (frontJarsFile == null || frontJarsFile.isEmpty()) {
                    LOGGER.debug("frontJarsFile is null or empty", (Object)"buildAntPropers");
                } else {
                    str = frontJarsFile.toString().substring(1, frontJarsFile.toString().length() - 1);
                    ContextUtil.saveSearalizeValue2Ctx(antSymbol.concat(".").concat("vsm.front.jars"), str);
                }
                ContextUtil.saveSearalizeValue2Ctx(antSymbol.concat(".").concat("vsm.folder.jar"), mainFolder);
                productbundleMap.put(bundle.getId(), bundle);
                LOGGER.debug("get " + bundle.getAntSymbol() + " success", (Object)"exec");
            }
            LOGGER.debug("get product bundle  ok", (Object)"exec");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("readProductBundle occurs error", (Throwable)e);
        }
    }

    private void initBundleXml(File productDir, Map<String, File> xmlFileMap) {
        String installScene = CommonUtil.getInstallScene();
        try {
            File[] products = productDir.listFiles();
            if (products != null) {
                for (File file : products) {
                    File[] productFile;
                    if (!file.isDirectory() || "policy".equals(file.getName()) || (null == installScene || "Independent Scene".equals(installScene)) && "integrate".equals(file.getName()) || (productFile = file.listFiles()) == null) continue;
                    for (File profile : productFile) {
                        if (!profile.getName().equals("bundle.xml")) continue;
                        xmlFileMap.put(file.getName(), profile);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Initializing bunldes xml files of plugin occurs error ...", (Throwable)e);
        }
    }

    private Bundles parseBundles(File bundleXmlFile, String key) {
        SAXReader sax = new SAXReader();
        try {
            Document document = sax.read(bundleXmlFile);
            Element eRootEle = document.getRootElement();
            Element el = (Element)eRootEle.elements(key).get(0);
            Bundles bundle = this.parsePlatBundle(el);
            return bundle;
        }
        catch (DocumentException e) {
            LOGGER.error("parseBundles", (Throwable)e);
            return null;
        }
    }

    private Bundles parsePlatBundle(Element el) {
        List backendJarEle;
        List frontJarEle;
        Bundles bundle = new Bundles();
        Attribute id = el.attribute("id");
        bundle.setId(id.getValue());
        Attribute version = el.attribute("version");
        bundle.setVersion(version.getValue());
        Attribute name = el.attribute("name");
        bundle.setName(name.getValue());
        Attribute needed = el.attribute("required");
        bundle.setNeeded(Boolean.parseBoolean(needed.getValue()));
        Attribute description = el.attribute("description");
        bundle.setDescription(description.getValue());
        Attribute size = el.attribute("size");
        bundle.setSize(size.getValue());
        bundle.setDependson(el.attributeValue("dependson"));
        bundle.setDependsonVersion(el.attributeValue("dependsonversion"));
        List portEle = el.elements("validport");
        if (null != portEle && !portEle.isEmpty()) {
            ArrayList<Validport> portList = new ArrayList<Validport>();
            for (Object element : portEle) {
                Validport port = new Validport();
                port.setId(element.attributeValue("id"));
                port.setName(element.attributeValue("name"));
                port.setDefaultvalue(Integer.parseInt(element.attributeValue("defaultvalue")));
                portList.add(port);
            }
            bundle.setValidportList(portList);
        }
        if (null != (frontJarEle = el.elements("frontendjar")) && !frontJarEle.isEmpty()) {
            ArrayList<String> frontJars = new ArrayList<String>();
            for (Element element : frontJarEle) {
                frontJars.add(element.getTextTrim());
            }
            bundle.setFrontJarsFile(frontJars);
        }
        if (null != (backendJarEle = el.elements("backendjar")) && !backendJarEle.isEmpty()) {
            ArrayList<String> backendJars = new ArrayList<String>();
            for (Element element : backendJarEle) {
                backendJars.add(element.getTextTrim());
            }
            bundle.setBackJarsFile(backendJars);
        }
        return bundle;
    }

    private boolean isCoreCfgFileContained(File file, String str) {
        String context = FileUtil.getContentFromFile(file);
        if (null != context) {
            String normalizeContext = Normalizer.normalize(context, Normalizer.Form.NFKC);
            return normalizeContext.contains(str);
        }
        return false;
    }
}

