/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.executor;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.exception.EnvException;
import com.huawei.elog.base.model.Bundles;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.base.sdk.IPropertyMap;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.card.install.RegisterCard;
import com.huawei.elog.ui.window.PreWindows;
import com.huawei.elog.util.CmdUtil;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.EnvUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import com.huawei.elog.util.sdp.EncryptData;
import java.io.File;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterExecutor4Esight
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterExecutor4Esight.class);
    private static String softWareName = ContextUtil.getStrValueFromCtx("software.install.name");
    private CountDownLatch latch;
    private int idx = 0;
    private IInstallContext ctx = InstallContext.getInstance();
    private String installType = this.ctx.getInstallType();

    public RegisterExecutor4Esight() {
    }

    public RegisterExecutor4Esight(CountDownLatch latch) {
        this.latch = latch;
    }

    @Override
    public void run() {
        block5: {
            try {
                this.executeMultiInstallScene(this.ctx);
                if (UIUtil.isSilentMode()) break block5;
                final RegisterCard card = RegisterCard.getInstance();
                while (this.idx < 100) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("RegisterExecutor4Esight.run()", (Throwable)e);
                    }
                    ++this.idx;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            card.getProcessBar().setValue(RegisterExecutor4Esight.this.idx);
                            card.getProcessBar().setString(RegisterExecutor4Esight.this.idx + "%");
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("RegisterExecutor4Esight.run()", (Throwable)e);
            }
        }
        this.latch.countDown();
    }

    private void executeMultiInstallScene(IInstallContext context) throws InterruptedException {
        String entEnvRoot = PropertyManager.getProValue("ent.env.root");
        String rootPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
        this.writeUninstalledPath();
        if ("install".equalsIgnoreCase(context.getInstallMode())) {
            if (this.installType.contains("legoPlat") && context.getEnvirments().getOsName().equals("windows")) {
                if ("Independent Scene".equals(CommonUtil.getInstallScene())) {
                    if ("fuseWithEsight".equals(ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight")) || "sqlserverFuse".equals(ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight"))) {
                        LOGGER.info("SCENE_INTEGRATED_INSTALL... do not generateMenu", (Object)"exec");
                    } else {
                        LOGGER.info("SCENE_INDEPENDENT_INSTALL... generateMenu", (Object)"exec");
                        this.generateMenu();
                    }
                } else {
                    LOGGER.info("SCENE_INTEGRATED_INSTALL... do not generateMenu", (Object)"exec");
                }
            }
            try {
                EnvUtil.setEnv(entEnvRoot, rootPath, "REG_SZ");
                this.setCollectorPath(rootPath + "\\indexserver");
            }
            catch (EnvException enve) {
                String softName = PropertyManager.getProValue("software.install.name");
                String errorMsg = "register system environment env error.";
                LOGGER.error(errorMsg, (Object)"executeMultiInstallScene");
                char[] mnemonicKeys = new char[]{'O', 'D'};
                OptionPane.showDetailDialog(OptionPane.STRING_ERROR, ResourceManager.getString("VSM.OPERATION.FALIURE.TIP", softName), enve.toString(), 0, false, ResourceManager.getString("InputDBPara.OK"), null, mnemonicKeys);
            }
            LOGGER.info("register system environment env success.");
            this.searalizePropMap();
            this.dealPropMapForHA();
            if (this.installType.contains("legoPlat")) {
                if ("Independent Scene".equals(CommonUtil.getInstallScene())) {
                    CmdUtil.runbatParams(rootPath + "/Runtime/bin/changeAuth.bat", null);
                    String collectAutFile = rootPath + "/antiddos_collector/uninstall/changeAuth.bat";
                    if (new File(collectAutFile).exists()) {
                        CmdUtil.runbatParams(collectAutFile, null);
                    }
                }
            } else {
                CmdUtil.runbatParams(rootPath + "/antiddos_collector/uninstall/changeAuth.bat", null);
            }
        } else if ("update".equalsIgnoreCase(context.getInstallMode())) {
            this.writeUpdateXml(context);
        } else if ("uninstall".equalsIgnoreCase(context.getInstallMode())) {
            try {
                String strPath = EnvUtil.getEnv(entEnvRoot);
                EnvUtil.removeEnv(entEnvRoot);
                this.removeCollectorPath(strPath + "\\indexserver");
            }
            catch (EnvException enve) {
                String softName = PropertyManager.getProValue("software.install.name");
                String errorMsg = "remove system environment env error.";
                LOGGER.error(errorMsg, (Object)"executeMultiInstallScene");
                char[] mnemonicKeys = new char[]{'O', 'D'};
                OptionPane.showDetailDialog(OptionPane.STRING_ERROR, ResourceManager.getString("VSM.OPERATION.FALIURE.TIP", softName), enve.toString(), 0, false, ResourceManager.getString("InputDBPara.OK"), null, mnemonicKeys);
            }
            LOGGER.info("remove system environment env success.");
            PreWindows.getInstance().setVisible(false);
            if (this.installType.contains("legoPlat")) {
                OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DELETE.SUCCESS", softWareName));
                CommonUtil.shutDownJvm(0);
            } else if (this.installType.contains("Collector")) {
                OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DELETE.SUCCESS", "Collector"));
                CommonUtil.shutDownJvm(0);
            }
        } else if ("patch".equalsIgnoreCase(context.getInstallMode())) {
            PreWindows.getInstance().setVisible(false);
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.PATCH.SUCCESS", softWareName));
            CommonUtil.shutDownJvm(0);
        }
    }

    private void writeUninstalledPath() {
        ContextPropVal platformValInstalled = ContextUtil.getCpvValueFromCtx("lego.base.components.plat");
        ContextPropVal productValInstalled = ContextUtil.getCpvValueFromCtx("lego.base.components.product");
        String uninstallPath = "";
        if (this.ctx.getInstallType().contains("legoPlat")) {
            uninstallPath = ContextUtil.getStrValueFromCtx("lego.base.installpath") + "/Runtime/bin/uninstall/";
        } else if (this.ctx.getInstallType().contains("Collector")) {
            uninstallPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
        }
        Map platMap = (Map)platformValInstalled.getValue();
        Collection platBundles = platMap.values();
        for (Bundles bundles : platBundles) {
            bundles.setUninstallPath(uninstallPath + "PlatForm/");
        }
        Map productMap = (Map)productValInstalled.getValue();
        Collection productBundles = productMap.values();
        for (Bundles bundles : productBundles) {
            if (this.ctx.getInstallType().contains("legoPlat")) {
                bundles.setUninstallPath(uninstallPath + "Plug-In/" + bundles.getAntSymbol() + "/");
                continue;
            }
            if (!this.ctx.getInstallType().contains("Collector")) continue;
            bundles.setUninstallPath(uninstallPath + File.separator + bundles.getAntSymbol() + "/uninstall/Plug-In/" + bundles.getAntSymbol() + "/");
        }
    }

    private void generateMenu() {
        CmdUtil.runbatParams(ContextUtil.getStrValueFromCtx("lego.base.installpath") + "/Runtime/bin/createShortcut.bat", null);
    }

    private void writeUpdateXml(IInstallContext context) {
        ContextPropVal contextPro = context.getPropertyMap().getProp("lego.db.password");
        String pass = "";
        if (contextPro != null) {
            EncryptData encryptData = EncryptData.getInstanse();
            pass = contextPro.getValue().toString().trim();
            String password = encryptData.encrypt(pass);
            contextPro.setValue(password);
            context.getPropertyMap().addProp("lego.db.password", contextPro);
        }
        context.getEnvirments().setPropertyMap(context.getPropertyMap());
        context.getEnvirments().writePropMap();
        LOGGER.debug("write update information to xml.");
        ContextPropVal contextPass = context.getPropertyMap().getProp("lego.db.password");
        if (contextPass != null) {
            contextPass.setValue(pass);
            context.getPropertyMap().addProp("lego.db.password", contextPro);
        }
    }

    private void searalizePropMap() {
        IPropertyMap map = (IPropertyMap)this.ctx.getPropertyMap().clone();
        IPropertyMap currentMap = this.ctx.getPropertyMap();
        IPropertyMap envMap = this.ctx.getEnvirments().getPropertyMap();
        for (Map.Entry entry : envMap.getAllSerialProps().entrySet()) {
            String key = (String)entry.getKey();
            if (currentMap.isContained(key)) continue;
            currentMap.addProp(key, (ContextPropVal)entry.getValue());
        }
        ContextUtil.removePorp4Context("lego.db.password");
        ContextUtil.removePorp4Context("esight.db.nmsdbpassword");
        ContextUtil.removePorp4Context("lego.db.password.quotation");
        this.ctx.getEnvirments().setPropertyMap(currentMap);
        this.ctx.getEnvirments().writePropMap();
        this.ctx.getEnvirments().setPropertyMap(map);
    }

    private void dealPropMapForHA() {
        String haInstallXML = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + InstallContext.getInstance().getInstallType() + "Installed.xml_HA";
        String installXML = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + InstallContext.getInstance().getInstallType() + "Installed.xml";
        if (new File(haInstallXML).exists() && new File(installXML).exists()) {
            FileUtil.copyFile(haInstallXML, installXML);
        }
        if (new File(haInstallXML).delete()) {
            LOGGER.debug("haInstallXML delete successful");
        }
    }

    private void setCollectorPath(String strLogCenterPath) {
        if (new File(strLogCenterPath).exists()) {
            String normalizeStrPath;
            String strPath = "";
            if (EnvUtil.hasEnv("Path")) {
                strPath = EnvUtil.getEnv("Path");
            }
            if (!(normalizeStrPath = Normalizer.normalize(strPath, Normalizer.Form.NFKC)).contains(strLogCenterPath + "\\bin")) {
                normalizeStrPath = normalizeStrPath.concat(";").concat(strLogCenterPath).concat("\\bin");
                EnvUtil.setEnv("Path", normalizeStrPath, "REG_EXPAND_SZ");
            }
        }
    }

    private void removeCollectorPath(String strLogCenterPath) {
        if (new File(strLogCenterPath).exists()) {
            String strPath = "";
            if (EnvUtil.hasEnv("Path")) {
                strPath = EnvUtil.getEnv("Path");
                String[] arrayPath = strPath.split(";");
                strPath = "";
                for (String path : arrayPath) {
                    String normalizePath = Normalizer.normalize(path, Normalizer.Form.NFKC);
                    if (normalizePath.contains(strLogCenterPath + "\\bin")) continue;
                    strPath = strPath.concat(normalizePath).concat(";");
                }
                if (!"".equals(strPath)) {
                    EnvUtil.setEnv("Path", strPath, "REG_EXPAND_SZ");
                }
            }
        }
    }
}

