/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.executor;

import com.huawei.elog.CollectorHelper;
import com.huawei.elog.ant.executor.AntExecutor4Esight;
import com.huawei.elog.ant.executor.RegisterExecutor4Esight;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.exception.InstallException;
import com.huawei.elog.base.model.EnvirmentProps;
import com.huawei.elog.base.sdk.IExecute;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.base.sdk.IPropertyMap;
import com.huawei.elog.ui.util.CMDHelper;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.EnvUtil;
import com.huawei.elog.util.EsightEnvMgr;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.WindowsGetMem;
import com.huawei.elog.util.sdp.EncryptData;
import com.huawei.elog.util.thread.ThreadUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilentExecutor
implements IExecute {
    private static final Logger LOG = LoggerFactory.getLogger(SilentExecutor.class);
    private static final String USER_HOME = System.getProperty("user.home") + File.separator;
    private static final String SILENT_PROPS_FILE_PATH = "logcenter/conf/silent_install.ini";
    private static final String SILENT_PROPS_MYSQL_FILE_PATH = "etc/config/conf/silent_mysql.ini";
    private static final String SILENT_PROPS_SQLSERVER_FILE_PATH = "etc/config/conf/silent_sqlserver.ini";
    private static final String SILENT_PROPS_COLLECTOR_FILE_PATH = "etc/config/conf/silent_collector.ini";
    private static final String LOCAL_SERVER_IP = "192.168.1.1";
    private static String dbType = InstallContext.getInstance().getDbType();
    private static String installType = InstallContext.getInstance().getInstallType();
    private static String caller = InstallContext.getInstance().getCaller();
    private static String cmpType = InstallContext.getInstance().getCmpType();
    private static boolean isServerIntall = "server".equalsIgnoreCase(cmpType) || "all".equalsIgnoreCase(cmpType);
    private static boolean isCollectorInstall = "collector".equalsIgnoreCase(cmpType) || "all".equalsIgnoreCase(cmpType);
    private static EncryptData encryptData = EncryptData.getInstanse();
    private static CountDownLatch latch = new CountDownLatch(1);

    @Override
    public boolean exec(IInstallContext context) throws InstallException {
        CMDHelper.getInstance().println("[0%] Initializing environmental information...");
        if (!"extended".equals(caller)) {
            this.initProperties();
        }
        this.loadSilentEnvArgs();
        this.parseEnvArgs();
        Thread thread = new Thread(new AntExecutor4Esight(latch));
        thread.start();
        Thread cc = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    LOG.error("SilentExecutor.exec(IInstallContext context)", (Throwable)e);
                }
                finally {
                    latch = new CountDownLatch(1);
                    SilentExecutor.this.execRegisterShortCut();
                }
            }
        });
        cc.start();
        while (true) {
            ThreadUtil.sleep(1000L);
        }
    }

    private void execRegisterShortCut() {
        Thread thread = new Thread(new RegisterExecutor4Esight(latch));
        thread.start();
        Thread cc = new Thread(new IRunnable());
        cc.start();
    }

    private void initProperties() {
        if (isServerIntall) {
            LOG.debug("It is server silent install: {} ", (Object)installType);
            if (CommonUtil.isIntegratedScene()) {
                String esightDbType = EsightEnvMgr.getInstance().getValue("@{ENT_DBTYPE}");
                if (StringUtils.isEmpty((CharSequence)esightDbType)) {
                    esightDbType = EsightEnvMgr.getInstance().getValue("DBType");
                }
                LOG.debug("It is integrated scene, and dbtype is: {} ", (Object)esightDbType);
                if ("mysql".equalsIgnoreCase(esightDbType) || "2".equalsIgnoreCase(esightDbType)) {
                    FileUtil.copyFile(EnvirmentProps.getInstance().getBasePath() + SILENT_PROPS_MYSQL_FILE_PATH, USER_HOME + SILENT_PROPS_FILE_PATH);
                } else if ("sqlserver".equalsIgnoreCase(esightDbType) || "0".equalsIgnoreCase(esightDbType)) {
                    FileUtil.copyFile(EnvirmentProps.getInstance().getBasePath() + SILENT_PROPS_SQLSERVER_FILE_PATH, USER_HOME + SILENT_PROPS_FILE_PATH);
                } else {
                    LOG.error("Unknown esightDbType defined in the properties, dbtype: {}", (Object)esightDbType);
                }
            } else if ("fuseWithEsight".equals(ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight"))) {
                String esightDbType = "mysql";
                LOG.debug("It is integrated scene, and dbtype is: {} ", (Object)esightDbType);
                if ("mysql".equalsIgnoreCase(esightDbType) || "2".equalsIgnoreCase(esightDbType)) {
                    FileUtil.copyFile(EnvirmentProps.getInstance().getBasePath() + SILENT_PROPS_MYSQL_FILE_PATH, USER_HOME + SILENT_PROPS_FILE_PATH);
                    ContextUtil.saveSearalizeValue2Ctx("lego.db.type", "MySQL");
                } else if ("sqlserver".equalsIgnoreCase(esightDbType) || "0".equalsIgnoreCase(esightDbType)) {
                    FileUtil.copyFile(EnvirmentProps.getInstance().getBasePath() + SILENT_PROPS_SQLSERVER_FILE_PATH, USER_HOME + SILENT_PROPS_FILE_PATH);
                    ContextUtil.saveSearalizeValue2Ctx("lego.db.type", "Microsoft SQL Server");
                } else {
                    LOG.error("Unknown esightDbType defined in the properties, dbtype: {}", (Object)esightDbType);
                }
            } else {
                LOG.debug("It is independent scene, and dbtype is: " + dbType, (Object)"initProperties");
                if ("mysql".equalsIgnoreCase(dbType)) {
                    FileUtil.copyFile(EnvirmentProps.getInstance().getBasePath() + SILENT_PROPS_MYSQL_FILE_PATH, USER_HOME + SILENT_PROPS_FILE_PATH);
                    ContextUtil.saveSearalizeValue2Ctx("lego.db.type", "MySQL");
                } else if ("sqlserver".equalsIgnoreCase(dbType)) {
                    FileUtil.copyFile(EnvirmentProps.getInstance().getBasePath() + SILENT_PROPS_SQLSERVER_FILE_PATH, USER_HOME + SILENT_PROPS_FILE_PATH);
                    ContextUtil.saveSearalizeValue2Ctx("lego.db.type", "Microsoft SQL Server");
                } else {
                    LOG.error("Unknown dbtype defined in the arguments, dbtype: " + dbType, (Object)"initProperties");
                }
            }
        } else if ("Collector".equalsIgnoreCase(installType)) {
            LOG.debug("It is collector silent install: {} ", (Object)installType);
            FileUtil.copyFile(EnvirmentProps.getInstance().getBasePath() + SILENT_PROPS_COLLECTOR_FILE_PATH, USER_HOME + SILENT_PROPS_FILE_PATH);
        } else {
            LOG.error("Unknown install type: {}", (Object)installType);
        }
    }

    private void loadSilentEnvArgs() {
        String filePath = USER_HOME + SILENT_PROPS_FILE_PATH;
        Properties props = FileUtil.pass2PropertiesByPath(filePath);
        Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
        LOG.info("system.cfg size: " + props.size(), (Object)"parseInstalledDirFromCfg");
        String key = null;
        String value = null;
        int index = -1;
        for (Map.Entry<Object, Object> entry : entrySet) {
            key = String.valueOf(entry.getKey());
            value = String.valueOf(entry.getValue());
            if (!value.trim().isEmpty()) {
                index = value.indexOf("${");
            }
            if (this.isCtxContained(key) || index != -1) continue;
            ContextUtil.saveSearalizeValue2Ctx(key, value);
        }
        String macroValue = null;
        for (Map.Entry<Object, Object> entry : entrySet) {
            key = String.valueOf(entry.getKey());
            value = String.valueOf(entry.getValue());
            if (!value.trim().isEmpty() && (index = value.indexOf("${")) > -1) {
                int x = value.indexOf("}");
                String macroStr = value.substring(index + 2, x);
                macroValue = ContextUtil.getStrValueFromCtx(macroStr);
                if (StringUtils.isNotEmpty((CharSequence)macroValue)) {
                    value = value.replace("${" + macroStr + "}", macroValue);
                }
                if (value.indexOf("${") > -1 && value.indexOf("}") > -1 && StringUtils.isNotEmpty((CharSequence)(macroValue = ContextUtil.getStrValueFromCtx(macroStr = value.substring((index = value.indexOf("${")) + 2, x = value.indexOf("}")))))) {
                    value = value.replace("${" + macroStr + "}", macroValue);
                }
            }
            if (this.isCtxContained(key) || index <= -1) continue;
            ContextUtil.saveSearalizeValue2Ctx(key, value);
        }
        if ("all".equalsIgnoreCase(cmpType)) {
            String allIndexDataPath;
            String string;
            String string2 = ContextUtil.getStrValueFromCtx("dump.data.all.path");
            if (null != string2 && !"".equals(string2)) {
                ContextUtil.saveSearalizeValue2Ctx("dump.data.path", string2);
            }
            if (null != (string = ContextUtil.getStrValueFromCtx("online.data.all.path")) && !"".equals(string)) {
                ContextUtil.saveSearalizeValue2Ctx("online.data.path", string);
            }
            if (null != (allIndexDataPath = ContextUtil.getStrValueFromCtx("index.data.all.path")) && !"".equals(allIndexDataPath)) {
                ContextUtil.saveSearalizeValue2Ctx("index.data.path", allIndexDataPath);
            }
        }
    }

    private void parseEnvArgs() {
        String softwareName;
        String pwd;
        String pwdEncrypt;
        ContextUtil.saveAntValue2Ctx("is.history.data.reused", "false");
        String databaseType = ContextUtil.getStrValueFromCtx("lego.db.type");
        if ("MySQL".equalsIgnoreCase(databaseType)) {
            ContextUtil.saveSearalizeValue2Ctx("lego.db.type.path", "mysql");
        }
        ContextUtil.saveSearalizeValue2Ctx("lego.osname.short", OSUtil.isWindows() ? "windows" : "linux");
        CollectorHelper.parseClStoreConfig();
        ContextUtil.saveSearalizeValue2Ctx("collector.install.language.env", ResourceManager.getLocale().toString());
        if (OSUtil.isVcsInstalled()) {
            File[] searalizeFiles = EnvUtil.getInstalledSearalizeFileArray(CommonUtil.getInstallPath());
            if (searalizeFiles.length == 0) {
                ContextUtil.saveSearalizeValue2Ctx("vsm.install.mode.ha", "NORMAL");
            } else {
                ContextUtil.saveSearalizeValue2Ctx("vsm.install.mode.ha", "HA");
            }
        } else {
            ContextUtil.saveSearalizeValue2Ctx("vsm.install.mode.ha", "NORMAL");
        }
        String nmspwdEncrypt = ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword.encrypt");
        if (null != nmspwdEncrypt && !nmspwdEncrypt.trim().isEmpty()) {
            String pwd2 = encryptData.decrypt(nmspwdEncrypt);
            ContextUtil.saveSearalizeValue2Ctx("esight.db.nmsdbpassword", pwd2);
            String nmspwdEncryptNew = encryptData.encrypt(pwd2);
            ContextUtil.saveSearalizeValue2Ctx("esight.db.nmsdbpassword.encrypt", nmspwdEncryptNew);
        }
        if (null != (pwdEncrypt = ContextUtil.getStrValueFromCtx("lego.db.password.encrypt")) && !pwdEncrypt.trim().isEmpty()) {
            pwd = encryptData.decrypt(pwdEncrypt);
            ContextUtil.saveSearalizeValue2Ctx("lego.db.password", pwd);
            String pwdEncryptNew = encryptData.encrypt(pwd);
            ContextUtil.saveSearalizeValue2Ctx("lego.db.password.encrypt", pwdEncryptNew);
        } else {
            pwd = ContextUtil.getStrValueFromCtx("lego.db.password");
            if (null != pwd) {
                ContextUtil.saveSearalizeValue2Ctx("lego.db.password.encrypt", encryptData.encrypt(pwd));
            }
        }
        if (!OSUtil.isX64()) {
            ContextUtil.saveSearalizeValue2Ctx("vsm.install.system.info.env", "x86");
        } else {
            ContextUtil.saveSearalizeValue2Ctx("vsm.install.system.info.env", "x64");
        }
        double mb = 0.0;
        if (!"linux".equalsIgnoreCase(ContextUtil.getStrValueFromCtx("lego.osname.short"))) {
            mb = (double)WindowsGetMem.getTotalMemInfo() / 1024.0;
        }
        this.checkPerformance(mb);
        ContextUtil.saveSearalizeValue2Ctx("vsm.install.index.static.id", String.valueOf(UUID.randomUUID()));
        if (!CommonUtil.isIntegratedScene()) {
            String serverIP;
            String collectorIP = ContextUtil.getStrValueFromCtx("lego.base.installIpAddress");
            if (StringUtils.isEmpty((CharSequence)collectorIP)) {
                String strIp = OSUtil.getLocalFirstIp();
                LOG.info("get loacl first ip: {}", (Object)strIp);
                if (null != strIp) {
                    ContextUtil.saveSearalizeValue2Ctx("lego.base.installIpAddress", strIp);
                } else {
                    ContextUtil.saveSearalizeValue2Ctx("lego.base.installIpAddress", LOCAL_SERVER_IP);
                }
            }
            if (StringUtils.isEmpty((CharSequence)(serverIP = ContextUtil.getStrValueFromCtx("lego.base.serverIpAddress")))) {
                if (null != collectorIP) {
                    ContextUtil.saveSearalizeValue2Ctx("lego.base.serverIpAddress", collectorIP);
                } else {
                    String strIp = OSUtil.getLocalFirstIp();
                    LOG.info("get loacl first ip: {}", (Object)strIp);
                    if (null != strIp) {
                        ContextUtil.saveSearalizeValue2Ctx("lego.base.serverIpAddress", strIp);
                    } else {
                        ContextUtil.saveSearalizeValue2Ctx("lego.base.serverIpAddress", LOCAL_SERVER_IP);
                    }
                }
            }
        }
        LOG.debug("isServerIntall: {}", (Object)isServerIntall);
        LOG.debug("isCollectorInstall: {}", (Object)isCollectorInstall);
        ContextUtil.saveSearalizeValue2Ctx("collector.install.is.or.not", isCollectorInstall);
        if ("collector".equalsIgnoreCase(cmpType)) {
            ContextUtil.removePorp4Context("collector.install.is.or.not");
        }
        if (!isCollectorInstall) {
            ContextUtil.removePorp4Context("dump.data.path");
            ContextUtil.removePorp4Context("online.data.path");
            ContextUtil.removePorp4Context("temp.data.path");
            String dataPath = ContextUtil.getStrValueFromCtx("data.save.path");
            if (StringUtils.isNotEmpty((CharSequence)dataPath)) {
                String installPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
                ContextUtil.saveSearalizeValue2Ctx("data.save.path", installPath + File.separator + "LogCenterSData");
            }
        }
        List<String> ipSets = OSUtil.getLocalAllIps();
        StringBuffer namingIps = new StringBuffer();
        if (!ipSets.isEmpty()) {
            for (String oneIp : ipSets) {
                namingIps.append("<IP TYPE=\"server\">");
                namingIps.append(oneIp);
                namingIps.append("</IP>");
                namingIps.append("\r\t");
            }
            String installIpAddress = ContextUtil.getStrValueFromCtx("lego.base.installIpAddress");
            namingIps.append("<IP TYPE=\"collector\">");
            if (null != installIpAddress && !"".equals(installIpAddress)) {
                namingIps.append(installIpAddress);
            } else {
                namingIps.append(ipSets.get(0));
            }
            namingIps.append("</IP>");
        }
        ContextUtil.saveAntValue2Ctx("lego.base.allIpAddress", String.valueOf(namingIps).trim());
        if ("MySQL".equalsIgnoreCase(databaseType)) {
            String nmscomPassword = ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword");
            if (!"fuseWithEsight".equals(ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight"))) {
                ContextUtil.saveSearalizeValue2Ctx("lego.db.password", nmscomPassword);
            }
        }
        if (null != (softwareName = ContextUtil.getStrValueFromCtx("software.install.name")) && !softwareName.contains("Collector")) {
            String nmsPassword;
            String adminPassword;
            String adminPasswordcmd = adminPassword = ContextUtil.getStrValueFromCtx("lego.db.password");
            String adminPasswordcmdbat2 = adminPassword;
            if (adminPassword.contains("^")) {
                adminPasswordcmd = adminPasswordcmd.replace("^", "^^^^");
                adminPasswordcmdbat2 = adminPasswordcmdbat2.replace("^", "^^^^^^^^");
            }
            if (adminPassword.contains("|")) {
                adminPasswordcmd = adminPasswordcmd.replace("|", "^^^|");
                adminPasswordcmdbat2 = adminPasswordcmdbat2.replace("|", "^^^^^^^|");
            }
            ContextUtil.saveSearalizeValue2Ctx("lego.db.password", adminPassword);
            ContextUtil.saveAntValue2Ctx("lego.db.password.cmd", adminPasswordcmd);
            ContextUtil.saveAntValue2Ctx("lego.db.password.cmd2", adminPasswordcmdbat2);
            String nmsPasswordcmd = nmsPassword = ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword");
            String nmsPasswordcmdbat2 = nmsPassword;
            if (nmsPassword.contains("^")) {
                nmsPasswordcmd = nmsPasswordcmd.replace("^", "^^^^");
                nmsPasswordcmdbat2 = nmsPasswordcmdbat2.replace("^", "^^^^^^^^");
            }
            if (nmsPassword.contains("|")) {
                nmsPasswordcmd = nmsPasswordcmd.replace("|", "^^^|");
                nmsPasswordcmdbat2 = nmsPasswordcmdbat2.replace("|", "^^^^^^^|");
            }
            ContextUtil.saveAntValue2Ctx("esight.db.nmsdbpassword.cmd", nmsPasswordcmd);
            ContextUtil.saveAntValue2Ctx("esight.db.nmsdbpassword.cmd2", nmsPasswordcmdbat2);
        }
    }

    private void checkPerformance(Double mem) {
        if (4096.0 > mem) {
            if (CommonUtil.isIntegratedScene()) {
                ContextUtil.saveSearalizeValue2Ctx("performance.conf", "1");
            } else {
                ContextUtil.saveSearalizeValue2Ctx("performance.conf", "2");
            }
        } else if (4096.0 <= mem && 8000.0 > mem) {
            ContextUtil.saveSearalizeValue2Ctx("performance.conf", "2");
        } else if (8000.0 <= mem && 16000.0 > mem) {
            if (CommonUtil.isIntegratedScene()) {
                ContextUtil.saveSearalizeValue2Ctx("performance.conf", "2");
            } else {
                ContextUtil.saveSearalizeValue2Ctx("performance.conf", "3");
            }
        } else if (16000.0 <= mem) {
            ContextUtil.saveSearalizeValue2Ctx("performance.conf", "4");
        }
    }

    private boolean isCtxContained(Object key) {
        IPropertyMap map = InstallContext.getInstance().getPropertyMap();
        return map.isContained(String.valueOf(key));
    }

    public static String getSilentPorpsFilePath() {
        return USER_HOME + SILENT_PROPS_FILE_PATH;
    }

    private static class IRunnable
    implements Runnable {
        private IRunnable() {
        }

        @Override
        public void run() {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                LOG.error("execRegisterShortCut", (Throwable)e);
            }
            finally {
                CMDHelper.getInstance().println("[100%] " + ResourceManager.getString("LogCenter.Install.Silent.Succeed"));
                LOG.info("Silent install mode is succeed, jvm will be shutdown.", (Object)"execRegisterShortCut");
                CommonUtil.shutDownJvm(0);
            }
        }
    }
}

