/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.executor;

import com.huawei.elog.base.exception.InstallException;
import com.huawei.elog.base.sdk.IExecute;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.window.PreWindows;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.ServiceUtil;
import com.huawei.elog.util.db.DBUtil;

public class UninstallExecutor
implements IExecute {
    @Override
    public boolean exec(IInstallContext context) throws InstallException {
        int resultSave;
        PreWindows.getInstance().setVisible(false);
        String msg = ResourceManager.getString("Uninstall.AreYouSureToContinue");
        int result = OptionPane.showWarnConfirmDialog(msg);
        if (0 != result) {
            CommonUtil.shutDownJvm(0);
        }
        boolean isMonitorRun = ServiceUtil.isServiceRunning("LEGOMonitor");
        boolean isWebServiceRun = ServiceUtil.isServiceRunning("LEGOWebSrv");
        boolean isCollectorRun = ServiceUtil.isServiceRunning("DDOSCOLLECTORSVC");
        boolean server = isMonitorRun || isWebServiceRun;
        boolean collector = isCollectorRun;
        if (server || collector) {
            OptionPane.showInfoDialog(ResourceManager.getString("start.err.10001"));
            CommonUtil.shutDownJvm(0);
        }
        if (0 != (resultSave = OptionPane.showWarnConfirmDialog(ResourceManager.getString("LEGO.VSM.DB.DELETE.CONFIRM"))) && 1 != resultSave) {
            CommonUtil.shutDownJvm(0);
        }
        if (0 == resultSave) {
            ContextUtil.saveAntValue2Ctx("db.isdbdel", String.valueOf(false));
        }
        ContextUtil.saveSearalizeValue2Ctx("lego.base.is.uninstall.all", String.valueOf(true));
        if (!DBUtil.checkDbValid()) {
            result = OptionPane.showWarnConfirmDialog(ResourceManager.getString("VSM.DB.ERROR.CONTINUE.COMFIRM"));
            if (0 != result) {
                CommonUtil.shutDownJvm(0);
            } else {
                ContextUtil.saveSearalizeValue2Ctx("lego.base.isdbdel", String.valueOf(false));
            }
        } else {
            ContextUtil.saveSearalizeValue2Ctx("lego.base.isdbdel", String.valueOf(true));
        }
        String dbType = ContextUtil.getStrValueFromCtx("lego.db.type");
        if ("MySQL".equalsIgnoreCase(dbType)) {
            ContextUtil.saveAntValue2Ctx("mysql", "lego.db.type.path");
        } else if ("Microsoft SQL Server".equalsIgnoreCase(dbType)) {
            ContextUtil.saveAntValue2Ctx("sqlserver", "lego.db.type.path");
        } else if ("Oracle".equalsIgnoreCase(dbType)) {
            ContextUtil.saveAntValue2Ctx("oracle", "lego.db.type.path");
        }
        return true;
    }
}

