/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.executor;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.exception.InstallException;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.Step;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.base.sdk.IExecute;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.base.sdk.IMainUIWizard;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.util.JFrameUtil;
import com.huawei.elog.ui.window.PreWindows;
import com.huawei.elog.util.CmdUtil;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.PathCheckUtil;
import com.huawei.elog.util.PortCheckUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.elog.util.ValidateUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalExexcutor
implements IExecute,
IMainUIWizard {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniversalExexcutor.class);
    private static boolean isFinished = false;
    private IInstallContext installContext = null;
    private WizardDialog wiz = null;
    private WizardDialog sDialog = null;

    public static boolean isFinished() {
        return isFinished;
    }

    public void setFinished(boolean isaFinished) {
        UniversalExexcutor.setFinishedValue(isaFinished);
    }

    public static void setFinishedValue(boolean isaFinished) {
        isFinished = isaFinished;
    }

    @Override
    public boolean exec(IInstallContext context) throws InstallException {
        try {
            this.installContext = context;
            LOGGER.debug("Begin install panel", (Object)"exec");
            ContextPropVal uiExeVal = new ContextPropVal(false, false, false, this);
            context.getPropertyMap().addProp("lego.base.installUIExecutor", uiExeVal);
            this.sDialog = this.createWiza(585, 450);
            ContextPropVal propVal = new ContextPropVal(false, false, false, this.sDialog);
            context.getPropertyMap().addProp("lego.base.wizarddlg", propVal);
            PreWindows.getInstance().setVisible(false);
            this.sDialog.setVisible(true);
            if (null != this.wiz.getTitle()) {
                this.sDialog.setTitle(this.wiz.getTitle());
            }
            while (!isFinished) {
                Thread.sleep(300L);
            }
        }
        catch (Exception ex) {
            LOGGER.error("exec", (Throwable)ex);
            throw new InstallException("Error running the install, " + ex.getMessage(), ex);
        }
        return true;
    }

    @Override
    public void closeWizard() {
        this.sDialog.dispose();
        this.setFinished(true);
    }

    @Override
    public void hideWizard() {
        this.sDialog.setVisible(false);
    }

    protected void writeUpdateInfor(IInstallContext context) {
        LOGGER.debug("upgrade system.", (Object)"writeUpdateInfor");
    }

    protected WizardDialog createWiza(int width, int hight) {
        String basePathString;
        Properties props;
        if (this.installContext.getEnvirments().getOsName().equals("windows")) {
            try {
                Runtime.getRuntime().exec("sc stop PcaSvc");
            }
            catch (IOException e) {
                LOGGER.error("##--stop PcaSvc Error----##", (Throwable)e);
            }
        }
        ArrayList<String> stepNames = new ArrayList<String>();
        ContextPropVal propVal = ContextUtil.getCpvValueFromCtx("lego.base.cardStepOrder");
        List stepList = (List)propVal.getValue();
        for (Step step : stepList) {
            String displayName = ResourceManager.getString(step.getShowName());
            stepNames.add(displayName);
        }
        WizardDialog.Card nextCard = null;
        Class<?> clazz = null;
        Method method = null;
        try {
            clazz = Class.forName(((Step)stepList.get(0)).getCardClassName());
            method = clazz.getMethod("getInstance", new Class[0]);
            nextCard = (WizardDialog.Card)method.invoke(null, new Object[0]);
            ContextUtil.saveSimpleValue2Ctx("lego.wizard.active.card", nextCard);
            LOGGER.debug("current card is: " + nextCard, (Object)"initStepList");
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("In UniversalExexcutor : createWiza Next Page error: " + e);
        }
        catch (SecurityException e) {
            LOGGER.error("In UniversalExexcutor : createWiza Next Page error: " + e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("In UniversalExexcutor : createWiza Next Page error: " + e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("In UniversalExexcutor : createWiza Next Page error: " + e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("In UniversalExexcutor : createWiza Next Page error: " + e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("In UniversalExexcutor : createWiza Next Page error: " + e);
        }
        if (nextCard != null) {
            this.wiz = new WizardDialog(stepNames, nextCard, width, hight, this.installContext);
        }
        if ((props = System.getProperties()).getProperty("os.name").equalsIgnoreCase("linux")) {
            this.wiz.setAlwaysOnTop(false);
        } else {
            this.wiz.setAlwaysOnTop(true);
        }
        this.wiz.setLocation(JFrameUtil.getScreenCenterPoint(this.wiz));
        LOGGER.debug("wiz setLocation ", (Object)"createWiza");
        int portNumber = PortCheckUtil.checkSystemUsing();
        if (-1 != portNumber) {
            PreWindows.getInstance().setVisible(false);
            String[] params = new String[]{PropertyManager.getProValue("software.install.name"), Integer.toString(portNumber)};
            String errorMsg = ResourceManager.getString("LEGO.SYSTEM.INUSING", params);
            OptionPane.showErrorDialog(errorMsg);
            LOGGER.error(errorMsg, (Object)"createWiza");
            CommonUtil.shutDownJvm(0);
        }
        ContextPropVal installCollector = ContextUtil.getCpvValueFromCtx("collector.install.is.or.not");
        ContextPropVal installCollectorPath = ContextUtil.getCpvValueFromCtx("lego.base.installpath");
        if (null != installCollector && null != installCollectorPath) {
            boolean isCollector = Boolean.parseBoolean(installCollector.getValue().toString());
            String collectorPath = installCollectorPath.getValue().toString().concat("/collector");
            File collectorFile = new File(collectorPath);
            if (isCollector && collectorFile.exists()) {
                File oldFile = new File(collectorPath);
                boolean isRename = oldFile.renameTo(new File(collectorPath + "_Bak"));
                if (!isRename) {
                    PreWindows.getInstance().setVisible(false);
                    OptionPane.showInfoDialog(ResourceManager.getString("COLLECTOR.FILE.IS.USING"));
                    LOGGER.error(ResourceManager.getString("COLLECTOR.FILE.IS.USING"), (Object)"createWiza");
                    CommonUtil.shutDownJvm(0);
                } else {
                    LOGGER.debug(collectorPath + "_Bak", (Object)"##----New Collector Dir----##");
                    File newFile = new File(collectorPath + "_Bak");
                    boolean bl = newFile.renameTo(oldFile);
                }
            }
        }
        if (this.installContext.getInstallType().contains("legoPlat") && System.getProperty("os.name").toLowerCase(Locale.ENGLISH).charAt(0) == 'w' && System.getProperty("os.version").charAt(0) != '6' && CmdUtil.hasIpV6Ip()) {
            PreWindows.getInstance().setVisible(false);
            LOGGER.debug("Content IPV6 Address", (Object)"This Computer Contents IPV6 and OS:winXp&2003");
            OptionPane.showErrorDialog(ResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.IPV6ERROR"));
            LOGGER.error("Content IPV6 Address", (Object)"Forbid Install");
            LOGGER.error(ResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.IPV6ERROR"), (Object)"createWiza");
            CommonUtil.shutDownJvm(0);
        }
        if (!PathCheckUtil.checkPathChar(basePathString = InstallContext.getInstance().getEnvirments().getBasePath())) {
            PreWindows.getInstance().setVisible(false);
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.CHAR"));
            this.setFinished(false);
            LOGGER.error(ResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.CHAR"), (Object)"createWiza");
            CommonUtil.shutDownJvm(0);
        }
        if (this.installContext.getInstallMode().equalsIgnoreCase("install") && this.installContext.getEnvirments().getOsName().equals("windows")) {
            ValidateUtil validateUtil = ValidateUtil.getInstance();
            if (validateUtil.checkRegditLocked()) {
                PreWindows.getInstance().setVisible(false);
                OptionPane.showErrorDialog(ResourceManager.getString("REGIDIT.LOCKED.ERROR"));
                this.setFinished(false);
                LOGGER.error(ResourceManager.getString("REGIDIT.LOCKED.ERROR"), (Object)"createWiza");
                CommonUtil.shutDownJvm(0);
            }
            if (!validateUtil.checkDigitalFormat()) {
                LOGGER.warn("Digital format error", (Object)"");
                PreWindows.getInstance().setVisible(false);
                OptionPane.showErrorDialog(ResourceManager.getString("FORMAT.REGION.SETTING"));
                LOGGER.error(ResourceManager.getString("FORMAT.REGION.SETTING"), (Object)"createWiza");
                this.setFinished(false);
                SystemExitUtil.systemExit(0);
            }
        }
        return this.wiz;
    }
}

