/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.listener;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.ui.card.uninstall.UninstallCard;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ResourceManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorUninstallBuildListener
implements BuildListener {
    private static IInstallContext ctx = InstallContext.getInstance();
    private static String basePath = ctx.getEnvirments().getBasePath();
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectorUninstallBuildListener.class);
    private String title;
    private String bundleName;
    private UninstallCard card;
    private int index = -1;
    private int size;
    private Map<?, ?> targets;
    private List<String> unexecuted;
    private double progress = 0.0;
    private String targetName;
    private String message;
    private String simpleMsg;
    private Object eventSource;
    private ExecTask et;
    private boolean initFlag = false;
    private final String wrapChar = CommonUtil.WRAP_CHAR;
    private List<String> noteList = new ArrayList<String>(10);
    private int curIndex = -1;
    private Throwable th;

    public CollectorUninstallBuildListener() {
    }

    public CollectorUninstallBuildListener(UninstallCard card, List<String> bundleNameList, String bundleName, String title) {
        this.card = card;
        this.noteList = bundleNameList;
        this.bundleName = bundleName;
        this.title = title;
        if (null != title) {
            String[] ts = title.split("/");
            this.index = Integer.parseInt(ts[0].substring(1));
            this.size = Integer.parseInt(ts[1].substring(0, 1));
        }
    }

    public void buildStarted(BuildEvent event) {
        Project project = event.getProject();
        this.targets = project.getTargets();
        LOGGER.info("finished start: " + event.getProject().getName(), (Object)"LegoBuildListener.buildStarted");
    }

    public void buildFinished(BuildEvent event) {
        double percent = this.index / this.size * 100;
        this.card.getFileName().setText("Finished...");
        this.card.getProcessBar().setValue((int)percent);
        this.card.getProcessBar().setString((int)percent + "%");
        LOGGER.info("finished build: " + event.getProject().getName(), (Object)"LegoBuildListener.buildFinished");
    }

    public void messageLogged(BuildEvent event) {
        this.message = event.getMessage();
        this.th = event.getException();
        if (null == this.message || this.message.trim().isEmpty()) {
            return;
        }
        if (null != this.th) {
            this.simpleMsg = this.message.replace(basePath, "...");
            LOGGER.debug("----- build.faild:-----\n " + this.th, (Object)"messageLogged");
            LOGGER.debug("messageLogged: " + this.simpleMsg, (Object)"messageLogged");
        }
        this.card.getNoteTextArea().setText(this.bundlesInstalling(ResourceManager.getString(this.bundleName)));
        this.eventSource = event.getSource();
        if (this.eventSource instanceof ExecTask) {
            this.et = (ExecTask)this.eventSource;
            if ("exec".equals(this.et.getTaskName())) {
                return;
            }
        }
        if (!this.message.contains("Setting") && !this.message.contains("antcontrib")) {
            this.simpleMsg = this.message.replace(basePath, "...");
            this.targetName = event.getTarget() == null ? "" : event.getTarget().getName();
            double percent = ((double)(this.index - 1) + this.progress) / (double)this.size * 100.0;
            this.card.getCopingFile().setText(this.title + " " + ResourceManager.getString(this.bundleName) + "  " + this.targetName);
            this.card.getFileName().setText(this.simpleMsg);
            this.card.getProcessBar().setValue((int)percent);
            this.card.getProcessBar().setString((int)percent + "%");
        }
    }

    public void targetStarted(BuildEvent event) {
        LOGGER.info("target started: -*-*-*-" + event.getTarget().getName() + "-*-*-*-", (Object)"LegoBuildListener.targetStarted");
        if (!this.initFlag) {
            Hashtable htb;
            Project project = event.getProject();
            this.targets = htb = project.getTargets();
            this.unexecuted = new ArrayList<String>();
            Enumeration en = htb.elements();
            while (en.hasMoreElements()) {
                Target tar = (Target)en.nextElement();
                if (null == tar) continue;
                this.unexecuted.add(tar.getName());
            }
            this.initFlag = true;
        }
    }

    public void targetFinished(BuildEvent event) {
        Target tar = event.getTarget();
        if (tar != null && this.unexecuted.contains(tar.getName())) {
            this.unexecuted.remove(tar.getName());
        }
        this.progress = (double)(this.targets.size() - this.unexecuted.size()) / (double)this.targets.size();
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public String bundlesInstalling(String str) {
        int i;
        if (this.noteList == null || this.noteList.size() == 0) {
            return "";
        }
        this.curIndex = this.noteList.indexOf(str);
        if (this.curIndex == -1) {
            return "";
        }
        String strNote = "";
        StringBuffer tmp = new StringBuffer(strNote);
        for (i = 0; i < this.curIndex; ++i) {
            tmp.append(this.wrapChar);
            tmp.append("             ");
            tmp.append(this.noteList.get(i));
            tmp.append("......");
            tmp.append(ResourceManager.getString("Uninstall.Completed"));
            strNote = tmp.toString();
        }
        StringBuffer tmp1 = new StringBuffer();
        tmp1.append(strNote);
        tmp1.append(this.wrapChar);
        tmp1.append("             ");
        tmp1.append(str);
        tmp1.append("...");
        strNote = tmp1.toString();
        StringBuffer tmp2 = new StringBuffer(strNote);
        for (i = this.curIndex + 1; i < this.noteList.size(); ++i) {
            tmp2.append(this.wrapChar);
            tmp2.append("             ");
            tmp2.append(this.noteList.get(i));
            strNote = tmp2.toString();
        }
        return strNote;
    }

    public void setNoteList(List<String> noteList) {
        this.noteList = noteList;
    }

    static {
        if (basePath.indexOf("/") > -1) {
            basePath = basePath.replaceAll("/", "\\\\");
        }
    }
}

